"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QAudioInput(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaudioinput.html

    **Detailed Description**

    This class represents an input channel that can be used together with
    **QMediaCaptureSession** . It enables the selection of the physical input
    device to be used, muting the channel, and changing the channel's volume.
    """

    @overload
    def __init__(
        self,
        deviceInfo: PySide6.QtMultimedia.QAudioDevice,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        ...

    def device(self) -> PySide6.QtMultimedia.QAudioDevice:
        """
        https://doc.qt.io/qt-6/qaudioinput.html#device-prop

        **device : QAudioDevice**

        This property holds the audio device connected to this input.

        The device property represents the audio device connected to this input.
        This property can be used to select an input device from the
        **QMediaDevices::audioInputs** () list.

        You can select the system default audio input by setting this property
        to a default constructed **QAudioDevice**  object.

        **Access functions:**

        QAudioDevice **device** () const
        void **setDevice** (const
        QAudioDevice & **device** )

        **Notifier signal:**

        void **deviceChanged** ()
        """
        ...

    def isMuted(self) -> bool:
        ...

    def setDevice(self, device: PySide6.QtMultimedia.QAudioDevice) -> None:
        """
        https://doc.qt.io/qt-6/qaudioinput.html#device-prop

        **device : QAudioDevice**

        This property holds the audio device connected to this input.

        The device property represents the audio device connected to this input.
        This property can be used to select an input device from the
        **QMediaDevices::audioInputs** () list.

        You can select the system default audio input by setting this property
        to a default constructed **QAudioDevice**  object.

        **Access functions:**

        QAudioDevice **device** () const
        void **setDevice** (const
        QAudioDevice & **device** )

        **Notifier signal:**

        void **deviceChanged** ()
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaudioinput.html#muted-prop

        **muted : bool**

        This property holds the muted state of the current media.

        The value will be `true` if the input is muted; otherwise `false`.

        **Access functions:**

        bool **isMuted** () const
        void **setMuted** (bool **muted** )

        **Notifier signal:**

        void **mutedChanged** (bool **muted** )
        """
        ...

    def setVolume(self, volume: float) -> None:
        ...

    def volume(self) -> float:
        ...

    @property
    def deviceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def mutedChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def volumeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
