"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpSearchResult(object):
    """
    https://doc.qt.io/qt-6/qhelpsearchresult.html

    **Detailed Description**

    The QHelpSearchResult object is a data object that describes a single search
    result. The vector of search result objects is returned by
    **QHelpSearchEngine::searchResults** (). The description of the search
    result contains the document title and URL that the search input matched. It
    also contains the snippet from the document content containing the best
    match of the search input.

    **See also** **QHelpSearchEngine** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult

        **QHelpSearchResult::QHelpSearchResult()**

        Constructs a new empty QHelpSearchResult.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtHelp.QHelpSearchResult) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult-1

        **QHelpSearchResult::QHelpSearchResult(const QHelpSearchResult & other
        )**

        Constructs a copy of **other**.
        """
        ...

    @overload
    def __init__(
        self, url: Union[PySide6.QtCore.QUrl, str], title: str, snippet: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult-2

        **QHelpSearchResult::QHelpSearchResult(const QUrl & url , const QString
        & title , const QString & snippet )**

        Constructs the search result containing **url** , **title** and
        **snippet** as the description of the result.
        """
        ...

    def snippet(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#snippet

        **QString QHelpSearchResult::snippet() const**

        Returns the document snippet containing the search phrase of the search
        result.
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#title

        **QString QHelpSearchResult::title() const**

        Returns the document title of the search result.
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#url

        **QUrl QHelpSearchResult::url() const**

        Returns the document URL of the search result.
        """
        ...
