"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import Optional, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpFilterSettingsWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html

    **Detailed Description**

    The instance of QHelpFilterSettingsWidget may be a part of a preferences
    dialog. Before showing the dialog, **setAvailableComponents** () and
    **setAvailableVersions** () should be called, otherwise the filter settings
    widget will only offer a creation of empty filters, which wouldn't be
    useful. In addition, **readSettings**  should also be called to fill up the
    filter settings widget with the list of filters already stored in the filter
    engine. The creation of new filters, modifications to existing filters and
    removal of unneeded filters are handled by the widget automatically. If you
    want to store the current state of the widget and apply it to the filter
    engine e.g. after the user clicked the apply button - call **applySettings**
    ().
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html#QHelpFilterSetting
        sWidget

        **QHelpFilterSettingsWidget::QHelpFilterSettingsWidget(QWidget * parent
        = nullptr)**

        Constructs a filter settings widget with **parent** as parent widget.
        """
        ...

    def applySettings(self, filterEngine: PySide6.QtHelp.QHelpFilterEngine) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html#applySettings

        **bool QHelpFilterSettingsWidget::applySettings(QHelpFilterEngine *
        filterEngine ) const**

        Writes the filter settings, currently presented in this filter settings
        widget, to the **filterEngine**. The old settings stored in the filter
        engine will be overwritten. Returns `true` on success.
        """
        ...

    def readSettings(self, filterEngine: PySide6.QtHelp.QHelpFilterEngine) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html#readSettings

        **void QHelpFilterSettingsWidget::readSettings(const QHelpFilterEngine *
        filterEngine )**

        Reads the filter settings stored inside **filterEngine** and sets up
        this filter settings widget accordingly.
        """
        ...

    def setAvailableComponents(self, components: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html#setAvailableCompon
        ents

        **void QHelpFilterSettingsWidget::setAvailableComponents(const
        QStringList & components )**

        Sets the list of all available components to **components**.

        **See also** **QHelpFilterEngine::availableComponents** ().
        """
        ...

    def setAvailableVersions(
        self, versions: Sequence[PySide6.QtCore.QVersionNumber]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfiltersettingswidget.html#setAvailableVersio
        ns

        **void QHelpFilterSettingsWidget::setAvailableVersions(const
        QList<QVersionNumber> & versions )**

        Sets the list of all available version numbers to **versions**.

        **See also** **QHelpFilterEngine::availableVersions** ().
        """
        ...
