"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpEngineCore(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qhelpenginecore.html

    **Detailed Description**

    Before the help engine can be used, it must be initialized by calling
    **setupData** (). At the beginning of the setup process the signal
    **setupStarted** () is emitted. From this point on until the signal
    **setupFinished** () is emitted, is the help data in an undefined meaning
    unusable state.

    The core help engine can be used to perform different tasks. By calling
    **documentsForIdentifier** () the engine returns URLs specifying the file
    locations inside the help system. The actual file data can then be retrived
    by calling **fileData** ().

    The help engine can contain any number of custom filters. The management of
    the filters, including adding new filters, changing filter definitions, or
    removing existing filters, is done through the **QHelpFilterEngine**  class,
    which can be accessed by the **filterEngine** () method.

    **Note:****QHelpFilterEngine**  replaces the older filter API that is
    deprecated since Qt 5.13. Call **setUsesFilterEngine** () with `true` to
    enable the new functionality.

    The core help engine has two modes:

    * Read-only mode, where the help collection file is not changed unless
    explicitly requested. This also works if the collection file is in a read-
    only location, and is the default.
      * Fully writable mode, which requires
    the help collection file to be writable.

    The mode can be changed by calling **setReadOnly** () method, prior to
    calling **setupData** ().

    The help engine also offers the possibility to set and read values in a
    persistent way comparable to ini files or Windows registry entries. For more
    information see setValue() or value().

    This class does not offer any GUI components or functionality for indices or
    contents. If you need one of those use **QHelpEngine**  instead.
    """

    def __init__(
        self, collectionFile: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#QHelpEngineCore

        **QHelpEngineCore::QHelpEngineCore(const QString & collectionFile ,
        QObject * parent = nullptr)**

        Constructs a new core help engine with a **parent**. The help engine
        uses the information stored in the **collectionFile** to provide help.
        If the collection file does not exist yet, it'll be created.
        """
        ...

    def addCustomFilter(self, filterName: str, attributes: Sequence[str]) -> bool:
        ...

    def autoSaveFilter(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#autoSaveFilter-prop

        **autoSaveFilter : bool**

        This property holds whether **QHelpEngineCore**  is in auto save filter
        mode or not.

        If **QHelpEngineCore**  is in auto save filter mode, the current filter
        is automatically saved when it is changed by the
        **QHelpFilterEngine::setActiveFilter** () function. The filter is saved
        persistently in the help collection file.

        By default, this mode is on.

        **Access functions:**

        bool **autoSaveFilter** () const
        void **setAutoSaveFilter** (bool
        **save** )
        """
        ...

    def collectionFile(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#collectionFile-prop

        **collectionFile : QString**

        This property holds the absolute file name of the collection file
        currently used.

        Setting this property leaves the help engine in an invalid state. It is
        important to invoke **setupData** () or any getter function in order to
        setup the help engine again.

        **Access functions:**

        QString **collectionFile** () const
        void **setCollectionFile** (const
        QString & **fileName** )
        """
        ...

    def copyCollectionFile(self, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#copyCollectionFile

        **bool QHelpEngineCore::copyCollectionFile(const QString & fileName )**

        Creates the file **fileName** and copies all contents from the current
        collection file into the newly created file, and returns true if
        successful; otherwise returns false.

        The copying process makes sure that file references to Qt Collection
        files (`.qch`) files are updated accordingly.
        """
        ...

    def currentFilter(self) -> str:
        ...

    def customFilters(self) -> List[str]:
        ...

    def customValue(self, key: str, defaultValue: Any = ...) -> Any:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#customValue

        **QVariant QHelpEngineCore::customValue(const QString & key , const
        QVariant & defaultValue = QVariant()) const**

        Returns the value assigned to the **key**. If the requested key does not
        exist, the specified **defaultValue** is returned.

        **See also** **setCustomValue** () and **removeCustomValue** ().
        """
        ...

    def documentationFileName(self, namespaceName: str) -> str:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#documentationFileName

        **QString QHelpEngineCore::documentationFileName(const QString &
        namespaceName )**

        Returns the absolute file name of the Qt compressed help file (.qch)
        identified by the **namespaceName**. If there is no Qt compressed help
        file with the specified namespace registered, an empty string is
        returned.

        **See also** **namespaceName** ().
        """
        ...

    @overload
    def documentsForIdentifier(self, id: str) -> List[PySide6.QtHelp.QHelpLink]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#documentsForIdentifier

        **[since 5.15] QList<QHelpLink>
        QHelpEngineCore::documentsForIdentifier(const QString & id ) const**

        Returns a list of all the document links found for the **id**. The
        returned list contents depend on the current filter, and therefore only
        the keywords registered for the current filter will be returned.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def documentsForIdentifier(
        self, id: str, filterName: str
    ) -> List[PySide6.QtHelp.QHelpLink]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#documentsForIdentifier-1

        **[since 5.15] QList<QHelpLink>
        QHelpEngineCore::documentsForIdentifier(const QString & id , const
        QString & filterName ) const**

        Returns a list of the document links found for the **id** , filtered by
        **filterName**. The returned list contents depend on the passed filter,
        and therefore only the keywords registered for this filter will be
        returned. If you want to get all results unfiltered, pass empty string
        as **filterName**.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def documentsForKeyword(self, keyword: str) -> List[PySide6.QtHelp.QHelpLink]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#documentsForKeyword

        **[since 5.15] QList<QHelpLink>
        QHelpEngineCore::documentsForKeyword(const QString & keyword ) const**

        Returns a list of all the document links found for the **keyword**. The
        returned list contents depend on the current filter, and therefore only
        the keywords registered for the current filter will be returned.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def documentsForKeyword(
        self, keyword: str, filterName: str
    ) -> List[PySide6.QtHelp.QHelpLink]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#documentsForKeyword-1

        **[since 5.15] QList<QHelpLink>
        QHelpEngineCore::documentsForKeyword(const QString & keyword , const
        QString & filterName ) const**

        Returns a list of the document links found for the **keyword** ,
        filtered by **filterName**. The returned list contents depend on the
        passed filter, and therefore only the keywords registered for this
        filter will be returned. If you want to get all results unfiltered, pass
        empty string as **filterName**.

        This function was introduced in Qt 5.15.
        """
        ...

    def error(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#error

        **QString QHelpEngineCore::error() const**

        Returns a description of the last error that occurred.
        """
        ...

    def fileData(
        self, url: Union[PySide6.QtCore.QUrl, str]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#fileData

        **QByteArray QHelpEngineCore::fileData(const QUrl & url ) const**

        Returns the data of the file specified by **url**. If the file does not
        exist, an empty **QByteArray**  is returned.

        **See also** **findFile** ().
        """
        ...

    @overload
    def files(
        self,
        namespaceName: str,
        filterAttributes: Sequence[str],
        extensionFilter: str = ...,
    ) -> List[PySide6.QtCore.QUrl]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#files-1

        **QList<QUrl> QHelpEngineCore::files(const QString namespaceName , const
        QString & filterName , const QString & extensionFilter = QString())**

        Returns a list of files contained in the Qt compressed help file for
        **namespaceName**. The files can be filtered by **filterName** as well
        as by their extension **extensionFilter** (for example, 'html').
        """
        ...

    @overload
    def files(
        self, namespaceName: str, filterName: str, extensionFilter: str = ...
    ) -> List[PySide6.QtCore.QUrl]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#files-1

        **QList<QUrl> QHelpEngineCore::files(const QString namespaceName , const
        QString & filterName , const QString & extensionFilter = QString())**

        Returns a list of files contained in the Qt compressed help file for
        **namespaceName**. The files can be filtered by **filterName** as well
        as by their extension **extensionFilter** (for example, 'html').
        """
        ...

    def filterAttributeSets(self, namespaceName: str) -> List[List[str]]:
        ...

    @overload
    def filterAttributes(self) -> List[str]:
        ...

    @overload
    def filterAttributes(self, filterName: str) -> List[str]:
        ...

    def filterEngine(self) -> PySide6.QtHelp.QHelpFilterEngine:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#filterEngine

        **[since 5.13] QHelpFilterEngine *QHelpEngineCore::filterEngine()
        const**

        Returns the filter engine associated with this help engine. The filter
        engine allows for adding, changing, and removing existing filters for
        this help engine. To use the engine you also have to call
        **setUsesFilterEngine** () set to `true`.

        This function was introduced in Qt 5.13.
        """
        ...

    def findFile(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#findFile

        **QUrl QHelpEngineCore::findFile(const QUrl & url ) const**

        Returns the corrected URL for the **url** that may refer to a different
        namespace defined by the virtual folder defined as a part of the
        **url**. If the virtual folder matches the namespace of the **url** ,
        the method just checks if the file exists and returns the same **url**.
        When the virtual folder doesn't match the namespace of the **url** , it
        tries to find the best matching namespace according to the active
        filter. When the namespace is found, it returns the corrected URL if the
        file exists, otherwise it returns an invalid URL.
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    @staticmethod
    def metaData(documentationFileName: str, name: str) -> Any:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#metaData

        **[static] QVariant QHelpEngineCore::metaData(const QString &
        documentationFileName , const QString & name )**

        Returns the meta data for the Qt compressed help file
        **documentationFileName**. If there is no data available for **name** ,
        an invalid QVariant() is returned. The meta data is defined when
        creating the Qt compressed help file and cannot be modified later.
        Common meta data includes e.g. the author of the documentation.
        """
        ...

    @staticmethod
    def namespaceName(documentationFileName: str) -> str:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#namespaceName

        **[static] QString QHelpEngineCore::namespaceName(const QString &
        documentationFileName )**

        Returns the namespace name defined for the Qt compressed help file
        (.qch) specified by its **documentationFileName**. If the file is not
        valid, an empty string is returned.

        **See also** **documentationFileName** ().
        """
        ...

    def registerDocumentation(self, documentationFileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#registerDocumentation

        **bool QHelpEngineCore::registerDocumentation(const QString &
        documentationFileName )**

        Registers the Qt compressed help file (.qch) contained in the file
        **documentationFileName**. One compressed help file, uniquely identified
        by its namespace can only be registered once. True is returned if the
        registration was successful, otherwise false.

        **See also** **unregisterDocumentation** () and **error** ().
        """
        ...

    def registeredDocumentations(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#registeredDocumentations

        **QStringList QHelpEngineCore::registeredDocumentations() const**

        Returns a list of all registered Qt compressed help files of the current
        collection file. The returned names are the namespaces of the registered
        Qt compressed help files (.qch).
        """
        ...

    def removeCustomFilter(self, filterName: str) -> bool:
        ...

    def removeCustomValue(self, key: str) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#removeCustomValue

        **bool QHelpEngineCore::removeCustomValue(const QString & key )**

        Removes the **key** from the settings section in the collection file.
        Returns true if the value was removed successfully, otherwise false.

        **See also** **customValue** () and **setCustomValue** ().
        """
        ...

    def setAutoSaveFilter(self, save: bool) -> None:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#autoSaveFilter-prop

        **autoSaveFilter : bool**

        This property holds whether **QHelpEngineCore**  is in auto save filter
        mode or not.

        If **QHelpEngineCore**  is in auto save filter mode, the current filter
        is automatically saved when it is changed by the
        **QHelpFilterEngine::setActiveFilter** () function. The filter is saved
        persistently in the help collection file.

        By default, this mode is on.

        **Access functions:**

        bool **autoSaveFilter** () const
        void **setAutoSaveFilter** (bool
        **save** )
        """
        ...

    def setCollectionFile(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#collectionFile-prop

        **collectionFile : QString**

        This property holds the absolute file name of the collection file
        currently used.

        Setting this property leaves the help engine in an invalid state. It is
        important to invoke **setupData** () or any getter function in order to
        setup the help engine again.

        **Access functions:**

        QString **collectionFile** () const
        void **setCollectionFile** (const
        QString & **fileName** )
        """
        ...

    def setCurrentFilter(self, filterName: str) -> None:
        ...

    def setCustomValue(self, key: str, value: Any) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#setCustomValue

        **bool QHelpEngineCore::setCustomValue(const QString & key , const
        QVariant & value )**

        Save the **value** under the **key**. If the key already exist, the
        value will be overwritten. Returns true if the value was saved
        successfully, otherwise false.

        **See also** **customValue** () and **removeCustomValue** ().
        """
        ...

    def setReadOnly(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#readOnly-prop

        **[since 6.0] readOnly : bool**

        This property holds whether the help engine is read-only.

        In read-only mode, the user can use the help engine with a collection
        file installed in a read-only location. In this case, some functionality
        won't be accessible, like registering additional documentation, filter
        editing, or any action that would require changes to the collection
        file. Setting it to `false` enables the full functionality of the help
        engine.

        By default, this property is `true`.

        This property was introduced in Qt 6.0.

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **enable** )

        **Member Function Documentation**
        """
        ...

    def setUsesFilterEngine(self, uses: bool) -> None:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#setUsesFilterEngine

        **[since 5.13] void QHelpEngineCore::setUsesFilterEngine(bool uses )**

        Enables or disables the new filter engine functionality inside the help
        engine, according to the passed **uses** parameter.

        This function was introduced in Qt 5.13.

        **See also** **usesFilterEngine** () and **filterEngine** ().
        """
        ...

    def setupData(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#setupData

        **bool QHelpEngineCore::setupData()**

        Sets up the help engine by processing the information found in the
        collection file and returns true if successful; otherwise returns false.

        By calling the function, the help engine is forced to initialize itself
        immediately. Most of the times, this function does not have to be called
        explicitly because getter functions which depend on a correctly set up
        help engine do that themselves.

        **Note:**`qsqlite4.dll` needs to be deployed with the application as the
        help system uses the sqlite driver when loading help collections.
        """
        ...

    def unregisterDocumentation(self, namespaceName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#unregisterDocumentation

        **bool QHelpEngineCore::unregisterDocumentation(const QString &
        namespaceName )**

        Unregisters the Qt compressed help file (.qch) identified by its
        **namespaceName** from the help collection. Returns true on success,
        otherwise false.

        **See also** **registerDocumentation** () and **error** ().
        """
        ...

    def usesFilterEngine(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#usesFilterEngine

        **[since 5.13] bool QHelpEngineCore::usesFilterEngine() const**

        Returns whether the help engine uses the new filter functionality.

        This function was introduced in Qt 5.13.

        **See also** **setUsesFilterEngine** () and **filterEngine** ().
        """
        ...

    @property
    def setupFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#setupFinished

        **[signal] void QHelpEngineCore::setupFinished()**

        This signal is emitted when the setup is complete.
        """
        ...

    @property
    def setupStarted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#setupStarted

        **[signal] void QHelpEngineCore::setupStarted()**

        This signal is emitted when setup is started.
        """
        ...

    @property
    def warning(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpenginecore.html#warning

        **[signal] void QHelpEngineCore::warning(const QString & msg )**

        This signal is emitted when a non critical error occurs. The warning
        message is stored in **msg**.
        """
        ...
