"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QCompressedHelpInfo(object):
    """
    https://doc.qt.io/qt-6/qcompressedhelpinfo.html

    **Detailed Description**

    The detailed information about the compressed help file can be fetched by
    calling the **fromCompressedHelpFile** () static method, providing the path
    to the compressed help file.

    The class provides access to various information about a compressed help
    file. The namespace associated with the given compressed help file is
    **namespaceName** (), the associated component name is **component** () and
    **version** () provides version information.

    **See also** **QHelpFilterEngine** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#QCompressedHelpInfo

        **QCompressedHelpInfo::QCompressedHelpInfo()**

        Constructs empty information about a compressed help file.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtHelp.QCompressedHelpInfo) -> None:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#QCompressedHelpInfo-1

        **QCompressedHelpInfo::QCompressedHelpInfo(const QCompressedHelpInfo &
        other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def component(self) -> str:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#component

        **QString QCompressedHelpInfo::component() const**

        Returns the component of the compressed help file.
        """
        ...

    @staticmethod
    def fromCompressedHelpFile(
        documentationFileName: str,
    ) -> PySide6.QtHelp.QCompressedHelpInfo:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#fromCompressedHelpFile

        **[static] QCompressedHelpInfo
        QCompressedHelpInfo::fromCompressedHelpFile(const QString &
        documentationFileName )**

        Returns the **QCompressedHelpInfo**  instance for the
        **documentationFileName** of the existing qch file.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#isNull

        **bool QCompressedHelpInfo::isNull() const**

        Returns `true` if the info is invalid, otherwise returns `false`.
        """
        ...

    def namespaceName(self) -> str:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#namespaceName

        **QString QCompressedHelpInfo::namespaceName() const**

        Returns the namespace name of the compressed help file.
        """
        ...

    def swap(self, other: PySide6.QtHelp.QCompressedHelpInfo) -> None:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#swap

        **void QCompressedHelpInfo::swap(QCompressedHelpInfo & other )**

        Swaps the compressed help file **other** with this compressed help file.
        This operation is very fast and never fails.
        """
        ...

    def version(self) -> PySide6.QtCore.QVersionNumber:
        """
        https://doc.qt.io/qt-6/qcompressedhelpinfo.html#version

        **QVersionNumber QCompressedHelpInfo::version() const**

        Returns the version of the compressed help file.
        """
        ...
