"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QWindow(PySide6.QtCore.QObject, PySide6.QtGui.QSurface):
    """
    https://doc.qt.io/qt-6/qwindow.html

    **Detailed Description**

    A window that is supplied a parent becomes a native child window of their
    parent window.

    An application will typically use **QWidget**  or **QQuickView**  for its
    UI, and not QWindow directly. Still, it is possible to render directly to a
    QWindow with **QBackingStore**  or **QOpenGLContext** , when wanting to keep
    dependencies to a minimum or when wanting to use OpenGL directly. The
    **Raster Window Example**  and **OpenGL Window Example**  are useful
    reference examples for how to render to a QWindow using either approach.

    **Resource Management**

    Windows can potentially use a lot of memory. A usual measurement is width
    times height times color depth. A window might also include multiple buffers
    to support double and triple buffering, as well as depth and stencil
    buffers. To release a window's memory resources, call the **destroy** ()
    function.

    **Content Orientation**

    QWindow has **reportContentOrientationChange** () that can be used to
    specify the layout of the window contents in relation to the screen. The
    content orientation is simply a hint to the windowing system about which
    orientation the window contents are in. It's useful when you wish to keep
    the same window size, but rotate the contents instead, especially when doing
    rotation animations between different orientations. The windowing system
    might use this value to determine the layout of system popups or dialogs.

    **Visibility and Windowing System Exposure**

    By default, the window is not visible, and you must call **setVisible**
    (true), or **show** () or similar to make it visible. To make a window
    hidden again, call **setVisible** (false) or **hide** (). The visible
    property describes the state the application wants the window to be in.
    Depending on the underlying system, a visible window might still not be
    shown on the screen. It could, for instance, be covered by other opaque
    windows or moved outside the physical area of the screen. On windowing
    systems that have exposure notifications, the **isExposed** () accessor
    describes whether the window should be treated as directly visible on
    screen. The **exposeEvent** () function is called whenever an area of the
    window is invalidated, for example due to the exposure in the windowing
    system changing. On windowing systems that do not make this information
    visible to the application, **isExposed** () will simply return the same
    value as **isVisible** ().

    **QWindow::Visibility**  queried through **visibility** () is a convenience
    API combining the functions of visible() and **windowStates** ().

    **Rendering**

    There are two Qt APIs that can be used to render content into a window,
    **QBackingStore**  for rendering with a **QPainter**  and flushing the
    contents to a window with type **QSurface::RasterSurface** , and
    **QOpenGLContext**  for rendering with OpenGL to a window with type
    **QSurface::OpenGLSurface** .

    The application can start rendering as soon as **isExposed** () returns
    `true`, and can keep rendering until it **isExposed** () returns `false`. To
    find out when **isExposed** () changes, reimplement **exposeEvent** (). The
    window will always get a resize event before the first expose event.

    **Initial Geometry**

    If the window's width and height are left uninitialized, the window will get
    a reasonable default geometry from the platform window. If the position is
    left uninitialized, then the platform window will allow the windowing system
    to position the window. For example on X11, the window manager usually does
    some kind of smart positioning to try to avoid having new windows completely
    obscure existing windows. However **setGeometry** () initializes both the
    position and the size, so if you want a fixed size but an automatic
    position, you should call **resize** () or **setWidth** () and **setHeight**
    () instead.
    """

    ExcludeTransients: QWindow.AncestorMode = ...
    IncludeTransients: QWindow.AncestorMode = ...
    Hidden: QWindow.Visibility = ...
    AutomaticVisibility: QWindow.Visibility = ...
    Windowed: QWindow.Visibility = ...
    Minimized: QWindow.Visibility = ...
    Maximized: QWindow.Visibility = ...
    FullScreen: QWindow.Visibility = ...

    class AncestorMode(Enum):
        ExcludeTransients: QWindow.AncestorMode = ...
        IncludeTransients: QWindow.AncestorMode = ...

    class Visibility(Enum):
        Hidden: QWindow.Visibility = ...
        AutomaticVisibility: QWindow.Visibility = ...
        Windowed: QWindow.Visibility = ...
        Minimized: QWindow.Visibility = ...
        Maximized: QWindow.Visibility = ...
        FullScreen: QWindow.Visibility = ...

    @overload
    def __init__(self, parent: PySide6.QtGui.QWindow) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#QWindow

        **QWindow::QWindow(QScreen * targetScreen = nullptr)**

        Creates a window as a top level on the **targetScreen**.

        The window is not shown until **setVisible** (true), **show** (), or
        similar is called.

        **See also** **setScreen** ().
        """
        ...

    @overload
    def __init__(self, screen: Optional[PySide6.QtGui.QScreen] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#QWindow-1

        **QWindow::QWindow(QWindow * parent )**

        Creates a window as a child of the given **parent** window.

        The window will be embedded inside the parent window, its coordinates
        relative to the parent.

        The screen is inherited from the parent.

        **See also** **setParent** ().
        """
        ...

    def accessibleRoot(self) -> PySide6.QtGui.QAccessibleInterface:
        ...

    def alert(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#alert

        **[slot, since 5.1] void QWindow::alert(int msec )**

        Causes an alert to be shown for **msec** milliseconds. If **msec** is
        `0` (the default), then the alert is shown indefinitely until the window
        becomes active again. This function has no effect on an active window.

        In alert state, the window indicates that it demands attention, for
        example by flashing or bouncing the taskbar entry.

        This function was introduced in Qt 5.1.
        """
        ...

    def baseSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwindow.html#baseSize

        **QSize QWindow::baseSize() const**

        Returns the base size of the window.

        **See also** **setBaseSize** ().
        """
        ...

    def close(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#close

        **[slot] bool QWindow::close()**

        Close the window.

        This closes the window, effectively calling **destroy** (), and
        potentially quitting the application. Returns `true` on success, false
        if it has a parent window (in which case the top level window should be
        closed instead).

        **See also** **destroy** (), **QGuiApplication::quitOnLastWindowClosed**
        (), and **closeEvent** ().
        """
        ...

    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#closeEvent

        **[virtual protected] void QWindow::closeEvent(QCloseEvent * ev )**

        Override this to handle close events ( **ev** ).

        The function is called when the window is requested to close. Call
        **QEvent::ignore** () on the event if you want to prevent the window
        from being closed.

        **See also** **close** ().
        """
        ...

    def contentOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation:
        """
        https://doc.qt.io/qt-6/qwindow.html#contentOrientation-prop

        **contentOrientation : Qt::ScreenOrientation**

        This property holds the orientation of the window's contents

        This is a hint to the window manager in case it needs to display
        additional content like popups, dialogs, status bars, or similar in
        relation to the window.

        The recommended orientation is **QScreen::orientation** () but an
        application doesn't have to support all possible orientations, and thus
        can opt to ignore the current screen orientation.

        The difference between the window and the content orientation determines
        how much to rotate the content by. **QScreen::angleBetween** (),
        **QScreen::transformBetween** (), and **QScreen::mapBetween** () can be
        used to compute the necessary transform.

        The default value is **Qt::PrimaryOrientation**

        **Access functions:**

        Qt::ScreenOrientation **contentOrientation** () const
        void
        **reportContentOrientationChange** (Qt::ScreenOrientation
        **orientation** )

        **Notifier signal:**

        void **contentOrientationChanged** (Qt::ScreenOrientation
        **orientation** )
        """
        ...

    def create(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#create

        **void QWindow::create()**

        Allocates the platform resources associated with the window.

        It is at this point that the surface format set using **setFormat** ()
        gets resolved into an actual native surface. However, the window remains
        hidden until **setVisible** () is called.

        Note that it is not usually necessary to call this function directly, as
        it will be implicitly called by **show** (), **setVisible** (), and
        other functions that require access to the platform resources.

        Call **destroy** () to free the platform resources if necessary.

        **See also** **destroy** ().
        """
        ...

    def cursor(self) -> PySide6.QtGui.QCursor:
        """
        https://doc.qt.io/qt-6/qwindow.html#cursor

        **QCursor QWindow::cursor() const**

        the cursor shape for this window

        **See also** **setCursor** () and **unsetCursor** ().
        """
        ...

    def destroy(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#destroy

        **void QWindow::destroy()**

        Releases the native platform resources associated with this window.

        **See also** **create** ().
        """
        ...

    def devicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qwindow.html#devicePixelRatio

        **qreal QWindow::devicePixelRatio() const**

        Returns the ratio between physical pixels and device-independent pixels
        for the window. This value is dependent on the screen the window is on,
        and may change when the window is moved.

        Common values are 1.0 on normal displays and 2.0 on Apple "retina"
        displays.

        **Note:** For windows not backed by a platform window, meaning that
        **create** () was not called, the function will fall back to the
        associated **QScreen** 's device pixel ratio.

        **See also** **QScreen::devicePixelRatio** ().
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#event

        **[override virtual protected] bool QWindow::event(QEvent * ev )**

        Reimplements: **QObject::event** (QEvent *e).

        Override this to handle any event ( **ev** ) sent to the window. Return
        `true` if the event was recognized and processed.

        Remember to call the base class version if you wish for mouse events,
        key events, resize events, etc to be dispatched as usual.
        """
        ...

    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#exposeEvent

        **[virtual protected] void QWindow::exposeEvent(QExposeEvent * ev )**

        The expose event ( **ev** ) is sent by the window system when a window
        moves between the un-exposed and exposed states.

        An exposed window is potentially visible to the user. If the window is
        moved off screen, is made totally obscured by another window, is
        minimized, or similar, this function might be called and the value of
        **isExposed** () might change to false. You may use this event to limit
        expensive operations such as animations to only run when the window is
        exposed.

        This event should not be used to paint. To handle painting implement
        **paintEvent** () instead.

        A resize event will always be sent before the expose event the first
        time a window is shown.

        **See also** **paintEvent** () and **isExposed** ().
        """
        ...

    def filePath(self) -> str:
        """
        https://doc.qt.io/qt-6/qwindow.html#filePath

        **QString QWindow::filePath() const**

        the file name this window is representing.

        **See also** **setFilePath** ().
        """
        ...

    def flags(self) -> PySide6.QtCore.Qt.WindowFlags:
        """
        https://doc.qt.io/qt-6/qwindow.html#flags-prop

        **flags : Qt::WindowFlags**

        This property holds the window flags of the window

        The window flags control the window's appearance in the windowing
        system, whether it's a dialog, popup, or a regular window, and whether
        it should have a title bar, etc.

        The actual window flags might differ from the flags set with setFlags()
        if the requested flags could not be fulfilled.

        **Access functions:**

        Qt::WindowFlags **flags** () const
        void **setFlags** (Qt::WindowFlags
        **flags** )

        **See also** **setFlag** ().
        """
        ...

    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#focusInEvent

        **[virtual protected] void QWindow::focusInEvent(QFocusEvent * ev )**

        Override this to handle focus in events ( **ev** ).

        Focus in events are sent when the window receives keyboard focus.

        **See also** **focusOutEvent** ().
        """
        ...

    def focusObject(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qwindow.html#focusObject

        **[virtual] QObject *QWindow::focusObject() const**

        Returns the **QObject**  that will be the final receiver of events tied
        focus, such as key events.
        """
        ...

    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#focusOutEvent

        **[virtual protected] void QWindow::focusOutEvent(QFocusEvent * ev )**

        Override this to handle focus out events ( **ev** ).

        Focus out events are sent when the window loses keyboard focus.

        **See also** **focusInEvent** ().
        """
        ...

    def format(self) -> PySide6.QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-6/qwindow.html#format

        **[override virtual] QSurfaceFormat QWindow::format() const**

        Reimplements: **QSurface::format() const** .

        Returns the actual format of this window.

        After the window has been created, this function will return the actual
        surface format of the window. It might differ from the requested format
        if the requested format could not be fulfilled by the platform. It might
        also be a superset, for example certain buffer sizes may be larger than
        requested.

        **Note:** Depending on the platform, certain values in this surface
        format may still contain the requested values, that is, the values that
        have been passed to **setFormat** (). Typical examples are the OpenGL
        version, profile and options. These may not get updated during
        **create** () since these are context specific and a single window may
        be used together with multiple contexts over its lifetime. Use the
        **QOpenGLContext** 's format() instead to query such values.

        **See also** **setFormat** (), **create** (), **requestedFormat** (),
        and **QOpenGLContext::format** ().
        """
        ...

    def frameGeometry(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qwindow.html#frameGeometry

        **QRect QWindow::frameGeometry() const**

        Returns the geometry of the window, including its window frame.

        The geometry is in relation to the virtualGeometry() of its screen.

        **See also** **geometry** () and **frameMargins** ().
        """
        ...

    def frameMargins(self) -> PySide6.QtCore.QMargins:
        """
        https://doc.qt.io/qt-6/qwindow.html#frameMargins

        **QMargins QWindow::frameMargins() const**

        Returns the window frame margins surrounding the window.

        **See also** **geometry** () and **frameGeometry** ().
        """
        ...

    def framePosition(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwindow.html#framePosition

        **QPoint QWindow::framePosition() const**

        Returns the top left position of the window, including its window frame.

        This returns the same value as **frameGeometry** ().topLeft().

        **See also** **setFramePosition** (), **geometry** (), and
        **frameGeometry** ().
        """
        ...

    @staticmethod
    def fromWinId(id: int) -> PySide6.QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qwindow.html#fromWinId

        **[static] QWindow *QWindow::fromWinId(WId id )**

        Creates a local representation of a window created by another process or
        by using native libraries below Qt.

        Given the handle **id** to a native window, this method creates a
        **QWindow**  object which can be used to represent the window when
        invoking methods like **setParent** () and **setTransientParent** ().

        This can be used, on platforms which support it, to embed a **QWindow**
        inside a native window, or to embed a native window inside a **QWindow**
        .

        If foreign windows are not supported or embedding the native window
        failed in the platform plugin, this function returns `nullptr`.

        **Note:** The resulting **QWindow**  should not be used to manipulate
        the underlying native window (besides re-parenting), or to observe state
        changes of the native window. Any support for these kind of operations
        is incidental, highly platform dependent and untested.

        **See also** **setParent** ().
        """
        ...

    def geometry(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qwindow.html#geometry

        **QRect QWindow::geometry() const**

        Returns the geometry of the window, excluding its window frame.

        The geometry is in relation to the virtualGeometry() of its screen.

        **See also** **setGeometry** (), **frameMargins** (), and
        **frameGeometry** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#height-prop

        **height : int**

        This property holds the height of the window's geometry

        **Access functions:**

        int **height** () const
        void **setHeight** (int **arg** )

        **Notifier signal:**

        void **heightChanged** (int **arg** )
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#hide

        **[slot] void QWindow::hide()**

        Hides the window.

        Equivalent to calling **setVisible** (false).

        **See also** **show** () and **setVisible** ().
        """
        ...

    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#hideEvent

        **[virtual protected] void QWindow::hideEvent(QHideEvent * ev )**

        Override this to handle hide events ( **ev** ).

        The function is called when the window has requested being hidden in the
        windowing system.
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qwindow.html#icon

        **QIcon QWindow::icon() const**

        Returns the window's icon in the windowing system

        **See also** **setIcon** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#isActive

        **bool QWindow::isActive() const**

        Returns `true` if the window is active.

        This is the case for the window that has input focus as well as windows
        that are in the same parent / transient parent chain as the focus
        window.

        Typically active windows should appear active from a style perspective.

        To get the window that currently has focus, use
        **QGuiApplication::focusWindow** ().

        **Note:** Getter function for property **active** .
        """
        ...

    def isAncestorOf(
        self,
        child: PySide6.QtGui.QWindow,
        mode: PySide6.QtGui.QWindow.AncestorMode = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#isAncestorOf

        **bool QWindow::isAncestorOf(const QWindow * child ,
        QWindow::AncestorMode mode = IncludeTransients) const**

        Returns `true` if the window is an ancestor of the given **child**. If
        **mode** is **IncludeTransients** , then transient parents are also
        considered ancestors.
        """
        ...

    def isExposed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#isExposed

        **bool QWindow::isExposed() const**

        Returns if this window is exposed in the windowing system.

        When the window is not exposed, it is shown by the application but it is
        still not showing in the windowing system, so the application should
        minimize animations and other graphical activities.

        An **exposeEvent** () is sent every time this value changes.

        **See also** **exposeEvent** ().
        """
        ...

    def isModal(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#isModal

        **bool QWindow::isModal() const**

        Returns whether the window is modal.

        A modal window prevents other windows from getting any input.

        **See also** **QWindow::modality** .
        """
        ...

    def isTopLevel(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#isTopLevel

        **bool QWindow::isTopLevel() const**

        Returns whether the window is top level, i.e. has no parent window.
        """
        ...

    def isVisible(self) -> bool:
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#keyPressEvent

        **[virtual protected] void QWindow::keyPressEvent(QKeyEvent * ev )**

        Override this to handle key press events ( **ev** ).

        **See also** **keyReleaseEvent** ().
        """
        ...

    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#keyReleaseEvent

        **[virtual protected] void QWindow::keyReleaseEvent(QKeyEvent * ev )**

        Override this to handle key release events ( **ev** ).

        **See also** **keyPressEvent** ().
        """
        ...

    def lower(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#lower

        **[slot] void QWindow::lower()**

        Lower the window in the windowing system.

        Requests that the window be lowered to appear below other windows.
        """
        ...

    @overload
    def mapFromGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwindow.html#mapFromGlobal

        **[since 6.0] QPointF QWindow::mapFromGlobal(const QPointF & pos )
        const**

        Translates the global screen coordinate **pos** to window coordinates.

        This function was introduced in Qt 6.0.

        **See also** **mapToGlobal** ().
        """
        ...

    @overload
    def mapFromGlobal(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qwindow.html#mapFromGlobal-1

        **QPoint QWindow::mapFromGlobal(const QPoint & pos ) const**

        This is an overloaded function.
        """
        ...

    @overload
    def mapToGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwindow.html#mapToGlobal

        **[since 6.0] QPointF QWindow::mapToGlobal(const QPointF & pos ) const**

        Translates the window coordinate **pos** to global screen coordinates.
        For example, `mapToGlobal(QPointF(0,0))` would give the global
        coordinates of the top-left pixel of the window.

        This function was introduced in Qt 6.0.

        **See also** **mapFromGlobal** ().
        """
        ...

    @overload
    def mapToGlobal(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qwindow.html#mapToGlobal-1

        **QPoint QWindow::mapToGlobal(const QPoint & pos ) const**

        This is an overloaded function.
        """
        ...

    def mask(self) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qwindow.html#mask

        **QRegion QWindow::mask() const**

        Returns the mask set on the window.

        The mask is a hint to the windowing system that the application does not
        want to receive mouse or touch input outside the given region.

        **See also** **setMask** ().
        """
        ...

    def maximumHeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#maximumHeight-prop

        **maximumHeight : int**

        This property holds the maximum height of the window's geometry

        **Access functions:**

        int **maximumHeight** () const
        void **setMaximumHeight** (int **h** )

        **Notifier signal:**

        void **maximumHeightChanged** (int **arg** )
        """
        ...

    def maximumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwindow.html#maximumSize

        **QSize QWindow::maximumSize() const**

        Returns the maximum size of the window.

        **See also** **setMaximumSize** ().
        """
        ...

    def maximumWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#maximumWidth-prop

        **maximumWidth : int**

        This property holds the maximum width of the window's geometry

        **Access functions:**

        int **maximumWidth** () const
        void **setMaximumWidth** (int **w** )

        **Notifier signal:**

        void **maximumWidthChanged** (int **arg** )
        """
        ...

    def minimumHeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#minimumHeight-prop

        **minimumHeight : int**

        This property holds the minimum height of the window's geometry

        **Access functions:**

        int **minimumHeight** () const
        void **setMinimumHeight** (int **h** )

        **Notifier signal:**

        void **minimumHeightChanged** (int **arg** )
        """
        ...

    def minimumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwindow.html#minimumSize

        **QSize QWindow::minimumSize() const**

        Returns the minimum size of the window.

        **See also** **setMinimumSize** ().
        """
        ...

    def minimumWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#minimumWidth-prop

        **minimumWidth : int**

        This property holds the minimum width of the window's geometry

        **Access functions:**

        int **minimumWidth** () const
        void **setMinimumWidth** (int **w** )

        **Notifier signal:**

        void **minimumWidthChanged** (int **arg** )
        """
        ...

    def modality(self) -> PySide6.QtCore.Qt.WindowModality:
        """
        https://doc.qt.io/qt-6/qwindow.html#modality-prop

        **modality : Qt::WindowModality**

        This property holds the modality of the window

        A modal window prevents other windows from receiving input events. Qt
        supports two types of modality: **Qt::WindowModal**  and
        **Qt::ApplicationModal** .

        By default, this property is **Qt::NonModal**

        **Access functions:**

        Qt::WindowModality **modality** () const
        void **setModality**
        (Qt::WindowModality **modality** )

        **Notifier signal:**

        void ****modalityChanged** ** (Qt::WindowModality **modality** )

        **See also** **Qt::WindowModality** .
        """
        ...

    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#mouseDoubleClickEvent

        **[virtual protected] void QWindow::mouseDoubleClickEvent(QMouseEvent *
        ev )**

        Override this to handle mouse double click events ( **ev** ).

        **See also** **mousePressEvent** () and
        **QStyleHints::mouseDoubleClickInterval** ().
        """
        ...

    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#mouseMoveEvent

        **[virtual protected] void QWindow::mouseMoveEvent(QMouseEvent * ev )**

        Override this to handle mouse move events ( **ev** ).
        """
        ...

    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#mousePressEvent

        **[virtual protected] void QWindow::mousePressEvent(QMouseEvent * ev )**

        Override this to handle mouse press events ( **ev** ).

        **See also** **mouseReleaseEvent** ().
        """
        ...

    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#mouseReleaseEvent

        **[virtual protected] void QWindow::mouseReleaseEvent(QMouseEvent * ev
        )**

        Override this to handle mouse release events ( **ev** ).

        **See also** **mousePressEvent** ().
        """
        ...

    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#moveEvent

        **[virtual protected] void QWindow::moveEvent(QMoveEvent * ev )**

        Override this to handle window move events ( **ev** ).
        """
        ...

    def nativeEvent(
        self, eventType: Union[PySide6.QtCore.QByteArray, bytes], message: int
    ) -> Tuple[object, int]:
        """
        https://doc.qt.io/qt-6/qwindow.html#nativeEvent

        **[virtual protected] bool QWindow::nativeEvent(const QByteArray &
        eventType , void * message , qintptr * result )**

        Override this to handle platform dependent events. Will be given
        **eventType** , **message** and **result**.

        This might make your application non-portable.

        Should return true only if the event was handled.
        """
        ...

    def opacity(self) -> float:
        """
        https://doc.qt.io/qt-6/qwindow.html#opacity-prop

        **[since 5.1] opacity : qreal**

        This property holds the opacity of the window in the windowing system.

        If the windowing system supports window opacity, this can be used to
        fade the window in and out, or to make it semitransparent.

        A value of 1.0 or above is treated as fully opaque, whereas a value of
        0.0 or below is treated as fully transparent. Values inbetween represent
        varying levels of translucency between the two extremes.

        The default value is 1.0.

        This property was introduced in Qt 5.1.

        **Access functions:**

        qreal **opacity** () const
        void **setOpacity** (qreal **level** )

        **Notifier signal:**

        void **opacityChanged** (qreal **opacity** )
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#paintEvent

        **[virtual protected, since 6.0] void QWindow::paintEvent(QPaintEvent *
        ev )**

        The paint event ( **ev** ) is sent by the window system whenever an area
        of the window needs a repaint, for example when initially showing the
        window, or due to parts of the window being uncovered by moving another
        window.

        The application is expected to render into the window in response to the
        paint event, regardless of the exposed state of the window. For example,
        a paint event may be sent before the window is exposed, to prepare it
        for showing to the user.

        This function was introduced in Qt 6.0.

        **See also** **exposeEvent** ().
        """
        ...

    def parent(
        self, mode: PySide6.QtGui.QWindow.AncestorMode = ...
    ) -> PySide6.QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qwindow.html#parent

        **[since 5.9] QWindow *QWindow::parent(QWindow::AncestorMode mode =
        ExcludeTransients) const**

        Returns the parent window, if any.

        If **mode** is **IncludeTransients** , then the transient parent is
        returned if there is no parent.

        A window without a parent is known as a top level window.

        This function was introduced in Qt 5.9.

        **See also** **setParent** ().
        """
        ...

    def position(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwindow.html#position

        **QPoint QWindow::position() const**

        Returns the position of the window on the desktop excluding any window
        frame

        **See also** **setPosition** ().
        """
        ...

    def raise_(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#raise

        **[slot] void QWindow::raise()**

        Raise the window in the windowing system.

        Requests that the window be raised to appear above other windows.
        """
        ...

    def reportContentOrientationChange(
        self, orientation: PySide6.QtCore.Qt.ScreenOrientation
    ) -> None:
        ...

    def requestActivate(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#requestActivate

        **[slot] void QWindow::requestActivate()**

        Requests the window to be activated, i.e. receive keyboard focus.

        **See also** **isActive** () and **QGuiApplication::focusWindow** ().
        """
        ...

    def requestUpdate(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#requestUpdate

        **[slot, since 5.5] void QWindow::requestUpdate()**

        Schedules a **QEvent::UpdateRequest**  event to be delivered to this
        window.

        The event is delivered in sync with the display vsync on platforms where
        this is possible. Otherwise, the event is delivered after a delay of 5
        ms. The additional time is there to give the event loop a bit of idle
        time to gather system events, and can be overridden using the
        QT_QPA_UPDATE_IDLE_TIME environment variable.

        When driving animations, this function should be called once after
        drawing has completed. Calling this function multiple times will result
        in a single event being delivered to the window.

        Subclasses of **QWindow**  should reimplement **event** (), intercept
        the event and call the application's rendering code, then call the base
        class implementation.

        **Note:** The subclass' reimplementation of **event** () must invoke the
        base class implementation, unless it is absolutely sure that the event
        does not need to be handled by the base class. For example, the default
        implementation of this function relies on **QEvent::Timer**  events.
        Filtering them away would therefore break the delivery of the update
        events.

        This function was introduced in Qt 5.5.
        """
        ...

    def requestedFormat(self) -> PySide6.QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-6/qwindow.html#requestedFormat

        **QSurfaceFormat QWindow::requestedFormat() const**

        Returns the requested surface format of this window.

        If the requested format was not supported by the platform
        implementation, the requestedFormat will differ from the actual window
        format.

        This is the value set with **setFormat** ().

        **See also** **setFormat** () and **format** ().
        """
        ...

    @overload
    def resize(self, newSize: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#resize

        **void QWindow::resize(const QSize & newSize )**

        set the size of the window, excluding any window frame, to **newSize**

        **See also** **size** () and **geometry** ().
        """
        ...

    @overload
    def resize(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#resize-1

        **void QWindow::resize(int w , int h )**

        set the size of the window, excluding any window frame, to a **QSize**
        constructed from width **w** and height **h**

        For interactively resizing windows, see **startSystemResize** ().

        **See also** **size** () and **geometry** ().
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#resizeEvent

        **[virtual protected] void QWindow::resizeEvent(QResizeEvent * ev )**

        Override this to handle resize events ( **ev** ).

        The resize event is called whenever the window is resized in the
        windowing system, either directly through the windowing system
        acknowledging a **setGeometry** () or **resize** () request, or
        indirectly through the user resizing the window manually.
        """
        ...

    def resolveInterface(self, name: bytes, revision: int) -> int:
        ...

    def screen(self) -> PySide6.QtGui.QScreen:
        """
        https://doc.qt.io/qt-6/qwindow.html#screen

        **QScreen *QWindow::screen() const**

        Returns the screen on which the window is shown, or null if there is
        none.

        For child windows, this returns the screen of the corresponding top
        level window.

        **See also** **setScreen** () and **QScreen::virtualSiblings** ().
        """
        ...

    def setBaseSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setBaseSize

        **void QWindow::setBaseSize(const QSize & size )**

        Sets the base **size** of the window.

        The base size is used to calculate a proper window size if the window
        defines **sizeIncrement** ().

        **See also** **setMinimumSize** (), **setMaximumSize** (),
        **setSizeIncrement** (), and **baseSize** ().
        """
        ...

    def setCursor(
        self,
        arg__1: Union[
            PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setCursor

        **void QWindow::setCursor(const QCursor & cursor )**

        set the cursor shape for this window

        The mouse **cursor** will assume this shape when it is over this window,
        unless an override cursor is set. See the **list of predefined cursor
        objects**  for a range of useful shapes.

        If no cursor has been set, or after a call to **unsetCursor** (), the
        parent window's cursor is used.

        By default, the cursor has the **Qt::ArrowCursor**  shape.

        Some underlying window implementations will reset the cursor if it
        leaves a window even if the mouse is grabbed. If you want to have a
        cursor set for all windows, even when outside the window, consider
        **QGuiApplication::setOverrideCursor** ().

        **See also** **cursor** () and **QGuiApplication::setOverrideCursor**
        ().
        """
        ...

    def setFilePath(self, filePath: str) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setFilePath

        **void QWindow::setFilePath(const QString & filePath )**

        set the file name this window is representing.

        The windowing system might use **filePath** to display the path of the
        document this window is representing in the tile bar.

        **See also** **filePath** ().
        """
        ...

    def setFlag(self, arg__1: PySide6.QtCore.Qt.WindowType, on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setFlag

        **[since 5.9] void QWindow::setFlag(Qt::WindowType flag , bool on =
        true)**

        Sets the window flag **flag** on this window if **on** is true;
        otherwise clears the flag.

        This function was introduced in Qt 5.9.

        **See also** **setFlags** (), **flags** (), and **type** ().
        """
        ...

    def setFlags(self, flags: PySide6.QtCore.Qt.WindowFlags) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#flags-prop

        **flags : Qt::WindowFlags**

        This property holds the window flags of the window

        The window flags control the window's appearance in the windowing
        system, whether it's a dialog, popup, or a regular window, and whether
        it should have a title bar, etc.

        The actual window flags might differ from the flags set with setFlags()
        if the requested flags could not be fulfilled.

        **Access functions:**

        Qt::WindowFlags **flags** () const
        void **setFlags** (Qt::WindowFlags
        **flags** )

        **See also** **setFlag** ().
        """
        ...

    def setFormat(
        self,
        format: Union[
            PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOptions
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setFormat

        **void QWindow::setFormat(const QSurfaceFormat & format )**

        Sets the window's surface **format**.

        The format determines properties such as color depth, alpha, depth and
        stencil buffer size, etc. For example, to give a window a transparent
        background (provided that the window system supports compositing, and
        provided that other content in the window does not make it opaque
        again):

        **QSurfaceFormat**  format;
            format.setAlphaBufferSize(8);
        window.setFormat(format);

        The surface format will be resolved in the **create** () function.
        Calling this function after **create** () has been called will not re-
        resolve the surface format of the native surface.

        When the format is not explicitly set via this function, the format
        returned by **QSurfaceFormat::defaultFormat** () will be used. This
        means that when having multiple windows, individual calls to this
        function can be replaced by one single call to
        **QSurfaceFormat::setDefaultFormat** () before creating the first
        window.

        **See also** **format** (), **create** (), **destroy** (), and
        **QSurfaceFormat::setDefaultFormat** ().
        """
        ...

    def setFramePosition(self, point: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setFramePosition

        **void QWindow::setFramePosition(const QPoint & point )**

        Sets the upper left position of the window ( **point** ) including its
        window frame.

        The position is in relation to the virtualGeometry() of its screen.

        **See also** **framePosition** (), **setGeometry** (), and
        **frameGeometry** ().
        """
        ...

    @overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setGeometry

        **[slot] void QWindow::setGeometry(int posx , int posy , int w , int h
        )**

        Sets the geometry of the window, excluding its window frame, to a
        rectangle constructed from **posx** , **posy** , **w** and **h**.

        The geometry is in relation to the virtualGeometry() of its screen.

        **See also** **geometry** ().
        """
        ...

    @overload
    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setGeometry-1

        **[slot] void QWindow::setGeometry(const QRect & rect )**

        Sets the geometry of the window, excluding its window frame, to
        **rect**.

        The geometry is in relation to the virtualGeometry() of its screen.

        **See also** **geometry** ().
        """
        ...

    def setHeight(self, arg: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#height-prop

        **height : int**

        This property holds the height of the window's geometry

        **Access functions:**

        int **height** () const
        void **setHeight** (int **arg** )

        **Notifier signal:**

        void **heightChanged** (int **arg** )
        """
        ...

    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setIcon

        **void QWindow::setIcon(const QIcon & icon )**

        Sets the window's **icon** in the windowing system

        The window icon might be used by the windowing system for example to
        decorate the window, and/or in the task switcher.

        **Note:** On macOS, the window title bar icon is meant for windows
        representing documents, and will only show up if a file path is also
        set.

        **See also** **icon** () and **setFilePath** ().
        """
        ...

    def setKeyboardGrabEnabled(self, grab: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#setKeyboardGrabEnabled

        **bool QWindow::setKeyboardGrabEnabled(bool grab )**

        Sets whether keyboard grab should be enabled or not ( **grab** ).

        If the return value is true, the window receives all key events until
        setKeyboardGrabEnabled(false) is called; other windows get no key events
        at all. Mouse events are not affected. Use **setMouseGrabEnabled** () if
        you want to grab that.

        **See also** **setMouseGrabEnabled** ().
        """
        ...

    def setMask(
        self,
        region: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setMask

        **void QWindow::setMask(const QRegion & region )**

        Sets the mask of the window.

        The mask is a hint to the windowing system that the application does not
        want to receive mouse or touch input outside the given **region**.

        The window manager may or may not choose to display any areas of the
        window not included in the mask, thus it is the application's
        responsibility to clear to transparent the areas that are not part of
        the mask.

        **See also** **mask** ().
        """
        ...

    def setMaximumHeight(self, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#maximumHeight-prop

        **maximumHeight : int**

        This property holds the maximum height of the window's geometry

        **Access functions:**

        int **maximumHeight** () const
        void **setMaximumHeight** (int **h** )

        **Notifier signal:**

        void **maximumHeightChanged** (int **arg** )
        """
        ...

    def setMaximumSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setMaximumSize

        **void QWindow::setMaximumSize(const QSize & size )**

        Sets the maximum size of the window.

        This is a hint to the window manager to prevent resizing above the
        specified **size**.

        **See also** **setMinimumSize** () and **maximumSize** ().
        """
        ...

    def setMaximumWidth(self, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#maximumWidth-prop

        **maximumWidth : int**

        This property holds the maximum width of the window's geometry

        **Access functions:**

        int **maximumWidth** () const
        void **setMaximumWidth** (int **w** )

        **Notifier signal:**

        void **maximumWidthChanged** (int **arg** )
        """
        ...

    def setMinimumHeight(self, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#minimumHeight-prop

        **minimumHeight : int**

        This property holds the minimum height of the window's geometry

        **Access functions:**

        int **minimumHeight** () const
        void **setMinimumHeight** (int **h** )

        **Notifier signal:**

        void **minimumHeightChanged** (int **arg** )
        """
        ...

    def setMinimumSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setMinimumSize

        **void QWindow::setMinimumSize(const QSize & size )**

        Sets the minimum size of the window.

        This is a hint to the window manager to prevent resizing below the
        specified **size**.

        **See also** **setMaximumSize** () and **minimumSize** ().
        """
        ...

    def setMinimumWidth(self, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#minimumWidth-prop

        **minimumWidth : int**

        This property holds the minimum width of the window's geometry

        **Access functions:**

        int **minimumWidth** () const
        void **setMinimumWidth** (int **w** )

        **Notifier signal:**

        void **minimumWidthChanged** (int **arg** )
        """
        ...

    def setModality(self, modality: PySide6.QtCore.Qt.WindowModality) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#modality-prop

        **modality : Qt::WindowModality**

        This property holds the modality of the window

        A modal window prevents other windows from receiving input events. Qt
        supports two types of modality: **Qt::WindowModal**  and
        **Qt::ApplicationModal** .

        By default, this property is **Qt::NonModal**

        **Access functions:**

        Qt::WindowModality **modality** () const
        void **setModality**
        (Qt::WindowModality **modality** )

        **Notifier signal:**

        void ****modalityChanged** ** (Qt::WindowModality **modality** )

        **See also** **Qt::WindowModality** .
        """
        ...

    def setMouseGrabEnabled(self, grab: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#setMouseGrabEnabled

        **bool QWindow::setMouseGrabEnabled(bool grab )**

        Sets whether mouse grab should be enabled or not ( **grab** ).

        If the return value is true, the window receives all mouse events until
        setMouseGrabEnabled(false) is called; other windows get no mouse events
        at all. Keyboard events are not affected. Use **setKeyboardGrabEnabled**
        () if you want to grab that.

        **See also** **setKeyboardGrabEnabled** ().
        """
        ...

    def setOpacity(self, level: float) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#opacity-prop

        **[since 5.1] opacity : qreal**

        This property holds the opacity of the window in the windowing system.

        If the windowing system supports window opacity, this can be used to
        fade the window in and out, or to make it semitransparent.

        A value of 1.0 or above is treated as fully opaque, whereas a value of
        0.0 or below is treated as fully transparent. Values inbetween represent
        varying levels of translucency between the two extremes.

        The default value is 1.0.

        This property was introduced in Qt 5.1.

        **Access functions:**

        qreal **opacity** () const
        void **setOpacity** (qreal **level** )

        **Notifier signal:**

        void **opacityChanged** (qreal **opacity** )
        """
        ...

    def setParent(self, parent: PySide6.QtGui.QWindow) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setParent

        **void QWindow::setParent(QWindow * parent )**

        Sets the **parent** Window. This will lead to the windowing system
        managing the clip of the window, so it will be clipped to the **parent**
        window.

        Setting **parent** to be `nullptr` will make the window become a top
        level window.

        If **parent** is a window created by **fromWinId** (), then the current
        window will be embedded inside **parent** , if the platform supports it.

        **See also** **parent** ().
        """
        ...

    @overload
    def setPosition(self, posx: int, posy: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setPosition

        **void QWindow::setPosition(const QPoint & pt )**

        set the position of the window on the desktop to **pt**

        The position is in relation to the virtualGeometry() of its screen.

        For interactively moving windows, see **startSystemMove** (). For
        interactively resizing windows, see **startSystemResize** ().

        **See also** **position** () and **startSystemMove** ().
        """
        ...

    @overload
    def setPosition(self, pt: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setPosition-1

        **void QWindow::setPosition(int posx , int posy )**

        set the position of the window on the desktop to **posx** , **posy**

        The position is in relation to the virtualGeometry() of its screen.

        **See also** **position** ().
        """
        ...

    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setScreen

        **void QWindow::setScreen(QScreen * newScreen )**

        Sets the screen on which the window should be shown.

        If the window has been created, it will be recreated on the
        **newScreen**.

        **Note:** If the screen is part of a virtual desktop of multiple
        screens, the window will not move automatically to **newScreen**. To
        place the window relative to the screen, use the screen's topLeft()
        position.

        This function only works for top level windows.

        **See also** **screen** () and **QScreen::virtualSiblings** ().
        """
        ...

    def setSizeIncrement(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setSizeIncrement

        **void QWindow::setSizeIncrement(const QSize & size )**

        Sets the size increment ( **size** ) of the window.

        When the user resizes the window, the size will move in steps of
        **sizeIncrement** ().**width** () pixels horizontally and
        **sizeIncrement** ().**height** () pixels vertically, with **baseSize**
        () as the basis.

        By default, this property contains a size with zero width and height.

        The windowing system might not support size increments.

        **See also** **sizeIncrement** (), **setBaseSize** (),
        **setMinimumSize** (), and **setMaximumSize** ().
        """
        ...

    def setSurfaceType(self, surfaceType: PySide6.QtGui.QSurface.SurfaceType) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setSurfaceType

        **void QWindow::setSurfaceType(QSurface::SurfaceType surfaceType )**

        Sets the **surfaceType** of the window.

        Specifies whether the window is meant for raster rendering with
        **QBackingStore** , or OpenGL rendering with **QOpenGLContext** .

        The **surfaceType**  will be used when the native surface is created in
        the **create** () function. Calling this function after the native
        surface has been created requires calling **destroy** () and **create**
        () to release the old native surface and create a new one.

        **See also** **surfaceType** (), **QBackingStore** , **QOpenGLContext**
        , **create** (), and **destroy** ().
        """
        ...

    def setTitle(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#title-prop

        **title : QString**

        This property holds the window's title in the windowing system

        The window title might appear in the title area of the window
        decorations, depending on the windowing system and the window flags. It
        might also be used by the windowing system to identify the window in
        other contexts, such as in the task switcher.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &)

        **Notifier signal:**

        void **windowTitleChanged** (const QString & **title** )

        **See also** **flags** ().
        """
        ...

    def setTransientParent(self, parent: PySide6.QtGui.QWindow) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#transientParent-prop

        **[since 5.13] transientParent : QWindow***

        This property holds the window for which this window is a transient pop-
        up

        This is a hint to the window manager that this window is a dialog or
        pop-up on behalf of the transient parent.

        In order to cause the window to be centered above its transient
        **parent** by default, depending on the window manager, it may also be
        necessary to call **setFlags** () with a suitable **Qt::WindowType**
        (such as `Qt::Dialog`).

        This property was introduced in Qt 5.13.

        **Access functions:**

        QWindow * **transientParent** () const
        void **setTransientParent**
        (QWindow * **parent** )

        **Notifier signal:**

        void **transientParentChanged** (QWindow * **transientParent** )

        **See also** **parent** ().
        """
        ...

    def setVisibility(self, v: PySide6.QtGui.QWindow.Visibility) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#visibility-prop

        **[since 5.1] visibility : Visibility**

        This property holds the screen-occupation state of the window

        Visibility is whether the window should appear in the windowing system
        as normal, minimized, maximized, fullscreen or hidden.

        To set the visibility to **AutomaticVisibility**  means to give the
        window a default visible state, which might be fullscreen or windowed
        depending on the platform. When reading the visibility property you will
        always get the actual state, never **AutomaticVisibility** .

        This property was introduced in Qt 5.1.

        **Access functions:**

        QWindow::Visibility **visibility** () const
        void **setVisibility**
        (QWindow::Visibility **v** )

        **Notifier signal:**

        void **visibilityChanged** (QWindow::Visibility **visibility** )
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#visible-prop

        **visible : bool**

        This property holds whether the window is visible or not

        This property controls the visibility of the window in the windowing
        system.

        By default, the window is not visible, you must call setVisible(true),
        or **show** () or similar to make it visible.

        **Note:** Hiding a window does not remove the window from the windowing
        system, it only hides it. On windowing systems that give full screen
        applications a dedicated desktop (such as macOS), hiding a full screen
        window will not remove that desktop, but leave it blank. Another window
        from the same application might be shown full screen, and will fill that
        desktop. Use **QWindow::close**  to completely remove a window from the
        windowing system.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Notifier signal:**

        void **visibleChanged** (bool **arg** )

        **See also** **show** ().
        """
        ...

    def setWidth(self, arg: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#width-prop

        **width : int**

        This property holds the width of the window's geometry

        **Access functions:**

        int **width** () const
        void **setWidth** (int **arg** )

        **Notifier signal:**

        void **widthChanged** (int **arg** )
        """
        ...

    def setWindowState(self, state: PySide6.QtCore.Qt.WindowState) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setWindowState

        **void QWindow::setWindowState(Qt::WindowState state )**

        set the screen-occupation state of the window

        The window **state** represents whether the window appears in the
        windowing system as maximized, minimized, fullscreen, or normal.

        The enum value **Qt::WindowActive**  is not an accepted parameter.

        **See also** **windowState** (), **showNormal** (), **showFullScreen**
        (), **showMinimized** (), **showMaximized** (), and **setWindowStates**
        ().
        """
        ...

    def setWindowStates(self, states: PySide6.QtCore.Qt.WindowStates) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#setWindowStates

        **[since 5.10] void QWindow::setWindowStates(Qt::WindowStates state )**

        set the screen-occupation state of the window

        The window **state** represents whether the window appears in the
        windowing system as maximized, minimized and/or fullscreen.

        The window can be in a combination of several states. For example, if
        the window is both minimized and maximized, the window will appear
        minimized, but clicking on the task bar entry will restore it to the
        maximized state.

        The enum value **Qt::WindowActive**  should not be set.

        This function was introduced in Qt 5.10.

        **See also** **windowStates** (), **showNormal** (), **showFullScreen**
        (), **showMinimized** (), and **showMaximized** ().
        """
        ...

    def setX(self, arg: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#x-prop

        **x : int**

        This property holds the x position of the window's geometry

        **Access functions:**

        int **x** () const
        void **setX** (int **arg** )

        **Notifier signal:**

        void **xChanged** (int **arg** )
        """
        ...

    def setY(self, arg: int) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#y-prop

        **y : int**

        This property holds the y position of the window's geometry

        **Access functions:**

        int **y** () const
        void **setY** (int **arg** )

        **Notifier signal:**

        void **yChanged** (int **arg** )

        **Member Function Documentation**
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#show

        **[slot] void QWindow::show()**

        Shows the window.

        This is equivalent to calling **showFullScreen** (), **showMaximized**
        (), or **showNormal** (), depending on the platform's default behavior
        for the window type and flags.

        **See also** **showFullScreen** (), **showMaximized** (), **showNormal**
        (), **hide** (), **QStyleHints::showIsFullScreen** (), and **flags** ().
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#showEvent

        **[virtual protected] void QWindow::showEvent(QShowEvent * ev )**

        Override this to handle show events ( **ev** ).

        The function is called when the window has requested becoming visible.

        If the window is successfully shown by the windowing system, this will
        be followed by a resize and an expose event.
        """
        ...

    def showFullScreen(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#showFullScreen

        **[slot] void QWindow::showFullScreen()**

        Shows the window as fullscreen.

        Equivalent to calling **setWindowStates** (**Qt::WindowFullScreen** )
        and then **setVisible** (true).

        See the **QWidget::showFullScreen** () documentation for platform-
        specific considerations and limitations.

        **See also** **setWindowStates** () and **setVisible** ().
        """
        ...

    def showMaximized(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#showMaximized

        **[slot] void QWindow::showMaximized()**

        Shows the window as maximized.

        Equivalent to calling **setWindowStates** (**Qt::WindowMaximized** ) and
        then **setVisible** (true).

        **See also** **setWindowStates** () and **setVisible** ().
        """
        ...

    def showMinimized(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#showMinimized

        **[slot] void QWindow::showMinimized()**

        Shows the window as minimized.

        Equivalent to calling **setWindowStates** (**Qt::WindowMinimized** ) and
        then **setVisible** (true).

        **See also** **setWindowStates** () and **setVisible** ().
        """
        ...

    def showNormal(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#showNormal

        **[slot] void QWindow::showNormal()**

        Shows the window as normal, i.e. neither maximized, minimized, nor
        fullscreen.

        Equivalent to calling **setWindowStates** (**Qt::WindowNoState** ) and
        then **setVisible** (true).

        **See also** **setWindowStates** () and **setVisible** ().
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwindow.html#size

        **[override virtual] QSize QWindow::size() const**

        Reimplements: **QSurface::size() const** .

        Returns the size of the window excluding any window frame

        **See also** **resize** ().
        """
        ...

    def sizeIncrement(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwindow.html#sizeIncrement

        **QSize QWindow::sizeIncrement() const**

        Returns the size increment of the window.

        **See also** **setSizeIncrement** ().
        """
        ...

    def startSystemMove(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#startSystemMove

        **[slot, since 5.15] bool QWindow::startSystemMove()**

        Start a system-specific move operation

        Calling this will start an interactive move operation on the window by
        platforms that support it. The actual behavior may vary depending on the
        platform. Usually, it will make the window follow the mouse cursor until
        a mouse button is released.

        On platforms that support it, this method of moving windows is preferred
        over `setPosition`, because it allows a more native look-and-feel of
        moving windows, e.g. letting the window manager snap this window against
        other windows, or special tiling or resizing behavior with animations
        when dragged to the edge of the screen. Furthermore, on some platforms
        such as Wayland, `setPosition` is not supported, so this is the only way
        the application can influence its position.

        Returns true if the operation was supported by the system.

        This function was introduced in Qt 5.15.
        """
        ...

    def startSystemResize(self, edges: PySide6.QtCore.Qt.Edges) -> bool:
        """
        https://doc.qt.io/qt-6/qwindow.html#startSystemResize

        **[slot, since 5.15] bool QWindow::startSystemResize(Qt::Edges edges )**

        Start a system-specific resize operation

        Calling this will start an interactive resize operation on the window by
        platforms that support it. The actual behavior may vary depending on the
        platform. Usually, it will make the window resize so that its edge
        follows the mouse cursor.

        On platforms that support it, this method of resizing windows is
        preferred over `setGeometry`, because it allows a more native look and
        feel of resizing windows, e.g. letting the window manager snap this
        window against other windows, or special resizing behavior with
        animations when dragged to the edge of the screen.

        **edges** should either be a single edge, or two adjacent edges (a
        corner). Other values are not allowed.

        Returns true if the operation was supported by the system.

        This function was introduced in Qt 5.15.
        """
        ...

    def surfaceHandle(self) -> int:
        ...

    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType:
        """
        https://doc.qt.io/qt-6/qwindow.html#surfaceType

        **[override virtual] QSurface::SurfaceType QWindow::surfaceType()
        const**

        Reimplements: **QSurface::surfaceType() const** .

        Returns the surface type of the window.

        **See also** **setSurfaceType** ().
        """
        ...

    def tabletEvent(self, arg__1: PySide6.QtGui.QTabletEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#tabletEvent

        **[virtual protected] void QWindow::tabletEvent(QTabletEvent * ev )**

        Override this to handle tablet press, move, and release events ( **ev**
        ).

        Proximity enter and leave events are not sent to windows, they are
        delivered to the application instance.
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwindow.html#title-prop

        **title : QString**

        This property holds the window's title in the windowing system

        The window title might appear in the title area of the window
        decorations, depending on the windowing system and the window flags. It
        might also be used by the windowing system to identify the window in
        other contexts, such as in the task switcher.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &)

        **Notifier signal:**

        void **windowTitleChanged** (const QString & **title** )

        **See also** **flags** ().
        """
        ...

    def touchEvent(self, arg__1: PySide6.QtGui.QTouchEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#touchEvent

        **[virtual protected] void QWindow::touchEvent(QTouchEvent * ev )**

        Override this to handle touch events ( **ev** ).
        """
        ...

    def transientParent(self) -> PySide6.QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qwindow.html#transientParent-prop

        **[since 5.13] transientParent : QWindow***

        This property holds the window for which this window is a transient pop-
        up

        This is a hint to the window manager that this window is a dialog or
        pop-up on behalf of the transient parent.

        In order to cause the window to be centered above its transient
        **parent** by default, depending on the window manager, it may also be
        necessary to call **setFlags** () with a suitable **Qt::WindowType**
        (such as `Qt::Dialog`).

        This property was introduced in Qt 5.13.

        **Access functions:**

        QWindow * **transientParent** () const
        void **setTransientParent**
        (QWindow * **parent** )

        **Notifier signal:**

        void **transientParentChanged** (QWindow * **transientParent** )

        **See also** **parent** ().
        """
        ...

    def type(self) -> PySide6.QtCore.Qt.WindowType:
        """
        https://doc.qt.io/qt-6/qwindow.html#type

        **Qt::WindowType QWindow::type() const**

        Returns the type of the window.

        This returns the part of the window flags that represents whether the
        window is a dialog, tooltip, popup, regular window, etc.

        **See also** **flags** () and **setFlags** ().
        """
        ...

    def unsetCursor(self) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#unsetCursor

        **void QWindow::unsetCursor()**

        Restores the default arrow cursor for this window.
        """
        ...

    def visibility(self) -> PySide6.QtGui.QWindow.Visibility:
        """
        https://doc.qt.io/qt-6/qwindow.html#visibility-prop

        **[since 5.1] visibility : Visibility**

        This property holds the screen-occupation state of the window

        Visibility is whether the window should appear in the windowing system
        as normal, minimized, maximized, fullscreen or hidden.

        To set the visibility to **AutomaticVisibility**  means to give the
        window a default visible state, which might be fullscreen or windowed
        depending on the platform. When reading the visibility property you will
        always get the actual state, never **AutomaticVisibility** .

        This property was introduced in Qt 5.1.

        **Access functions:**

        QWindow::Visibility **visibility** () const
        void **setVisibility**
        (QWindow::Visibility **v** )

        **Notifier signal:**

        void **visibilityChanged** (QWindow::Visibility **visibility** )
        """
        ...

    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwindow.html#wheelEvent

        **[virtual protected] void QWindow::wheelEvent(QWheelEvent * ev )**

        Override this to handle mouse wheel or other wheel events ( **ev** ).
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#width-prop

        **width : int**

        This property holds the width of the window's geometry

        **Access functions:**

        int **width** () const
        void **setWidth** (int **arg** )

        **Notifier signal:**

        void **widthChanged** (int **arg** )
        """
        ...

    def winId(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#winId

        **WId QWindow::winId() const**

        Returns the window's platform id.

        For platforms where this id might be useful, the value returned will
        uniquely represent the window inside the corresponding screen.

        **See also** **screen** ().
        """
        ...

    def windowState(self) -> PySide6.QtCore.Qt.WindowState:
        """
        https://doc.qt.io/qt-6/qwindow.html#windowState

        **Qt::WindowState QWindow::windowState() const**

        the screen-occupation state of the window

        **See also** **setWindowState** () and **windowStates** ().
        """
        ...

    def windowStates(self) -> PySide6.QtCore.Qt.WindowStates:
        """
        https://doc.qt.io/qt-6/qwindow.html#windowStates

        **[since 5.10] Qt::WindowStates QWindow::windowStates() const**

        the screen-occupation state of the window

        The window can be in a combination of several states. For example, if
        the window is both minimized and maximized, the window will appear
        minimized, but clicking on the task bar entry will restore it to the
        maximized state.

        This function was introduced in Qt 5.10.

        **See also** **setWindowStates** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#x-prop

        **x : int**

        This property holds the x position of the window's geometry

        **Access functions:**

        int **x** () const
        void **setX** (int **arg** )

        **Notifier signal:**

        void **xChanged** (int **arg** )
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-6/qwindow.html#y-prop

        **y : int**

        This property holds the y position of the window's geometry

        **Access functions:**

        int **y** () const
        void **setY** (int **arg** )

        **Notifier signal:**

        void **yChanged** (int **arg** )

        **Member Function Documentation**
        """
        ...

    @property
    def activeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def contentOrientationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def focusObjectChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwindow.html#focusObjectChanged

        **[signal] void QWindow::focusObjectChanged(QObject * object )**

        This signal is emitted when the final receiver of events tied to focus
        is changed to **object**.

        **See also** **focusObject** ().
        """
        ...

    @property
    def heightChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maximumHeightChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maximumWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minimumHeightChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minimumWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def modalityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwindow.html#modalityChanged

        **[signal] void QWindow::modalityChanged(Qt::WindowModality modality )**

        This signal is emitted when the Qwindow::modality property changes to
        **modality**.

        **Note:** Notifier signal for property **modality** .
        """
        ...

    @property
    def opacityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def screenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwindow.html#screenChanged

        **[signal] void QWindow::screenChanged(QScreen * screen )**

        This signal is emitted when a window's **screen** changes, either by
        being set explicitly with **setScreen** (), or automatically when the
        window's screen is removed.
        """
        ...

    @property
    def transientParentChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def visibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def widthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def windowStateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwindow.html#windowStateChanged

        **[signal] void QWindow::windowStateChanged(Qt::WindowState windowState
        )**

        This signal is emitted when the **windowState** changes, either by being
        set explicitly with **setWindowStates** (), or automatically when the
        user clicks one of the titlebar buttons or by other means.
        """
        ...

    @property
    def windowTitleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
