"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QWheelEvent(PySide6.QtGui.QSinglePointEvent):
    """
    https://doc.qt.io/qt-6/qwheelevent.html

    **Detailed Description**

    Wheel events are sent to the widget under the mouse cursor, but if that
    widget does not handle the event they are sent to the focus widget. Wheel
    events are generated for both mouse wheels and trackpad scroll gestures.
    There are two ways to read the wheel event delta: **angleDelta** () returns
    the deltas in wheel degrees. These values are always provided.
    **pixelDelta** () returns the deltas in screen pixels, and is available on
    platforms that have high-resolution trackpads, such as macOS. If that is the
    case, **device** ()->**type** () will return
    QInputDevice::DeviceType::Touchpad.

    The functions **position** () and **globalPosition** () return the mouse
    cursor's location at the time of the event.

    A wheel event contains a special accept flag that indicates whether the
    receiver wants the event. You should call **ignore** () if you do not handle
    the wheel event; this ensures that it will be sent to the parent widget.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse and keyboard events for a widget.

    The event handler **QWidget::wheelEvent** () receives wheel events.

    **See also** **QMouseEvent**  and **QWidget::grabMouse** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#QWheelEvent-2

        **[since 5.12] QWheelEvent::QWheelEvent(const QPointF & pos , const
        QPointF & globalPos , QPoint pixelDelta , QPoint angleDelta ,
        Qt::MouseButtons buttons , Qt::KeyboardModifiers modifiers ,
        Qt::ScrollPhase phase , bool inverted , Qt::MouseEventSource source =
        Qt::MouseEventNotSynthesized, const QPointingDevice * device =
        QPointingDevice::primaryPointingDevice())**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase** , and the
        **source** indicates whether this is a genuine or artificial
        (synthesized) event.

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        The device from which the wheel event originated is specified by
        **device**.

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **device** ().
        """
        ...

    @overload
    def __init__(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        pixelDelta: PySide6.QtCore.QPoint,
        angleDelta: PySide6.QtCore.QPoint,
        buttons: PySide6.QtCore.Qt.MouseButtons,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
        phase: PySide6.QtCore.Qt.ScrollPhase,
        inverted: bool,
        source: PySide6.QtCore.Qt.MouseEventSource = ...,
        device: PySide6.QtGui.QPointingDevice = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#QWheelEvent-2

        **[since 5.12] QWheelEvent::QWheelEvent(const QPointF & pos , const
        QPointF & globalPos , QPoint pixelDelta , QPoint angleDelta ,
        Qt::MouseButtons buttons , Qt::KeyboardModifiers modifiers ,
        Qt::ScrollPhase phase , bool inverted , Qt::MouseEventSource source =
        Qt::MouseEventNotSynthesized, const QPointingDevice * device =
        QPointingDevice::primaryPointingDevice())**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase** , and the
        **source** indicates whether this is a genuine or artificial
        (synthesized) event.

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        The device from which the wheel event originated is specified by
        **device**.

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **device** ().
        """
        ...

    def angleDelta(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#angleDelta

        **QPoint QWheelEvent::angleDelta() const**

        Returns the relative amount that the wheel was rotated, in eighths of a
        degree. A positive value indicates that the wheel was rotated forwards
        away from the user; a negative value indicates that the wheel was
        rotated backwards toward the user. `angleDelta().y()` provides the angle
        through which the common vertical mouse wheel was rotated since the
        previous event. `angleDelta().x()` provides the angle through which the
        horizontal mouse wheel was rotated, if the mouse has a horizontal wheel;
        otherwise it stays at zero. Some mice allow the user to tilt the wheel
        to perform horizontal scrolling, and some touchpads support a horizontal
        scrolling gesture; that will also appear in `angleDelta().x()`.

        Most mouse types work in steps of 15 degrees, in which case the delta
        value is a multiple of 120; i.e., 120 units * 1/8 = 15 degrees.

        However, some mice have finer-resolution wheels and send delta values
        that are less than 120 units (less than 15 degrees). To support this
        possibility, you can either cumulatively add the delta values from
        events until the value of 120 is reached, then scroll the widget, or you
        can partially scroll the widget in response to each wheel event. But to
        provide a more native feel, you should prefer **pixelDelta** () on
        platforms where it's available.

        Example:

        void MyWidget::wheelEvent(QWheelEvent *event)
            {
                **QPoint**
        numPixels = event->pixelDelta();
                **QPoint**  numDegrees =
        event->angleDelta() / 8;

                if (!numPixels.isNull()) {
        scrollWithPixels(numPixels);
                } else if (!numDegrees.isNull()) {
        **QPoint**  numSteps = numDegrees / 15;
        scrollWithDegrees(numSteps);
                }

                event->accept();
        }

        **Note:** On platforms that support scrolling **phases** , the delta may
        be null when:

        * scrolling is about to begin, but the distance did not yet change
        (**Qt::ScrollBegin** ),
          * or scrolling has ended and the distance did
        not change anymore (**Qt::ScrollEnd** ).

        **Note:** Getter function for property angleDelta.

        **See also** **pixelDelta** ().
        """
        ...

    def clone(self) -> PySide6.QtGui.QWheelEvent:
        ...

    def hasPixelDelta(self) -> bool:
        ...

    def inverted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#inverted

        **[since 5.7] bool QWheelEvent::inverted() const**

        Returns whether the delta values delivered with the event are inverted.

        Normally, a vertical wheel will produce a **QWheelEvent**  with positive
        delta values if the top of the wheel is rotating away from the hand
        operating it. Similarly, a horizontal wheel movement will produce a
        **QWheelEvent**  with positive delta values if the top of the wheel is
        moved to the left.

        However, on some platforms this is configurable, so that the same
        operations described above will produce negative delta values (but with
        the same magnitude). With the inverted property a wheel event consumer
        can choose to always follow the direction of the wheel, regardless of
        the system settings, but only for specific widgets. (One such use case
        could be that the user is rotating the wheel in the same direction as a
        visual Tumbler rotates. Another usecase is to make a slider handle
        follow the direction of movement of fingers on a touchpad regardless of
        system configuration.)

        **Note:** Many platforms provide no such information. On such platforms
        inverted always returns false.

        **Note:** Getter function for property inverted.

        This function was introduced in Qt 5.7.
        """
        ...

    def isBeginEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#isBeginEvent

        **[override virtual] bool QWheelEvent::isBeginEvent() const**

        Reimplements: **QSinglePointEvent::isBeginEvent() const** .

        Returns `true` if this event's **phase** () is **Qt::ScrollBegin** .
        """
        ...

    def isEndEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#isEndEvent

        **[override virtual] bool QWheelEvent::isEndEvent() const**

        Reimplements: **QSinglePointEvent::isEndEvent() const** .

        Returns `true` if this event's **phase** () is **Qt::ScrollEnd** .
        """
        ...

    def isInverted(self) -> bool:
        ...

    def isUpdateEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#isUpdateEvent

        **[override virtual] bool QWheelEvent::isUpdateEvent() const**

        Reimplements: **QSinglePointEvent::isUpdateEvent() const** .

        Returns `true` if this event's **phase** () is **Qt::ScrollUpdate**  or
        **Qt::ScrollMomentum** .
        """
        ...

    def phase(self) -> PySide6.QtCore.Qt.ScrollPhase:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#phase

        **[since 5.2] Qt::ScrollPhase QWheelEvent::phase() const**

        Returns the scrolling phase of this wheel event.

        **Note:** The **Qt::ScrollBegin**  and **Qt::ScrollEnd**  phases are
        currently supported only on macOS.

        **Note:** Getter function for property phase.

        This function was introduced in Qt 5.2.
        """
        ...

    def pixelDelta(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwheelevent.html#pixelDelta

        **QPoint QWheelEvent::pixelDelta() const**

        Returns the scrolling distance in pixels on screen. This value is
        provided on platforms that support high-resolution pixel-based delta
        values, such as macOS. The value should be used directly to scroll
        content on screen.

        Example:

        void MyWidget::wheelEvent(QWheelEvent *event)
            {
                **QPoint**
        numPixels = event->pixelDelta();
                **QPoint**  numDegrees =
        event->angleDelta() / 8;

                if (!numPixels.isNull()) {
        scrollWithPixels(numPixels);
                } else if (!numDegrees.isNull()) {
        **QPoint**  numSteps = numDegrees / 15;
        scrollWithDegrees(numSteps);
                }

                event->accept();
        }

        **Note:** On platforms that support scrolling **phases** , the delta may
        be null when:

        * scrolling is about to begin, but the distance did not yet change
        (**Qt::ScrollBegin** ),
          * or scrolling has ended and the distance did
        not change anymore (**Qt::ScrollEnd** ).

        **Note:** On X11 this value is driver-specific and unreliable, use
        **angleDelta** () instead.

        **Note:** Getter function for property pixelDelta.
        """
        ...

    def source(self) -> PySide6.QtCore.Qt.MouseEventSource:
        ...
