"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QVector3D(object):
    """
    https://doc.qt.io/qt-6/qvector3d.html

    **Detailed Description**

    Vectors are one of the main building blocks of 3D representation and
    drawing. They consist of three finite floating-point coordinates,
    traditionally called x, y, and z.

    The QVector3D class can also be used to represent vertices in 3D space. We
    therefore do not need to provide a separate vertex class.

    **See also** **QVector2D** , **QVector4D** , and **QQuaternion** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D

        **QVector3D::QVector3D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0).
        """
        ...

    @overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-2

        **QVector3D::QVector3D(float xpos , float ypos , float zpos )**

        Constructs a vector with coordinates ( **xpos** , **ypos** , **zpos** ).
        All parameters must be finite.
        """
        ...

    @overload
    def __init__(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-3

        **QVector3D::QVector3D(QPoint point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and a
        z coordinate of 0.
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-4

        **QVector3D::QVector3D(QPointF point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and a
        z coordinate of 0.
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D, zpos: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-5

        **QVector3D::QVector3D(QVector2D vector )**

        Constructs a 3D vector from the specified 2D **vector**. The z
        coordinate is set to zero.

        **See also** **toVector2D** ().
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-6

        **QVector3D::QVector3D(QVector2D vector , float zpos )**

        Constructs a 3D vector from the specified 2D **vector**. The z
        coordinate is set to **zpos** , which must be finite.

        **See also** **toVector2D** ().
        """
        ...

    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#QVector3D-7

        **QVector3D::QVector3D(QVector4D vector )**

        Constructs a 3D vector from the specified 4D **vector**. The w
        coordinate is dropped.

        **See also** **toVector4D** ().
        """
        ...

    def __add__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector3D:
        ...

    @overload
    def __imul__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    def __isub__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector3D:
        ...

    @overload
    def __mul__(
        self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]
    ) -> PySide6.QtGui.QVector3D:
        ...

    @overload
    def __mul__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QVector3D:
        ...

    @overload
    def __mul__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    def __neg__(self) -> PySide6.QtGui.QVector3D:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        ...

    @staticmethod
    def crossProduct(
        v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D
    ) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#crossProduct

        **[static] QVector3D QVector3D::crossProduct(QVector3D v1 , QVector3D v2
        )**

        Returns the cross-product of vectors **v1** and **v2** , which is normal
        to the plane spanned by **v1** and **v2**. It will be zero if the two
        vectors are parallel.

        **See also** **normal** ().
        """
        ...

    def distanceToLine(
        self, point: PySide6.QtGui.QVector3D, direction: PySide6.QtGui.QVector3D
    ) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#distanceToLine

        **float QVector3D::distanceToLine(QVector3D point , QVector3D direction
        ) const**

        Returns the distance that this vertex is from a line defined by
        **point** and the unit vector **direction**.

        If **direction** is a null vector, then it does not define a line. In
        that case, the distance from **point** to this vertex is returned.

        **See also** **distanceToPlane** ().
        """
        ...

    @overload
    def distanceToPlane(
        self,
        plane1: PySide6.QtGui.QVector3D,
        plane2: PySide6.QtGui.QVector3D,
        plane3: PySide6.QtGui.QVector3D,
    ) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#distanceToPlane

        **float QVector3D::distanceToPlane(QVector3D plane , QVector3D normal )
        const**

        Returns the distance from this vertex to a plane defined by the vertex
        **plane** and a **normal** unit vector. The **normal** parameter is
        assumed to have been normalized to a unit vector.

        The return value will be negative if the vertex is below the plane, or
        zero if it is on the plane.

        **See also** **normal** () and **distanceToLine** ().
        """
        ...

    @overload
    def distanceToPlane(
        self, plane: PySide6.QtGui.QVector3D, normal: PySide6.QtGui.QVector3D
    ) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#distanceToPlane-1

        **float QVector3D::distanceToPlane(QVector3D plane1 , QVector3D plane2 ,
        QVector3D plane3 ) const**

        Returns the distance from this vertex to a plane defined by the vertices
        **plane1** , **plane2** and **plane3**.

        The return value will be negative if the vertex is below the plane, or
        zero if it is on the plane.

        The two vectors that define the plane are **plane2** \\- **plane1** and
        **plane3** \\- **plane1**.

        **See also** **normal** () and **distanceToLine** ().
        """
        ...

    def distanceToPoint(self, point: PySide6.QtGui.QVector3D) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#distanceToPoint

        **[since 5.1] float QVector3D::distanceToPoint(QVector3D point ) const**

        Returns the distance from this vertex to a point defined by the vertex
        **point**.

        This function was introduced in Qt 5.1.

        **See also** **distanceToPlane** () and **distanceToLine** ().
        """
        ...

    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#dotProduct

        **[static] float QVector3D::dotProduct(QVector3D v1 , QVector3D v2 )**

        Returns the dot product of **v1** and **v2**.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvector3d.html#isNull

        **bool QVector3D::isNull() const**

        Returns `true` if the x, y, and z coordinates are set to 0.0, otherwise
        returns `false`.
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#length

        **float QVector3D::length() const**

        Returns the length of the vector from the origin.

        **See also** **lengthSquared** () and **normalized** ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#lengthSquared

        **float QVector3D::lengthSquared() const**

        Returns the squared length of the vector from the origin. This is
        equivalent to the dot product of the vector with itself.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    @overload
    @staticmethod
    def normal(
        v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D
    ) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#normal

        **[static] QVector3D QVector3D::normal(QVector3D v1 , QVector3D v2 )**

        Returns the unit normal vector of a plane spanned by vectors **v1** and
        **v2** , which must not be parallel to one another.

        Use **crossProduct** () to compute the cross-product of **v1** and
        **v2** if you do not need the result to be normalized to a unit vector.

        **See also** **crossProduct** () and **distanceToPlane** ().
        """
        ...

    @overload
    @staticmethod
    def normal(
        v1: PySide6.QtGui.QVector3D,
        v2: PySide6.QtGui.QVector3D,
        v3: PySide6.QtGui.QVector3D,
    ) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#normal-1

        **[static] QVector3D QVector3D::normal(QVector3D v1 , QVector3D v2 ,
        QVector3D v3 )**

        Returns the unit normal vector of a plane spanned by vectors **v2** \\-
        **v1** and **v3** \\- **v1** , which must not be parallel to one another.

        Use **crossProduct** () to compute the cross-product of **v2** \\- **v1**
        and **v3** \\- **v1** if you do not need the result to be normalized to a
        unit vector.

        **See also** **crossProduct** () and **distanceToPlane** ().
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#normalize

        **void QVector3D::normalize()**

        Normalizes the currect vector in place. Nothing happens if this vector
        is a null vector or the length of the vector is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#normalized

        **QVector3D QVector3D::normalized() const**

        Returns the normalized unit vector form of this vector.

        If this vector is null, then a null vector is returned. If the length of
        the vector is very close to 1, then the vector will be returned as-is.
        Otherwise the normalized form of the vector of length 1 will be
        returned.

        **See also** **length** () and **normalize** ().
        """
        ...

    def project(
        self,
        modelView: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        projection: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        viewport: PySide6.QtCore.QRect,
    ) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#project

        **[since 5.5] QVector3D QVector3D::project(const QMatrix4x4 & modelView
        , const QMatrix4x4 & projection , const QRect & viewport ) const**

        Returns the window coordinates of this vector initially in object/model
        coordinates using the model view matrix **modelView** , the projection
        matrix **projection** and the viewport dimensions **viewport**.

        When transforming from clip to normalized space, a division by the w
        component on the vector components takes place. To prevent dividing by 0
        if w equals to 0, it is set to 1.

        **Note:** the returned y coordinates are in OpenGL orientation. OpenGL
        expects the bottom to be 0 whereas for Qt top is 0.

        This function was introduced in Qt 5.5.

        **See also** **unproject** ().
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#setX

        **void QVector3D::setX(float x )**

        Sets the x coordinate of this point to the given finite **x**
        coordinate.

        **See also** **x** (), **setY** (), and **setZ** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#setY

        **void QVector3D::setY(float y )**

        Sets the y coordinate of this point to the given finite **y**
        coordinate.

        **See also** **y** (), **setX** (), and **setZ** ().
        """
        ...

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector3d.html#setZ

        **void QVector3D::setZ(float z )**

        Sets the z coordinate of this point to the given finite **z**
        coordinate.

        **See also** **z** (), **setX** (), and **setY** ().
        """
        ...

    def toPoint(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qvector3d.html#toPoint

        **QPoint QVector3D::toPoint() const**

        Returns the **QPoint**  form of this 3D vector. The z coordinate is
        dropped. The x and y coordinates are rounded to nearest integers.

        **See also** **toPointF** () and **toVector2D** ().
        """
        ...

    def toPointF(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qvector3d.html#toPointF

        **QPointF QVector3D::toPointF() const**

        Returns the **QPointF**  form of this 3D vector. The z coordinate is
        dropped.

        **See also** **toPoint** () and **toVector2D** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    def toVector2D(self) -> PySide6.QtGui.QVector2D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#toVector2D

        **QVector2D QVector3D::toVector2D() const**

        Returns the 2D vector form of this 3D vector, dropping the z coordinate.

        **See also** **toVector4D** () and **toPoint** ().
        """
        ...

    def toVector4D(self) -> PySide6.QtGui.QVector4D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#toVector4D

        **QVector4D QVector3D::toVector4D() const**

        Returns the 4D form of this 3D vector, with the w coordinate set to
        zero.

        **See also** **toVector2D** () and **toPoint** ().
        """
        ...

    def unproject(
        self,
        modelView: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        projection: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        viewport: PySide6.QtCore.QRect,
    ) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector3d.html#unproject

        **[since 5.5] QVector3D QVector3D::unproject(const QMatrix4x4 &
        modelView , const QMatrix4x4 & projection , const QRect & viewport )
        const**

        Returns the object/model coordinates of this vector initially in window
        coordinates using the model view matrix **modelView** , the projection
        matrix **projection** and the viewport dimensions **viewport**.

        When transforming from clip to normalized space, a division by the w
        component of the vector components takes place. To prevent dividing by 0
        if w equals to 0, it is set to 1.

        **Note:** y coordinates in **viewport** should use OpenGL orientation.
        OpenGL expects the bottom to be 0 whereas for Qt top is 0.

        This function was introduced in Qt 5.5.

        **See also** **project** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#x

        **float QVector3D::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** (), **y** (), and **z** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#y

        **float QVector3D::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** (), **x** (), and **z** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector3d.html#z

        **float QVector3D::z() const**

        Returns the z coordinate of this point.

        **See also** **setZ** (), **x** (), and **y** ().
        """
        ...
