"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QUndoStack(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qundostack.html

    **Detailed Description**

    For an overview of Qt's Undo Framework, see the **overview document** .

    An undo stack maintains a stack of commands that have been applied to a
    document.

    New commands are pushed on the stack using **push** (). Commands can be
    undone and redone using **undo** () and **redo** (), or by triggering the
    actions returned by **createUndoAction** () and **createRedoAction** ().

    QUndoStack keeps track of the **current** command. This is the command which
    will be executed by the next call to **redo** (). The index of this command
    is returned by **index** (). The state of the edited object can be rolled
    forward or back using **setIndex** (). If the top-most command on the stack
    has already been redone, **index** () is equal to **count** ().

    QUndoStack provides support for undo and redo actions, command compression,
    command macros, and supports the concept of a **clean state**.

    **Undo and Redo Actions**

    QUndoStack provides convenient undo and redo **QAction**  objects, which can
    be inserted into a menu or a toolbar. When commands are undone or redone,
    QUndoStack updates the text properties of these actions to reflect what
    change they will trigger. The actions are also disabled when no command is
    available for undo or redo. These actions are returned by
    **QUndoStack::createUndoAction** () and **QUndoStack::createRedoAction** ().

    **Command Compression and Macros**

    Command compression is useful when several commands can be compressed into a
    single command that can be undone and redone in a single operation. For
    example, when a user types a character in a text editor, a new command is
    created. This command inserts the character into the document at the cursor
    position. However, it is more convenient for the user to be able to undo or
    redo typing of whole words, sentences, or paragraphs. Command compression
    allows these single-character commands to be merged into a single command
    which inserts or deletes sections of text. For more information, see
    **QUndoCommand::mergeWith** () and **push** ().

    A command macro is a sequence of commands, all of which are undone and
    redone in one go. Command macros are created by giving a command a list of
    child commands. Undoing or redoing the parent command will cause the child
    commands to be undone or redone. Command macros may be created explicitly by
    specifying a parent in the **QUndoCommand**  constructor, or by using the
    convenience functions **beginMacro** () and **endMacro** ().

    Although command compression and macros appear to have the same effect to
    the user, they often have different uses in an application. Commands that
    perform small changes to a document may be usefully compressed if there is
    no need to individually record them, and if only larger changes are relevant
    to the user. However, for commands that need to be recorded individually, or
    those that cannot be compressed, it is useful to use macros to provide a
    more convenient user experience while maintaining a record of each command.

    **Clean State**

    QUndoStack supports the concept of a clean state. When the document is saved
    to disk, the stack can be marked as clean using **setClean** (). Whenever
    the stack returns to this state through undoing and redoing commands, it
    emits the signal **cleanChanged** (). This signal is also emitted when the
    stack leaves the clean state. This signal is usually used to enable and
    disable the save actions in the application, and to update the document's
    title to reflect that it contains unsaved changes.

    **Obsolete Commands**

    QUndoStack is able to delete commands from the stack if the command is no
    longer needed. One example may be to delete a command when two commands are
    merged together in such a way that the merged command has no function. This
    can be seen with move commands where the user moves their mouse to one part
    of the screen and then moves it to the original position. The merged command
    results in a mouse movement of 0. This command can be deleted since it
    serves no purpose. Another example is with networking commands that fail due
    to connection issues. In this case, the command is to be removed from the
    stack because the **redo** () and **undo** () functions have no function
    since there was connection issues.

    A command can be marked obsolete with the **QUndoCommand::setObsolete** ()
    function. The **QUndoCommand::isObsolete** () flag is checked in
    **QUndoStack::push** (), **QUndoStack::undo** (), **QUndoStack::redo** (),
    and **QUndoStack::setIndex** () after calling **QUndoCommand::undo** (),
    **QUndoCommand::redo** () and **QUndoCommand** :mergeWith() where
    applicable.

    If a command is set obsolete and the clean index is greater than or equal to
    the current command index, then the clean index will be reset when the
    command is deleted from the stack.

    **See also** **QUndoCommand**  and **QUndoView** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#QUndoStack

        **QUndoStack::QUndoStack(QObject * parent = nullptr)**

        Constructs an empty undo stack with the parent **parent**. The stack
        will initially be in the clean state. If **parent** is a **QUndoGroup**
        object, the stack is automatically added to the group.

        **See also** **push** ().
        """
        ...

    def beginMacro(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#beginMacro

        **void QUndoStack::beginMacro(const QString & text )**

        Begins composition of a macro command with the given **text**
        description.

        An empty command described by the specified **text** is pushed on the
        stack. Any subsequent commands pushed on the stack will be appended to
        the empty command's children until **endMacro** () is called.

        Calls to beginMacro() and **endMacro** () may be nested, but every call
        to beginMacro() must have a matching call to **endMacro** ().

        While a macro is being composed, the stack is disabled. This means that:

        * **indexChanged** () and **cleanChanged** () are not emitted,
          *
        **canUndo** () and **canRedo** () return false,
          * calling **undo** ()
        or **redo** () has no effect,
          * the undo/redo actions are disabled.

        The stack becomes enabled and appropriate signals are emitted when
        **endMacro** () is called for the outermost macro.

        stack.beginMacro("insert red text");
            stack.push(new
        InsertText(document, idx, text));
            stack.push(new SetColor(document,
        idx, text.length(), Qt::red));
            stack.endMacro(); // indexChanged()
        is emitted

        This code is equivalent to:

        **QUndoCommand**  *insertRed = new **QUndoCommand** (); // an empty
        command
            insertRed->setText("insert red text");

            new
        InsertText(document, idx, text, insertRed); // becomes child of
        insertRed
            new SetColor(document, idx, text.length(), Qt::red,
        insertRed);

            stack.push(insertRed);

        **See also** **endMacro** ().
        """
        ...

    def canRedo(self) -> bool:
        """
        https://doc.qt.io/qt-6/qundostack.html#canRedo

        **bool QUndoStack::canRedo() const**

        Returns `true` if there is a command available for redo; otherwise
        returns `false`.

        This function returns `false` if the stack is empty or if the top
        command on the stack has already been redone.

        Synonymous with **index** () == **count** ().

        **Note:** Getter function for property canRedo.

        **See also** **index** () and **canUndo** ().
        """
        ...

    def canUndo(self) -> bool:
        """
        https://doc.qt.io/qt-6/qundostack.html#canUndo

        **bool QUndoStack::canUndo() const**

        Returns `true` if there is a command available for undo; otherwise
        returns `false`.

        This function returns `false` if the stack is empty, or if the bottom
        command on the stack has already been undone.

        Synonymous with **index** () == 0.

        **Note:** Getter function for property canUndo.

        **See also** **index** () and **canRedo** ().
        """
        ...

    def cleanIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qundostack.html#cleanIndex

        **int QUndoStack::cleanIndex() const**

        Returns the clean index. This is the index at which **setClean** () was
        called.

        A stack may not have a clean index. This happens if a document is saved,
        some commands are undone, then a new command is pushed. Since **push**
        () deletes all the undone commands before pushing the new command, the
        stack can't return to the clean state again. In this case, this function
        returns -1. The -1 may also be returned after an explicit call to
        **resetClean** ().

        **See also** **isClean** () and **setClean** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#clear

        **void QUndoStack::clear()**

        Clears the command stack by deleting all commands on it, and returns the
        stack to the clean state.

        Commands are not undone or redone; the state of the edited object
        remains unchanged.

        This function is usually used when the contents of the document are
        abandoned.

        **See also** **QUndoStack** ().
        """
        ...

    def command(self, index: int) -> PySide6.QtGui.QUndoCommand:
        """
        https://doc.qt.io/qt-6/qundostack.html#command

        **const QUndoCommand *QUndoStack::command(int index ) const**

        Returns a const pointer to the command at **index**.

        This function returns a const pointer, because modifying a command, once
        it has been pushed onto the stack and executed, almost always causes
        corruption of the state of the document, if the command is later undone
        or redone.

        **See also** **QUndoCommand::child** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qundostack.html#count

        **int QUndoStack::count() const**

        Returns the number of commands on the stack. Macro commands are counted
        as one command.

        **See also** **index** (), **setIndex** (), and **command** ().
        """
        ...

    def createRedoAction(
        self, parent: PySide6.QtCore.QObject, prefix: str = ...
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qundostack.html#createRedoAction

        **QAction *QUndoStack::createRedoAction(QObject * parent , const QString
        & prefix = QString()) const**

        Creates an redo **QAction**  object with the given **parent**.

        Triggering this action will cause a call to **redo** (). The text of
        this action is the text of the command which will be redone in the next
        call to **redo** (), prefixed by the specified **prefix**. If there is
        no command available for redo, this action will be disabled.

        If **prefix** is empty, the default template "Redo %1" is used instead
        of prefix. Before Qt 4.8, the prefix "Redo" was used by default.

        **See also** **createUndoAction** (), **canRedo** (), and
        **QUndoCommand::text** ().
        """
        ...

    def createUndoAction(
        self, parent: PySide6.QtCore.QObject, prefix: str = ...
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qundostack.html#createUndoAction

        **QAction *QUndoStack::createUndoAction(QObject * parent , const QString
        & prefix = QString()) const**

        Creates an undo **QAction**  object with the given **parent**.

        Triggering this action will cause a call to **undo** (). The text of
        this action is the text of the command which will be undone in the next
        call to **undo** (), prefixed by the specified **prefix**. If there is
        no command available for undo, this action will be disabled.

        If **prefix** is empty, the default template "Undo %1" is used instead
        of prefix. Before Qt 4.8, the prefix "Undo" was used by default.

        **See also** **createRedoAction** (), **canUndo** (), and
        **QUndoCommand::text** ().
        """
        ...

    def endMacro(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#endMacro

        **void QUndoStack::endMacro()**

        Ends composition of a macro command.

        If this is the outermost macro in a set nested macros, this function
        emits **indexChanged** () once for the entire macro command.

        **See also** **beginMacro** ().
        """
        ...

    def index(self) -> int:
        """
        https://doc.qt.io/qt-6/qundostack.html#index

        **int QUndoStack::index() const**

        Returns the index of the current command. This is the command that will
        be executed on the next call to **redo** (). It is not always the top-
        most command on the stack, since a number of commands may have been
        undone.

        **See also** **setIndex** (), **undo** (), **redo** (), and **count**
        ().
        """
        ...

    def isActive(self) -> bool:
        ...

    def isClean(self) -> bool:
        """
        https://doc.qt.io/qt-6/qundostack.html#isClean

        **bool QUndoStack::isClean() const**

        If the stack is in the clean state, returns `true`; otherwise returns
        `false`.

        **Note:** Getter function for property **clean** .

        **See also** **setClean** () and **cleanIndex** ().
        """
        ...

    def push(self, cmd: PySide6.QtGui.QUndoCommand) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#push

        **void QUndoStack::push(QUndoCommand * cmd )**

        Pushes **cmd** on the stack or merges it with the most recently executed
        command. In either case, executes **cmd** by calling its **redo** ()
        function.

        If **cmd** 's id is not -1, and if the id is the same as that of the
        most recently executed command, **QUndoStack**  will attempt to merge
        the two commands by calling **QUndoCommand::mergeWith** () on the most
        recently executed command. If **QUndoCommand::mergeWith** () returns
        `true`, **cmd** is deleted.

        After calling **QUndoCommand::redo** () and, if applicable,
        **QUndoCommand::mergeWith** (), **QUndoCommand::isObsolete** () will be
        called for **cmd** or the merged command. If
        **QUndoCommand::isObsolete** () returns `true`, then **cmd** or the
        merged command will be deleted from the stack.

        In all other cases **cmd** is simply pushed on the stack.

        If commands were undone before **cmd** was pushed, the current command
        and all commands above it are deleted. Hence **cmd** always ends up
        being the top-most on the stack.

        Once a command is pushed, the stack takes ownership of it. There are no
        getters to return the command, since modifying it after it has been
        executed will almost always lead to corruption of the document's state.

        **See also** **QUndoCommand::id** () and **QUndoCommand::mergeWith** ().
        """
        ...

    def redo(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#redo

        **[slot] void QUndoStack::redo()**

        Redoes the current command by calling **QUndoCommand::redo** ().
        Increments the current command index.

        If the stack is empty, or if the top command on the stack has already
        been redone, this function does nothing.

        If **QUndoCommand::isObsolete** () returns true for the current command,
        then the command will be deleted from the stack. Additionally, if the
        clean index is greater than or equal to the current command index, then
        the clean index is reset.

        **See also** **undo** () and **index** ().
        """
        ...

    def redoText(self) -> str:
        """
        https://doc.qt.io/qt-6/qundostack.html#redoText

        **QString QUndoStack::redoText() const**

        Returns the text of the command which will be redone in the next call to
        **redo** ().

        **Note:** Getter function for property redoText.

        **See also** **QUndoCommand::actionText** () and **undoText** ().
        """
        ...

    def resetClean(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#resetClean

        **[slot, since 5.8] void QUndoStack::resetClean()**

        Leaves the clean state and emits **cleanChanged** () if the stack was
        clean. This method resets the clean index to -1.

        This is typically called in the following cases, when a document has
        been:

        * created basing on some template and has not been saved, so no filename
        has been associated with the document yet.
          * restored from a backup
        file.
          * changed outside of the editor and the user did not reload it.

        This function was introduced in Qt 5.8.

        **See also** **isClean** (), **setClean** (), and **cleanIndex** ().
        """
        ...

    def setActive(self, active: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#active-prop

        **active : bool**

        This property holds the active status of this stack.

        An application often has multiple undo stacks, one for each opened
        document. The active stack is the one associated with the currently
        active document. If the stack belongs to a **QUndoGroup** , calls to
        **QUndoGroup::undo** () or **QUndoGroup::redo** () will be forwarded to
        this stack when it is active. If the **QUndoGroup**  is watched by a
        **QUndoView** , the view will display the contents of this stack when it
        is active. If the stack does not belong to a **QUndoGroup** , making it
        active has no effect.

        It is the programmer's responsibility to specify which stack is active
        by calling setActive(), usually when the associated document window
        receives focus.

        **Access functions:**

        bool **isActive** () const
        void **setActive** (bool **active** = true)

        **See also** **QUndoGroup** .
        """
        ...

    def setClean(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#setClean

        **[slot] void QUndoStack::setClean()**

        Marks the stack as clean and emits **cleanChanged** () if the stack was
        not already clean.

        This is typically called when a document is saved, for example.

        Whenever the stack returns to this state through the use of undo/redo
        commands, it emits the signal **cleanChanged** (). This signal is also
        emitted when the stack leaves the clean state.

        **See also** **isClean** (), **resetClean** (), and **cleanIndex** ().
        """
        ...

    def setIndex(self, idx: int) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#setIndex

        **[slot] void QUndoStack::setIndex(int idx )**

        Repeatedly calls **undo** () or **redo** () until the current command
        index reaches **idx**. This function can be used to roll the state of
        the document forwards of backwards. **indexChanged** () is emitted only
        once.

        **See also** **index** (), **count** (), **undo** (), and **redo** ().
        """
        ...

    def setUndoLimit(self, limit: int) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#undoLimit-prop

        **undoLimit : int**

        This property holds the maximum number of commands on this stack.

        When the number of commands on a stack exceedes the stack's undoLimit,
        commands are deleted from the bottom of the stack. Macro commands
        (commands with child commands) are treated as one command. The default
        value is 0, which means that there is no limit.

        This property may only be set when the undo stack is empty, since
        setting it on a non-empty stack might delete the command at the current
        index. Calling setUndoLimit() on a non-empty stack prints a warning and
        does nothing.

        **Access functions:**

        int **undoLimit** () const
        void **setUndoLimit** (int **limit** )
        """
        ...

    def text(self, idx: int) -> str:
        """
        https://doc.qt.io/qt-6/qundostack.html#text

        **QString QUndoStack::text(int idx ) const**

        Returns the text of the command at index **idx**.

        **See also** **beginMacro** ().
        """
        ...

    def undo(self) -> None:
        """
        https://doc.qt.io/qt-6/qundostack.html#undo

        **[slot] void QUndoStack::undo()**

        Undoes the command below the current command by calling
        **QUndoCommand::undo** (). Decrements the current command index.

        If the stack is empty, or if the bottom command on the stack has already
        been undone, this function does nothing.

        After the command is undone, if **QUndoCommand::isObsolete** () returns
        `true`, then the command will be deleted from the stack. Additionally,
        if the clean index is greater than or equal to the current command
        index, then the clean index is reset.

        **See also** **redo** () and **index** ().
        """
        ...

    def undoLimit(self) -> int:
        """
        https://doc.qt.io/qt-6/qundostack.html#undoLimit-prop

        **undoLimit : int**

        This property holds the maximum number of commands on this stack.

        When the number of commands on a stack exceedes the stack's undoLimit,
        commands are deleted from the bottom of the stack. Macro commands
        (commands with child commands) are treated as one command. The default
        value is 0, which means that there is no limit.

        This property may only be set when the undo stack is empty, since
        setting it on a non-empty stack might delete the command at the current
        index. Calling setUndoLimit() on a non-empty stack prints a warning and
        does nothing.

        **Access functions:**

        int **undoLimit** () const
        void **setUndoLimit** (int **limit** )
        """
        ...

    def undoText(self) -> str:
        """
        https://doc.qt.io/qt-6/qundostack.html#undoText

        **QString QUndoStack::undoText() const**

        Returns the text of the command which will be undone in the next call to
        **undo** ().

        **Note:** Getter function for property undoText.

        **See also** **QUndoCommand::actionText** () and **redoText** ().
        """
        ...

    @property
    def canRedoChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#canRedoChanged

        **[signal] void QUndoStack::canRedoChanged(bool canRedo )**

        This signal is emitted whenever the value of **canRedo** () changes. It
        is used to enable or disable the redo action returned by
        **createRedoAction** (). **canRedo** specifies the new value.

        **Note:** Notifier signal for property **canRedo** .
        """
        ...

    @property
    def canUndoChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#canUndoChanged

        **[signal] void QUndoStack::canUndoChanged(bool canUndo )**

        This signal is emitted whenever the value of **canUndo** () changes. It
        is used to enable or disable the undo action returned by
        **createUndoAction** (). **canUndo** specifies the new value.

        **Note:** Notifier signal for property **canUndo** .
        """
        ...

    @property
    def cleanChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#cleanChanged

        **[signal] void QUndoStack::cleanChanged(bool clean )**

        This signal is emitted whenever the stack enters or leaves the clean
        state. If **clean** is true, the stack is in a clean state; otherwise
        this signal indicates that it has left the clean state.

        **Note:** Notifier signal for property **clean** .

        **See also** **isClean** () and **setClean** ().
        """
        ...

    @property
    def indexChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#indexChanged

        **[signal] void QUndoStack::indexChanged(int idx )**

        This signal is emitted whenever a command modifies the state of the
        document. This happens when a command is undone or redone. When a macro
        command is undone or redone, or **setIndex** () is called, this signal
        is emitted only once.

        **idx** specifies the index of the current command, ie. the command
        which will be executed on the next call to **redo** ().

        **See also** **index** () and **setIndex** ().
        """
        ...

    @property
    def redoTextChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#redoTextChanged

        **[signal] void QUndoStack::redoTextChanged(const QString & redoText )**

        This signal is emitted whenever the value of **redoText** () changes. It
        is used to update the text property of the redo action returned by
        **createRedoAction** (). **redoText** specifies the new text.

        **Note:** Notifier signal for property **redoText** .
        """
        ...

    @property
    def undoTextChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qundostack.html#undoTextChanged

        **[signal] void QUndoStack::undoTextChanged(const QString & undoText )**

        This signal is emitted whenever the value of **undoText** () changes. It
        is used to update the text property of the undo action returned by
        **createUndoAction** (). **undoText** specifies the new text.

        **Note:** Notifier signal for property **undoText** .
        """
        ...
