"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextTableCellFormat(PySide6.QtGui.QTextCharFormat):
    """
    https://doc.qt.io/qt-6/qtexttablecellformat.html

    **Detailed Description**

    The table cell format of a table cell in a document specifies the visual
    properties of the table cell.

    The padding properties of a table cell are controlled by **setLeftPadding**
    (), **setRightPadding** (), **setTopPadding** (), and **setBottomPadding**
    (). All the paddings can be set at once using **setPadding** ().

    **See also** **QTextFormat** , **QTextBlockFormat** , **QTextTableFormat** ,
    and **QTextCharFormat** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#QTextTableCellFormat

        **QTextTableCellFormat::QTextTableCellFormat()**

        Constructs a new table cell format object.
        """
        ...

    @overload
    def __init__(
        self, QTextTableCellFormat: PySide6.QtGui.QTextTableCellFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#QTextTableCellFormat

        **QTextTableCellFormat::QTextTableCellFormat()**

        Constructs a new table cell format object.
        """
        ...

    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#QTextTableCellFormat

        **QTextTableCellFormat::QTextTableCellFormat()**

        Constructs a new table cell format object.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def bottomBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorder

        **[since 5.14] qreal QTextTableCellFormat::bottomBorder() const**

        Returns the bottom border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorder** ().
        """
        ...

    def bottomBorderBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::bottomBorderBrush() const**

        Returns the bottom border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorderBrush** ().
        """
        ...

    def bottomBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::bottomBorderStyle() const**

        Returns the bottom border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorderStyle** ().
        """
        ...

    def bottomPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomPadding

        **qreal QTextTableCellFormat::bottomPadding() const**

        Gets the bottom padding of the table cell.

        **See also** **setBottomPadding** (), **leftPadding** (),
        **rightPadding** (), and **topPadding** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#isValid

        **bool QTextTableCellFormat::isValid() const**

        Returns `true` if this table cell format is valid; otherwise returns
        `false`.
        """
        ...

    def leftBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorder

        **[since 5.14] qreal QTextTableCellFormat::leftBorder() const**

        Returns the left border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorder** ().
        """
        ...

    def leftBorderBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::leftBorderBrush() const**

        Returns the left border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderBrush** ().
        """
        ...

    def leftBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::leftBorderStyle() const**

        Returns the left border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderStyle** ().
        """
        ...

    def leftPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftPadding

        **qreal QTextTableCellFormat::leftPadding() const**

        Gets the left padding of the table cell.

        **See also** **setLeftPadding** (), **rightPadding** (), **topPadding**
        (), and **bottomPadding** ().
        """
        ...

    def rightBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorder

        **[since 5.14] qreal QTextTableCellFormat::rightBorder() const**

        Returns the right border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorder** ().
        """
        ...

    def rightBorderBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::rightBorderBrush() const**

        Returns the right border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorderBrush** ().
        """
        ...

    def rightBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::rightBorderStyle() const**

        Returns the right border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorderStyle** ().
        """
        ...

    def rightPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightPadding

        **qreal QTextTableCellFormat::rightPadding() const**

        Gets the right padding of the table cell.

        **See also** **setRightPadding** (), **leftPadding** (), **topPadding**
        (), and **bottomPadding** ().
        """
        ...

    def setBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorder

        **[since 5.14] void QTextTableCellFormat::setBorder(qreal width )**

        Sets the left, right, top, and bottom border **width** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorder** (), **setRightBorder** (),
        **setTopBorder** (), **setBottomBorder** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorderBrush

        **[since 5.14] void QTextTableCellFormat::setBorderBrush(const QBrush &
        brush )**

        Sets the left, right, top, and bottom border **brush** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderBrush** (), **setRightBorderBrush** (),
        **setTopBorderBrush** (), **setBottomBorderBrush** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setBorderStyle(QTextFrameFormat::BorderStyle style
        )**

        Sets the left, right, top, and bottom border **style** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderStyle** (), **setRightBorderStyle** (),
        **setTopBorderStyle** (), **setBottomBorderStyle** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBottomBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorder

        **[since 5.14] void QTextTableCellFormat::setBottomBorder(qreal width
        )**

        Sets the bottom border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBottomBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorderBrush

        **[since 5.14] void QTextTableCellFormat::setBottomBorderBrush(const
        QBrush & brush )**

        Sets the bottom border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBottomBorderStyle(
        self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setBottomBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the bottom border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBottomPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomPadding

        **void QTextTableCellFormat::setBottomPadding(qreal padding )**

        Sets the bottom **padding** of the table cell.

        **See also** **bottomPadding** (), **setLeftPadding** (),
        **setRightPadding** (), and **setTopPadding** ().
        """
        ...

    def setLeftBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorder

        **[since 5.14] void QTextTableCellFormat::setLeftBorder(qreal width )**

        Sets the left border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setLeftBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorderBrush

        **[since 5.14] void QTextTableCellFormat::setLeftBorderBrush(const
        QBrush & brush )**

        Sets the left border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setLeftBorderStyle(
        self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setLeftBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the left border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setLeftPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftPadding

        **void QTextTableCellFormat::setLeftPadding(qreal padding )**

        Sets the left **padding** of the table cell.

        **See also** **leftPadding** (), **setRightPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def setPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setPadding

        **void QTextTableCellFormat::setPadding(qreal padding )**

        Sets the left, right, top, and bottom **padding** of the table cell.

        **See also** **setLeftPadding** (), **setRightPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def setRightBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorder

        **[since 5.14] void QTextTableCellFormat::setRightBorder(qreal width )**

        Sets the right border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setRightBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorderBrush

        **[since 5.14] void QTextTableCellFormat::setRightBorderBrush(const
        QBrush & brush )**

        Sets the right border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setRightBorderStyle(
        self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setRightBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the right border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setRightPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightPadding

        **void QTextTableCellFormat::setRightPadding(qreal padding )**

        Sets the right **padding** of the table cell.

        **See also** **rightPadding** (), **setLeftPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def setTopBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorder

        **[since 5.14] void QTextTableCellFormat::setTopBorder(qreal width )**

        Sets the top border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setTopBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorderBrush

        **[since 5.14] void QTextTableCellFormat::setTopBorderBrush(const QBrush
        & brush )**

        Sets the top border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setTopBorderStyle(
        self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setTopBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the top border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setTopPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopPadding

        **void QTextTableCellFormat::setTopPadding(qreal padding )**

        Sets the top **padding** of the table cell.

        **See also** **topPadding** (), **setLeftPadding** (),
        **setRightPadding** (), and **setBottomPadding** ().
        """
        ...

    def topBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorder

        **[since 5.14] qreal QTextTableCellFormat::topBorder() const**

        Returns the top border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorder** ().
        """
        ...

    def topBorderBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::topBorderBrush() const**

        Returns the top border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorderBrush** ().
        """
        ...

    def topBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::topBorderStyle() const**

        Returns the top border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorderStyle** ().
        """
        ...

    def topPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topPadding

        **qreal QTextTableCellFormat::topPadding() const**

        Gets the top padding of the table cell.

        **See also** **setTopPadding** (), **leftPadding** (), **rightPadding**
        (), and **bottomPadding** ().
        """
        ...
