"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextTable(PySide6.QtGui.QTextFrame):
    """
    https://doc.qt.io/qt-6/qtexttable.html

    **Detailed Description**

    A table is a group of cells ordered into rows and columns. Each table
    contains at least one row and one column. Each cell contains a block, and is
    surrounded by a frame.

    Tables are usually created and inserted into a document with the
    **QTextCursor::insertTable** () function. For example, we can insert a table
    with three rows and two columns at the current cursor position in an editor
    using the following lines of code:

    **QTextCursor**  cursor(editor->textCursor());
    cursor.movePosition(**QTextCursor** ::Start);

            QTextTable *table
    = cursor.insertTable(rows, columns, tableFormat);

    The table format is either defined when the table is created or changed
    later with **setFormat** ().

    The table currently being edited by the cursor is found with
    **QTextCursor::currentTable** (). This allows its format or dimensions to be
    changed after it has been inserted into a document.

    A table's size can be changed with **resize** (), or by using **insertRows**
    (), **insertColumns** (), **removeRows** (), or **removeColumns** (). Use
    **cellAt** () to retrieve table cells.

    The starting and ending positions of table rows can be found by moving a
    cursor within a table, and using the **rowStart** () and **rowEnd** ()
    functions to obtain cursors at the start and end of each row.

    Rows and columns within a QTextTable can be merged and split using the
    **mergeCells** () and **splitCell** () functions. However, only cells that
    span multiple rows or columns can be split. (Merging or splitting does not
    increase or decrease the number of rows and columns.)

    Note that if you have merged multiple columns and rows into one cell, you
    will not be able to split the merged cell into new cells spanning over more
    than one row or column. To be able to split cells spanning over several rows
    and columns you need to do this over several iterations.

    ![Original Table](images/texttable-split.png)Suppose we have a 2x3 table of
    names and addresses. To merge both columns in the first row we invoke
    **mergeCells** () with **row** = 0, **column** = 0, **numRows** = 1 and
    **numColumns** = 2.



            table->mergeCells(0, 0, 1, 2);
    ![](images/texttable-merge.png)This gives us the following table. To split
    the first row of the table back into two cells, we invoke the **splitCell**
    () function with **numRows** and **numCols** = 1.
    table->splitCell(0, 0, 1, 1);

    ![Split Table](images/texttable-
    split.png)This results in the original table.

    **See also** **QTextTableFormat** .
    """

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None:
        ...

    def appendColumns(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#appendColumns

        **void QTextTable::appendColumns(int count )**

        Appends **count** columns at the right side of the table.

        **See also** **insertColumns** (), **insertRows** (), **resize** (),
        **removeRows** (), **removeColumns** (), and **appendRows** ().
        """
        ...

    def appendRows(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#appendRows

        **void QTextTable::appendRows(int count )**

        Appends **count** rows at the bottom of the table.

        **See also** **insertColumns** (), **insertRows** (), **resize** (),
        **removeRows** (), **removeColumns** (), and **appendColumns** ().
        """
        ...

    @overload
    def cellAt(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextTableCell:
        """
        https://doc.qt.io/qt-6/qtexttable.html#cellAt

        **QTextTableCell QTextTable::cellAt(int row , int column ) const**

        Returns the table cell at the given **row** and **column** in the table.

        **See also** **columns** () and **rows** ().
        """
        ...

    @overload
    def cellAt(self, position: int) -> PySide6.QtGui.QTextTableCell:
        """
        https://doc.qt.io/qt-6/qtexttable.html#cellAt-1

        **QTextTableCell QTextTable::cellAt(int position ) const**

        This is an overloaded function.

        Returns the table cell that contains the character at the given
        **position** in the document.
        """
        ...

    @overload
    def cellAt(self, row: int, col: int) -> PySide6.QtGui.QTextTableCell:
        """
        https://doc.qt.io/qt-6/qtexttable.html#cellAt-2

        **QTextTableCell QTextTable::cellAt(const QTextCursor & cursor ) const**

        This is an overloaded function.

        Returns the table cell containing the given **cursor**.
        """
        ...

    def columns(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttable.html#columns

        **int QTextTable::columns() const**

        Returns the number of columns in the table.

        **See also** **rows** ().
        """
        ...

    def format(self) -> PySide6.QtGui.QTextTableFormat:
        """
        https://doc.qt.io/qt-6/qtexttable.html#format

        **QTextTableFormat QTextTable::format() const**

        Returns the table's format.

        **See also** **setFormat** ().
        """
        ...

    def insertColumns(self, pos: int, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#insertColumns

        **void QTextTable::insertColumns(int index , int columns )**

        Inserts a number of **columns** before the column with the specified
        **index**.

        **See also** **insertRows** (), **resize** (), **removeRows** (),
        **removeColumns** (), **appendRows** (), and **appendColumns** ().
        """
        ...

    def insertRows(self, pos: int, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#insertRows

        **void QTextTable::insertRows(int index , int rows )**

        Inserts a number of **rows** before the row with the specified
        **index**.

        **See also** **resize** (), **insertColumns** (), **removeRows** (),
        **removeColumns** (), **appendRows** (), and **appendColumns** ().
        """
        ...

    @overload
    def mergeCells(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#mergeCells

        **void QTextTable::mergeCells(int row , int column , int numRows , int
        numCols )**

        Merges the cell at the specified **row** and **column** with the
        adjacent cells into one cell. The new cell will span **numRows** rows
        and **numCols** columns. This method does nothing if **numRows** or
        **numCols** is less than the current number of rows or columns spanned
        by the cell.

        **See also** **splitCell** ().
        """
        ...

    @overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#mergeCells-1

        **void QTextTable::mergeCells(const QTextCursor & cursor )**

        This is an overloaded function.

        Merges the cells selected by the provided **cursor**.

        **See also** **splitCell** ().
        """
        ...

    def removeColumns(self, pos: int, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#removeColumns

        **void QTextTable::removeColumns(int index , int columns )**

        Removes a number of **columns** starting with the column at the
        specified **index**.

        **See also** **insertRows** (), **insertColumns** (), **removeRows** (),
        **resize** (), **appendRows** (), and **appendColumns** ().
        """
        ...

    def removeRows(self, pos: int, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#removeRows

        **void QTextTable::removeRows(int index , int rows )**

        Removes a number of **rows** starting with the row at the specified
        **index**.

        **See also** **insertRows** (), **insertColumns** (), **resize** (),
        **removeColumns** (), **appendRows** (), and **appendColumns** ().
        """
        ...

    def resize(self, rows: int, cols: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#resize

        **void QTextTable::resize(int rows , int columns )**

        Resizes the table to contain the required number of **rows** and
        **columns**.

        **See also** **insertRows** (), **insertColumns** (), **removeRows** (),
        and **removeColumns** ().
        """
        ...

    def rowEnd(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtexttable.html#rowEnd

        **QTextCursor QTextTable::rowEnd(const QTextCursor & cursor ) const**

        Returns a cursor pointing to the end of the row that contains the given
        **cursor**.

        **See also** **rowStart** ().
        """
        ...

    def rowStart(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtexttable.html#rowStart

        **QTextCursor QTextTable::rowStart(const QTextCursor & cursor ) const**

        Returns a cursor pointing to the start of the row that contains the
        given **cursor**.

        **See also** **rowEnd** ().
        """
        ...

    def rows(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttable.html#rows

        **int QTextTable::rows() const**

        Returns the number of rows in the table.

        **See also** **columns** ().
        """
        ...

    def setFormat(self, format: PySide6.QtGui.QTextTableFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#setFormat

        **void QTextTable::setFormat(const QTextTableFormat & format )**

        Sets the table's **format**.

        **See also** **format** ().
        """
        ...

    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None:
        """
        https://doc.qt.io/qt-6/qtexttable.html#splitCell

        **void QTextTable::splitCell(int row , int column , int numRows , int
        numCols )**

        Splits the specified cell at **row** and **column** into an array of
        multiple cells with dimensions specified by **numRows** and **numCols**.

        **Note:** It is only possible to split cells that span multiple rows or
        columns, such as rows that have been merged using **mergeCells** ().

        **See also** **mergeCells** ().
        """
        ...
