"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextOption(object):
    """
    https://doc.qt.io/qt-6/qtextoption.html

    **Detailed Description**

    QTextOption is used to encapsulate common rich text properties in a single
    object. It contains information about text alignment, layout direction, word
    wrapping, and other standard properties associated with text rendering and
    layout.

    **See also** **QTextEdit** , **QTextDocument** , and **QTextCursor** .
    """

    IncludeTrailingSpaces: QTextOption.Flag = ...
    ShowTabsAndSpaces: QTextOption.Flag = ...
    ShowLineAndParagraphSeparators: QTextOption.Flag = ...
    AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ...
    SuppressColors: QTextOption.Flag = ...
    ShowDocumentTerminator: QTextOption.Flag = ...
    LeftTab: QTextOption.TabType = ...
    RightTab: QTextOption.TabType = ...
    CenterTab: QTextOption.TabType = ...
    DelimiterTab: QTextOption.TabType = ...
    NoWrap: QTextOption.WrapMode = ...
    WordWrap: QTextOption.WrapMode = ...
    ManualWrap: QTextOption.WrapMode = ...
    WrapAnywhere: QTextOption.WrapMode = ...
    WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ...

    class Flag(Enum):
        IncludeTrailingSpaces: QTextOption.Flag = ...
        ShowTabsAndSpaces: QTextOption.Flag = ...
        ShowLineAndParagraphSeparators: QTextOption.Flag = ...
        AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ...
        SuppressColors: QTextOption.Flag = ...
        ShowDocumentTerminator: QTextOption.Flag = ...

    class Flags(object):
        ...

    class Tab(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, Tab: PySide6.QtGui.QTextOption.Tab) -> None:
            ...

        @overload
        def __init__(
            self,
            pos: float,
            tabType: PySide6.QtGui.QTextOption.TabType,
            delim: str = ...,
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class TabType(Enum):
        LeftTab: QTextOption.TabType = ...
        RightTab: QTextOption.TabType = ...
        CenterTab: QTextOption.TabType = ...
        DelimiterTab: QTextOption.TabType = ...

    class WrapMode(Enum):
        NoWrap: QTextOption.WrapMode = ...
        WordWrap: QTextOption.WrapMode = ...
        ManualWrap: QTextOption.WrapMode = ...
        WrapAnywhere: QTextOption.WrapMode = ...
        WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#QTextOption

        **QTextOption::QTextOption()**

        Constructs a text option with default properties for text. The text
        alignment property is set to **Qt::AlignLeft** . The word wrap property
        is set to **QTextOption::WordWrap** . The using of design metrics flag
        is set to false.
        """
        ...

    @overload
    def __init__(self, alignment: PySide6.QtCore.Qt.Alignment) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#QTextOption-1

        **QTextOption::QTextOption(Qt::Alignment alignment )**

        Constructs a text option with the given **alignment** for text. The word
        wrap property is set to **QTextOption::WordWrap** . The using of design
        metrics flag is set to false.
        """
        ...

    @overload
    def __init__(
        self, o: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.Alignment]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#QTextOption-2

        **QTextOption::QTextOption(const QTextOption & other )**

        Construct a copy of the **other** text option.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def alignment(self) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qtextoption.html#alignment

        **Qt::Alignment QTextOption::alignment() const**

        Returns the text alignment defined by the option.

        **See also** **setAlignment** ().
        """
        ...

    def flags(self) -> PySide6.QtGui.QTextOption.Flags:
        """
        https://doc.qt.io/qt-6/qtextoption.html#flags

        **QTextOption::Flags QTextOption::flags() const**

        Returns the flags associated with the option.

        **See also** **setFlags** ().
        """
        ...

    def setAlignment(self, alignment: PySide6.QtCore.Qt.Alignment) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setAlignment

        **void QTextOption::setAlignment(Qt::Alignment alignment )**

        Sets the option's text alignment to the specified **alignment**.

        **See also** **alignment** ().
        """
        ...

    def setFlags(self, flags: PySide6.QtGui.QTextOption.Flags) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setFlags

        **void QTextOption::setFlags(QTextOption::Flags flags )**

        Sets the flags associated with the option to the given **flags**.

        **See also** **flags** ().
        """
        ...

    def setTabArray(self, tabStops: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setTabArray

        **void QTextOption::setTabArray(const QList<qreal> & tabStops )**

        Sets the tab positions for the text layout to those specified by
        **tabStops**.

        **See also** **tabArray** (), **setTabStopDistance** (), and **setTabs**
        ().
        """
        ...

    def setTabStopDistance(self, tabStopDistance: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setTabStopDistance

        **[since 5.10] void QTextOption::setTabStopDistance(qreal
        tabStopDistance )**

        Sets the default distance in device units between tab stops to the value
        specified by **tabStopDistance**.

        This function was introduced in Qt 5.10.

        **See also** **tabStopDistance** (), **setTabArray** (), **setTabs** (),
        and **tabs** ().
        """
        ...

    def setTabs(self, tabStops: Sequence[PySide6.QtGui.QTextOption.Tab]) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setTabs

        **void QTextOption::setTabs(const QList<QTextOption::Tab> & tabStops )**

        Sets the tab positions for the text layout to those specified by
        **tabStops**.

        **See also** **tabs** () and **tabStopDistance** ().
        """
        ...

    def setTextDirection(self, aDirection: PySide6.QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setTextDirection

        **void QTextOption::setTextDirection(Qt::LayoutDirection direction )**

        Sets the direction of the text layout defined by the option to the given
        **direction**.

        **See also** **textDirection** ().
        """
        ...

    def setUseDesignMetrics(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setUseDesignMetrics

        **void QTextOption::setUseDesignMetrics(bool enable )**

        If **enable** is true then the layout will use design metrics; otherwise
        it will use the metrics of the paint device (which is the default
        behavior).

        **See also** **useDesignMetrics** ().
        """
        ...

    def setWrapMode(self, wrap: PySide6.QtGui.QTextOption.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qtextoption.html#setWrapMode

        **void QTextOption::setWrapMode(QTextOption::WrapMode mode )**

        Sets the option's text wrap mode to the given **mode**.

        **See also** **wrapMode** ().
        """
        ...

    def tabArray(self) -> List[float]:
        """
        https://doc.qt.io/qt-6/qtextoption.html#tabArray

        **QList<qreal> QTextOption::tabArray() const**

        Returns a list of tab positions defined for the text layout.

        **See also** **setTabArray** () and **tabStopDistance** ().
        """
        ...

    def tabStopDistance(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextoption.html#tabStopDistance

        **[since 5.10] qreal QTextOption::tabStopDistance() const**

        Returns the distance in device units between tab stops.

        This function was introduced in Qt 5.10.

        **See also** **setTabStopDistance** (), **tabArray** (), **setTabs** (),
        and **tabs** ().
        """
        ...

    def tabs(self) -> List[PySide6.QtGui.QTextOption.Tab]:
        """
        https://doc.qt.io/qt-6/qtextoption.html#tabs

        **QList<QTextOption::Tab> QTextOption::tabs() const**

        Returns a list of tab positions defined for the text layout.

        **See also** **tabStopDistance** (), **setTabs** (), and
        **setTabStopDistance** ().
        """
        ...

    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qtextoption.html#textDirection

        **Qt::LayoutDirection QTextOption::textDirection() const**

        Returns the direction of the text layout defined by the option.

        **See also** **setTextDirection** ().
        """
        ...

    def useDesignMetrics(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextoption.html#useDesignMetrics

        **bool QTextOption::useDesignMetrics() const**

        Returns `true` if the layout uses design rather than device metrics;
        otherwise returns `false`.

        **See also** **setUseDesignMetrics** ().
        """
        ...

    def wrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode:
        """
        https://doc.qt.io/qt-6/qtextoption.html#wrapMode

        **QTextOption::WrapMode QTextOption::wrapMode() const**

        Returns the text wrap mode defined by the option.

        **See also** **setWrapMode** ().
        """
        ...
