"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextObjectInterface(object):
    """
    https://doc.qt.io/qt-6/qtextobjectinterface.html

    **Detailed Description**

    A text object describes the structure of one or more elements in a text
    document; for instance, images imported from HTML are implemented using text
    objects. A text object knows how to lay out and draw its elements when a
    document is being rendered.

    Qt allows custom text objects to be inserted into a document by registering
    a custom **object type**  with **QTextCharFormat** . A QTextObjectInterface
    must also be implemented for this type and be **registered**  with the
    **QAbstractTextDocumentLayout**  of the document. When the object type is
    encountered while rendering a **QTextDocument** , the **intrinsicSize** ()
    and **drawObject** () functions of the interface are called.

    The following list explains the required steps of inserting a custom text
    object into a document:

    * Choose an **objectType**. The **objectType** is an integer with a value
    greater or equal to **QTextFormat::UserObject** .
      * Create a
    **QTextCharFormat**  object and set the object type to the chosen type using
    the setObjectType() function.
      * Implement the QTextObjectInterface class.
    * Call **QAbstractTextDocumentLayout::registerHandler** () with an instance
    of your QTextObjectInterface subclass to register your object type.
      *
    Insert **QChar::ObjectReplacementCharacter**  with the aforementioned
    **QTextCharFormat**  of the chosen object type into the document. As
    mentioned, the functions of QTextObjectInterface **intrinsicSize** () and
    **drawObject** () will then be called with the **QTextFormat**  as parameter
    whenever the replacement character is encountered.

    A class implementing a text object needs to inherit both **QObject**  and
    QTextObjectInterface. **QObject**  must be the first class inherited. For
    instance:

    class SvgTextObject : public **QObject** , public **QTextObjectInterface**
    {
            Q_OBJECT
            Q_INTERFACES(**QTextObjectInterface** )

    The data of a text object is usually stored in the **QTextCharFormat**
    using **QTextCharFormat::setProperty** (), and then retrieved with
    **QTextCharFormat::property** ().

    **Warning:** Copy and Paste operations ignore custom text objects.

    **See also** **Text Object Example** , **QTextCharFormat** , and
    **QTextLayout** .
    """

    def __init__(self) -> None:
        ...

    def drawObject(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        doc: PySide6.QtGui.QTextDocument,
        posInDocument: int,
        format: PySide6.QtGui.QTextFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextobjectinterface.html#drawObject

        **[pure virtual] void QTextObjectInterface::drawObject(QPainter *
        painter , const QRectF & rect , QTextDocument * doc , int posInDocument
        , const QTextFormat & format )**

        Draws this text object using the specified **painter**.

        The size of the rectangle, **rect** , to draw in is the size previously
        calculated by **intrinsicSize** (). The rectangles position is relative
        to the **painter**.

        You also get the document ( **doc** ) and the position (
        **posInDocument** ) of the **format** in that document.

        **See also** **intrinsicSize** ().
        """
        ...

    def intrinsicSize(
        self,
        doc: PySide6.QtGui.QTextDocument,
        posInDocument: int,
        format: PySide6.QtGui.QTextFormat,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qtextobjectinterface.html#intrinsicSize

        **[pure virtual] QSizeF
        QTextObjectInterface::intrinsicSize(QTextDocument * doc , int
        posInDocument , const QTextFormat & format )**

        The intrinsicSize() function returns the size of the text object
        represented by **format** in the given document ( **doc** ) at the given
        position ( **posInDocument** ).

        The size calculated will be used for subsequent calls to **drawObject**
        () for this **format**.

        **See also** **drawObject** ().
        """
        ...
