"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextLength(object):
    """
    https://doc.qt.io/qt-6/qtextlength.html

    **Detailed Description**

    When we specify a value for the length of an element in a text document, we
    often need to provide some other information so that the length is used in
    the way we expect. For example, when we specify a table width, the value can
    represent a fixed number of pixels, or it can be a percentage value. This
    information changes both the meaning of the value and the way it is used.

    Generally, this class is used to specify table widths. These can be
    specified either as a fixed amount of pixels, as a percentage of the
    containing frame's width, or by a variable width that allows it to take up
    just the space it requires.

    **See also** **QTextTable** .
    """

    VariableLength: QTextLength.Type = ...
    FixedLength: QTextLength.Type = ...
    PercentageLength: QTextLength.Type = ...

    class Type(Enum):
        VariableLength: QTextLength.Type = ...
        FixedLength: QTextLength.Type = ...
        PercentageLength: QTextLength.Type = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlength.html#QTextLength

        **QTextLength::QTextLength()**

        Constructs a new length object which represents a variable size.
        """
        ...

    @overload
    def __init__(self, QTextLength: PySide6.QtGui.QTextLength) -> None:
        """
        https://doc.qt.io/qt-6/qtextlength.html#QTextLength-1

        **QTextLength::QTextLength(QTextLength::Type type , qreal value )**

        Constructs a new length object of the given **type** and **value**.
        """
        ...

    @overload
    def __init__(self, type: PySide6.QtGui.QTextLength.Type, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextlength.html#QTextLength

        **QTextLength::QTextLength()**

        Constructs a new length object which represents a variable size.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def rawValue(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextlength.html#rawValue

        **qreal QTextLength::rawValue() const**

        Returns the constraint value that is specific for the type of the
        length. If the length is **QTextLength::PercentageLength**  then the raw
        value is in percent, in the range of 0 to 100. If the length is
        **QTextLength::FixedLength**  then that fixed amount is returned. For
        variable lengths, zero is returned.
        """
        ...

    def type(self) -> PySide6.QtGui.QTextLength.Type:
        """
        https://doc.qt.io/qt-6/qtextlength.html#type

        **QTextLength::Type QTextLength::type() const**

        Returns the type of this length object.

        **See also** **QTextLength::Type** .
        """
        ...

    def value(self, maximumLength: float) -> float:
        """
        https://doc.qt.io/qt-6/qtextlength.html#value

        **qreal QTextLength::value(qreal maximumLength ) const**

        Returns the effective length, constrained by the type of the length
        object and the specified **maximumLength**.

        **See also** **type** ().
        """
        ...
