"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextInlineObject(object):
    """
    https://doc.qt.io/qt-6/qtextinlineobject.html

    **Detailed Description**

    Normally, you do not need to create a QTextInlineObject. It is used by
    **QAbstractTextDocumentLayout**  to handle inline objects when implementing
    a custom layout.

    The inline object has various attributes that can be set, for example using,
    **setWidth** (), **setAscent** (), and **setDescent** (). The rectangle it
    occupies is given by **rect** (), and its direction by **textDirection** ().
    Its position in the text layout is given by **textPosition** (), and its
    format is given by **format** ().
    """

    def __init__(self) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def ascent(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#ascent

        **qreal QTextInlineObject::ascent() const**

        Returns the inline object's ascent.

        **See also** **setAscent** (), **descent** (), **width** (), and
        **rect** ().
        """
        ...

    def descent(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#descent

        **qreal QTextInlineObject::descent() const**

        Returns the inline object's descent.

        **See also** **setDescent** (), **ascent** (), **width** (), and
        **rect** ().
        """
        ...

    def format(self) -> PySide6.QtGui.QTextFormat:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#format

        **QTextFormat QTextInlineObject::format() const**

        Returns format of the inline object within the text layout.
        """
        ...

    def formatIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#formatIndex

        **int QTextInlineObject::formatIndex() const**

        Returns an integer describing the format of the inline object within the
        text layout.
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#height

        **qreal QTextInlineObject::height() const**

        Returns the inline object's total height. This is equal to **ascent** ()
        + **descent** () + 1.

        **See also** **ascent** (), **descent** (), **width** (), and **rect**
        ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#isValid

        **bool QTextInlineObject::isValid() const**

        Returns `true` if this inline object is valid; otherwise returns false.
        """
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#rect

        **QRectF QTextInlineObject::rect() const**

        Returns the inline object's rectangle.

        **See also** **ascent** (), **descent** (), and **width** ().
        """
        ...

    def setAscent(self, a: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#setAscent

        **void QTextInlineObject::setAscent(qreal a )**

        Sets the inline object's ascent to **a**.

        **See also** **ascent** (), **setDescent** (), **width** (), and
        **rect** ().
        """
        ...

    def setDescent(self, d: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#setDescent

        **void QTextInlineObject::setDescent(qreal d )**

        Sets the inline object's descent to **d**.

        **See also** **descent** (), **setAscent** (), **width** (), and
        **rect** ().
        """
        ...

    def setWidth(self, w: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#setWidth

        **void QTextInlineObject::setWidth(qreal w )**

        Sets the inline object's width to **w**.

        **See also** **width** (), **ascent** (), **descent** (), and **rect**
        ().
        """
        ...

    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#textDirection

        **Qt::LayoutDirection QTextInlineObject::textDirection() const**

        Returns if the object should be laid out right-to-left or left-to-right.
        """
        ...

    def textPosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#textPosition

        **int QTextInlineObject::textPosition() const**

        The position of the inline object within the text layout.
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextinlineobject.html#width

        **qreal QTextInlineObject::width() const**

        Returns the inline object's width.

        **See also** **setWidth** (), **ascent** (), **descent** (), and
        **rect** ().
        """
        ...
