"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextDocument(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qtextdocument.html

    **Detailed Description**

    QTextDocument is a container for structured rich text documents, providing
    support for styled text and various types of document elements, such as
    lists, tables, frames, and images. They can be created for use in a
    **QTextEdit** , or used independently.

    Each document element is described by an associated format object. Each
    format object is treated as a unique object by QTextDocuments, and can be
    passed to **objectForFormat** () to obtain the document element that it is
    applied to.

    A QTextDocument can be edited programmatically using a **QTextCursor** , and
    its contents can be examined by traversing the document structure. The
    entire document structure is stored as a hierarchy of document elements
    beneath the root frame, found with the **rootFrame** () function.
    Alternatively, if you just want to iterate over the textual contents of the
    document you can use **begin** (), **end** (), and **findBlock** () to
    retrieve text blocks that you can examine and iterate over.

    The layout of a document is determined by the **documentLayout** (); you can
    create your own **QAbstractTextDocumentLayout**  subclass and set it using
    **setDocumentLayout** () if you want to use your own layout logic. The
    document's title and other meta-information can be obtained by calling the
    **metaInformation** () function. For documents that are exposed to users
    through the **QTextEdit**  class, the document title is also available via
    the **QTextEdit::documentTitle** () function.

    The **toPlainText** () and **toHtml** () convenience functions allow you to
    retrieve the contents of the document as plain text and HTML. The document's
    text can be searched using the **find** () functions.

    Undo/redo of operations performed on the document can be controlled using
    the **setUndoRedoEnabled** () function. The undo/redo system can be
    controlled by an editor widget through the **undo** () and **redo** ()
    slots; the document also provides **contentsChanged** (), **undoAvailable**
    (), and **redoAvailable** () signals that inform connected editor widgets
    about the state of the undo/redo system. The following are the undo/redo
    operations of a QTextDocument:

    * Insertion or removal of characters. A sequence of insertions or removals
    within the same text block are regarded as a single undo/redo operation.
      *
    Insertion or removal of text blocks. Sequences of insertion or removals in a
    single operation (e.g., by selecting and then deleting text) are regarded as
    a single undo/redo operation.
      * Text character format changes.
      * Text
    block format changes.
      * Text block group format changes.

    **See also** **QTextCursor** , **QTextEdit** , **Rich Text Processing** ,
    and **Text Object Example** .
    """

    FindBackward: QTextDocument.FindFlag = ...
    FindCaseSensitively: QTextDocument.FindFlag = ...
    FindWholeWords: QTextDocument.FindFlag = ...
    MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ...
    MarkdownNoHTML: QTextDocument.MarkdownFeature = ...
    MarkdownDialectGitHub: QTextDocument.MarkdownFeature = ...
    DocumentTitle: QTextDocument.MetaInformation = ...
    DocumentUrl: QTextDocument.MetaInformation = ...
    UnknownResource: QTextDocument.ResourceType = ...
    HtmlResource: QTextDocument.ResourceType = ...
    ImageResource: QTextDocument.ResourceType = ...
    StyleSheetResource: QTextDocument.ResourceType = ...
    MarkdownResource: QTextDocument.ResourceType = ...
    UserResource: QTextDocument.ResourceType = ...
    UndoStack: QTextDocument.Stacks = ...
    RedoStack: QTextDocument.Stacks = ...
    UndoAndRedoStacks: QTextDocument.Stacks = ...

    class FindFlag(Enum):
        FindBackward: QTextDocument.FindFlag = ...
        FindCaseSensitively: QTextDocument.FindFlag = ...
        FindWholeWords: QTextDocument.FindFlag = ...

    class FindFlags(object):
        ...

    class MarkdownFeature(Enum):
        MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ...
        MarkdownNoHTML: QTextDocument.MarkdownFeature = ...
        MarkdownDialectGitHub: QTextDocument.MarkdownFeature = ...

    class MarkdownFeatures(object):
        ...

    class MetaInformation(Enum):
        DocumentTitle: QTextDocument.MetaInformation = ...
        DocumentUrl: QTextDocument.MetaInformation = ...

    class ResourceType(Enum):
        UnknownResource: QTextDocument.ResourceType = ...
        HtmlResource: QTextDocument.ResourceType = ...
        ImageResource: QTextDocument.ResourceType = ...
        StyleSheetResource: QTextDocument.ResourceType = ...
        MarkdownResource: QTextDocument.ResourceType = ...
        UserResource: QTextDocument.ResourceType = ...

    class Stacks(Enum):
        UndoStack: QTextDocument.Stacks = ...
        RedoStack: QTextDocument.Stacks = ...
        UndoAndRedoStacks: QTextDocument.Stacks = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#QTextDocument

        **QTextDocument::QTextDocument(QObject * parent = nullptr)**

        Constructs an empty QTextDocument with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self, text: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#QTextDocument-1

        **QTextDocument::QTextDocument(const QString & text , QObject * parent =
        nullptr)**

        Constructs a QTextDocument containing the plain (unformatted) **text**
        specified, and with the given **parent**.
        """
        ...

    def addResource(
        self, type: int, name: Union[PySide6.QtCore.QUrl, str], resource: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#addResource

        **void QTextDocument::addResource(int type , const QUrl & name , const
        QVariant & resource )**

        Adds the resource **resource** to the resource cache, using **type** and
        **name** as identifiers. **type** should be a value from
        **QTextDocument::ResourceType** .

        For example, you can add an image as a resource in order to reference it
        from within the document:

        document->addResource(**QTextDocument** ::ImageResource,
        **QUrl** ("mydata://image.png"), **QVariant** (image));

        The image can be inserted into the document using the **QTextCursor**
        API:

        **QTextImageFormat**  imageFormat;
        imageFormat.setName("mydata://image.png");
        cursor.insertImage(imageFormat);

        Alternatively, you can insert images using the HTML `img` tag:

        editor->append("<img src=\\"mydata://image.png\\" />");
        """
        ...

    def adjustSize(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#adjustSize

        **void QTextDocument::adjustSize()**

        Adjusts the document to a reasonable size.

        **See also** **idealWidth** (), **textWidth** , and **size** .
        """
        ...

    def allFormats(self) -> List[PySide6.QtGui.QTextFormat]:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#allFormats

        **QList<QTextFormat> QTextDocument::allFormats() const**

        Returns a list of text formats for all the formats used in the document.
        """
        ...

    def availableRedoSteps(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#availableRedoSteps

        **int QTextDocument::availableRedoSteps() const**

        Returns the number of available redo steps.

        **See also** **isRedoAvailable** ().
        """
        ...

    def availableUndoSteps(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#availableUndoSteps

        **int QTextDocument::availableUndoSteps() const**

        Returns the number of available undo steps.

        **See also** **isUndoAvailable** ().
        """
        ...

    def baseUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#baseUrl-prop

        **[since 5.3] baseUrl : QUrl**

        This property holds the base URL used to resolve relative resource URLs
        within the document.

        Resource URLs are resolved to be within the same directory as the target
        of the base URL meaning any portion of the path after the last '/' will
        be ignored.

        Base URLRelative URLResolved URL
        file:///path/to/contentimages/logo.pngfile:///path/to/images/logo.png

        file:///path/to/content/images/logo.pngfile:///path/to/content/images/lo
        go.png
        file:///path/to/content/index.htmlimages/logo.pngfile:///path/t
        o/content/images/logo.png
        file:///path/to/content/images/../images/log
        o.pngfile:///path/to/content/images/logo.png

        This property was introduced in Qt 5.3.

        **Access functions:**

        QUrl **baseUrl** () const
        void **setBaseUrl** (const QUrl & **url** )

        **Notifier signal:**

        void **baseUrlChanged** (const QUrl & **url** )
        """
        ...

    def baselineOffset(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#baselineOffset

        **[since 6.0] qreal QTextDocument::baselineOffset() const**

        Returns the the baseline offset in % used in the document layout.

        This function was introduced in Qt 6.0.

        **See also** **setBaselineOffset** (), **setSubScriptBaseline** (),
        **subScriptBaseline** (), **setSuperScriptBaseline** (), and
        **superScriptBaseline** ().
        """
        ...

    def begin(self) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#begin

        **QTextBlock QTextDocument::begin() const**

        Returns the document's first text block.

        **See also** **firstBlock** ().
        """
        ...

    def blockCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#blockCount-prop

        **[read-only] blockCount : const int**

        This property holds the number of text blocks in the document.

        The value of this property is undefined in documents with tables or
        frames.

        By default, if defined, this property contains a value of 1.

        **Access functions:**

        int **blockCount** () const

        **See also** **lineCount** () and **characterCount** ().
        """
        ...

    def characterAt(self, pos: int) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#characterAt

        **QChar QTextDocument::characterAt(int pos ) const**

        Returns the character at position **pos** , or a null character if the
        position is out of range.

        **See also** **characterCount** ().
        """
        ...

    def characterCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#characterCount

        **int QTextDocument::characterCount() const**

        Returns the number of characters of this document.

        **Note:** As a **QTextDocument**  always contains at least one
        **QChar::ParagraphSeparator** , this method will return at least 1.

        **See also** **blockCount** () and **characterAt** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#clear

        **[virtual] void QTextDocument::clear()**

        Clears the document.
        """
        ...

    def clearUndoRedoStacks(
        self, historyToClear: PySide6.QtGui.QTextDocument.Stacks = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#clearUndoRedoStacks

        **void QTextDocument::clearUndoRedoStacks(QTextDocument::Stacks
        stacksToClear = UndoAndRedoStacks)**

        Clears the stacks specified by **stacksToClear**.

        This method clears any commands on the undo stack, the redo stack, or
        both (the default). If commands are cleared, the appropriate signals are
        emitted, **QTextDocument::undoAvailable** () or
        **QTextDocument::redoAvailable** ().

        **See also** **QTextDocument::undoAvailable** () and
        **QTextDocument::redoAvailable** ().
        """
        ...

    def clone(
        self, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> PySide6.QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#clone

        **QTextDocument *QTextDocument::clone(QObject * parent = nullptr)
        const**

        Creates a new **QTextDocument**  that is a copy of this text document.
        **parent** is the parent of the returned text document.
        """
        ...

    def createObject(self, f: PySide6.QtGui.QTextFormat) -> PySide6.QtGui.QTextObject:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#createObject

        **[virtual protected] QTextObject *QTextDocument::createObject(const
        QTextFormat & format )**

        Creates and returns a new document object (a **QTextObject** ), based on
        the given **format**.

        QTextObjects will always get created through this method, so you must
        reimplement it if you use custom text objects inside your document.
        """
        ...

    def defaultCursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#defaultCursorMoveStyle

        **Qt::CursorMoveStyle QTextDocument::defaultCursorMoveStyle() const**

        The default cursor movement style is used by all **QTextCursor**
        objects created from the document. The default is
        **Qt::LogicalMoveStyle** .

        **See also** **setDefaultCursorMoveStyle** ().
        """
        ...

    def defaultFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#defaultFont

        **QFont QTextDocument::defaultFont() const**

        Returns the default font to be used in the document layout.

        **Note:** Getter function for property defaultFont.

        **See also** **setDefaultFont** ().
        """
        ...

    def defaultStyleSheet(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#defaultStyleSheet-prop

        **defaultStyleSheet : QString**

        The default style sheet is applied to all newly HTML formatted text that
        is inserted into the document, for example using **setHtml** () or
        **QTextCursor::insertHtml** ().

        The style sheet needs to be compliant to CSS 2.1 syntax.

        **Note:** Changing the default style sheet does not have any effect to
        the existing content of the document.

        **Access functions:**

        QString **defaultStyleSheet** () const
        void **setDefaultStyleSheet**
        (const QString & **sheet** )

        **See also** **Supported HTML Subset** .
        """
        ...

    def defaultTextOption(self) -> PySide6.QtGui.QTextOption:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#defaultTextOption

        **QTextOption QTextDocument::defaultTextOption() const**

        The default text option is used on all **QTextLayout**  objects in the
        document. This allows setting global properties for the document such as
        the default word wrap mode.

        **Note:** Getter function for property defaultTextOption.

        **See also** **setDefaultTextOption** ().
        """
        ...

    def documentLayout(self) -> PySide6.QtGui.QAbstractTextDocumentLayout:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#documentLayout

        **QAbstractTextDocumentLayout *QTextDocument::documentLayout() const**

        Returns the document layout for this document.

        **See also** **setDocumentLayout** ().
        """
        ...

    def documentMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#documentMargin-prop

        **documentMargin : qreal**

        The margin around the document. The default is 4.

        **Access functions:**

        qreal **documentMargin** () const
        void **setDocumentMargin** (qreal
        **margin** )
        """
        ...

    def drawContents(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#drawContents

        **void QTextDocument::drawContents(QPainter * p , const QRectF & rect =
        QRectF())**

        Draws the content of the document with painter **p** , clipped to
        **rect**. If **rect** is a null rectangle (default) then the document is
        painted unclipped.
        """
        ...

    def end(self) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#end

        **QTextBlock QTextDocument::end() const**

        This function returns a block to test for the end of the document while
        iterating over it.

        for (**QTextBlock**  it = doc->begin(); it != doc->end(); it =
        it.next())
                std::cout << it.text().toStdString() << "\\n";

        The block returned is invalid and represents the block after the last
        block in the document. You can use **lastBlock** () to retrieve the last
        valid block of the document.

        **See also** **lastBlock** ().
        """
        ...

    @overload
    def find(
        self,
        expr: Union[PySide6.QtCore.QRegularExpression, str],
        cursor: PySide6.QtGui.QTextCursor,
        options: PySide6.QtGui.QTextDocument.FindFlags = ...,
    ) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#find

        **QTextCursor QTextDocument::find(const QString & subString , const
        QTextCursor & cursor , QTextDocument::FindFlags options = FindFlags())
        const**

        Finds the next occurrence of the string, **subString** , in the
        document. The search starts at the position of the given **cursor** ,
        and proceeds forwards through the document unless specified otherwise in
        the search options. The **options** control the type of search
        performed.

        Returns a cursor with the match selected if **subString** was found;
        otherwise returns a null cursor.

        If the given **cursor** has a selection, the search begins after the
        selection; otherwise it begins at the cursor's position.

        By default the search is case insensitive, and can match text anywhere
        in the document.
        """
        ...

    @overload
    def find(
        self,
        expr: Union[PySide6.QtCore.QRegularExpression, str],
        from_: int = ...,
        options: PySide6.QtGui.QTextDocument.FindFlags = ...,
    ) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#find-1

        **QTextCursor QTextDocument::find(const QString & subString , int
        position = 0, QTextDocument::FindFlags options = FindFlags()) const**

        This is an overloaded function.

        Finds the next occurrence of the string, **subString** , in the
        document. The search starts at the given **position** , and proceeds
        forwards through the document unless specified otherwise in the search
        options. The **options** control the type of search performed.

        Returns a cursor with the match selected if **subString** was found;
        otherwise returns a null cursor.

        If the **position** is 0 (the default) the search begins from the
        beginning of the document; otherwise it begins at the specified
        position.
        """
        ...

    @overload
    def find(
        self,
        subString: str,
        cursor: PySide6.QtGui.QTextCursor,
        options: PySide6.QtGui.QTextDocument.FindFlags = ...,
    ) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#find-2

        **[since 5.5] QTextCursor QTextDocument::find(const QRegularExpression &
        expr , int from = 0, QTextDocument::FindFlags options = FindFlags())
        const**

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the given **from** position, and proceeds forwards
        through the document unless specified otherwise in the search options.
        The **options** control the type of search performed.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the **from** position is 0 (the default) the search begins from the
        beginning of the document; otherwise it begins at the specified
        position.

        This function was introduced in Qt 5.5.
        """
        ...

    @overload
    def find(
        self,
        subString: str,
        from_: int = ...,
        options: PySide6.QtGui.QTextDocument.FindFlags = ...,
    ) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#find-3

        **[since 5.5] QTextCursor QTextDocument::find(const QRegularExpression &
        expr , const QTextCursor & cursor , QTextDocument::FindFlags options =
        FindFlags()) const**

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the position of the given **cursor** , and proceeds
        forwards through the document unless specified otherwise in the search
        options. The **options** control the type of search performed.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the given **cursor** has a selection, the search begins after the
        selection; otherwise it begins at the cursor's position.

        By default the search is case insensitive, and can match text anywhere
        in the document.

        This function was introduced in Qt 5.5.
        """
        ...

    def findBlock(self, pos: int) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#findBlock

        **QTextBlock QTextDocument::findBlock(int pos ) const**

        Returns the text block that contains the **pos** -th character.
        """
        ...

    def findBlockByLineNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#findBlockByLineNumber

        **QTextBlock QTextDocument::findBlockByLineNumber(int lineNumber )
        const**

        Returns the text block that contains the specified **lineNumber**.

        **See also** **QTextBlock::firstLineNumber** ().
        """
        ...

    def findBlockByNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#findBlockByNumber

        **QTextBlock QTextDocument::findBlockByNumber(int blockNumber ) const**

        Returns the text block with the specified **blockNumber**.

        **See also** **QTextBlock::blockNumber** ().
        """
        ...

    def firstBlock(self) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#firstBlock

        **QTextBlock QTextDocument::firstBlock() const**

        Returns the document's first text block.
        """
        ...

    def frameAt(self, pos: int) -> PySide6.QtGui.QTextFrame:
        ...

    def idealWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#idealWidth

        **qreal QTextDocument::idealWidth() const**

        Returns the ideal width of the text document. The ideal width is the
        actually used width of the document without optional alignments taken
        into account. It is always <= **size** ().width().

        **See also** **adjustSize** () and **textWidth** .
        """
        ...

    def indentWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#indentWidth-prop

        **indentWidth : qreal**

        Returns the width used for text list and text block indenting.

        The indent properties of **QTextListFormat**  and **QTextBlockFormat**
        specify multiples of this value. The default indent width is 40.

        **Access functions:**

        qreal **indentWidth** () const
        void ****setIndentWidth** ** (qreal
        **width** )
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#isEmpty

        **bool QTextDocument::isEmpty() const**

        Returns `true` if the document is empty; otherwise returns `false`.
        """
        ...

    def isModified(self) -> bool:
        ...

    def isRedoAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#isRedoAvailable

        **bool QTextDocument::isRedoAvailable() const**

        Returns `true` if redo is available; otherwise returns `false`.

        **See also** **isUndoAvailable** () and **availableRedoSteps** ().
        """
        ...

    def isUndoAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#isUndoAvailable

        **bool QTextDocument::isUndoAvailable() const**

        Returns `true` if undo is available; otherwise returns `false`.

        **See also** **isRedoAvailable** () and **availableUndoSteps** ().
        """
        ...

    def isUndoRedoEnabled(self) -> bool:
        ...

    def lastBlock(self) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#lastBlock

        **QTextBlock QTextDocument::lastBlock() const**

        Returns the document's last (valid) text block.
        """
        ...

    def lineCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#lineCount

        **int QTextDocument::lineCount() const**

        Returns the number of lines of this document (if the layout supports
        this). Otherwise, this is identical to the number of blocks.

        **See also** **blockCount** () and **characterCount** ().
        """
        ...

    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#loadResource

        **[virtual protected invokable] QVariant QTextDocument::loadResource(int
        type , const QUrl & name )**

        Loads data of the specified **type** from the resource with the given
        **name**.

        This function is called by the rich text engine to request data that
        isn't directly stored by **QTextDocument** , but still associated with
        it. For example, images are referenced indirectly by the name attribute
        of a **QTextImageFormat**  object.

        When called by Qt, **type** is one of the values of
        **QTextDocument::ResourceType** .

        If the **QTextDocument**  is a child object of a **QObject**  that has
        an invokable loadResource method such as **QTextEdit** ,
        **QTextBrowser**  or a **QTextDocument**  itself then the default
        implementation tries to retrieve the data from the parent.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QTextDocument::ResourceProvider** .
        """
        ...

    def markContentsDirty(self, from_: int, length: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#markContentsDirty

        **void QTextDocument::markContentsDirty(int position , int length )**

        Marks the contents specified by the given **position** and **length** as
        "dirty", informing the document that it needs to be laid out again.
        """
        ...

    def maximumBlockCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        Specifies the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents.

        Setting this property also disables the undo redo history.

        This property is undefined in documents with tables or frames.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def metaInformation(self, info: PySide6.QtGui.QTextDocument.MetaInformation) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#metaInformation

        **QString QTextDocument::metaInformation(QTextDocument::MetaInformation
        info ) const**

        Returns meta information about the document of the type specified by
        **info**.

        **See also** **setMetaInformation** ().
        """
        ...

    def object(self, objectIndex: int) -> PySide6.QtGui.QTextObject:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#object

        **QTextObject *QTextDocument::object(int objectIndex ) const**

        Returns the text object associated with the given **objectIndex**.
        """
        ...

    def objectForFormat(
        self, arg__1: PySide6.QtGui.QTextFormat
    ) -> PySide6.QtGui.QTextObject:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#objectForFormat

        **QTextObject *QTextDocument::objectForFormat(const QTextFormat & f )
        const**

        Returns the text object associated with the format **f**.
        """
        ...

    def pageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#pageCount

        **int QTextDocument::pageCount() const**

        returns the number of pages in this document.
        """
        ...

    def pageSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#pageSize-prop

        **pageSize : QSizeF**

        This property holds the page size that should be used for laying out the
        document

        The units are determined by the underlying paint device. The size is
        measured in logical pixels when painting to the screen, and in points
        (1/72 inch) when painting to a printer.

        By default, for a newly-created, empty document, this property contains
        an undefined size.

        **Access functions:**

        QSizeF **pageSize** () const
        void **setPageSize** (const QSizeF &
        **size** )

        **See also** **modificationChanged** ().
        """
        ...

    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#print

        **void QTextDocument::print(QPagedPaintDevice * printer ) const**

        Prints the document to the given **printer**. The **QPagedPaintDevice**
        must be set up before being used with this function.

        This is only a convenience method to print the whole document to the
        printer.

        If the document is already paginated through a specified height in the
        **pageSize** () property it is printed as-is.

        If the document is not paginated, like for example a document used in a
        **QTextEdit** , then a temporary copy of the document is created and the
        copy is broken into multiple pages according to the size of the paint
        device's paperRect(). By default a 2 cm margin is set around the
        document contents. In addition the current page number is printed at the
        bottom of each page.

        **See also** **QTextEdit::print** ().
        """
        ...

    @overload
    def redo(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#redo

        **void QTextDocument::redo(QTextCursor * cursor )**

        Redoes the last editing operation on the document if **redo is
        available** .

        The provided **cursor** is positioned at the end of the location where
        the edition operation was redone.
        """
        ...

    @overload
    def redo(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#redo-1

        **[slot] void QTextDocument::redo()**

        This is an overloaded function.

        Redoes the last editing operation on the document if **redo is
        available** .
        """
        ...

    def resource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#resource

        **QVariant QTextDocument::resource(int type , const QUrl & name )
        const**

        Returns data of the specified **type** from the resource with the given
        **name**.

        This function is called by the rich text engine to request data that
        isn't directly stored by **QTextDocument** , but still associated with
        it. For example, images are referenced indirectly by the name attribute
        of a **QTextImageFormat**  object.

        Resources are cached internally in the document. If a resource can not
        be found in the cache, **loadResource**  is called to try to load the
        resource. **loadResource**  should then use **addResource**  to add the
        resource to the cache.

        If **loadResource**  does not load the resource, then the
        **resourceProvider**  and lastly the **defaultResourceProvider**  will
        be called, if set. Note that the result from the provider will not be
        added automatically to the cache.

        **See also** **QTextDocument::ResourceType**  and **resourceProvider**
        ().
        """
        ...

    def revision(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#revision

        **int QTextDocument::revision() const**

        Returns the document's revision (if undo is enabled).

        The revision is guaranteed to increase when a document that is not
        modified is edited.

        **See also** **QTextBlock::revision** () and **isModified** ().
        """
        ...

    def rootFrame(self) -> PySide6.QtGui.QTextFrame:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#rootFrame

        **QTextFrame *QTextDocument::rootFrame() const**

        Returns the document's root frame.
        """
        ...

    def setBaseUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#baseUrl-prop

        **[since 5.3] baseUrl : QUrl**

        This property holds the base URL used to resolve relative resource URLs
        within the document.

        Resource URLs are resolved to be within the same directory as the target
        of the base URL meaning any portion of the path after the last '/' will
        be ignored.

        Base URLRelative URLResolved URL
        file:///path/to/contentimages/logo.pngfile:///path/to/images/logo.png

        file:///path/to/content/images/logo.pngfile:///path/to/content/images/lo
        go.png
        file:///path/to/content/index.htmlimages/logo.pngfile:///path/t
        o/content/images/logo.png
        file:///path/to/content/images/../images/log
        o.pngfile:///path/to/content/images/logo.png

        This property was introduced in Qt 5.3.

        **Access functions:**

        QUrl **baseUrl** () const
        void **setBaseUrl** (const QUrl & **url** )

        **Notifier signal:**

        void **baseUrlChanged** (const QUrl & **url** )
        """
        ...

    def setBaselineOffset(self, baseline: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setBaselineOffset

        **[since 6.0] void QTextDocument::setBaselineOffset(qreal baseline )**

        Sets the base line as a% of font height to use in the document layout to
        **baseline**. The default value is 0. A positive value moves up the
        text, by the corresponding %; a negative value moves it down.

        This function was introduced in Qt 6.0.

        **See also** **baselineOffset** (), **setSubScriptBaseline** (),
        **subScriptBaseline** (), **setSuperScriptBaseline** (), and
        **superScriptBaseline** ().
        """
        ...

    def setDefaultCursorMoveStyle(
        self, style: PySide6.QtCore.Qt.CursorMoveStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setDefaultCursorMoveStyle

        **void QTextDocument::setDefaultCursorMoveStyle(Qt::CursorMoveStyle
        style )**

        Sets the default cursor movement style to the given **style**.

        **See also** **defaultCursorMoveStyle** ().
        """
        ...

    def setDefaultFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setDefaultFont

        **void QTextDocument::setDefaultFont(const QFont & font )**

        Sets the default **font** to use in the document layout.

        **Note:** Setter function for property **defaultFont** .

        **See also** **defaultFont** ().
        """
        ...

    def setDefaultStyleSheet(self, sheet: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#defaultStyleSheet-prop

        **defaultStyleSheet : QString**

        The default style sheet is applied to all newly HTML formatted text that
        is inserted into the document, for example using **setHtml** () or
        **QTextCursor::insertHtml** ().

        The style sheet needs to be compliant to CSS 2.1 syntax.

        **Note:** Changing the default style sheet does not have any effect to
        the existing content of the document.

        **Access functions:**

        QString **defaultStyleSheet** () const
        void **setDefaultStyleSheet**
        (const QString & **sheet** )

        **See also** **Supported HTML Subset** .
        """
        ...

    def setDefaultTextOption(
        self, option: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.Alignment]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setDefaultTextOption

        **void QTextDocument::setDefaultTextOption(const QTextOption & option
        )**

        Sets the default text option to **option**.

        **Note:** Setter function for property **defaultTextOption** .

        **See also** **defaultTextOption** ().
        """
        ...

    def setDocumentLayout(
        self, layout: PySide6.QtGui.QAbstractTextDocumentLayout
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setDocumentLayout

        **void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *
        layout )**

        Sets the document to use the given **layout**. The previous layout is
        deleted.

        **See also** **documentLayoutChanged** ().
        """
        ...

    def setDocumentMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#documentMargin-prop

        **documentMargin : qreal**

        The margin around the document. The default is 4.

        **Access functions:**

        qreal **documentMargin** () const
        void **setDocumentMargin** (qreal
        **margin** )
        """
        ...

    def setHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setHtml

        **void QTextDocument::setHtml(const QString & html )**

        Replaces the entire contents of the document with the given HTML-
        formatted text in the **html** string. The undo/redo history is reset
        when this function is called.

        The HTML formatting is respected as much as possible; for example,
        "<b>bold</b> text" will produce text where the first word has a font
        weight that gives it a bold appearance: " **bold** text".

        **Note:** It is the responsibility of the caller to make sure that the
        text is correctly decoded when a **QString**  containing HTML is created
        and passed to setHtml().

        **See also** **setPlainText** () and **Supported HTML Subset** .
        """
        ...

    def setIndentWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setIndentWidth

        **void QTextDocument::setIndentWidth(qreal width )**

        Sets the **width** used for text list and text block indenting.

        The indent properties of **QTextListFormat**  and **QTextBlockFormat**
        specify multiples of this value. The default indent width is 40 .

        **Note:** Setter function for property **indentWidth** .

        **See also** **indentWidth** ().
        """
        ...

    def setMarkdown(
        self,
        markdown: str,
        features: PySide6.QtGui.QTextDocument.MarkdownFeatures = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setMarkdown

        **[since 5.14] void QTextDocument::setMarkdown(const QString & markdown
        , QTextDocument::MarkdownFeatures features = MarkdownDialectGitHub)**

        Replaces the entire contents of the document with the given Markdown-
        formatted text in the **markdown** string, with the given **features**
        supported. By default, all supported GitHub-style Markdown features are
        included; pass `MarkdownDialectCommonMark` for a more basic parse.

        The Markdown formatting is respected as much as possible; for example,
        "*bold* text" will produce text where the first word has a font weight
        that gives it an emphasized appearance.

        Parsing of HTML included in the **markdown** string is handled in the
        same way as in **setHtml** ; however, Markdown formatting inside HTML
        blocks is not supported.

        Some features of the parser can be enabled or disabled via the
        **features** argument:

        ConstantDescription
        `MarkdownNoHTML`Any HTML tags in the Markdown text
        will be discarded
        `MarkdownDialectCommonMark`The parser supports only
        the features standardized by CommonMark
        `MarkdownDialectGitHub`The
        parser supports the GitHub dialect

        The default is `MarkdownDialectGitHub`.

        The undo/redo history is reset when this function is called.

        This function was introduced in Qt 5.14.
        """
        ...

    def setMaximumBlockCount(self, maximum: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        Specifies the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents.

        Setting this property also disables the undo redo history.

        This property is undefined in documents with tables or frames.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def setMetaInformation(
        self, info: PySide6.QtGui.QTextDocument.MetaInformation, arg__2: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setMetaInformation

        **void QTextDocument::setMetaInformation(QTextDocument::MetaInformation
        info , const QString & string )**

        Sets the document's meta information of the type specified by **info**
        to the given **string**.

        **See also** **metaInformation** ().
        """
        ...

    def setModified(self, m: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#modified-prop

        **modified : bool**

        This property holds whether the document has been modified by the user

        By default, this property is `false`.

        **Access functions:**

        bool **isModified** () const
        void **setModified** (bool **m** = true)

        **See also** **modificationChanged** ().
        """
        ...

    def setPageSize(
        self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#pageSize-prop

        **pageSize : QSizeF**

        This property holds the page size that should be used for laying out the
        document

        The units are determined by the underlying paint device. The size is
        measured in logical pixels when painting to the screen, and in points
        (1/72 inch) when painting to a printer.

        By default, for a newly-created, empty document, this property contains
        an undefined size.

        **Access functions:**

        QSizeF **pageSize** () const
        void **setPageSize** (const QSizeF &
        **size** )

        **See also** **modificationChanged** ().
        """
        ...

    def setPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setPlainText

        **void QTextDocument::setPlainText(const QString & text )**

        Replaces the entire contents of the document with the given plain
        **text**. The undo/redo history is reset when this function is called.

        **See also** **setHtml** ().
        """
        ...

    def setSubScriptBaseline(self, baseline: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setSubScriptBaseline

        **[since 6.0] void QTextDocument::setSubScriptBaseline(qreal baseline
        )**

        Sets the default subscript's base line as a % of font height to use in
        the document layout to **baseline**. The default value is 16.67% (1/6 of
        height).

        This function was introduced in Qt 6.0.

        **See also** **subScriptBaseline** (), **setSuperScriptBaseline** (),
        **superScriptBaseline** (), **setBaselineOffset** (), and
        **baselineOffset** ().
        """
        ...

    def setSuperScriptBaseline(self, baseline: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#setSuperScriptBaseline

        **[since 6.0] void QTextDocument::setSuperScriptBaseline(qreal baseline
        )**

        Sets the default superscript's base line as a % of font height to use in
        the document layout to **baseline**. The default value is 50% (1/2 of
        height).

        This function was introduced in Qt 6.0.

        **See also** **superScriptBaseline** (), **setSubScriptBaseline** (),
        **subScriptBaseline** (), **setBaselineOffset** (), and
        **baselineOffset** ().
        """
        ...

    def setTextWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#textWidth-prop

        **textWidth : qreal**

        The text width specifies the preferred width for text in the document.
        If the text (or content in general) is wider than the specified with it
        is broken into multiple lines and grows vertically. If the text cannot
        be broken into multiple lines to fit into the specified text width it
        will be larger and the **size** () and the **idealWidth** () property
        will reflect that.

        If the text width is set to -1 then the text will not be broken into
        multiple lines unless it is enforced through an explicit line break or a
        new paragraph.

        The default value is -1.

        Setting the text width will also set the page height to -1, causing the
        document to grow or shrink vertically in a continuous way. If you want
        the document layout to break the text into multiple pages then you have
        to set the **pageSize**  property instead.

        **Access functions:**

        qreal **textWidth** () const
        void **setTextWidth** (qreal **width** )

        **See also** **size** (), **idealWidth** (), and **pageSize** ().
        """
        ...

    def setUndoRedoEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#undoRedoEnabled-prop

        **undoRedoEnabled : bool**

        This property holds whether undo/redo are enabled for this document

        This defaults to true. If disabled, the undo stack is cleared and no
        items will be added to it.

        **Access functions:**

        bool **isUndoRedoEnabled** () const
        void **setUndoRedoEnabled** (bool
        **enable** )
        """
        ...

    def setUseDesignMetrics(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#useDesignMetrics-prop

        **useDesignMetrics : bool**

        This property holds whether the document uses design metrics of fonts to
        improve the accuracy of text layout

        If this property is set to true, the layout will use design metrics.
        Otherwise, the metrics of the paint device as set on
        **QAbstractTextDocumentLayout::setPaintDevice** () will be used.

        Using design metrics makes a layout have a width that is no longer
        dependent on hinting and pixel-rounding. This means that WYSIWYG text
        layout becomes possible because the width scales much more linearly
        based on paintdevice metrics than it would otherwise.

        By default, this property is `false`.

        **Access functions:**

        bool **useDesignMetrics** () const
        void **setUseDesignMetrics** (bool
        **b** )

        **Member Function Documentation**
        """
        ...

    def size(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#size-prop

        **[read-only] size : const QSizeF**

        This property holds the actual size of the document. This is equivalent
        to **documentLayout** ()->documentSize();

        The size of the document can be changed either by setting a text width
        or setting an entire page size.

        Note that the width is always >= **pageSize** ().width().

        By default, for a newly-created, empty document, this property contains
        a configuration-dependent size.

        **Access functions:**

        QSizeF **size** () const

        **See also** **setTextWidth** (), **setPageSize** (), and **idealWidth**
        ().
        """
        ...

    def subScriptBaseline(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#subScriptBaseline

        **[since 6.0] qreal QTextDocument::subScriptBaseline() const**

        Returns the superscript's base line as a % of font height used in the
        document layout.

        This function was introduced in Qt 6.0.

        **See also** **setSubScriptBaseline** (), **setSuperScriptBaseline** (),
        **superScriptBaseline** (), **setBaselineOffset** (), and
        **baselineOffset** ().
        """
        ...

    def superScriptBaseline(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#superScriptBaseline

        **[since 6.0] qreal QTextDocument::superScriptBaseline() const**

        Returns the superscript's base line as a % of font height used in the
        document layout.

        This function was introduced in Qt 6.0.

        **See also** **setSuperScriptBaseline** (), **setSubScriptBaseline** (),
        **subScriptBaseline** (), **setBaselineOffset** (), and
        **baselineOffset** ().
        """
        ...

    def textWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#textWidth-prop

        **textWidth : qreal**

        The text width specifies the preferred width for text in the document.
        If the text (or content in general) is wider than the specified with it
        is broken into multiple lines and grows vertically. If the text cannot
        be broken into multiple lines to fit into the specified text width it
        will be larger and the **size** () and the **idealWidth** () property
        will reflect that.

        If the text width is set to -1 then the text will not be broken into
        multiple lines unless it is enforced through an explicit line break or a
        new paragraph.

        The default value is -1.

        Setting the text width will also set the page height to -1, causing the
        document to grow or shrink vertically in a continuous way. If you want
        the document layout to break the text into multiple pages then you have
        to set the **pageSize**  property instead.

        **Access functions:**

        qreal **textWidth** () const
        void **setTextWidth** (qreal **width** )

        **See also** **size** (), **idealWidth** (), and **pageSize** ().
        """
        ...

    def toHtml(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#toHtml

        **QString QTextDocument::toHtml() const**

        Returns a string containing an HTML representation of the document.

        The content of the document specifies its encoding to be UTF-8. If you
        later on convert the returned html string into a byte array for
        transmission over a network or when saving to disk you should use
        **QString::toUtf8** () to convert the string to a **QByteArray** .

        **See also** **Supported HTML Subset** .
        """
        ...

    def toMarkdown(
        self, features: PySide6.QtGui.QTextDocument.MarkdownFeatures = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#toMarkdown

        **[since 5.14] QString
        QTextDocument::toMarkdown(QTextDocument::MarkdownFeatures features =
        MarkdownDialectGitHub) const**

        Returns a string containing a Markdown representation of the document
        with the given **features** , or an empty string if writing fails for
        any reason.

        This function was introduced in Qt 5.14.

        **See also** **setMarkdown** .
        """
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#toPlainText

        **QString QTextDocument::toPlainText() const**

        Returns the plain text contained in the document. If you want formatting
        information use a **QTextCursor**  instead.

        This function returns the same as **toRawText** (), but will replace
        some unicode characters with ASCII alternatives. In particular, no-break
        space (U+00A0) is replaced by a regular space (U+0020), and both
        paragraph (U+2029) and line (U+2028) separators are replaced by line
        feed (U+000A). If you need the precise contents of the document, use
        **toRawText** () instead.

        **Note:** Embedded objects, such as images, are represented by a Unicode
        value U+FFFC (OBJECT REPLACEMENT CHARACTER).

        **See also** **toHtml** ().
        """
        ...

    def toRawText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#toRawText

        **[since 5.9] QString QTextDocument::toRawText() const**

        Returns the raw text contained in the document without any formatting
        information. If you want formatting information use a **QTextCursor**
        instead.

        This function was introduced in Qt 5.9.

        **See also** **toPlainText** ().
        """
        ...

    @overload
    def undo(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#undo

        **void QTextDocument::undo(QTextCursor * cursor )**

        Undoes the last editing operation on the document if undo is available.
        The provided **cursor** is positioned at the end of the location where
        the edition operation was undone.

        See the **Qt Undo Framework**  documentation for details.

        **See also** **undoAvailable** () and **isUndoRedoEnabled** ().
        """
        ...

    @overload
    def undo(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#undo-1

        **[slot] void QTextDocument::undo()**

        This is an overloaded function.
        """
        ...

    def useDesignMetrics(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#useDesignMetrics-prop

        **useDesignMetrics : bool**

        This property holds whether the document uses design metrics of fonts to
        improve the accuracy of text layout

        If this property is set to true, the layout will use design metrics.
        Otherwise, the metrics of the paint device as set on
        **QAbstractTextDocumentLayout::setPaintDevice** () will be used.

        Using design metrics makes a layout have a width that is no longer
        dependent on hinting and pixel-rounding. This means that WYSIWYG text
        layout becomes possible because the width scales much more linearly
        based on paintdevice metrics than it would otherwise.

        By default, this property is `false`.

        **Access functions:**

        bool **useDesignMetrics** () const
        void **setUseDesignMetrics** (bool
        **b** )

        **Member Function Documentation**
        """
        ...

    @property
    def baseUrlChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def blockCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#blockCountChanged

        **[signal] void QTextDocument::blockCountChanged(int newBlockCount )**

        This signal is emitted when the total number of text blocks in the
        document changes. The value passed in **newBlockCount** is the new
        total.
        """
        ...

    @property
    def contentsChange(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#contentsChange

        **[signal] void QTextDocument::contentsChange(int position , int
        charsRemoved , int charsAdded )**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        Information is provided about the **position** of the character in the
        document where the change occurred, the number of characters removed (
        **charsRemoved** ), and the number of characters added ( **charsAdded**
        ).

        The signal is emitted before the document's layout manager is notified
        about the change. This hook allows you to implement syntax highlighting
        for the document.

        **See also** **QAbstractTextDocumentLayout::documentChanged** () and
        **contentsChanged** ().
        """
        ...

    @property
    def contentsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#contentsChanged

        **[signal] void QTextDocument::contentsChanged()**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        **See also** **contentsChange** ().
        """
        ...

    @property
    def cursorPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#cursorPositionChanged

        **[signal] void QTextDocument::cursorPositionChanged(const QTextCursor &
        cursor )**

        This signal is emitted whenever the position of a cursor changed due to
        an editing operation. The cursor that changed is passed in **cursor**.
        If the document is used with the **QTextEdit**  class and you need a
        signal when the cursor is moved with the arrow keys you can use the
        **cursorPositionChanged** () signal in **QTextEdit** .
        """
        ...

    @property
    def documentLayoutChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#documentLayoutChanged

        **[signal] void QTextDocument::documentLayoutChanged()**

        This signal is emitted when a new document layout is set.

        **See also** **setDocumentLayout** ().
        """
        ...

    @property
    def modificationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#modificationChanged

        **[signal] void QTextDocument::modificationChanged(bool changed )**

        This signal is emitted whenever the content of the document changes in a
        way that affects the modification state. If **changed** is true, the
        document has been modified; otherwise it is false.

        For example, calling **setModified** (false) on a document and then
        inserting text causes the signal to get emitted. If you undo that
        operation, causing the document to return to its original unmodified
        state, the signal will get emitted again.
        """
        ...

    @property
    def redoAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#redoAvailable

        **[signal] void QTextDocument::redoAvailable(bool available )**

        This signal is emitted whenever redo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...

    @property
    def undoAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#undoAvailable

        **[signal] void QTextDocument::undoAvailable(bool available )**

        This signal is emitted whenever undo operations become available (
        **available** is true) or unavailable ( **available** is false).

        See the **Qt Undo Framework**  documentation for details.

        **See also** **undo** () and **isUndoRedoEnabled** ().
        """
        ...

    @property
    def undoCommandAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextdocument.html#undoCommandAdded

        **[signal] void QTextDocument::undoCommandAdded()**

        This signal is emitted every time a new level of undo is added to the
        **QTextDocument** .
        """
        ...
