"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextBlockFormat(PySide6.QtGui.QTextFormat):
    """
    https://doc.qt.io/qt-6/qtextblockformat.html

    **Detailed Description**

    A document is composed of a list of blocks, represented by **QTextBlock**
    objects. Each block can contain an item of some kind, such as a paragraph of
    text, a table, a list, or an image. Every block has an associated
    QTextBlockFormat that specifies its characteristics.

    To cater for left-to-right and right-to-left languages you can set a block's
    direction with setDirection(). Paragraph alignment is set with
    **setAlignment** (). Margins are controlled by **setTopMargin** (),
    **setBottomMargin** (), **setLeftMargin** (), **setRightMargin** (). Overall
    indentation is set with **setIndent** (), the indentation of the first line
    with **setTextIndent** ().

    Line spacing is set with **setLineHeight** () and retrieved via
    **lineHeight** () and **lineHeightType** (). The types of line spacing
    available are in the **LineHeightTypes**  enum.

    Line breaking can be enabled and disabled with **setNonBreakableLines** ().

    The brush used to paint the paragraph's background is set with
    **setBackground** (), and other aspects of the text's appearance can be
    customized by using the **setProperty** () function with the `OutlinePen`,
    `ForegroundBrush`, and `BackgroundBrush` **QTextFormat::Property**  values.

    If a text block is part of a list, it can also have a list format that is
    accessible with the listFormat() function.

    **See also** **QTextBlock**  and **QTextCharFormat** .
    """

    SingleHeight: QTextBlockFormat.LineHeightTypes = ...
    ProportionalHeight: QTextBlockFormat.LineHeightTypes = ...
    FixedHeight: QTextBlockFormat.LineHeightTypes = ...
    MinimumHeight: QTextBlockFormat.LineHeightTypes = ...
    LineDistanceHeight: QTextBlockFormat.LineHeightTypes = ...

    class LineHeightTypes(Enum):
        SingleHeight: QTextBlockFormat.LineHeightTypes = ...
        ProportionalHeight: QTextBlockFormat.LineHeightTypes = ...
        FixedHeight: QTextBlockFormat.LineHeightTypes = ...
        MinimumHeight: QTextBlockFormat.LineHeightTypes = ...
        LineDistanceHeight: QTextBlockFormat.LineHeightTypes = ...

    class MarkerType(Enum):
        NoMarker: QTextBlockFormat.MarkerType = ...
        Unchecked: QTextBlockFormat.MarkerType = ...
        Checked: QTextBlockFormat.MarkerType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#QTextBlockFormat

        **QTextBlockFormat::QTextBlockFormat()**

        Constructs a new QTextBlockFormat.
        """
        ...

    @overload
    def __init__(self, QTextBlockFormat: PySide6.QtGui.QTextBlockFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#QTextBlockFormat

        **QTextBlockFormat::QTextBlockFormat()**

        Constructs a new QTextBlockFormat.
        """
        ...

    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#QTextBlockFormat

        **QTextBlockFormat::QTextBlockFormat()**

        Constructs a new QTextBlockFormat.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def alignment(self) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#alignment

        **Qt::Alignment QTextBlockFormat::alignment() const**

        Returns the paragraph's alignment.

        **See also** **setAlignment** ().
        """
        ...

    def bottomMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#bottomMargin

        **qreal QTextBlockFormat::bottomMargin() const**

        Returns the paragraph's bottom margin.

        **See also** **setBottomMargin** () and **topMargin** ().
        """
        ...

    def headingLevel(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#headingLevel

        **[since 5.12] int QTextBlockFormat::headingLevel() const**

        Returns the paragraph's heading level if it is a heading, or 0 if not.

        This function was introduced in Qt 5.12.

        **See also** **setHeadingLevel** ().
        """
        ...

    def indent(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#indent

        **int QTextBlockFormat::indent() const**

        Returns the paragraph's indent.

        **See also** **setIndent** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#isValid

        **bool QTextBlockFormat::isValid() const**

        Returns `true` if this block format is valid; otherwise returns false.
        """
        ...

    def leftMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#leftMargin

        **qreal QTextBlockFormat::leftMargin() const**

        Returns the paragraph's left margin.

        **See also** **setLeftMargin** (), **rightMargin** (), and **indent**
        ().
        """
        ...

    @overload
    def lineHeight(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#lineHeight

        **qreal QTextBlockFormat::lineHeight(qreal scriptLineHeight , qreal
        scaling = 1.0) const**

        Returns the height of the lines in the paragraph based on the height of
        the script line given by **scriptLineHeight** and the specified
        **scaling** factor.

        The value that is returned is also dependent on the given LineHeightType
        of the paragraph as well as the LineHeight setting that has been set for
        the paragraph.

        The scaling is needed for heights that include a fixed number of pixels,
        to scale them appropriately for printing.

        **See also** **LineHeightTypes** , **setLineHeight** (), and
        **lineHeightType** ().
        """
        ...

    @overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#lineHeight-1

        **qreal QTextBlockFormat::lineHeight() const**

        This returns the LineHeight property for the paragraph.

        **See also** **LineHeightTypes** , **setLineHeight** (), and
        **lineHeightType** ().
        """
        ...

    def lineHeightType(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#lineHeightType

        **int QTextBlockFormat::lineHeightType() const**

        This returns the LineHeightType property of the paragraph.

        **See also** **LineHeightTypes** , **setLineHeight** (), and
        **lineHeight** ().
        """
        ...

    def marker(self) -> PySide6.QtGui.QTextBlockFormat.MarkerType:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#marker

        **[since 5.14] QTextBlockFormat::MarkerType QTextBlockFormat::marker()
        const**

        Returns the paragraph's marker if one has been set, or `NoMarker` if
        not.

        This function was introduced in Qt 5.14.

        **See also** **setMarker** ().
        """
        ...

    def nonBreakableLines(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#nonBreakableLines

        **bool QTextBlockFormat::nonBreakableLines() const**

        Returns `true` if the lines in the paragraph are non-breakable;
        otherwise returns `false`.

        **See also** **setNonBreakableLines** ().
        """
        ...

    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlags:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#pageBreakPolicy

        **QTextFormat::PageBreakFlags QTextBlockFormat::pageBreakPolicy()
        const**

        Returns the currently set page break policy for the paragraph. The
        default is **QTextFormat::PageBreak_Auto** .

        **See also** **setPageBreakPolicy** ().
        """
        ...

    def rightMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#rightMargin

        **qreal QTextBlockFormat::rightMargin() const**

        Returns the paragraph's right margin.

        **See also** **setRightMargin** () and **leftMargin** ().
        """
        ...

    def setAlignment(self, alignment: PySide6.QtCore.Qt.Alignment) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setAlignment

        **void QTextBlockFormat::setAlignment(Qt::Alignment alignment )**

        Sets the paragraph's **alignment**.

        **See also** **alignment** ().
        """
        ...

    def setBottomMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setBottomMargin

        **void QTextBlockFormat::setBottomMargin(qreal margin )**

        Sets the paragraph's bottom **margin**.

        **See also** **bottomMargin** (), **setTopMargin** (), **setLeftMargin**
        (), and **setRightMargin** ().
        """
        ...

    def setHeadingLevel(self, alevel: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setHeadingLevel

        **[since 5.12] void QTextBlockFormat::setHeadingLevel(int level )**

        Sets the paragraph's heading **level** , where 1 is the highest-level
        heading type (usually with the largest possible heading font size), and
        increasing values are progressively deeper into the document (and
        usually with smaller font sizes). For example when reading an HTML H1
        tag, the heading level is set to 1. Setting the heading level does not
        automatically change the font size; however
        **QTextDocumentFragment::fromHtml** () sets both the heading level and
        the font size simultaneously.

        If the paragraph is not a heading, the level should be set to 0 (the
        default).

        This function was introduced in Qt 5.12.

        **See also** **headingLevel** ().
        """
        ...

    def setIndent(self, indent: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setIndent

        **void QTextBlockFormat::setIndent(int indentation )**

        Sets the paragraph's **indentation**. Margins are set independently of
        indentation with **setLeftMargin** () and **setTextIndent** (). The
        **indentation** is an integer that is multiplied with the document-wide
        standard indent, resulting in the actual indent of the paragraph.

        **See also** **indent** () and **QTextDocument::indentWidth** ().
        """
        ...

    def setLeftMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setLeftMargin

        **void QTextBlockFormat::setLeftMargin(qreal margin )**

        Sets the paragraph's left **margin**. Indentation can be applied
        separately with **setIndent** ().

        **See also** **leftMargin** (), **setRightMargin** (), **setTopMargin**
        (), and **setBottomMargin** ().
        """
        ...

    def setLineHeight(self, height: float, heightType: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setLineHeight

        **void QTextBlockFormat::setLineHeight(qreal height , int heightType )**

        Sets the line height for the paragraph to the value given by **height**
        which is dependent on **heightType** in the way described by the
        **LineHeightTypes**  enum.

        **See also** **LineHeightTypes** , **lineHeight** (), and
        **lineHeightType** ().
        """
        ...

    def setMarker(self, marker: PySide6.QtGui.QTextBlockFormat.MarkerType) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setMarker

        **[since 5.14] void
        QTextBlockFormat::setMarker(QTextBlockFormat::MarkerType marker )**

        Sets the type of adornment that should be rendered alongside the
        paragraph to **marker**. For example, a list item can be adorned with a
        checkbox, either checked or unchecked, as a replacement for its bullet.
        The default is `NoMarker`.

        This function was introduced in Qt 5.14.

        **See also** **marker** ().
        """
        ...

    def setNonBreakableLines(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setNonBreakableLines

        **void QTextBlockFormat::setNonBreakableLines(bool b )**

        If **b** is true, the lines in the paragraph are treated as non-
        breakable; otherwise they are breakable.

        **See also** **nonBreakableLines** ().
        """
        ...

    def setPageBreakPolicy(
        self, flags: PySide6.QtGui.QTextFormat.PageBreakFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setPageBreakPolicy

        **void QTextBlockFormat::setPageBreakPolicy(QTextFormat::PageBreakFlags
        policy )**

        Sets the page break policy for the paragraph to **policy**.

        **See also** **pageBreakPolicy** ().
        """
        ...

    def setRightMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setRightMargin

        **void QTextBlockFormat::setRightMargin(qreal margin )**

        Sets the paragraph's right **margin**.

        **See also** **rightMargin** (), **setLeftMargin** (), **setTopMargin**
        (), and **setBottomMargin** ().
        """
        ...

    def setTabPositions(self, tabs: Sequence[PySide6.QtGui.QTextOption.Tab]) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setTabPositions

        **void QTextBlockFormat::setTabPositions(const QList<QTextOption::Tab> &
        tabs )**

        Sets the tab positions for the text block to those specified by
        **tabs**.

        **See also** **tabPositions** ().
        """
        ...

    def setTextIndent(self, aindent: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setTextIndent

        **void QTextBlockFormat::setTextIndent(qreal indent )**

        Sets the **indent** for the first line in the block. This allows the
        first line of a paragraph to be indented differently to the other lines,
        enhancing the readability of the text.

        **See also** **textIndent** (), **setLeftMargin** (), **setRightMargin**
        (), **setTopMargin** (), and **setBottomMargin** ().
        """
        ...

    def setTopMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#setTopMargin

        **void QTextBlockFormat::setTopMargin(qreal margin )**

        Sets the paragraph's top **margin**.

        **See also** **topMargin** (), **setBottomMargin** (), **setLeftMargin**
        (), and **setRightMargin** ().
        """
        ...

    def tabPositions(self) -> List[PySide6.QtGui.QTextOption.Tab]:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#tabPositions

        **QList<QTextOption::Tab> QTextBlockFormat::tabPositions() const**

        Returns a list of tab positions defined for the text block.

        **See also** **setTabPositions** ().
        """
        ...

    def textIndent(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#textIndent

        **qreal QTextBlockFormat::textIndent() const**

        Returns the paragraph's text indent.

        **See also** **setTextIndent** ().
        """
        ...

    def topMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextblockformat.html#topMargin

        **qreal QTextBlockFormat::topMargin() const**

        Returns the paragraph's top margin.

        **See also** **setTopMargin** () and **bottomMargin** ().
        """
        ...
