"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTabletEvent(PySide6.QtGui.QSinglePointEvent):
    """
    https://doc.qt.io/qt-6/qtabletevent.html

    **Detailed Description**

    **Tablet events** are generated from tablet peripherals such as Wacom
    tablets and various other brands, and electromagnetic stylus devices
    included with some types of tablet computers. (It is not the same as
    **QTouchEvent**  which a touchscreen generates, even when a passive stylus
    is used on a touchscreen.)

    Tablet events are similar to mouse events; for example, the **x** (), **y**
    (), **pos** (), **globalX** (), **globalY** (), and **globalPos** ()
    accessors provide the cursor position, and you can see which **buttons** ()
    are pressed (pressing the stylus tip against the tablet surface is
    equivalent to a left mouse button). But tablet events also pass through some
    extra information that the tablet device driver provides; for example, you
    might want to do subpixel rendering with higher resolution coordinates
    (**globalPosF** ()), adjust color brightness based on the **pressure** () of
    the tool against the tablet surface, use different brushes depending on the
    type of tool in use (**deviceType** ()), modulate the brush shape in some
    way according to the X-axis and Y-axis tilt of the tool with respect to the
    tablet surface (**xTilt** () and **yTilt** ()), and use a virtual eraser
    instead of a brush if the user switches to the other end of a double-ended
    stylus (**pointerType** ()).

    Every event contains an accept flag that indicates whether the receiver
    wants the event. You should call **QTabletEvent::accept** () if you handle
    the tablet event; otherwise it will be sent to the parent widget. The
    exception are TabletEnterProximity and TabletLeaveProximity events: these
    are only sent to **QApplication**  and do not check whether or not they are
    accepted.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse, tablet and keyboard events for a widget.

    The event handler **QWidget::tabletEvent** () receives TabletPress,
    TabletRelease and TabletMove events. Qt will first send a tablet event, then
    if it is not accepted by any widget, it will send a mouse event. This allows
    users of applications that are not designed for tablets to use a tablet like
    a mouse. However high-resolution drawing applications should handle the
    tablet events, because they can occur at a higher frequency, which is a
    benefit for smooth and accurate drawing. If the tablet events are rejected,
    the synthetic mouse events may be compressed for efficiency.

    Note that pressing the stylus button while the stylus hovers over the tablet
    will generate a button press on some types of tablets, while on other types
    it will be necessary to press the stylus against the tablet surface in order
    to register the simultaneous stylus button press.

    **Notes for X11 Users**

    If the tablet is configured in xorg.conf to use the Wacom driver, there will
    be separate XInput "devices" for the stylus, eraser, and (optionally) cursor
    and touchpad. Qt recognizes these by their names. Otherwise, if the tablet
    is configured to use the evdev driver, there will be only one device and
    applications may not be able to distinguish the stylus from the eraser.

    **Notes for Windows Users**

    Tablet support currently requires the WACOM windows driver providing the DLL
    `wintab32.dll` to be installed. It is contained in older packages, for
    example `pentablet_5.3.5-3.exe`.
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QTabletEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#QTabletEvent-2

        **QTabletEvent::QTabletEvent(QEvent::Type type , const QPointingDevice *
        dev , const QPointF & pos , const QPointF & globalPos , qreal pressure ,
        float xTilt , float yTilt , float tangentialPressure , qreal rotation ,
        float z , Qt::KeyboardModifiers keyState , Qt::MouseButton button ,
        Qt::MouseButtons buttons )**

        Construct a tablet event of the given **type**.

        The **pos** parameter indicates where the event occurred in the widget;
        **globalPos** is the corresponding position in absolute coordinates.

        **pressure** gives the pressure exerted on the device **dev**.

        **xTilt** and **yTilt** give the device's degree of tilt from the x and
        y axes respectively.

        **keyState** specifies which keyboard modifiers are pressed (e.g.,
        **Ctrl** ).

        The **z** parameter gives the Z coordinate of the device on the tablet;
        this is usually given by a wheel on a 4D mouse. If the device does not
        support a Z-axis (i.e. **QPointingDevice::capabilities** () does not
        include `ZPosition`), pass `0` here.

        The **tangentialPressure** parameter gives the tangential pressure
        thumbwheel value from an airbrush. If the device does not support
        tangential pressure (i.e. **QPointingDevice::capabilities** () does not
        include `TangentialPressure`), pass `0` here.

        **rotation** gives the device's rotation in degrees. 4D mice, the Wacom
        Art Pen, and the Apple Pencil support rotation. If the device does not
        support rotation (i.e. **QPointingDevice::capabilities** () does not
        include `Rotation`), pass `0` here.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is not **TabletPress**
        or **TabletRelease** , the appropriate button for this event is
        **Qt::NoButton** .

        **buttons** is the state of all buttons at the time of the event.

        **See also** **pos** (), **globalPos** (), **device** (), **pressure**
        (), **xTilt** (), **yTilt** (), **uniqueId** (), **rotation** (),
        **tangentialPressure** (), and **z** ().
        """
        ...

    @overload
    def __init__(
        self,
        t: PySide6.QtCore.QEvent.Type,
        device: PySide6.QtGui.QPointingDevice,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        pressure: float,
        xTilt: float,
        yTilt: float,
        tangentialPressure: float,
        rotation: float,
        z: float,
        keyState: PySide6.QtCore.Qt.KeyboardModifiers,
        button: PySide6.QtCore.Qt.MouseButton,
        buttons: PySide6.QtCore.Qt.MouseButtons,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#QTabletEvent-2

        **QTabletEvent::QTabletEvent(QEvent::Type type , const QPointingDevice *
        dev , const QPointF & pos , const QPointF & globalPos , qreal pressure ,
        float xTilt , float yTilt , float tangentialPressure , qreal rotation ,
        float z , Qt::KeyboardModifiers keyState , Qt::MouseButton button ,
        Qt::MouseButtons buttons )**

        Construct a tablet event of the given **type**.

        The **pos** parameter indicates where the event occurred in the widget;
        **globalPos** is the corresponding position in absolute coordinates.

        **pressure** gives the pressure exerted on the device **dev**.

        **xTilt** and **yTilt** give the device's degree of tilt from the x and
        y axes respectively.

        **keyState** specifies which keyboard modifiers are pressed (e.g.,
        **Ctrl** ).

        The **z** parameter gives the Z coordinate of the device on the tablet;
        this is usually given by a wheel on a 4D mouse. If the device does not
        support a Z-axis (i.e. **QPointingDevice::capabilities** () does not
        include `ZPosition`), pass `0` here.

        The **tangentialPressure** parameter gives the tangential pressure
        thumbwheel value from an airbrush. If the device does not support
        tangential pressure (i.e. **QPointingDevice::capabilities** () does not
        include `TangentialPressure`), pass `0` here.

        **rotation** gives the device's rotation in degrees. 4D mice, the Wacom
        Art Pen, and the Apple Pencil support rotation. If the device does not
        support rotation (i.e. **QPointingDevice::capabilities** () does not
        include `Rotation`), pass `0` here.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is not **TabletPress**
        or **TabletRelease** , the appropriate button for this event is
        **Qt::NoButton** .

        **buttons** is the state of all buttons at the time of the event.

        **See also** **pos** (), **globalPos** (), **device** (), **pressure**
        (), **xTilt** (), **yTilt** (), **uniqueId** (), **rotation** (),
        **tangentialPressure** (), and **z** ().
        """
        ...

    def clone(self) -> PySide6.QtGui.QTabletEvent:
        ...

    def globalPos(self) -> PySide6.QtCore.QPoint:
        ...

    def globalPosF(self) -> PySide6.QtCore.QPointF:
        ...

    def globalX(self) -> int:
        ...

    def globalY(self) -> int:
        ...

    def hiResGlobalX(self) -> float:
        ...

    def hiResGlobalY(self) -> float:
        ...

    def pos(self) -> PySide6.QtCore.QPoint:
        ...

    def posF(self) -> PySide6.QtCore.QPointF:
        ...

    def pressure(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#pressure

        **qreal QTabletEvent::pressure() const**

        Returns the pressure for the device. 0.0 indicates that the stylus is
        not on the tablet, 1.0 indicates the maximum amount of pressure for the
        stylus.

        **See also** **tangentialPressure** ().
        """
        ...

    def rotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#rotation

        **qreal QTabletEvent::rotation() const**

        Returns the rotation of the current tool in degrees, where zero means
        the tip of the stylus is pointing towards the top of the tablet, a
        positive value means it's turned to the right, and a negative value
        means it's turned to the left. This can be given by a 4D Mouse or a
        rotation-capable stylus (such as the Wacom Art Pen or the Apple Pencil).
        If the device does not support rotation, this value is always 0.0.
        """
        ...

    def tangentialPressure(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#tangentialPressure

        **qreal QTabletEvent::tangentialPressure() const**

        Returns the tangential pressure for the device. This is typically given
        by a finger wheel on an airbrush tool. The range is from -1.0 to 1.0.
        0.0 indicates a neutral position. Current airbrushes can only move in
        the positive direction from the neutrual position. If the device does
        not support tangential pressure, this value is always 0.0.

        **Note:** The value is stored as a single-precision float.

        **See also** **pressure** ().
        """
        ...

    def uniqueId(self) -> int:
        ...

    def x(self) -> int:
        ...

    def xTilt(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#xTilt

        **qreal QTabletEvent::xTilt() const**

        Returns the angle between the device (a pen, for example) and the
        perpendicular in the direction of the x axis. Positive values are
        towards the tablet's physical right. The angle is in the range -60 to
        +60 degrees.

        ![](images/qtabletevent-tilt.png)

        **Note:** The value is stored as a single-precision float.

        **See also** **yTilt** ().
        """
        ...

    def y(self) -> int:
        ...

    def yTilt(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#yTilt

        **qreal QTabletEvent::yTilt() const**

        Returns the angle between the device (a pen, for example) and the
        perpendicular in the direction of the y axis. Positive values are
        towards the bottom of the tablet. The angle is within the range -60 to
        +60 degrees.

        **Note:** The value is stored as a single-precision float.

        **See also** **xTilt** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qtabletevent.html#z

        **qreal QTabletEvent::z() const**

        Returns the z position of the device. Typically this is represented by a
        wheel on a 4D Mouse. If the device does not support a Z-axis, this value
        is always zero. This is **not** the same as pressure.

        **Note:** The value is stored as a single-precision float.

        **See also** **pressure** ().
        """
        ...
