"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QStandardItemModel(PySide6.QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-6/qstandarditemmodel.html

    **Detailed Description**

    QStandardItemModel can be used as a repository for standard Qt data types.
    It is one of the **Model/View Classes**  and is part of Qt's **model/view**
    framework.

    QStandardItemModel provides a classic item-based approach to working with
    the model. The items in a QStandardItemModel are provided by
    **QStandardItem** .

    QStandardItemModel implements the **QAbstractItemModel**  interface, which
    means that the model can be used to provide data in any view that supports
    that interface (such as **QListView** , **QTableView**  and **QTreeView** ,
    and your own custom views). For performance and flexibility, you may want to
    subclass **QAbstractItemModel**  to provide support for different kinds of
    data repositories. For example, the **QFileSystemModel**  provides a model
    interface to the underlying file system.

    When you want a list or tree, you typically create an empty
    QStandardItemModel and use **appendRow** () to add items to the model, and
    **item** () to access an item. If your model represents a table, you
    typically pass the dimensions of the table to the QStandardItemModel
    constructor and use **setItem** () to position items into the table. You can
    also use **setRowCount** () and **setColumnCount** () to alter the
    dimensions of the model. To insert items, use **insertRow** () or
    **insertColumn** (), and to remove items, use **removeRow** () or
    **removeColumn** ().

    You can set the header labels of your model with
    **setHorizontalHeaderLabels** () and **setVerticalHeaderLabels** ().

    You can search for items in the model with **findItems** (), and sort the
    model by calling **sort** ().

    Call **clear** () to remove all items from the model.

    An example usage of QStandardItemModel to create a table:

    **QStandardItemModel**  model(4, 4);
        for (int row = 0; row <
    model.rowCount(); ++row) {
            for (int column = 0; column <
    model.columnCount(); ++column) {
                **QStandardItem**  *item = new
    **QStandardItem** (**QString** ("row %0, column %1").arg(row).arg(column));
    model.setItem(row, column, item);
            }
        }

    An example usage of QStandardItemModel to create a tree:

    **QStandardItemModel**  model;
        **QStandardItem**  *parentItem =
    model.invisibleRootItem();
        for (int i = 0; i < 4; ++i) {
    **QStandardItem**  *item = new **QStandardItem** (**QString** ("item
    %0").arg(i));
            parentItem->appendRow(item);
            parentItem =
    item;
        }

    After setting the model on a view, you typically want to react to user
    actions, such as an item being clicked. Since a **QAbstractItemView**
    provides **QModelIndex** -based signals and functions, you need a way to
    obtain the **QStandardItem**  that corresponds to a given **QModelIndex** ,
    and vice versa. **itemFromIndex** () and **indexFromItem** () provide this
    mapping. Typical usage of **itemFromIndex** () includes obtaining the item
    at the current index in a view, and obtaining the item that corresponds to
    an index carried by a **QAbstractItemView**  signal, such as
    **QAbstractItemView::clicked** (). First you connect the view's signal to a
    slot in your class:

    **QTreeView**  *treeView = new **QTreeView** (this);
    treeView->setModel(myStandardItemModel);
        connect(treeView,
    &**QTreeView** ::clicked,
                this, &MyWidget::clicked);

    When you receive the signal, you call **itemFromIndex** () on the given
    model index to get a pointer to the item:

    void MyWidget::clicked(const **QModelIndex**  &index)
        {
    **QStandardItem**  *item = myStandardItemModel->itemFromIndex(index);
    // Do stuff with the item ...
        }

    Conversely, you must obtain the **QModelIndex**  of an item when you want to
    invoke a model/view function that takes an index as argument. You can obtain
    the index either by using the model's **indexFromItem** () function, or,
    equivalently, by calling **QStandardItem::index** ():

    treeView->scrollTo(item->index());

    You are, of course, not required to use the item-based approach; you could
    instead rely entirely on the **QAbstractItemModel**  interface when working
    with the model, or use a combination of the two as appropriate.

    **See also** **QStandardItem** , **Model/View Programming** ,
    **QAbstractItemModel** , **Simple Tree Model example** , and **Item View
    Convenience Classes** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#QStandardItemModel

        **QStandardItemModel::QStandardItemModel(QObject * parent = nullptr)**

        Constructs a new item model with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self, rows: int, columns: int, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#QStandardItemModel-1

        **QStandardItemModel::QStandardItemModel(int rows , int columns ,
        QObject * parent = nullptr)**

        Constructs a new item model that initially has **rows** rows and
        **columns** columns, and that has the given **parent**.
        """
        ...

    def appendColumn(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#appendColumn

        **void QStandardItemModel::appendColumn(const QList<QStandardItem *> &
        items )**

        Appends a column containing **items**. If necessary, the row count is
        increased to the size of **items**.

        **See also** **insertColumn** () and **appendRow** ().
        """
        ...

    @overload
    def appendRow(self, item: PySide6.QtGui.QStandardItem) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#appendRow

        **void QStandardItemModel::appendRow(const QList<QStandardItem *> &
        items )**

        Appends a row containing **items**. If necessary, the column count is
        increased to the size of **items**.

        **See also** **insertRow** () and **appendColumn** ().
        """
        ...

    @overload
    def appendRow(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#appendRow-1

        **void QStandardItemModel::appendRow(QStandardItem * item )**

        This is an overloaded function.

        When building a list or a tree that has only one column, this function
        provides a convenient way to append a single new **item**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#clear

        **void QStandardItemModel::clear()**

        Removes all items (including header items) from the model and sets the
        number of rows and columns to zero.

        **See also** **removeColumns** () and **removeRows** ().
        """
        ...

    def clearItemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#clearItemData

        **[override virtual] bool QStandardItemModel::clearItemData(const
        QModelIndex & index )**

        Reimplements: **QAbstractItemModel::clearItemData** (const QModelIndex
        &index).
        """
        ...

    def columnCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#columnCount

        **[override virtual] int QStandardItemModel::columnCount(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount(const QModelIndex
        &parent) const** .

        **See also** **setColumnCount** ().
        """
        ...

    def data(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#data

        **[override virtual] QVariant QStandardItemModel::data(const QModelIndex
        & index , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data(const QModelIndex &index, int
        role) const** .

        **See also** **setData** ().
        """
        ...

    def dropMimeData(
        self,
        data: PySide6.QtCore.QMimeData,
        action: PySide6.QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#dropMimeData

        **[override virtual] bool QStandardItemModel::dropMimeData(const
        QMimeData * data , Qt::DropAction action , int row , int column , const
        QModelIndex & parent )**

        Reimplements: **QAbstractItemModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).
        """
        ...

    def findItems(
        self, text: str, flags: PySide6.QtCore.Qt.MatchFlags = ..., column: int = ...
    ) -> List[PySide6.QtGui.QStandardItem]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#findItems

        **QList<QStandardItem *> QStandardItemModel::findItems(const QString &
        text , Qt::MatchFlags flags = Qt::MatchExactly, int column = 0) const**

        Returns a list of items that match the given **text** , using the given
        **flags** , in the given **column**.
        """
        ...

    def flags(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#flags

        **[override virtual] Qt::ItemFlags QStandardItemModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::flags(const QModelIndex &index)
        const** .
        """
        ...

    def hasChildren(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#hasChildren

        **[override virtual] bool QStandardItemModel::hasChildren(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::hasChildren(const QModelIndex
        &parent) const** .
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#headerData

        **[override virtual] QVariant QStandardItemModel::headerData(int section
        , Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::headerData(int section,
        Qt::Orientation orientation, int role) const** .

        **See also** **setHeaderData** ().
        """
        ...

    def horizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#horizontalHeaderItem

        **QStandardItem *QStandardItemModel::horizontalHeaderItem(int column )
        const**

        Returns the horizontal header item for **column** if one has been set;
        otherwise returns `nullptr`.

        **See also** **setHorizontalHeaderItem** () and **verticalHeaderItem**
        ().
        """
        ...

    def index(
        self,
        row: int,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#index

        **[override virtual] QModelIndex QStandardItemModel::index(int row , int
        column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index(int row, int column, const
        QModelIndex &parent) const** .
        """
        ...

    def indexFromItem(
        self, item: PySide6.QtGui.QStandardItem
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#indexFromItem

        **QModelIndex QStandardItemModel::indexFromItem(const QStandardItem *
        item ) const**

        Returns the **QModelIndex**  associated with the given **item**.

        Use this function when you want to perform an operation that requires
        the **QModelIndex**  of the item, such as
        **QAbstractItemView::scrollTo** (). **QStandardItem::index** () is
        provided as convenience; it is equivalent to calling this function.

        **See also** **itemFromIndex** () and **QStandardItem::index** ().
        """
        ...

    @overload
    def insertColumn(
        self, column: int, items: Sequence[PySide6.QtGui.QStandardItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertColumn

        **void QStandardItemModel::insertColumn(int column , const
        QList<QStandardItem *> & items )**

        Inserts a column at **column** containing **items**. If necessary, the
        row count is increased to the size of **items**.

        **See also** **takeColumn** (), **appendColumn** (), and **insertRow**
        ().
        """
        ...

    @overload
    def insertColumn(
        self,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertColumn-1

        **bool QStandardItemModel::insertColumn(int column , const QModelIndex &
        parent = QModelIndex())**

        Inserts a single column before the given **column** in the child items
        of the **parent** specified. Returns `true` if the column is inserted;
        otherwise returns `false`.

        **See also** **insertColumns** (), **insertRow** (), and
        **removeColumn** ().
        """
        ...

    def insertColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertColumns

        **[override virtual] bool QStandardItemModel::insertColumns(int column ,
        int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    @overload
    def insertRow(self, row: int, item: PySide6.QtGui.QStandardItem) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertRow

        **void QStandardItemModel::insertRow(int row , const QList<QStandardItem
        *> & items )**

        Inserts a row at **row** containing **items**. If necessary, the column
        count is increased to the size of **items**.

        **See also** **takeRow** (), **appendRow** (), and **insertColumn** ().
        """
        ...

    @overload
    def insertRow(self, row: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertRow-1

        **void QStandardItemModel::insertRow(int row , QStandardItem * item )**

        This is an overloaded function.

        Inserts a row at **row** containing **item**.

        When building a list or a tree that has only one column, this function
        provides a convenient way to append a single new item.
        """
        ...

    @overload
    def insertRow(
        self,
        row: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertRow-2

        **bool QStandardItemModel::insertRow(int row , const QModelIndex &
        parent = QModelIndex())**

        Inserts a single row before the given **row** in the child items of the
        **parent** specified. Returns `true` if the row is inserted; otherwise
        returns `false`.

        **See also** **insertRows** (), **insertColumn** (), and **removeRow**
        ().
        """
        ...

    def insertRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#insertRows

        **[override virtual] bool QStandardItemModel::insertRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def invisibleRootItem(self) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#invisibleRootItem

        **QStandardItem *QStandardItemModel::invisibleRootItem() const**

        Returns the model's invisible root item.

        The invisible root item provides access to the model's top-level items
        through the **QStandardItem**  API, making it possible to write
        functions that can treat top-level items and their children in a uniform
        way; for example, recursive functions involving a tree model.

        **Note:** Calling **index** () on the **QStandardItem**  object
        retrieved from this function is not valid.
        """
        ...

    def item(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#item

        **QStandardItem *QStandardItemModel::item(int row , int column = 0)
        const**

        Returns the item for the given **row** and **column** if one has been
        set; otherwise returns `nullptr`.

        **See also** **setItem** (), **takeItem** (), and **itemFromIndex** ().
        """
        ...

    def itemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> Dict[int, Any]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#itemData

        **[override virtual] QMap<int, QVariant>
        QStandardItemModel::itemData(const QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::itemData(const QModelIndex &index)
        const** .

        **See also** **setItemData** ().
        """
        ...

    def itemFromIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#itemFromIndex

        **QStandardItem *QStandardItemModel::itemFromIndex(const QModelIndex &
        index ) const**

        Returns a pointer to the **QStandardItem**  associated with the given
        **index**.

        Calling this function is typically the initial step when processing
        **QModelIndex** -based signals from a view, such as
        **QAbstractItemView::activated** (). In your slot, you call
        itemFromIndex(), with the **QModelIndex**  carried by the signal as
        argument, to obtain a pointer to the corresponding **QStandardItem** .

        Note that this function will lazily create an item for the index (using
        **itemPrototype** ()), and set it in the parent item's child table, if
        no item already exists at that index.

        If **index** is an invalid index, this function returns `nullptr`.

        **See also** **indexFromItem** ().
        """
        ...

    def itemPrototype(self) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#itemPrototype

        **const QStandardItem *QStandardItemModel::itemPrototype() const**

        Returns the item prototype used by the model. The model uses the item
        prototype as an item factory when it needs to construct new items on
        demand (for instance, when a view or item delegate calls **setData**
        ()).

        **See also** **setItemPrototype** ().
        """
        ...

    def mimeData(self, indexes: List[int]) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#mimeData

        **[override virtual] QMimeData *QStandardItemModel::mimeData(const
        QModelIndexList & indexes ) const**

        Reimplements: **QAbstractItemModel::mimeData(const QModelIndexList
        &indexes) const** .
        """
        ...

    def mimeTypes(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#mimeTypes

        **[override virtual] QStringList QStandardItemModel::mimeTypes() const**

        Reimplements: **QAbstractItemModel::mimeTypes() const** .
        """
        ...

    @overload
    def parent(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#parent

        **[override virtual] QModelIndex QStandardItemModel::parent(const
        QModelIndex & child ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    @overload
    def parent(
        self,
        child: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#parent

        **[override virtual] QModelIndex QStandardItemModel::parent(const
        QModelIndex & child ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    def removeColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#removeColumns

        **[override virtual] bool QStandardItemModel::removeColumns(int column ,
        int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    def removeRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#removeRows

        **[override virtual] bool QStandardItemModel::removeRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#roleNames

        **[override virtual] QHash<int, QByteArray>
        QStandardItemModel::roleNames() const**

        Reimplements: **QAbstractItemModel::roleNames() const** .

        reimp
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#rowCount

        **[override virtual] int QStandardItemModel::rowCount(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount(const QModelIndex &parent)
        const** .

        **See also** **setRowCount** ().
        """
        ...

    def setColumnCount(self, columns: int) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setColumnCount

        **void QStandardItemModel::setColumnCount(int columns )**

        Sets the number of columns in this model to **columns**. If this is less
        than **columnCount** (), the data in the unwanted columns is discarded.

        **See also** **columnCount** () and **setRowCount** ().
        """
        ...

    def setData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setData

        **[override virtual] bool QStandardItemModel::setData(const QModelIndex
        & index , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        **See also** **data** ().
        """
        ...

    def setHeaderData(
        self,
        section: int,
        orientation: PySide6.QtCore.Qt.Orientation,
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setHeaderData

        **[override virtual] bool QStandardItemModel::setHeaderData(int section
        , Qt::Orientation orientation , const QVariant & value , int role =
        Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setHeaderData** (int section,
        Qt::Orientation orientation, const QVariant &value, int role).

        **See also** **headerData** ().
        """
        ...

    def setHorizontalHeaderItem(
        self, column: int, item: PySide6.QtGui.QStandardItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setHorizontalHeaderItem

        **void QStandardItemModel::setHorizontalHeaderItem(int column ,
        QStandardItem * item )**

        Sets the horizontal header item for **column** to **item**. The model
        takes ownership of the item. If necessary, the column count is increased
        to fit the item. The previous header item (if there was one) is deleted.

        **See also** **horizontalHeaderItem** (), **setHorizontalHeaderLabels**
        (), and **setVerticalHeaderItem** ().
        """
        ...

    def setHorizontalHeaderLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setHorizontalHeaderLabels

        **void QStandardItemModel::setHorizontalHeaderLabels(const QStringList &
        labels )**

        Sets the horizontal header labels using **labels**. If necessary, the
        column count is increased to the size of **labels**.

        **See also** **setHorizontalHeaderItem** ().
        """
        ...

    @overload
    def setItem(self, row: int, column: int, item: PySide6.QtGui.QStandardItem) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setItem

        **void QStandardItemModel::setItem(int row , int column , QStandardItem
        * item )**

        Sets the item for the given **row** and **column** to **item**. The
        model takes ownership of the item. If necessary, the row count and
        column count are increased to fit the item. The previous item at the
        given location (if there was one) is deleted.

        **See also** **item** ().
        """
        ...

    @overload
    def setItem(self, row: int, item: PySide6.QtGui.QStandardItem) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setItem-1

        **void QStandardItemModel::setItem(int row , QStandardItem * item )**

        This is an overloaded function.
        """
        ...

    def setItemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        roles: Dict[int, Any],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setItemData

        **[override virtual] bool QStandardItemModel::setItemData(const
        QModelIndex & index , const QMap<int, QVariant> & roles )**

        Reimplements: **QAbstractItemModel::setItemData** (const QModelIndex
        &index, const QMap<int, QVariant> &roles).

        **See also** **itemData** ().
        """
        ...

    def setItemPrototype(self, item: PySide6.QtGui.QStandardItem) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setItemPrototype

        **void QStandardItemModel::setItemPrototype(const QStandardItem * item
        )**

        Sets the item prototype for the model to the specified **item**. The
        model takes ownership of the prototype.

        The item prototype acts as a **QStandardItem**  factory, by relying on
        the **QStandardItem::clone** () function. To provide your own prototype,
        subclass **QStandardItem** , reimplement **QStandardItem::clone** () and
        set the prototype to be an instance of your custom class. Whenever
        **QStandardItemModel**  needs to create an item on demand (for instance,
        when a view or item delegate calls **setData** ())), the new items will
        be instances of your custom class.

        **See also** **itemPrototype** () and **QStandardItem::clone** ().
        """
        ...

    def setItemRoleNames(self, roleNames: Dict[int, PySide6.QtCore.QByteArray]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setItemRoleNames

        **void QStandardItemModel::setItemRoleNames(const QHash<int, QByteArray>
        & roleNames )**

        Sets the item role names to **roleNames**.
        """
        ...

    def setRowCount(self, rows: int) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setRowCount

        **void QStandardItemModel::setRowCount(int rows )**

        Sets the number of rows in this model to **rows**. If this is less than
        **rowCount** (), the data in the unwanted rows is discarded.

        **See also** **rowCount** () and **setColumnCount** ().
        """
        ...

    def setSortRole(self, role: int) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#sortRole-prop

        **[bindable] sortRole : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the item role that is used to query the model's data
        when sorting items

        The default value is **Qt::DisplayRole** .

        **See also** **sort** () and **QStandardItem::sortChildren** ().

        **Member Function Documentation**
        """
        ...

    def setVerticalHeaderItem(
        self, row: int, item: PySide6.QtGui.QStandardItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setVerticalHeaderItem

        **void QStandardItemModel::setVerticalHeaderItem(int row , QStandardItem
        * item )**

        Sets the vertical header item for **row** to **item**. The model takes
        ownership of the item. If necessary, the row count is increased to fit
        the item. The previous header item (if there was one) is deleted.

        **See also** **verticalHeaderItem** (), **setVerticalHeaderLabels** (),
        and **setHorizontalHeaderItem** ().
        """
        ...

    def setVerticalHeaderLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#setVerticalHeaderLabels

        **void QStandardItemModel::setVerticalHeaderLabels(const QStringList &
        labels )**

        Sets the vertical header labels using **labels**. If necessary, the row
        count is increased to the size of **labels**.

        **See also** **setVerticalHeaderItem** ().
        """
        ...

    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#sort

        **[override virtual] void QStandardItemModel::sort(int column ,
        Qt::SortOrder order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).
        """
        ...

    def sortRole(self) -> int:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#sortRole-prop

        **[bindable] sortRole : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the item role that is used to query the model's data
        when sorting items

        The default value is **Qt::DisplayRole** .

        **See also** **sort** () and **QStandardItem::sortChildren** ().

        **Member Function Documentation**
        """
        ...

    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#supportedDropActions

        **[override virtual] Qt::DropActions
        QStandardItemModel::supportedDropActions() const**

        Reimplements: **QAbstractItemModel::supportedDropActions() const** .

        **QStandardItemModel**  supports both copy and move.
        """
        ...

    def takeColumn(self, column: int) -> List[PySide6.QtGui.QStandardItem]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#takeColumn

        **QList<QStandardItem *> QStandardItemModel::takeColumn(int column )**

        Removes the given **column** without deleting the column items, and
        returns a list of pointers to the removed items. The model releases
        ownership of the items. For items in the column that have not been set,
        the corresponding pointers in the list will be `nullptr`.

        **See also** **takeRow** ().
        """
        ...

    def takeHorizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#takeHorizontalHeaderItem

        **QStandardItem *QStandardItemModel::takeHorizontalHeaderItem(int column
        )**

        Removes the horizontal header item at **column** from the header without
        deleting it, and returns a pointer to the item. The model releases
        ownership of the item.

        **See also** **horizontalHeaderItem** () and **takeVerticalHeaderItem**
        ().
        """
        ...

    def takeItem(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#takeItem

        **QStandardItem *QStandardItemModel::takeItem(int row , int column =
        0)**

        Removes the item at ( **row** , **column** ) without deleting it. The
        model releases ownership of the item.

        **See also** **item** (), **takeRow** (), and **takeColumn** ().
        """
        ...

    def takeRow(self, row: int) -> List[PySide6.QtGui.QStandardItem]:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#takeRow

        **QList<QStandardItem *> QStandardItemModel::takeRow(int row )**

        Removes the given **row** without deleting the row items, and returns a
        list of pointers to the removed items. The model releases ownership of
        the items. For items in the row that have not been set, the
        corresponding pointers in the list will be `nullptr`.

        **See also** **takeColumn** ().
        """
        ...

    def takeVerticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#takeVerticalHeaderItem

        **QStandardItem *QStandardItemModel::takeVerticalHeaderItem(int row )**

        Removes the vertical header item at **row** from the header without
        deleting it, and returns a pointer to the item. The model releases
        ownership of the item.

        **See also** **verticalHeaderItem** () and **takeHorizontalHeaderItem**
        ().
        """
        ...

    def verticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#verticalHeaderItem

        **QStandardItem *QStandardItemModel::verticalHeaderItem(int row )
        const**

        Returns the vertical header item for row **row** if one has been set;
        otherwise returns `nullptr`.

        **See also** **setVerticalHeaderItem** () and **horizontalHeaderItem**
        ().
        """
        ...

    @property
    def itemChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qstandarditemmodel.html#itemChanged

        **[signal] void QStandardItemModel::itemChanged(QStandardItem * item )**

        This signal is emitted whenever the data of **item** has changed.
        """
        ...
