"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QShortcutEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qshortcutevent.html

    **Detailed Description**

    Normally you do not need to use this class directly; **QShortcut**  provides
    a higher-level interface to handle shortcut keys.

    **See also** **QShortcut** .
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QShortcutEvent) -> None:
        """
        https://doc.qt.io/qt-6/qshortcutevent.html#QShortcutEvent-2

        **QShortcutEvent::QShortcutEvent(const QKeySequence & key , int id ,
        bool ambiguous = false)**

        Constructs a shortcut event for the given **key** press, associated with
        the **QShortcut**  ID **id**.

        **ambiguous** specifies whether there is more than one **QShortcut**
        for the same key sequence.
        """
        ...

    @overload
    def __init__(
        self,
        key: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
        id: int,
        ambiguous: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qshortcutevent.html#QShortcutEvent-2

        **QShortcutEvent::QShortcutEvent(const QKeySequence & key , int id ,
        bool ambiguous = false)**

        Constructs a shortcut event for the given **key** press, associated with
        the **QShortcut**  ID **id**.

        **ambiguous** specifies whether there is more than one **QShortcut**
        for the same key sequence.
        """
        ...

    def clone(self) -> PySide6.QtGui.QShortcutEvent:
        ...

    def isAmbiguous(self) -> bool:
        """
        https://doc.qt.io/qt-6/qshortcutevent.html#isAmbiguous

        **bool QShortcutEvent::isAmbiguous() const**

        Returns `true` if the key sequence that triggered the event is
        ambiguous.

        **See also** **QShortcut::activatedAmbiguously** ().
        """
        ...

    def key(self) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qshortcutevent.html#key

        **const QKeySequence &QShortcutEvent::key() const**

        Returns the key sequence that triggered the event.
        """
        ...

    def shortcutId(self) -> int:
        """
        https://doc.qt.io/qt-6/qshortcutevent.html#shortcutId

        **int QShortcutEvent::shortcutId() const**

        Returns the ID of the **QShortcut**  object for which this event was
        generated.

        **See also** **QShortcut::id** ().
        """
        ...
