"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QSessionManager(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsessionmanager.html

    **Detailed Description**

    A session manager in a desktop environment (in which Qt GUI applications
    live) keeps track of a session, which is a group of running applications,
    each of which has a particular state. The state of an application contains
    (most notably) the documents the application has open and the position and
    size of its windows.

    The session manager is used to save the session, e.g., when the machine is
    shut down, and to restore a session, e.g., when the machine is started up.
    We recommend that you use **QSettings**  to save an application's settings,
    for example, window positions, recently used files, etc. When the
    application is restarted by the session manager, you can restore the
    settings.

    QSessionManager provides an interface between the application and the
    platform's session manager. In Qt, session management requests for action
    are handled by the two signals **QGuiApplication::commitDataRequest** () and
    **QGuiApplication::saveStateRequest** (). Both provide a reference to a
    QSessionManager object as argument. The session manager can only be accessed
    in slots invoked by these signals.

    No user interaction is possible **unless** the application gets explicit
    permission from the session manager. You ask for permission by calling
    **allowsInteraction** () or, if it is really urgent,
    **allowsErrorInteraction** (). Qt does not enforce this, but the session
    manager may.

    You can try to abort the shutdown process by calling **cancel** ().

    For sophisticated session managers provided on Unix/X11, QSessionManager
    offers further possibilities to fine-tune an application's session
    management behavior: **setRestartCommand** (), **setDiscardCommand** (),
    **setRestartHint** (), **setProperty** (), **requestPhase2** (). See the
    respective function descriptions for further details.

    **See also** **QGuiApplication**  and **Session Management** .
    """

    RestartIfRunning: QSessionManager.RestartHint = ...
    RestartAnyway: QSessionManager.RestartHint = ...
    RestartImmediately: QSessionManager.RestartHint = ...
    RestartNever: QSessionManager.RestartHint = ...

    class RestartHint(Enum):
        RestartIfRunning: QSessionManager.RestartHint = ...
        RestartAnyway: QSessionManager.RestartHint = ...
        RestartImmediately: QSessionManager.RestartHint = ...
        RestartNever: QSessionManager.RestartHint = ...

    def allowsErrorInteraction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#allowsErrorInteraction

        **bool QSessionManager::allowsErrorInteraction()**

        Returns `true` if error interaction is permitted; otherwise returns
        `false`.

        This is similar to **allowsInteraction** (), but also enables the
        application to tell the user about any errors that occur. Session
        managers may give error interaction requests higher priority, which
        means that it is more likely that an error interaction is permitted.
        However, you are still not guaranteed that the session manager will
        allow interaction.

        **See also** **allowsInteraction** (), **release** (), and **cancel**
        ().
        """
        ...

    def allowsInteraction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#allowsInteraction

        **bool QSessionManager::allowsInteraction()**

        Asks the session manager for permission to interact with the user.
        Returns true if interaction is permitted; otherwise returns `false`.

        The rationale behind this mechanism is to make it possible to
        synchronize user interaction during a shutdown. Advanced session
        managers may ask all applications simultaneously to commit their data,
        resulting in a much faster shutdown.

        When the interaction is completed we strongly recommend releasing the
        user interaction semaphore with a call to **release** (). This way,
        other applications may get the chance to interact with the user while
        your application is still busy saving data. (The semaphore is implicitly
        released when the application exits.)

        If the user decides to cancel the shutdown process during the
        interaction phase, you must tell the session manager that this has
        happened by calling **cancel** ().

        Here's an example of how an application's
        **QGuiApplication::commitDataRequest** () might be implemented:

        MyMainWidget::MyMainWidget(**QWidget**  *parent)
                : **QWidget**
        (parent)
            {
                connect(**qApp** , &**QGuiApplication**
        ::commitDataRequest,
                        this, &MyMainWidget::commitData);
        }

            void MyMainWidget::commitData(QSessionManager& manager)
            {
        if (manager.allowsInteraction()) {
                    int ret = **QMessageBox**
        ::warning(
                                mainWindow,
        tr("My Application"),
                                tr("Save changes to
        document?"),
                                **QMessageBox** ::Save |
        **QMessageBox** ::Discard | **QMessageBox** ::Cancel);
        switch (ret) {
                    case **QMessageBox** ::Save:
        manager.release();
                        if (!saveDocument())
        manager.cancel();
                        break;
                    case
        **QMessageBox** ::Discard:
                        break;
                    case
        **QMessageBox** ::Cancel:
                    default:
        manager.cancel();
                    }
                } else {
                    // we did
        not get permission to interact, then
                    // do something
        reasonable instead
                }
            }

        If an error occurred within the application while saving its data, you
        may want to try **allowsErrorInteraction** () instead.

        **See also** **QGuiApplication::commitDataRequest** (), **release** (),
        and **cancel** ().
        """
        ...

    def cancel(self) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#cancel

        **void QSessionManager::cancel()**

        Tells the session manager to cancel the shutdown process. Applications
        should not call this function without asking the user first.

        **See also** **allowsInteraction** () and **allowsErrorInteraction** ().
        """
        ...

    def discardCommand(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#discardCommand

        **QStringList QSessionManager::discardCommand() const**

        Returns the currently set discard command.

        To iterate over the list, you can use the **foreach**  pseudo-keyword:

        const **QStringList**  commands = mySession.discardCommand();
            for
        (const **QString**  &command : mySession.discardCommand())
        do_something(command);

        **See also** **setDiscardCommand** (), **restartCommand** (), and
        **setRestartCommand** ().
        """
        ...

    def isPhase2(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#isPhase2

        **bool QSessionManager::isPhase2() const**

        Returns `true` if the session manager is currently performing a second
        session management phase; otherwise returns `false`.

        **See also** **requestPhase2** ().
        """
        ...

    def release(self) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#release

        **void QSessionManager::release()**

        Releases the session manager's interaction semaphore after an
        interaction phase.

        **See also** **allowsInteraction** () and **allowsErrorInteraction** ().
        """
        ...

    def requestPhase2(self) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#requestPhase2

        **void QSessionManager::requestPhase2()**

        Requests a second session management phase for the application. The
        application may then return immediately from the
        **QGuiApplication::commitDataRequest** () or
        **QApplication::saveStateRequest** () function, and they will be called
        again once most or all other applications have finished their session
        management.

        The two phases are useful for applications such as the X11 window
        manager that need to store information about another application's
        windows and therefore have to wait until these applications have
        completed their respective session management tasks.

        **Note:** If another application has requested a second phase it may get
        called before, simultaneously with, or after your application's second
        phase.

        **See also** **isPhase2** ().
        """
        ...

    def restartCommand(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#restartCommand

        **QStringList QSessionManager::restartCommand() const**

        Returns the currently set restart command.

        To iterate over the list, you can use the **foreach**  pseudo-keyword:

        const **QStringList**  commands = mySession.restartCommand();
            for
        (const **QString**  &command : commands)
                do_something(command);

        **See also** **setRestartCommand** () and **restartHint** ().
        """
        ...

    def restartHint(self) -> PySide6.QtGui.QSessionManager.RestartHint:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#restartHint

        **QSessionManager::RestartHint QSessionManager::restartHint() const**

        Returns the application's current restart hint. The default is
        `RestartIfRunning`.

        **See also** **setRestartHint** ().
        """
        ...

    def sessionId(self) -> str:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#sessionId

        **QString QSessionManager::sessionId() const**

        Returns the identifier of the current session.

        If the application has been restored from an earlier session, this
        identifier is the same as it was in the earlier session.

        **See also** **sessionKey** () and **QGuiApplication::sessionId** ().
        """
        ...

    def sessionKey(self) -> str:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#sessionKey

        **QString QSessionManager::sessionKey() const**

        Returns the session key in the current session.

        If the application has been restored from an earlier session, this key
        is the same as it was when the previous session ended.

        The session key changes with every call of commitData() or saveState().

        **See also** **sessionId** () and **QGuiApplication::sessionKey** ().
        """
        ...

    def setDiscardCommand(self, arg__1: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#setDiscardCommand

        **void QSessionManager::setDiscardCommand(const QStringList & command
        )**

        Sets the discard command to the given **command**.

        **See also** **discardCommand** () and **setRestartCommand** ().
        """
        ...

    @overload
    def setManagerProperty(self, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#setManagerProperty

        **void QSessionManager::setManagerProperty(const QString & name , const
        QStringList & value )**

        Low-level write access to the application's identification and state
        record are kept in the session manager.

        The property called **name** has its value set to the string list
        **value**.
        """
        ...

    @overload
    def setManagerProperty(self, name: str, value: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#setManagerProperty-1

        **void QSessionManager::setManagerProperty(const QString & name , const
        QString & value )**

        This is an overloaded function.

        Low-level write access to the application's identification and state
        records are kept in the session manager.

        The property called **name** has its value set to the string **value**.
        """
        ...

    def setRestartCommand(self, arg__1: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#setRestartCommand

        **void QSessionManager::setRestartCommand(const QStringList & command
        )**

        If the session manager is capable of restoring sessions it will execute
        **command** in order to restore the application. The command defaults to

        appname -session id

        The `-session` option is mandatory; otherwise **QGuiApplication**
        cannot tell whether it has been restored or what the current session
        identifier is. See **QGuiApplication::isSessionRestored** () and
        **QGuiApplication::sessionId** () for details.

        If your application is very simple, it may be possible to store the
        entire application state in additional command line options. This is
        usually a very bad idea because command lines are often limited to a few
        hundred bytes. Instead, use **QSettings** , temporary files, or a
        database for this purpose. By marking the data with the unique
        **sessionId** (), you will be able to restore the application in a
        future session.

        **See also** **restartCommand** (), **setDiscardCommand** (), and
        **setRestartHint** ().
        """
        ...

    def setRestartHint(self, arg__1: PySide6.QtGui.QSessionManager.RestartHint) -> None:
        """
        https://doc.qt.io/qt-6/qsessionmanager.html#setRestartHint

        **void QSessionManager::setRestartHint(QSessionManager::RestartHint hint
        )**

        Sets the application's restart hint to **hint**. On application startup,
        the hint is set to `RestartIfRunning`.

        **Note:** These flags are only hints, a session manager may or may not
        respect them.

        We recommend setting the restart hint in
        **QGuiApplication::saveStateRequest** () because most session managers
        perform a checkpoint shortly after an application's startup.

        **See also** **restartHint** ().
        """
        ...
