"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QScrollEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qscrollevent.html

    **Detailed Description**

    The scroll event is sent to indicate that the receiver should be scrolled.
    Usually the receiver should be something visual like **QWidget**  or
    **QGraphicsObject** .

    Some care should be taken that no conflicting QScrollEvents are sent from
    two sources. Using **QScroller::scrollTo**  is save however.

    **See also** **QScrollPrepareEvent**  and **QScroller** .
    """

    ScrollStarted: QScrollEvent.ScrollState = ...
    ScrollUpdated: QScrollEvent.ScrollState = ...
    ScrollFinished: QScrollEvent.ScrollState = ...

    class ScrollState(Enum):
        ScrollStarted: QScrollEvent.ScrollState = ...
        ScrollUpdated: QScrollEvent.ScrollState = ...
        ScrollFinished: QScrollEvent.ScrollState = ...

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QScrollEvent) -> None:
        """
        https://doc.qt.io/qt-6/qscrollevent.html#QScrollEvent-2

        **QScrollEvent::QScrollEvent(const QPointF & contentPos , const QPointF
        & overshootDistance , QScrollEvent::ScrollState scrollState )**

        Creates a new QScrollEvent **contentPos** is the new content position,
        **overshootDistance** is the new overshoot distance while
        **scrollState** indicates if this scroll event is the first one, the
        last one or some event in between.
        """
        ...

    @overload
    def __init__(
        self,
        contentPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        overshoot: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        scrollState: PySide6.QtGui.QScrollEvent.ScrollState,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscrollevent.html#QScrollEvent-2

        **QScrollEvent::QScrollEvent(const QPointF & contentPos , const QPointF
        & overshootDistance , QScrollEvent::ScrollState scrollState )**

        Creates a new QScrollEvent **contentPos** is the new content position,
        **overshootDistance** is the new overshoot distance while
        **scrollState** indicates if this scroll event is the first one, the
        last one or some event in between.
        """
        ...

    def clone(self) -> PySide6.QtGui.QScrollEvent:
        ...

    def contentPos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qscrollevent.html#contentPos

        **QPointF QScrollEvent::contentPos() const**

        Returns the new scroll position.
        """
        ...

    def overshootDistance(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qscrollevent.html#overshootDistance

        **QPointF QScrollEvent::overshootDistance() const**

        Returns the new overshoot distance. See **QScroller**  for an
        explanation of the term overshoot.

        **See also** **QScroller** .
        """
        ...

    def scrollState(self) -> PySide6.QtGui.QScrollEvent.ScrollState:
        """
        https://doc.qt.io/qt-6/qscrollevent.html#scrollState

        **QScrollEvent::ScrollState QScrollEvent::scrollState() const**

        Returns the current scroll state as a combination of ScrollStateFlag
        values. **ScrollStarted**  (or **ScrollFinished** ) will be set, if this
        scroll event is the first (or last) event in a scrolling activity.
        Please note that both values can be set at the same time, if the
        activity consists of a single **QScrollEvent** . All other scroll events
        in between will have their state set to **ScrollUpdated** .

        A widget could for example revert selections when scrolling is started
        and stopped.
        """
        ...
