"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QRasterWindow(PySide6.QtGui.QPaintDeviceWindow):
    """
    https://doc.qt.io/qt-6/qrasterwindow.html

    **Detailed Description**

    QRasterWindow is a **QWindow**  with a raster-based, non-OpenGL surface. On
    top of the functionality offered by **QWindow** , QRasterWindow adds a
    virtual **paintEvent** () function and the possibility to open a
    **QPainter**  on itself. The underlying paint engine will be the raster one,
    meaning that all drawing will happen on the CPU. For performing accelerated,
    OpenGL-based drawing, use **QOpenGLWindow**  instead.

    Internally the class is thin wrapper for **QWindow**  and **QBackingStore**
    and is very similar to the **Raster Window Example**  that uses these
    classes directly.

    **See also** **QPaintDeviceWindow::paintEvent** () and
    **QPaintDeviceWindow::update** ().
    """

    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qrasterwindow.html#QRasterWindow

        **QRasterWindow::QRasterWindow(QWindow * parent = nullptr)**

        Constructs a new QRasterWindow with **parent**.
        """
        ...

    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def redirected(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice:
        ...
