"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPointerEvent(PySide6.QtGui.QInputEvent):
    """
    https://doc.qt.io/qt-6/qpointerevent.html

    **Detailed Description**
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QPointerEvent) -> None:
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.QEvent.Type,
        dev: PySide6.QtGui.QPointingDevice,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        points: Sequence[PySide6.QtGui.QEventPoint] = ...,
    ) -> None:
        ...

    def addPassiveGrabber(
        self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#addPassiveGrabber

        **bool QPointerEvent::addPassiveGrabber(const QEventPoint & point ,
        QObject * grabber )**

        Informs the delivery logic that the given **grabber** is to receive all
        future update events and the release event containing the given
        **point** , regardless where else those events may be delivered.

        It's mainly for use in Qt Quick at this time.

        Returns `false` if **grabber** was already added, `true` otherwise.
        """
        ...

    def allPointsAccepted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#allPointsAccepted

        **bool QPointerEvent::allPointsAccepted() const**

        Returns `true` if isPointAccepted() is `true` for every point in
        **points** (); otherwise `false`.
        """
        ...

    def allPointsGrabbed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#allPointsGrabbed

        **bool QPointerEvent::allPointsGrabbed() const**

        Returns `true` if every point in **points** () has an
        **exclusiveGrabber** ().
        """
        ...

    def clearPassiveGrabbers(self, point: PySide6.QtGui.QEventPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#clearPassiveGrabbers

        **void QPointerEvent::clearPassiveGrabbers(const QEventPoint & point )**

        Removes all passive grabbers from the given **point**.

        It's mainly for use in Qt Quick at this time.

        **See also** **QPointerEvent::addPassiveGrabber** ().
        """
        ...

    def clone(self) -> PySide6.QtGui.QPointerEvent:
        ...

    def exclusiveGrabber(
        self, point: PySide6.QtGui.QEventPoint
    ) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#exclusiveGrabber

        **QObject *QPointerEvent::exclusiveGrabber(const QEventPoint & point )
        const**

        Returns the object which has been set to receive all future update
        events and the release event containing the given **point**.

        It's mainly for use in Qt Quick at this time.

        **See also** **setExclusiveGrabber** ().
        """
        ...

    def isBeginEvent(self) -> bool:
        ...

    def isEndEvent(self) -> bool:
        ...

    def isUpdateEvent(self) -> bool:
        ...

    def point(self, i: int) -> PySide6.QtGui.QEventPoint:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#point

        **QEventPoint &QPointerEvent::point(qsizetype i )**

        Returns a **QEventPoint**  reference for the point at index **i**.
        """
        ...

    def pointById(self, id: int) -> PySide6.QtGui.QEventPoint:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#pointById

        **QEventPoint *QPointerEvent::pointById(int id )**

        Returns the point whose **id**  matches the given **id** , or `nullptr`
        if no such point is found.
        """
        ...

    def pointCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#pointCount

        **qsizetype QPointerEvent::pointCount() const**

        Returns the number of points in this pointer event.
        """
        ...

    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#pointerType

        **QPointingDevice::PointerType QPointerEvent::pointerType() const**

        Returns the type of point that generated the event.
        """
        ...

    def pointingDevice(self) -> PySide6.QtGui.QPointingDevice:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#pointingDevice

        **const QPointingDevice *QPointerEvent::pointingDevice() const**

        Returns the source device from which this event originates.

        This is the same as **QInputEvent::device** () but typecast for
        convenience.
        """
        ...

    def points(self) -> List[PySide6.QtGui.QEventPoint]:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#points

        **const QList<QEventPoint> &QPointerEvent::points() const**

        Returns a list of points in this pointer event.
        """
        ...

    def removePassiveGrabber(
        self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#removePassiveGrabber

        **bool QPointerEvent::removePassiveGrabber(const QEventPoint & point ,
        QObject * grabber )**

        Removes the passive **grabber** from the given **point** if it was
        previously added. Returns `true` if it had been a passive grabber
        before, `false` if not.

        It's mainly for use in Qt Quick at this time.

        **See also** **QPointerEvent::addPassiveGrabber** ().
        """
        ...

    def setAccepted(self, accepted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#setAccepted

        **[override virtual] void QPointerEvent::setAccepted(bool accepted )**
        """
        ...

    def setExclusiveGrabber(
        self, point: PySide6.QtGui.QEventPoint, exclusiveGrabber: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpointerevent.html#setExclusiveGrabber

        **void QPointerEvent::setExclusiveGrabber(const QEventPoint & point ,
        QObject * exclusiveGrabber )**

        Informs the delivery logic that the given **exclusiveGrabber** is to
        receive all future update events and the release event containing the
        given **point** , and that delivery to other items can be skipped.

        It's mainly for use in Qt Quick at this time.

        **See also** **exclusiveGrabber** ().
        """
        ...

    def setTimestamp(self, timestamp: int) -> None:
        ...
