"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPlatformSurfaceEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qplatformsurfaceevent.html

    **Detailed Description**

    Platform window events are synchronously sent to windows and offscreen
    surfaces when their underlying native surfaces are created or are about to
    be destroyed.

    Applications can respond to these events to know when the underlying
    platform surface exists.
    """

    SurfaceCreated: QPlatformSurfaceEvent.SurfaceEventType = ...
    SurfaceAboutToBeDestroyed: QPlatformSurfaceEvent.SurfaceEventType = ...

    class SurfaceEventType(Enum):
        SurfaceCreated: QPlatformSurfaceEvent.SurfaceEventType = ...
        SurfaceAboutToBeDestroyed: QPlatformSurfaceEvent.SurfaceEventType = ...

    def __init__(self, arg__1: PySide6.QtGui.QPlatformSurfaceEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplatformsurfaceevent.html#QPlatformSurfaceEvent-
        2

        **QPlatformSurfaceEvent::QPlatformSurfaceEvent(QPlatformSurfaceEvent::Su
        rfaceEventType surfaceEventType )**

        Constructs a platform surface event for the given **surfaceEventType**.
        """
        ...

    def clone(self) -> PySide6.QtGui.QPlatformSurfaceEvent:
        ...

    def surfaceEventType(self) -> PySide6.QtGui.QPlatformSurfaceEvent.SurfaceEventType:
        """
        https://doc.qt.io/qt-6/qplatformsurfaceevent.html#surfaceEventType

        **QPlatformSurfaceEvent::SurfaceEventType
        QPlatformSurfaceEvent::surfaceEventType() const**

        Returns the specific type of platform surface event.
        """
        ...
