"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPixelFormat(object):
    """
    https://doc.qt.io/qt-6/qpixelformat.html

    **Detailed Description**

    In Qt there is a often a need to represent the layout of the pixels in a
    graphics buffer. Internally QPixelFormat stores everything in a 64 bit
    datastructure. This gives performance but also some limitations.

    QPixelFormat can describe 5 color channels and 1 alpha channel, each can use
    6 bits to describe the size of the color channel.

    The position of the alpha channel is described with a separate enum. This is
    to make it possible to describe **QImage**  formats like ARGB32, and also
    describe typical OpenGL formats like RBGA8888.

    How pixels are suppose to be read is determined by the
    **TypeInterpretation**  enum. It describes if color values are suppose to be
    read byte per byte, or if a pixel is suppose to be read as a complete int
    and then masked.

    There is no support for describing YUV's macro pixels. Instead a list of YUV
    formats has been made. When a QPixelFormat is describing a YUV format, the
    **bitsPerPixel**  value has been deduced by the YUV Layout enum. Also, the
    color channels should all be set to zero except the fifth color channel that
    should store the **bitsPerPixel**  value.

    **See also** **TypeInterpretation** .
    """

    AtBeginning: QPixelFormat.AlphaPosition = ...
    AtEnd: QPixelFormat.AlphaPosition = ...
    NotPremultiplied: QPixelFormat.AlphaPremultiplied = ...
    Premultiplied: QPixelFormat.AlphaPremultiplied = ...
    UsesAlpha: QPixelFormat.AlphaUsage = ...
    IgnoresAlpha: QPixelFormat.AlphaUsage = ...
    LittleEndian: QPixelFormat.ByteOrder = ...
    BigEndian: QPixelFormat.ByteOrder = ...
    CurrentSystemEndian: QPixelFormat.ByteOrder = ...
    RGB: QPixelFormat.ColorModel = ...
    BGR: QPixelFormat.ColorModel = ...
    Indexed: QPixelFormat.ColorModel = ...
    Grayscale: QPixelFormat.ColorModel = ...
    CMYK: QPixelFormat.ColorModel = ...
    HSL: QPixelFormat.ColorModel = ...
    HSV: QPixelFormat.ColorModel = ...
    YUV: QPixelFormat.ColorModel = ...
    Alpha: QPixelFormat.ColorModel = ...
    UnsignedInteger: QPixelFormat.TypeInterpretation = ...
    UnsignedShort: QPixelFormat.TypeInterpretation = ...
    UnsignedByte: QPixelFormat.TypeInterpretation = ...
    FloatingPoint: QPixelFormat.TypeInterpretation = ...
    YUV444: QPixelFormat.YUVLayout = ...
    YUV422: QPixelFormat.YUVLayout = ...
    YUV411: QPixelFormat.YUVLayout = ...
    YUV420P: QPixelFormat.YUVLayout = ...
    YUV420SP: QPixelFormat.YUVLayout = ...
    YV12: QPixelFormat.YUVLayout = ...
    UYVY: QPixelFormat.YUVLayout = ...
    YUYV: QPixelFormat.YUVLayout = ...
    NV12: QPixelFormat.YUVLayout = ...
    NV21: QPixelFormat.YUVLayout = ...
    IMC1: QPixelFormat.YUVLayout = ...
    IMC2: QPixelFormat.YUVLayout = ...
    IMC3: QPixelFormat.YUVLayout = ...
    IMC4: QPixelFormat.YUVLayout = ...
    Y8: QPixelFormat.YUVLayout = ...
    Y16: QPixelFormat.YUVLayout = ...

    class AlphaPosition(Enum):
        AtBeginning: QPixelFormat.AlphaPosition = ...
        AtEnd: QPixelFormat.AlphaPosition = ...

    class AlphaPremultiplied(Enum):
        NotPremultiplied: QPixelFormat.AlphaPremultiplied = ...
        Premultiplied: QPixelFormat.AlphaPremultiplied = ...

    class AlphaUsage(Enum):
        UsesAlpha: QPixelFormat.AlphaUsage = ...
        IgnoresAlpha: QPixelFormat.AlphaUsage = ...

    class ByteOrder(Enum):
        LittleEndian: QPixelFormat.ByteOrder = ...
        BigEndian: QPixelFormat.ByteOrder = ...
        CurrentSystemEndian: QPixelFormat.ByteOrder = ...

    class ColorModel(Enum):
        RGB: QPixelFormat.ColorModel = ...
        BGR: QPixelFormat.ColorModel = ...
        Indexed: QPixelFormat.ColorModel = ...
        Grayscale: QPixelFormat.ColorModel = ...
        CMYK: QPixelFormat.ColorModel = ...
        HSL: QPixelFormat.ColorModel = ...
        HSV: QPixelFormat.ColorModel = ...
        YUV: QPixelFormat.ColorModel = ...
        Alpha: QPixelFormat.ColorModel = ...

    class TypeInterpretation(Enum):
        UnsignedInteger: QPixelFormat.TypeInterpretation = ...
        UnsignedShort: QPixelFormat.TypeInterpretation = ...
        UnsignedByte: QPixelFormat.TypeInterpretation = ...
        FloatingPoint: QPixelFormat.TypeInterpretation = ...

    class YUVLayout(Enum):
        YUV444: QPixelFormat.YUVLayout = ...
        YUV422: QPixelFormat.YUVLayout = ...
        YUV411: QPixelFormat.YUVLayout = ...
        YUV420P: QPixelFormat.YUVLayout = ...
        YUV420SP: QPixelFormat.YUVLayout = ...
        YV12: QPixelFormat.YUVLayout = ...
        UYVY: QPixelFormat.YUVLayout = ...
        YUYV: QPixelFormat.YUVLayout = ...
        NV12: QPixelFormat.YUVLayout = ...
        NV21: QPixelFormat.YUVLayout = ...
        IMC1: QPixelFormat.YUVLayout = ...
        IMC2: QPixelFormat.YUVLayout = ...
        IMC3: QPixelFormat.YUVLayout = ...
        IMC4: QPixelFormat.YUVLayout = ...
        Y8: QPixelFormat.YUVLayout = ...
        Y16: QPixelFormat.YUVLayout = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#QPixelFormat

        **QPixelFormat::QPixelFormat()**

        Creates a null pixelformat. This format maps to
        **QImage::Format_Invalid** .
        """
        ...

    @overload
    def __init__(self, QPixelFormat: PySide6.QtGui.QPixelFormat) -> None:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#QPixelFormat-1

        **QPixelFormat::QPixelFormat(QPixelFormat::ColorModel colorModel , uchar
        firstSize , uchar secondSize , uchar thirdSize , uchar fourthSize ,
        uchar fifthSize , uchar alphaSize , QPixelFormat::AlphaUsage alphaUsage
        , QPixelFormat::AlphaPosition alphaPosition ,
        QPixelFormat::AlphaPremultiplied premultiplied ,
        QPixelFormat::TypeInterpretation typeInterpretation ,
        QPixelFormat::ByteOrder byteOrder = CurrentSystemEndian, uchar subEnum =
        0)**

        Creates a QPixelFormat which assigns its data to the attributes.
        **colorModel** will be put into a buffer which is 4 bits long.

        **firstSize** **secondSize** **thirdSize** **fourthSize** **fifthSize**
        **alphaSize** are all meant to represent the size of a channel. The
        channels will be used for different uses dependent on the
        **colorModel**. For RGB the firstSize will represent the Red channel. On
        CMYK it will represent the value of the Cyan channel.

        **alphaUsage** represents if the alpha channel is used or not.

        **alphaPosition** is the position of the alpha channel.

        **premultiplied** represents if the alpha channel is already multiplied
        with the color channels.

        **typeInterpretation** is how the pixel is interpreted.

        **byteOrder** represents the endianness of the pixelformat. This
        defaults to **CurrentSystemEndian** .

        **subEnum** is used for colorModels that have to store some extra
        information with supplying an extra enum. This is used by YUV to store
        the YUV type The default value is 0.
        """
        ...

    @overload
    def __init__(
        self,
        colorModel: PySide6.QtGui.QPixelFormat.ColorModel,
        firstSize: int,
        secondSize: int,
        thirdSize: int,
        fourthSize: int,
        fifthSize: int,
        alphaSize: int,
        alphaUsage: PySide6.QtGui.QPixelFormat.AlphaUsage,
        alphaPosition: PySide6.QtGui.QPixelFormat.AlphaPosition,
        premultiplied: PySide6.QtGui.QPixelFormat.AlphaPremultiplied,
        typeInterpretation: PySide6.QtGui.QPixelFormat.TypeInterpretation,
        byteOrder: PySide6.QtGui.QPixelFormat.ByteOrder = ...,
        subEnum: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#QPixelFormat

        **QPixelFormat::QPixelFormat()**

        Creates a null pixelformat. This format maps to
        **QImage::Format_Invalid** .
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def alphaPosition(self) -> PySide6.QtGui.QPixelFormat.AlphaPosition:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#alphaPosition

        **QPixelFormat::AlphaPosition QPixelFormat::alphaPosition() const**

        Accessor function for alphaPosition.
        """
        ...

    def alphaSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#alphaSize

        **uchar QPixelFormat::alphaSize() const**

        Accessor function for the alpha channel size.
        """
        ...

    def alphaUsage(self) -> PySide6.QtGui.QPixelFormat.AlphaUsage:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#alphaUsage

        **QPixelFormat::AlphaUsage QPixelFormat::alphaUsage() const**

        Accessor function for alphaUsage.
        """
        ...

    def bitsPerPixel(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#bitsPerPixel

        **uchar QPixelFormat::bitsPerPixel() const**

        Accessor function for the bits used per pixel. This function returns the
        sum of the color channels + the size of the alpha channel.
        """
        ...

    def blackSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#blackSize

        **uchar QPixelFormat::blackSize() const**

        Accessor function for the black/key color channel.
        """
        ...

    def blueSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#blueSize

        **uchar QPixelFormat::blueSize() const**

        Accessor function for the size of the blue color channel.
        """
        ...

    def brightnessSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#brightnessSize

        **uchar QPixelFormat::brightnessSize() const**

        Accessor function for the brightness channel size.
        """
        ...

    def byteOrder(self) -> PySide6.QtGui.QPixelFormat.ByteOrder:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#byteOrder

        **QPixelFormat::ByteOrder QPixelFormat::byteOrder() const**

        The byte order is almost always set the byte order of the current
        system. However, it can be useful to describe some YUV formats. This
        function should never return **QPixelFormat::CurrentSystemEndian**  as
        this value is translated to a endian value in the constructor.
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#channelCount

        **uchar QPixelFormat::channelCount() const**

        Accessor function for getting the channelCount. Channel Count is deduced
        by color channels with a size > 0 and if the size of the alpha channel
        is > 0.
        """
        ...

    def colorModel(self) -> PySide6.QtGui.QPixelFormat.ColorModel:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#colorModel

        **QPixelFormat::ColorModel QPixelFormat::colorModel() const**

        Accessor function for getting the colorModel.
        """
        ...

    def cyanSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#cyanSize

        **uchar QPixelFormat::cyanSize() const**

        Accessor function for the cyan color channel.
        """
        ...

    def greenSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#greenSize

        **uchar QPixelFormat::greenSize() const**

        Accessor function for the size of the green color channel.
        """
        ...

    def hueSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#hueSize

        **uchar QPixelFormat::hueSize() const**

        Accessor function for the hue channel size.
        """
        ...

    def lightnessSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#lightnessSize

        **uchar QPixelFormat::lightnessSize() const**

        Accessor function for the lightness channel size.
        """
        ...

    def magentaSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#magentaSize

        **uchar QPixelFormat::magentaSize() const**

        Accessor function for the megenta color channel.
        """
        ...

    def premultiplied(self) -> PySide6.QtGui.QPixelFormat.AlphaPremultiplied:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#premultiplied

        **QPixelFormat::AlphaPremultiplied QPixelFormat::premultiplied() const**

        Accessor function for the **AlphaPremultiplied**  enum. This indicates
        if the alpha channel is multiplied in to the color channels.
        """
        ...

    def redSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#redSize

        **uchar QPixelFormat::redSize() const**

        Accessor function for the size of the red color channel.
        """
        ...

    def saturationSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#saturationSize

        **uchar QPixelFormat::saturationSize() const**

        Accessor function for the saturation channel size.
        """
        ...

    def subEnum(self) -> int:
        ...

    def typeInterpretation(self) -> PySide6.QtGui.QPixelFormat.TypeInterpretation:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#typeInterpretation

        **QPixelFormat::TypeInterpretation QPixelFormat::typeInterpretation()
        const**

        Accessor function for the type representation of a color channel or a
        pixel.

        **See also** **TypeInterpretation** .
        """
        ...

    def yellowSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#yellowSize

        **uchar QPixelFormat::yellowSize() const**

        Accessor function for the yellow color channel.
        """
        ...

    def yuvLayout(self) -> PySide6.QtGui.QPixelFormat.YUVLayout:
        """
        https://doc.qt.io/qt-6/qpixelformat.html#yuvLayout

        **QPixelFormat::YUVLayout QPixelFormat::yuvLayout() const**

        Accessor function for the **YUVLayout** . It is difficult to describe
        the color channels of a YUV pixel format since YUV color model uses
        macro pixels. Instead the layout of the pixels are stored as an enum.
        """
        ...
