"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPalette(object):
    """
    https://doc.qt.io/qt-6/qpalette.html

    **Detailed Description**

    A palette consists of three color groups: **Active** , **Disabled** , and
    **Inactive**. All widgets in Qt contain a palette and use their palette to
    draw themselves. This makes the user interface easily configurable and
    easier to keep consistent.

    If you create a new widget we strongly recommend that you use the colors in
    the palette rather than hard-coding specific colors.

    The color groups:

    * The Active group is used for the window that has keyboard focus.
      * The
    Inactive group is used for other windows.
      * The Disabled group is used for
    widgets (not windows) that are disabled for some reason.

    Both active and inactive windows can contain disabled widgets. (Disabled
    widgets are often called **inaccessible** or **grayed out**.)

    In most styles, Active and Inactive look the same.

    Colors and brushes can be set for particular roles in any of a palette's
    color groups with **setColor** () and **setBrush** (). A color group
    contains a group of colors used by widgets for drawing themselves. We
    recommend that widgets use color group roles from the palette such as
    "foreground" and "base" rather than literal colors like "red" or
    "turquoise". The color roles are enumerated and defined in the **ColorRole**
    documentation.

    We strongly recommend that you use the default palette of the current style
    (returned by **QGuiApplication::palette** ()) and modify that as necessary.
    This is done by Qt's widgets when they are drawn.

    To modify a color group you call the functions **setColor** () and
    **setBrush** (), depending on whether you want a pure color or a pixmap
    pattern.

    There are also corresponding **color** () and **brush** () getters, and a
    commonly used convenience function to get the **ColorRole**  for the current
    **ColorGroup** : **window** (), **windowText** (), **base** (), etc.

    You can copy a palette using the copy constructor and test to see if two
    palettes are **identical** using **isCopyOf** ().

    QPalette is optimized by the use of **implicit sharing** , so it is very
    efficient to pass QPalette objects as arguments.

    **Warning:** Some styles do not use the palette for all drawing, for
    instance, if they make use of native theme engines. This is the case for
    both the Windows Vista and the macOS styles.

    **See also** **QApplication::setPalette** (), **QWidget::setPalette** (),
    and **QColor** .
    """

    Active: QPalette.ColorGroup = ...
    Normal: QPalette.ColorGroup = ...
    Disabled: QPalette.ColorGroup = ...
    Inactive: QPalette.ColorGroup = ...
    NColorGroups: QPalette.ColorGroup = ...
    Current: QPalette.ColorGroup = ...
    All: QPalette.ColorGroup = ...
    WindowText: QPalette.ColorRole = ...
    Button: QPalette.ColorRole = ...
    Light: QPalette.ColorRole = ...
    Midlight: QPalette.ColorRole = ...
    Dark: QPalette.ColorRole = ...
    Mid: QPalette.ColorRole = ...
    Text: QPalette.ColorRole = ...
    BrightText: QPalette.ColorRole = ...
    ButtonText: QPalette.ColorRole = ...
    Base: QPalette.ColorRole = ...
    Window: QPalette.ColorRole = ...
    Shadow: QPalette.ColorRole = ...
    Highlight: QPalette.ColorRole = ...
    HighlightedText: QPalette.ColorRole = ...
    Link: QPalette.ColorRole = ...
    LinkVisited: QPalette.ColorRole = ...
    AlternateBase: QPalette.ColorRole = ...
    NoRole: QPalette.ColorRole = ...
    ToolTipBase: QPalette.ColorRole = ...
    ToolTipText: QPalette.ColorRole = ...
    PlaceholderText: QPalette.ColorRole = ...
    NColorRoles: QPalette.ColorRole = ...

    class ColorGroup(Enum):
        Active: QPalette.ColorGroup = ...
        Normal: QPalette.ColorGroup = ...
        Disabled: QPalette.ColorGroup = ...
        Inactive: QPalette.ColorGroup = ...
        NColorGroups: QPalette.ColorGroup = ...
        Current: QPalette.ColorGroup = ...
        All: QPalette.ColorGroup = ...

    class ColorRole(Enum):
        WindowText: QPalette.ColorRole = ...
        Button: QPalette.ColorRole = ...
        Light: QPalette.ColorRole = ...
        Midlight: QPalette.ColorRole = ...
        Dark: QPalette.ColorRole = ...
        Mid: QPalette.ColorRole = ...
        Text: QPalette.ColorRole = ...
        BrightText: QPalette.ColorRole = ...
        ButtonText: QPalette.ColorRole = ...
        Base: QPalette.ColorRole = ...
        Window: QPalette.ColorRole = ...
        Shadow: QPalette.ColorRole = ...
        Highlight: QPalette.ColorRole = ...
        HighlightedText: QPalette.ColorRole = ...
        Link: QPalette.ColorRole = ...
        LinkVisited: QPalette.ColorRole = ...
        AlternateBase: QPalette.ColorRole = ...
        NoRole: QPalette.ColorRole = ...
        ToolTipBase: QPalette.ColorRole = ...
        ToolTipText: QPalette.ColorRole = ...
        PlaceholderText: QPalette.ColorRole = ...
        NColorRoles: QPalette.ColorRole = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette

        **QPalette::QPalette()**

        Constructs an empty palette object with no color roles set.

        When used as the palette of a **QWidget**  the colors are resolved as
        described by **QWidget::setPalette** ().

        **See also** **QApplication::setPalette** () and
        **QApplication::palette** ().
        """
        ...

    @overload
    def __init__(self, button: PySide6.QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-1

        **QPalette::QPalette(const QColor & button )**

        Constructs a palette from the **button** color. The other colors are
        automatically calculated, based on this color. `Window` will be the
        button color as well.
        """
        ...

    @overload
    def __init__(
        self,
        button: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-2

        **QPalette::QPalette(Qt::GlobalColor button )**

        Constructs a palette from the **button** color. The other colors are
        automatically calculated, based on this color. `Window` will be the
        button color as well.
        """
        ...

    @overload
    def __init__(
        self,
        button: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        window: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-3

        **QPalette::QPalette(const QColor & button , const QColor & window )**

        Constructs a palette from a **button** color and a **window**. The other
        colors are automatically calculated, based on these colors.
        """
        ...

    @overload
    def __init__(
        self,
        palette: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-4

        **QPalette::QPalette(const QBrush & windowText , const QBrush & button ,
        const QBrush & light , const QBrush & dark , const QBrush & mid , const
        QBrush & text , const QBrush & bright_text , const QBrush & base , const
        QBrush & window )**

        Constructs a palette. You can pass either brushes, pixmaps or plain
        colors for **windowText** , **button** , **light** , **dark** , **mid**
        , **text** , **bright_text** , **base** and **window**.

        **See also** **QBrush** .
        """
        ...

    @overload
    def __init__(
        self,
        windowText: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        button: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        light: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        dark: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        mid: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        text: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        bright_text: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        base: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        window: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-6

        **QPalette::QPalette(const QPalette & p )**

        Constructs a copy of **p**.

        This constructor is fast thanks to **implicit sharing** .
        """
        ...

    @overload
    def __init__(
        self,
        windowText: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        window: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        light: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        dark: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        mid: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        text: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        base: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#QPalette-7

        **[since 5.4] QPalette::QPalette(QPalette && other )**

        Move-constructs a QPalette instance, making it point at the same object
        that **other** was pointing to.

        After being moved from, you can only assign to or destroy **other**. Any
        other operation will result in undefined behavior.

        This function was introduced in Qt 5.4.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def alternateBase(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#alternateBase

        **const QBrush &QPalette::alternateBase() const**

        Returns the alternate base brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def base(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#base

        **const QBrush &QPalette::base() const**

        Returns the base brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def brightText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#brightText

        **const QBrush &QPalette::brightText() const**

        Returns the bright text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    @overload
    def brush(
        self,
        cg: PySide6.QtGui.QPalette.ColorGroup,
        cr: PySide6.QtGui.QPalette.ColorRole,
    ) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#brush

        **const QBrush &QPalette::brush(QPalette::ColorGroup group ,
        QPalette::ColorRole role ) const**

        Returns the brush in the specified color **group** , used for the given
        color **role**.

        **See also** **color** (), **setBrush** (), and **ColorRole** .
        """
        ...

    @overload
    def brush(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#brush-1

        **const QBrush &QPalette::brush(QPalette::ColorRole role ) const**

        This is an overloaded function.

        Returns the brush that has been set for the given color **role** in the
        current **ColorGroup** .

        **See also** **color** (), **setBrush** (), and **ColorRole** .
        """
        ...

    def button(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#button

        **const QBrush &QPalette::button() const**

        Returns the button brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def buttonText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#buttonText

        **const QBrush &QPalette::buttonText() const**

        Returns the button text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def cacheKey(self) -> int:
        """
        https://doc.qt.io/qt-6/qpalette.html#cacheKey

        **qint64 QPalette::cacheKey() const**

        Returns a number that identifies the contents of this **QPalette**
        object. Distinct **QPalette**  objects can have the same key if they
        refer to the same contents.

        The cacheKey() will change when the palette is altered.
        """
        ...

    @overload
    def color(
        self,
        cg: PySide6.QtGui.QPalette.ColorGroup,
        cr: PySide6.QtGui.QPalette.ColorRole,
    ) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qpalette.html#color

        **const QColor &QPalette::color(QPalette::ColorGroup group ,
        QPalette::ColorRole role ) const**

        Returns the color in the specified color **group** , used for the given
        color **role**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @overload
    def color(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qpalette.html#color-1

        **const QColor &QPalette::color(QPalette::ColorRole role ) const**

        This is an overloaded function.

        Returns the color that has been set for the given color **role** in the
        current **ColorGroup** .

        **See also** **brush** () and **ColorRole** .
        """
        ...

    def currentColorGroup(self) -> PySide6.QtGui.QPalette.ColorGroup:
        """
        https://doc.qt.io/qt-6/qpalette.html#currentColorGroup

        **QPalette::ColorGroup QPalette::currentColorGroup() const**

        Returns the palette's current color group.

        **See also** **setCurrentColorGroup** ().
        """
        ...

    def dark(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#dark

        **const QBrush &QPalette::dark() const**

        Returns the dark brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def highlight(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#highlight

        **const QBrush &QPalette::highlight() const**

        Returns the highlight brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def highlightedText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#highlightedText

        **const QBrush &QPalette::highlightedText() const**

        Returns the highlighted text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def isBrushSet(
        self,
        cg: PySide6.QtGui.QPalette.ColorGroup,
        cr: PySide6.QtGui.QPalette.ColorRole,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpalette.html#isBrushSet

        **bool QPalette::isBrushSet(QPalette::ColorGroup cg ,
        QPalette::ColorRole cr ) const**

        Returns `true` if the **ColorGroup**  **cg** and **ColorRole**  **cr**
        has been set previously on this palette; otherwise returns `false`.

        The **ColorGroup**  **cg** should be less than
        **QPalette::NColorGroups** , but you can use **QPalette::Current** . In
        this case, the previously set current color group will be used.

        The **ColorRole**  **cr** should be less than **QPalette::NColorRoles**
        .

        **See also** **setBrush** () and **currentColorGroup** ().
        """
        ...

    def isCopyOf(
        self,
        p: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpalette.html#isCopyOf

        **bool QPalette::isCopyOf(const QPalette & p ) const**

        Returns `true` if this palette and **p** are copies of each other, i.e.
        one of them was created as a copy of the other and neither was
        subsequently modified; otherwise returns `false`. This is much stricter
        than equality.

        **See also** **operator=** () and **operator==** ().
        """
        ...

    def isEqual(
        self,
        cr1: PySide6.QtGui.QPalette.ColorGroup,
        cr2: PySide6.QtGui.QPalette.ColorGroup,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpalette.html#isEqual

        **bool QPalette::isEqual(QPalette::ColorGroup cg1 , QPalette::ColorGroup
        cg2 ) const**

        Returns `true` (usually quickly) if color group **cg1** is equal to
        **cg2** ; otherwise returns `false`.
        """
        ...

    def light(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#light

        **const QBrush &QPalette::light() const**

        Returns the light brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def link(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#link

        **const QBrush &QPalette::link() const**

        Returns the unvisited link text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def linkVisited(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#linkVisited

        **const QBrush &QPalette::linkVisited() const**

        Returns the visited link text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def mid(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#mid

        **const QBrush &QPalette::mid() const**

        Returns the mid brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def midlight(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#midlight

        **const QBrush &QPalette::midlight() const**

        Returns the midlight brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def placeholderText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#placeholderText

        **[since 5.12] const QBrush &QPalette::placeholderText() const**

        Returns the placeholder text brush of the current color group.

        **Note:** Before Qt 5.12, the placeholder text color was hard-coded as
        **QPalette::text** ().**color** () with an alpha of 128 applied. In Qt
        6, it is an independent color.

        This function was introduced in Qt 5.12.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def resolve(
        self,
        other: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> PySide6.QtGui.QPalette:
        """
        https://doc.qt.io/qt-6/qpalette.html#resolve

        **QPalette QPalette::resolve(const QPalette & other ) const**

        Returns a new **QPalette**  that is a union of this instance and
        **other**. Color roles set in this instance take precedence.
        """
        ...

    def resolveMask(self) -> int:
        ...

    @overload
    def setBrush(
        self,
        cg: PySide6.QtGui.QPalette.ColorGroup,
        cr: PySide6.QtGui.QPalette.ColorRole,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setBrush

        **void QPalette::setBrush(QPalette::ColorRole role , const QBrush &
        brush )**

        Sets the brush for the given color **role** to the specified **brush**
        for all groups in the palette.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @overload
    def setBrush(
        self,
        cr: PySide6.QtGui.QPalette.ColorRole,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setBrush-1

        **void QPalette::setBrush(QPalette::ColorGroup group ,
        QPalette::ColorRole role , const QBrush & brush )**

        This is an overloaded function.

        Sets the brush in the specified color **group** , used for the given
        color **role** , to **brush**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @overload
    def setColor(
        self,
        cg: PySide6.QtGui.QPalette.ColorGroup,
        cr: PySide6.QtGui.QPalette.ColorRole,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setColor

        **void QPalette::setColor(QPalette::ColorGroup group ,
        QPalette::ColorRole role , const QColor & color )**

        Sets the color in the specified color **group** , used for the given
        color **role** , to the specified solid **color**.

        **See also** **setBrush** (), **color** (), and **ColorRole** .
        """
        ...

    @overload
    def setColor(
        self,
        cr: PySide6.QtGui.QPalette.ColorRole,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setColor-1

        **void QPalette::setColor(QPalette::ColorRole role , const QColor &
        color )**

        This is an overloaded function.

        Sets the color used for the given color **role** , in all color groups,
        to the specified solid **color**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    def setColorGroup(
        self,
        cr: PySide6.QtGui.QPalette.ColorGroup,
        windowText: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        button: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        light: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        dark: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        mid: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        text: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        bright_text: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        base: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
        window: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setColorGroup

        **void QPalette::setColorGroup(QPalette::ColorGroup cg , const QBrush &
        windowText , const QBrush & button , const QBrush & light , const QBrush
        & dark , const QBrush & mid , const QBrush & text , const QBrush &
        bright_text , const QBrush & base , const QBrush & window )**

        Sets a the group at **cg**. You can pass either brushes, pixmaps or
        plain colors for **windowText** , **button** , **light** , **dark** ,
        **mid** , **text** , **bright_text** , **base** and **window**.

        **See also** **QBrush** .
        """
        ...

    def setCurrentColorGroup(self, cg: PySide6.QtGui.QPalette.ColorGroup) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#setCurrentColorGroup

        **void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg )**

        Set the palette's current color group to **cg**.

        **See also** **currentColorGroup** ().
        """
        ...

    def setResolveMask(self, mask: int) -> None:
        ...

    def shadow(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#shadow

        **const QBrush &QPalette::shadow() const**

        Returns the shadow brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpalette.html#swap

        **[since 5.0] void QPalette::swap(QPalette & other )**

        Swaps this palette instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def text(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#text

        **const QBrush &QPalette::text() const**

        Returns the text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def toolTipBase(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#toolTipBase

        **const QBrush &QPalette::toolTipBase() const**

        Returns the tool tip base brush of the current color group. This brush
        is used by **QToolTip**  and **QWhatsThis** .

        **Note:** Tool tips use the Inactive color group of **QPalette** ,
        because tool tips are not active windows.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def toolTipText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#toolTipText

        **const QBrush &QPalette::toolTipText() const**

        Returns the tool tip text brush of the current color group. This brush
        is used by **QToolTip**  and **QWhatsThis** .

        **Note:** Tool tips use the Inactive color group of **QPalette** ,
        because tool tips are not active windows.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def window(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#window

        **const QBrush &QPalette::window() const**

        Returns the window (general background) brush of the current color
        group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def windowText(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qpalette.html#windowText

        **const QBrush &QPalette::windowText() const**

        Returns the window text (general foreground) brush of the current color
        group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...
