"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPainterPathStroker(object):
    """
    https://doc.qt.io/qt-6/qpainterpathstroker.html

    **Detailed Description**

    By calling the **createStroke** () function, passing a given
    **QPainterPath**  as argument, a new painter path representing the outline
    of the given path is created. The newly created painter path can then be
    filled to draw the original painter path's outline.

    You can control the various design aspects (width, cap styles, join styles
    and dash pattern) of the outlining using the following functions:

    * **setWidth** ()
      * **setCapStyle** ()
      * **setJoinStyle** ()
      *
    **setDashPattern** ()

    The **setDashPattern** () function accepts both a **Qt::PenStyle**  object
    and a list representation of the pattern as argument.

    In addition you can specify a curve's threshold, controlling the granularity
    with which a curve is drawn, using the **setCurveThreshold** () function.
    The default threshold is a well adjusted value (0.25), and normally you
    should not need to modify it. However, you can make the curve's appearance
    smoother by decreasing its value.

    You can also control the miter limit for the generated outline using the
    **setMiterLimit** () function. The miter limit describes how far from each
    join the miter join can extend. The limit is specified in the units of width
    so the pixelwise miter limit will be `miterlimit * width`. This value is
    only used if the join style is **Qt::MiterJoin** .

    The painter path generated by the **createStroke** () function should only
    be used for outlining the given painter path. Otherwise it may cause
    unexpected behavior. Generated outlines also require the **Qt::WindingFill**
    rule which is set by default.

    **See also** **QPen**  and **QBrush** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#QPainterPathStroker

        **QPainterPathStroker::QPainterPathStroker()**

        Creates a new stroker.
        """
        ...

    @overload
    def __init__(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#QPainterPathStroker-1

        **[since 5.3] QPainterPathStroker::QPainterPathStroker(const QPen & pen
        )**

        Creates a new stroker based on **pen**.

        This function was introduced in Qt 5.3.
        """
        ...

    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#capStyle

        **Qt::PenCapStyle QPainterPathStroker::capStyle() const**

        Returns the cap style of the generated outlines.

        **See also** **setCapStyle** ().
        """
        ...

    def createStroke(
        self, path: PySide6.QtGui.QPainterPath
    ) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#createStroke

        **QPainterPath QPainterPathStroker::createStroke(const QPainterPath &
        path ) const**

        Generates a new path that is a fillable area representing the outline of
        the given **path**.

        The various design aspects of the outline are based on the stroker's
        properties: **width** (), **capStyle** (), **joinStyle** (),
        **dashPattern** (), **curveThreshold** () and **miterLimit** ().

        The generated path should only be used for outlining the given painter
        path. Otherwise it may cause unexpected behavior. Generated outlines
        also require the **Qt::WindingFill**  rule which is set by default.
        """
        ...

    def curveThreshold(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#curveThreshold

        **qreal QPainterPathStroker::curveThreshold() const**

        Returns the curve flattening threshold for the generated outlines.

        **See also** **setCurveThreshold** ().
        """
        ...

    def dashOffset(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#dashOffset

        **qreal QPainterPathStroker::dashOffset() const**

        Returns the dash offset for the generated outlines.

        **See also** **setDashOffset** ().
        """
        ...

    def dashPattern(self) -> List[float]:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#dashPattern

        **QList<qreal> QPainterPathStroker::dashPattern() const**

        Returns the dash pattern for the generated outlines.

        **See also** **setDashPattern** ().
        """
        ...

    def joinStyle(self) -> PySide6.QtCore.Qt.PenJoinStyle:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#joinStyle

        **Qt::PenJoinStyle QPainterPathStroker::joinStyle() const**

        Returns the join style of the generated outlines.

        **See also** **setJoinStyle** ().
        """
        ...

    def miterLimit(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#miterLimit

        **qreal QPainterPathStroker::miterLimit() const**

        Returns the miter limit for the generated outlines.

        **See also** **setMiterLimit** ().
        """
        ...

    def setCapStyle(self, style: PySide6.QtCore.Qt.PenCapStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setCapStyle

        **void QPainterPathStroker::setCapStyle(Qt::PenCapStyle style )**

        Sets the cap style of the generated outlines to **style**. If a dash
        pattern is set, each segment of the pattern is subject to the cap
        **style**.

        **See also** **capStyle** ().
        """
        ...

    def setCurveThreshold(self, threshold: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setCurveThreshold

        **void QPainterPathStroker::setCurveThreshold(qreal threshold )**

        Specifies the curve flattening **threshold** , controlling the
        granularity with which the generated outlines' curve is drawn.

        The default threshold is a well adjusted value (0.25), and normally you
        should not need to modify it. However, you can make the curve's
        appearance smoother by decreasing its value.

        **See also** **curveThreshold** ().
        """
        ...

    def setDashOffset(self, offset: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setDashOffset

        **void QPainterPathStroker::setDashOffset(qreal offset )**

        Sets the dash offset for the generated outlines to **offset**.

        See the documentation for **QPen::setDashOffset** () for a description
        of the dash offset.

        **See also** **dashOffset** ().
        """
        ...

    @overload
    def setDashPattern(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setDashPattern

        **void QPainterPathStroker::setDashPattern(Qt::PenStyle style )**

        Sets the dash pattern for the generated outlines to **style**.

        **See also** **dashPattern** ().
        """
        ...

    @overload
    def setDashPattern(self, dashPattern: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setDashPattern-1

        **void QPainterPathStroker::setDashPattern(const QList<qreal> &
        dashPattern )**

        This is an overloaded function.

        Sets the dash pattern for the generated outlines to **dashPattern**.
        This function makes it possible to specify custom dash patterns.

        Each element in the list contains the lengths of the dashes and spaces
        in the stroke, beginning with the first dash in the first element, the
        first space in the second element, and alternating between dashes and
        spaces for each following pair of elements.

        The list can contain an odd number of elements, in which case the last
        element will be extended by the length of the first element when the
        pattern repeats.
        """
        ...

    def setJoinStyle(self, style: PySide6.QtCore.Qt.PenJoinStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setJoinStyle

        **void QPainterPathStroker::setJoinStyle(Qt::PenJoinStyle style )**

        Sets the join style of the generated outlines to **style**.

        **See also** **joinStyle** ().
        """
        ...

    def setMiterLimit(self, length: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setMiterLimit

        **void QPainterPathStroker::setMiterLimit(qreal limit )**

        Sets the miter limit of the generated outlines to **limit**.

        The miter limit describes how far from each join the miter join can
        extend. The limit is specified in units of the currently set width. So
        the pixelwise miter limit will be `miterlimit * width`.

        This value is only used if the join style is **Qt::MiterJoin** .

        **See also** **miterLimit** ().
        """
        ...

    def setWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#setWidth

        **void QPainterPathStroker::setWidth(qreal width )**

        Sets the width of the generated outline painter path to **width**.

        The generated outlines will extend approximately 50% of **width** to
        each side of the given input path's original outline.

        **See also** **width** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpathstroker.html#width

        **qreal QPainterPathStroker::width() const**

        Returns the width of the generated outlines.

        **See also** **setWidth** ().
        """
        ...
