"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPageSize(object):
    """
    https://doc.qt.io/qt-6/qpagesize.html

    **Detailed Description**

    This class implements support for the set of standard page sizes as defined
    in the Adobe Postscript PPD Standard v4.3. It defines the standard set of
    page sizes in points, millimeters and inches and ensures these sizes are
    consistently used. Other size units can be used but will be calculated
    results and so may not always be consistent. The defined point sizes are
    always a integer, all other sizes can be fractions of a unit.

    The defined size is always in width x height order with no implied page
    orientation. Note that it is possible for page sizes to be defined where the
    width is greater than the height, such as **QPageSize::Ledger** , so you
    cannot rely on comparing the width and height values to determine page
    orientation.

    For example, A4 is defined by the standard as 210mm x 297mm, 8.27in x
    11.69in, or 595pt x 842pt.

    You can also define custom page sizes with custom names in any units you
    want and this unit size will be preserved and used as the base for all other
    unit size calculations.

    When creating a QPageSize using a custom **QSize**  you can choose if you
    want QPageSize to try match the size to a standard page size. By default
    QPaperSize uses a **FuzzyMatch**  mode where it will match a given page size
    to a standard page size if it falls within 3 postscript points of a defined
    standard size. You can override this to request only an exact match but this
    is not recommended as conversions between units can easily lose 3 points and
    result in incorrect page sizes.

    A QPageSize instance may also be obtained by querying the supported page
    sizes for a print device. In this case the localized name returned is that
    defined by the printer itself. Note that the print device may not support
    the current default locale language.

    The class also provides convenience methods for converting page size IDs to
    and from various unit sizes.

    **See also** **QPagedPaintDevice**  and **QPdfWriter** .
    """

    AnsiA: QPageSize.PageSizeId = ...
    Letter: QPageSize.PageSizeId = ...
    Legal: QPageSize.PageSizeId = ...
    Executive: QPageSize.PageSizeId = ...
    A0: QPageSize.PageSizeId = ...
    A1: QPageSize.PageSizeId = ...
    A2: QPageSize.PageSizeId = ...
    A3: QPageSize.PageSizeId = ...
    A4: QPageSize.PageSizeId = ...
    A5: QPageSize.PageSizeId = ...
    A6: QPageSize.PageSizeId = ...
    A7: QPageSize.PageSizeId = ...
    A8: QPageSize.PageSizeId = ...
    A9: QPageSize.PageSizeId = ...
    A10: QPageSize.PageSizeId = ...
    B0: QPageSize.PageSizeId = ...
    B1: QPageSize.PageSizeId = ...
    B2: QPageSize.PageSizeId = ...
    B3: QPageSize.PageSizeId = ...
    B4: QPageSize.PageSizeId = ...
    B5: QPageSize.PageSizeId = ...
    B6: QPageSize.PageSizeId = ...
    B7: QPageSize.PageSizeId = ...
    B8: QPageSize.PageSizeId = ...
    B9: QPageSize.PageSizeId = ...
    B10: QPageSize.PageSizeId = ...
    C5E: QPageSize.PageSizeId = ...
    EnvelopeC5: QPageSize.PageSizeId = ...
    Comm10E: QPageSize.PageSizeId = ...
    Envelope10: QPageSize.PageSizeId = ...
    DLE: QPageSize.PageSizeId = ...
    EnvelopeDL: QPageSize.PageSizeId = ...
    Folio: QPageSize.PageSizeId = ...
    AnsiB: QPageSize.PageSizeId = ...
    Ledger: QPageSize.PageSizeId = ...
    Tabloid: QPageSize.PageSizeId = ...
    Custom: QPageSize.PageSizeId = ...
    A3Extra: QPageSize.PageSizeId = ...
    A4Extra: QPageSize.PageSizeId = ...
    A4Plus: QPageSize.PageSizeId = ...
    A4Small: QPageSize.PageSizeId = ...
    A5Extra: QPageSize.PageSizeId = ...
    B5Extra: QPageSize.PageSizeId = ...
    JisB0: QPageSize.PageSizeId = ...
    JisB1: QPageSize.PageSizeId = ...
    JisB2: QPageSize.PageSizeId = ...
    JisB3: QPageSize.PageSizeId = ...
    JisB4: QPageSize.PageSizeId = ...
    JisB5: QPageSize.PageSizeId = ...
    JisB6: QPageSize.PageSizeId = ...
    JisB7: QPageSize.PageSizeId = ...
    JisB8: QPageSize.PageSizeId = ...
    JisB9: QPageSize.PageSizeId = ...
    JisB10: QPageSize.PageSizeId = ...
    AnsiC: QPageSize.PageSizeId = ...
    AnsiD: QPageSize.PageSizeId = ...
    AnsiE: QPageSize.PageSizeId = ...
    LegalExtra: QPageSize.PageSizeId = ...
    LetterExtra: QPageSize.PageSizeId = ...
    LetterPlus: QPageSize.PageSizeId = ...
    LetterSmall: QPageSize.PageSizeId = ...
    TabloidExtra: QPageSize.PageSizeId = ...
    ArchA: QPageSize.PageSizeId = ...
    ArchB: QPageSize.PageSizeId = ...
    ArchC: QPageSize.PageSizeId = ...
    ArchD: QPageSize.PageSizeId = ...
    ArchE: QPageSize.PageSizeId = ...
    Imperial7x9: QPageSize.PageSizeId = ...
    Imperial8x10: QPageSize.PageSizeId = ...
    Imperial9x11: QPageSize.PageSizeId = ...
    Imperial9x12: QPageSize.PageSizeId = ...
    Imperial10x11: QPageSize.PageSizeId = ...
    Imperial10x13: QPageSize.PageSizeId = ...
    Imperial10x14: QPageSize.PageSizeId = ...
    Imperial12x11: QPageSize.PageSizeId = ...
    Imperial15x11: QPageSize.PageSizeId = ...
    ExecutiveStandard: QPageSize.PageSizeId = ...
    Note: QPageSize.PageSizeId = ...
    Quarto: QPageSize.PageSizeId = ...
    Statement: QPageSize.PageSizeId = ...
    SuperA: QPageSize.PageSizeId = ...
    SuperB: QPageSize.PageSizeId = ...
    Postcard: QPageSize.PageSizeId = ...
    DoublePostcard: QPageSize.PageSizeId = ...
    Prc16K: QPageSize.PageSizeId = ...
    Prc32K: QPageSize.PageSizeId = ...
    Prc32KBig: QPageSize.PageSizeId = ...
    FanFoldUS: QPageSize.PageSizeId = ...
    FanFoldGerman: QPageSize.PageSizeId = ...
    FanFoldGermanLegal: QPageSize.PageSizeId = ...
    EnvelopeB4: QPageSize.PageSizeId = ...
    EnvelopeB5: QPageSize.PageSizeId = ...
    EnvelopeB6: QPageSize.PageSizeId = ...
    EnvelopeC0: QPageSize.PageSizeId = ...
    EnvelopeC1: QPageSize.PageSizeId = ...
    EnvelopeC2: QPageSize.PageSizeId = ...
    EnvelopeC3: QPageSize.PageSizeId = ...
    EnvelopeC4: QPageSize.PageSizeId = ...
    EnvelopeC6: QPageSize.PageSizeId = ...
    EnvelopeC65: QPageSize.PageSizeId = ...
    EnvelopeC7: QPageSize.PageSizeId = ...
    Envelope9: QPageSize.PageSizeId = ...
    Envelope11: QPageSize.PageSizeId = ...
    Envelope12: QPageSize.PageSizeId = ...
    Envelope14: QPageSize.PageSizeId = ...
    EnvelopeMonarch: QPageSize.PageSizeId = ...
    EnvelopePersonal: QPageSize.PageSizeId = ...
    EnvelopeChou3: QPageSize.PageSizeId = ...
    EnvelopeChou4: QPageSize.PageSizeId = ...
    EnvelopeInvite: QPageSize.PageSizeId = ...
    EnvelopeItalian: QPageSize.PageSizeId = ...
    EnvelopeKaku2: QPageSize.PageSizeId = ...
    EnvelopeKaku3: QPageSize.PageSizeId = ...
    EnvelopePrc1: QPageSize.PageSizeId = ...
    EnvelopePrc2: QPageSize.PageSizeId = ...
    EnvelopePrc3: QPageSize.PageSizeId = ...
    EnvelopePrc4: QPageSize.PageSizeId = ...
    EnvelopePrc5: QPageSize.PageSizeId = ...
    EnvelopePrc6: QPageSize.PageSizeId = ...
    EnvelopePrc7: QPageSize.PageSizeId = ...
    EnvelopePrc8: QPageSize.PageSizeId = ...
    EnvelopePrc9: QPageSize.PageSizeId = ...
    EnvelopePrc10: QPageSize.PageSizeId = ...
    EnvelopeYou4: QPageSize.PageSizeId = ...
    LastPageSize: QPageSize.PageSizeId = ...
    FuzzyMatch: QPageSize.SizeMatchPolicy = ...
    FuzzyOrientationMatch: QPageSize.SizeMatchPolicy = ...
    ExactMatch: QPageSize.SizeMatchPolicy = ...
    Millimeter: QPageSize.Unit = ...
    Point: QPageSize.Unit = ...
    Inch: QPageSize.Unit = ...
    Pica: QPageSize.Unit = ...
    Didot: QPageSize.Unit = ...
    Cicero: QPageSize.Unit = ...

    class PageSizeId(Enum):
        AnsiA: QPageSize.PageSizeId = ...
        Letter: QPageSize.PageSizeId = ...
        Legal: QPageSize.PageSizeId = ...
        Executive: QPageSize.PageSizeId = ...
        A0: QPageSize.PageSizeId = ...
        A1: QPageSize.PageSizeId = ...
        A2: QPageSize.PageSizeId = ...
        A3: QPageSize.PageSizeId = ...
        A4: QPageSize.PageSizeId = ...
        A5: QPageSize.PageSizeId = ...
        A6: QPageSize.PageSizeId = ...
        A7: QPageSize.PageSizeId = ...
        A8: QPageSize.PageSizeId = ...
        A9: QPageSize.PageSizeId = ...
        A10: QPageSize.PageSizeId = ...
        B0: QPageSize.PageSizeId = ...
        B1: QPageSize.PageSizeId = ...
        B2: QPageSize.PageSizeId = ...
        B3: QPageSize.PageSizeId = ...
        B4: QPageSize.PageSizeId = ...
        B5: QPageSize.PageSizeId = ...
        B6: QPageSize.PageSizeId = ...
        B7: QPageSize.PageSizeId = ...
        B8: QPageSize.PageSizeId = ...
        B9: QPageSize.PageSizeId = ...
        B10: QPageSize.PageSizeId = ...
        C5E: QPageSize.PageSizeId = ...
        EnvelopeC5: QPageSize.PageSizeId = ...
        Comm10E: QPageSize.PageSizeId = ...
        Envelope10: QPageSize.PageSizeId = ...
        DLE: QPageSize.PageSizeId = ...
        EnvelopeDL: QPageSize.PageSizeId = ...
        Folio: QPageSize.PageSizeId = ...
        AnsiB: QPageSize.PageSizeId = ...
        Ledger: QPageSize.PageSizeId = ...
        Tabloid: QPageSize.PageSizeId = ...
        Custom: QPageSize.PageSizeId = ...
        A3Extra: QPageSize.PageSizeId = ...
        A4Extra: QPageSize.PageSizeId = ...
        A4Plus: QPageSize.PageSizeId = ...
        A4Small: QPageSize.PageSizeId = ...
        A5Extra: QPageSize.PageSizeId = ...
        B5Extra: QPageSize.PageSizeId = ...
        JisB0: QPageSize.PageSizeId = ...
        JisB1: QPageSize.PageSizeId = ...
        JisB2: QPageSize.PageSizeId = ...
        JisB3: QPageSize.PageSizeId = ...
        JisB4: QPageSize.PageSizeId = ...
        JisB5: QPageSize.PageSizeId = ...
        JisB6: QPageSize.PageSizeId = ...
        JisB7: QPageSize.PageSizeId = ...
        JisB8: QPageSize.PageSizeId = ...
        JisB9: QPageSize.PageSizeId = ...
        JisB10: QPageSize.PageSizeId = ...
        AnsiC: QPageSize.PageSizeId = ...
        AnsiD: QPageSize.PageSizeId = ...
        AnsiE: QPageSize.PageSizeId = ...
        LegalExtra: QPageSize.PageSizeId = ...
        LetterExtra: QPageSize.PageSizeId = ...
        LetterPlus: QPageSize.PageSizeId = ...
        LetterSmall: QPageSize.PageSizeId = ...
        TabloidExtra: QPageSize.PageSizeId = ...
        ArchA: QPageSize.PageSizeId = ...
        ArchB: QPageSize.PageSizeId = ...
        ArchC: QPageSize.PageSizeId = ...
        ArchD: QPageSize.PageSizeId = ...
        ArchE: QPageSize.PageSizeId = ...
        Imperial7x9: QPageSize.PageSizeId = ...
        Imperial8x10: QPageSize.PageSizeId = ...
        Imperial9x11: QPageSize.PageSizeId = ...
        Imperial9x12: QPageSize.PageSizeId = ...
        Imperial10x11: QPageSize.PageSizeId = ...
        Imperial10x13: QPageSize.PageSizeId = ...
        Imperial10x14: QPageSize.PageSizeId = ...
        Imperial12x11: QPageSize.PageSizeId = ...
        Imperial15x11: QPageSize.PageSizeId = ...
        ExecutiveStandard: QPageSize.PageSizeId = ...
        Note: QPageSize.PageSizeId = ...
        Quarto: QPageSize.PageSizeId = ...
        Statement: QPageSize.PageSizeId = ...
        SuperA: QPageSize.PageSizeId = ...
        SuperB: QPageSize.PageSizeId = ...
        Postcard: QPageSize.PageSizeId = ...
        DoublePostcard: QPageSize.PageSizeId = ...
        Prc16K: QPageSize.PageSizeId = ...
        Prc32K: QPageSize.PageSizeId = ...
        Prc32KBig: QPageSize.PageSizeId = ...
        FanFoldUS: QPageSize.PageSizeId = ...
        FanFoldGerman: QPageSize.PageSizeId = ...
        FanFoldGermanLegal: QPageSize.PageSizeId = ...
        EnvelopeB4: QPageSize.PageSizeId = ...
        EnvelopeB5: QPageSize.PageSizeId = ...
        EnvelopeB6: QPageSize.PageSizeId = ...
        EnvelopeC0: QPageSize.PageSizeId = ...
        EnvelopeC1: QPageSize.PageSizeId = ...
        EnvelopeC2: QPageSize.PageSizeId = ...
        EnvelopeC3: QPageSize.PageSizeId = ...
        EnvelopeC4: QPageSize.PageSizeId = ...
        EnvelopeC6: QPageSize.PageSizeId = ...
        EnvelopeC65: QPageSize.PageSizeId = ...
        EnvelopeC7: QPageSize.PageSizeId = ...
        Envelope9: QPageSize.PageSizeId = ...
        Envelope11: QPageSize.PageSizeId = ...
        Envelope12: QPageSize.PageSizeId = ...
        Envelope14: QPageSize.PageSizeId = ...
        EnvelopeMonarch: QPageSize.PageSizeId = ...
        EnvelopePersonal: QPageSize.PageSizeId = ...
        EnvelopeChou3: QPageSize.PageSizeId = ...
        EnvelopeChou4: QPageSize.PageSizeId = ...
        EnvelopeInvite: QPageSize.PageSizeId = ...
        EnvelopeItalian: QPageSize.PageSizeId = ...
        EnvelopeKaku2: QPageSize.PageSizeId = ...
        EnvelopeKaku3: QPageSize.PageSizeId = ...
        EnvelopePrc1: QPageSize.PageSizeId = ...
        EnvelopePrc2: QPageSize.PageSizeId = ...
        EnvelopePrc3: QPageSize.PageSizeId = ...
        EnvelopePrc4: QPageSize.PageSizeId = ...
        EnvelopePrc5: QPageSize.PageSizeId = ...
        EnvelopePrc6: QPageSize.PageSizeId = ...
        EnvelopePrc7: QPageSize.PageSizeId = ...
        EnvelopePrc8: QPageSize.PageSizeId = ...
        EnvelopePrc9: QPageSize.PageSizeId = ...
        EnvelopePrc10: QPageSize.PageSizeId = ...
        EnvelopeYou4: QPageSize.PageSizeId = ...
        LastPageSize: QPageSize.PageSizeId = ...

    class SizeMatchPolicy(Enum):
        FuzzyMatch: QPageSize.SizeMatchPolicy = ...
        FuzzyOrientationMatch: QPageSize.SizeMatchPolicy = ...
        ExactMatch: QPageSize.SizeMatchPolicy = ...

    class Unit(Enum):
        Millimeter: QPageSize.Unit = ...
        Point: QPageSize.Unit = ...
        Inch: QPageSize.Unit = ...
        Pica: QPageSize.Unit = ...
        Didot: QPageSize.Unit = ...
        Cicero: QPageSize.Unit = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize

        **QPageSize::QPageSize()**

        Creates a null QPageSize.
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-1

        **QPageSize::QPageSize(QPageSize::PageSizeId pageSize )**

        Creates a QPageSize of the standard **pageSize**.

        If **pageSize** is **QPageSize::Custom**  then the resulting QPageSize
        will not be valid. Use the custom size constructor instead.
        """
        ...

    @overload
    def __init__(self, pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-2

        **QPageSize::QPageSize(const QSize & pointSize , const QString & name =
        QString(), QPageSize::SizeMatchPolicy matchPolicy = FuzzyMatch)**

        Creates a QPageSize of the given **pointSize** in Points using the
        matching **matchPolicy**.

        If the given **pointSize** matches a standard **QPageSize::PageSizeId**
        , then that page size will be used. Note that if the **matchPolicy** is
        **FuzzyMatch**  this may result in the **pointSize** being adjusted to
        the standard size. To prevent this happening use a **matchPolicy** of
        **ExactMatch**  instead.

        If the given **pointSize** is not a standard **QPageSize::PageSizeId**
        then a **QPageSize::Custom**  size will be created.

        If **name** is null then the standard localized name will be used. If a
        custom page size then a custom name in the format "Custom (width x
        height)" will be created.

        The **matchPolicy** defaults to **FuzzyMatch** .
        """
        ...

    @overload
    def __init__(
        self,
        pointSize: PySide6.QtCore.QSize,
        name: str = ...,
        matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-3

        **QPageSize::QPageSize(const QSizeF & size , QPageSize::Unit units ,
        const QString & name = QString(), QPageSize::SizeMatchPolicy matchPolicy
        = FuzzyMatch)**

        Creates a custom page of the given **size** in **units**.

        If the given **size** matches a standard **QPageSize::PageSizeId** ,
        then that page size will be used. Note that if the **matchPolicy** is
        **FuzzyMatch**  this may result in the **size** being adjusted to the
        standard size. To prevent this happening use a **matchPolicy** of
        **ExactMatch**  instead.

        If the given **size** is not a standard **QPageSize::PageSizeId**  then
        a **QPageSize::Custom**  size will be created. The original unit size
        will be preserved and used as the base for all other unit size
        calculations.

        If **name** is null then a custom name will be created in the form
        "Custom (width x height)" where the size is expressed in units provided.
        """
        ...

    @overload
    def __init__(
        self,
        size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize],
        units: PySide6.QtGui.QPageSize.Unit,
        name: str = ...,
        matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-4

        **QPageSize::QPageSize(const QPageSize & other )**

        Copy constructor, copies **other** to this.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    @staticmethod
    def definitionSize(
        pageSizeId: PySide6.QtGui.QPageSize.PageSizeId,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionSize

        **QSizeF QPageSize::definitionSize() const**

        Returns the definition size of the page size.

        For a standard page size this will be the size as defined in the
        relevant standard, i.e. ISO A4 will be defined in millimeters while ANSI
        Letter will be defined in inches.

        For a custom page size this will be the original size used to create the
        page size object.

        If the **QPageSize**  is invalid then the **QSizeF**  will be invalid.

        **See also** **definitionUnits** ().
        """
        ...

    @overload
    def definitionSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionSize-1

        **[static] QSizeF QPageSize::definitionSize(QPageSize::PageSizeId
        pageSizeId )**

        Returns the definition size of the standard **pageSizeId**.

        To obtain the definition units, call **QPageSize::definitionUnits** ().
        """
        ...

    @overload
    @staticmethod
    def definitionUnits(
        pageSizeId: PySide6.QtGui.QPageSize.PageSizeId,
    ) -> PySide6.QtGui.QPageSize.Unit:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionUnits

        **QPageSize::Unit QPageSize::definitionUnits() const**

        Returns the definition units of the page size.

        For a standard page size this will be the units as defined in the
        relevant standard, i.e. ISO A4 will be defined in millimeters while ANSI
        Letter will be defined in inches.

        For a custom page size this will be the original units used to create
        the page size object.

        If the **QPageSize**  is invalid then the **QPageSize::Unit**  will be
        invalid.

        **See also** **definitionSize** ().
        """
        ...

    @overload
    def definitionUnits(self) -> PySide6.QtGui.QPageSize.Unit:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionUnits-1

        **[static] QPageSize::Unit
        QPageSize::definitionUnits(QPageSize::PageSizeId pageSizeId )**

        Returns the definition units of the standard **pageSizeId**.

        To obtain the definition size, call **QPageSize::definitionSize** ().
        """
        ...

    @overload
    @staticmethod
    def id(
        pointSize: PySide6.QtCore.QSize,
        matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...,
    ) -> PySide6.QtGui.QPageSize.PageSizeId:
        """
        https://doc.qt.io/qt-6/qpagesize.html#id

        **QPageSize::PageSizeId QPageSize::id() const**

        Returns the standard **QPageSize::PageSizeId**  of the page, or
        **QPageSize::Custom** .

        If the **QPageSize**  is invalid then the ID will be
        **QPageSize::Custom** .
        """
        ...

    @overload
    def id(self) -> PySide6.QtGui.QPageSize.PageSizeId:
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-1

        **[static] QPageSize::PageSizeId QPageSize::id(const QSize & pointSize ,
        QPageSize::SizeMatchPolicy matchPolicy = FuzzyMatch)**

        Returns the standard **QPageSize::PageSizeId**  of the given
        **pointSize** in points using the given **matchPolicy**.

        If using **FuzzyMatch**  then the point size of the **PageSizeId**
        returned may not exactly match the **pointSize** you passed in. You
        should call **QPageSize::sizePoints** () using the returned
        **PageSizeId**  to find out the actual point size of the **PageSizeId**
        before using it in any calculations.
        """
        ...

    @overload
    @staticmethod
    def id(
        size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize],
        units: PySide6.QtGui.QPageSize.Unit,
        matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...,
    ) -> PySide6.QtGui.QPageSize.PageSizeId:
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-2

        **[static] QPageSize::PageSizeId QPageSize::id(const QSizeF & size ,
        QPageSize::Unit units , QPageSize::SizeMatchPolicy matchPolicy =
        FuzzyMatch)**

        Returns the standard **QPageSize::PageSizeId**  of the given **size** in
        **units** using the given **matchPolicy**.

        If using **FuzzyMatch**  then the unit size of the **PageSizeId**
        returned may not exactly match the **size** you passed in. You should
        call **QPageSize::size** () using the returned **PageSizeId**  to find
        out the actual unit size of the **PageSizeId**  before using it in any
        calculations.
        """
        ...

    @overload
    @staticmethod
    def id(windowsId: int) -> PySide6.QtGui.QPageSize.PageSizeId:
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-3

        **[static] QPageSize::PageSizeId QPageSize::id(int windowsId )**

        Returns the **PageSizeId**  for the given Windows DMPAPER enum value
        **windowsId**.

        If there is no matching **PageSizeId**  then **QPageSize::Custom**  is
        returned.
        """
        ...

    def isEquivalentTo(
        self,
        other: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpagesize.html#isEquivalentTo

        **bool QPageSize::isEquivalentTo(const QPageSize & other ) const**

        Returns `true` if this page is equivalent to the **other** page, i.e. if
        the page has the same size regardless of other attributes like name.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpagesize.html#isValid

        **bool QPageSize::isValid() const**

        Returns `true` if this page size is valid.

        The page size may be invalid if created with an invalid **PageSizeId** ,
        or a negative or invalid **QSize**  or **QSizeF** , or the null
        constructor.
        """
        ...

    @overload
    @staticmethod
    def key(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#key

        **QString QPageSize::key() const**

        Returns the unique key of the page size.

        By default this is the PPD standard mediaOption keyword for the page
        size, or the PPD custom format key. If the **QPageSize**  instance was
        obtained from a print device then this will be the key provided by the
        print device and may differ from the standard key.

        If the **QPageSize**  is invalid then the key will be an empty string.

        This key should never be shown to end users, it is an internal key only.
        For a human-readable name use **name** ().

        **See also** **name** ().
        """
        ...

    @overload
    def key(self) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#key-1

        **[static] QString QPageSize::key(QPageSize::PageSizeId pageSizeId )**

        Returns the PPD mediaOption keyword of the standard **pageSizeId**.

        If the **QPageSize**  is invalid then the key will be empty.
        """
        ...

    @overload
    @staticmethod
    def name(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#name

        **QString QPageSize::name() const**

        Returns a localized human-readable name for the page size.

        If the **QPageSize**  instance was obtained from a print device then the
        name used is that provided by the print device. Note that a print device
        may not support the current default locale language.

        If the **QPageSize**  is invalid then the name will be an empty string.
        """
        ...

    @overload
    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#name-1

        **[static] QString QPageSize::name(QPageSize::PageSizeId pageSizeId )**

        Returns the localized name of the standard **pageSizeId**.

        If the **QPageSize**  is invalid then the name will be empty.
        """
        ...

    def rect(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rect

        **QRectF QPageSize::rect(QPageSize::Unit units ) const**

        Returns the page rectangle in the required **units**.

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    def rectPixels(self, resolution: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rectPixels

        **QRect QPageSize::rectPixels(int resolution ) const**

        Returns the page rectangle in Device Pixels at the given **resolution**.

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    def rectPoints(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rectPoints

        **QRect QPageSize::rectPoints() const**

        Returns the page rectangle in Postscript Points (1/72 of an inch).

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    @overload
    @staticmethod
    def size(
        pageSizeId: PySide6.QtGui.QPageSize.PageSizeId,
        units: PySide6.QtGui.QPageSize.Unit,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#size

        **QSizeF QPageSize::size(QPageSize::Unit units ) const**

        Returns the size of the page in the required **units**.

        If the **QPageSize**  is invalid then the **QSizeF**  will be invalid.
        """
        ...

    @overload
    def size(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#size-1

        **[static] QSizeF QPageSize::size(QPageSize::PageSizeId pageSizeId ,
        QPageSize::Unit units )**

        Returns the size of the standard **pageSizeId** in the requested
        **units**.
        """
        ...

    @overload
    @staticmethod
    def sizePixels(
        pageSizeId: PySide6.QtGui.QPageSize.PageSizeId, resolution: int
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePixels

        **QSize QPageSize::sizePixels(int resolution ) const**

        Returns the size of the page in Device Pixels at the given
        **resolution**.

        If the **QPageSize**  is invalid then the **QSize**  will be invalid.
        """
        ...

    @overload
    def sizePixels(self, resolution: int) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePixels-1

        **[static] QSize QPageSize::sizePixels(QPageSize::PageSizeId pageSizeId
        , int resolution )**

        Returns the size of the standard **pageSizeId** in Device Pixels for the
        given **resolution**.
        """
        ...

    @overload
    @staticmethod
    def sizePoints(
        pageSizeId: PySide6.QtGui.QPageSize.PageSizeId,
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePoints

        **QSize QPageSize::sizePoints() const**

        Returns the size of the page in Postscript Points (1/72 of an inch).

        If the **QPageSize**  is invalid then the **QSize**  will be invalid.
        """
        ...

    @overload
    def sizePoints(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePoints-1

        **[static] QSize QPageSize::sizePoints(QPageSize::PageSizeId pageSizeId
        )**

        Returns the size of the standard **pageSizeId** in Points.
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#swap

        **void QPageSize::swap(QPageSize & other )**

        Swaps this **QPageSize**  with **other**. This function is very fast and
        never fails.
        """
        ...

    @overload
    @staticmethod
    def windowsId(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> int:
        """
        https://doc.qt.io/qt-6/qpagesize.html#windowsId

        **int QPageSize::windowsId() const**

        Returns the Windows DMPAPER enum value for the page size.

        Not all valid PPD page sizes have a Windows equivalent, in which case 0
        will be returned.

        If the **QPageSize**  is invalid then the Windows ID will be 0.

        **See also** **id** ().
        """
        ...

    @overload
    def windowsId(self) -> int:
        """
        https://doc.qt.io/qt-6/qpagesize.html#windowsId-1

        **[static] int QPageSize::windowsId(QPageSize::PageSizeId pageSizeId )**

        Returns the Windows DMPAPER enum value of the standard **pageSizeId**.

        Not all valid PPD page sizes have a Windows equivalent, in which case 0
        will be returned.
        """
        ...
