"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPageRanges(object):
    """
    https://doc.qt.io/qt-6/qpageranges.html

    **Detailed Description**

    Use **QPagedPaintDevice::pageRanges** () to access the collection of page
    ranges associated with a paged device.
    """

    class Range(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, Range: PySide6.QtGui.QPageRanges.Range) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def contains(self, pageNumber: int) -> bool:
            ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#QPageRanges

        **QPageRanges::QPageRanges()**

        Constructs an empty QPageRanges object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QPageRanges) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#QPageRanges-1

        **QPageRanges::QPageRanges(const QPageRanges & other )**

        Constructs a QPageRanges object by copying **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def addPage(self, pageNumber: int) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#addPage

        **void QPageRanges::addPage(int pageNumber )**

        Adds the single page **pageNumber** to the ranges.

        **Note:** Page numbers start with 1. Attempts to add page numbers
        smaller than 1 will be ignored with a warning.
        """
        ...

    def addRange(self, from_: int, to: int) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#addRange

        **void QPageRanges::addRange(int from , int to )**

        Adds the range specified with **from** and **to** to the ranges.

        **Note:** Page numbers start with 1. Attempts to add page numbers
        smaller than 1 will be ignored with a warning.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#clear

        **void QPageRanges::clear()**

        Removes all page ranges.
        """
        ...

    def contains(self, pageNumber: int) -> bool:
        """
        https://doc.qt.io/qt-6/qpageranges.html#contains

        **bool QPageRanges::contains(int pageNumber ) const**

        Returns `true` if the ranges include the page **pageNumber** ; otherwise
        returns `false`.
        """
        ...

    def firstPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qpageranges.html#firstPage

        **int QPageRanges::firstPage() const**

        Returns the index of the first page covered by the page ranges, or 0 if
        the page ranges are empty.
        """
        ...

    @staticmethod
    def fromString(ranges: str) -> PySide6.QtGui.QPageRanges:
        """
        https://doc.qt.io/qt-6/qpageranges.html#fromString

        **[static] QPageRanges QPageRanges::fromString(const QString & ranges
        )**

        Constructs and returns a **QPageRanges**  object populated with the
        **ranges** from the string representation.

        **QPrinter**  printer;
            **QPageRanges**  ranges = **QPageRanges**
        ::fromString("1-3,6-7");
            printer.setPageRanges(ranges);

        In case of parsing error, returns an empty **QPageRanges**  object.

        **See also** **isEmpty** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpageranges.html#isEmpty

        **bool QPageRanges::isEmpty() const**

        Returns `true` if the ranges are empty; otherwise returns `false`.
        """
        ...

    def lastPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qpageranges.html#lastPage

        **int QPageRanges::lastPage() const**

        Returns the index of the last page covered by the page ranges, or 0 if
        the page ranges are empty.
        """
        ...

    def swap(self, other: PySide6.QtGui.QPageRanges) -> None:
        ...

    def toRangeList(self) -> List[PySide6.QtGui.QPageRanges.Range]:
        """
        https://doc.qt.io/qt-6/qpageranges.html#toRangeList

        **QList<QPageRanges::Range> QPageRanges::toRangeList() const**

        Returns a list with the values of the ranges.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qpageranges.html#toString

        **QString QPageRanges::toString() const**

        Returns the string representation of the page ranges.
        """
        ...
