"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPageLayout(object):
    """
    https://doc.qt.io/qt-6/qpagelayout.html

    **Detailed Description**

    The QPageLayout class defines the layout of a page in a paged document, with
    the page size, orientation and margins able to be set and the full page and
    paintable page rectangles defined by those attributes able to be queried in
    a variety of units.

    The page size is defined by the **QPageSize**  class which can be queried
    for page size attributes. Note that the **QPageSize**  itself is always
    defined in a Portrait orientation.

    The minimum margins can be defined for the layout but normally default to 0.
    When used in conjunction with Qt's printing support the minimum margins will
    reflect the minimum printable area defined by the printer.

    In the default **StandardMode**  the current margins and minimum margins are
    always taken into account. The paintable rectangle is the full page
    rectangle less the current margins, and the current margins can only be set
    to values between the minimum margins and the maximum margins allowed by the
    full page size.

    In **FullPageMode**  the current margins and minimum margins are not taken
    into account. The paintable rectangle is the full page rectangle, and the
    current margins can be set to any values regardless of the minimum margins
    and page size.

    **See also** **QPageSize** .
    """

    StandardMode: QPageLayout.Mode = ...
    FullPageMode: QPageLayout.Mode = ...
    Portrait: QPageLayout.Orientation = ...
    Landscape: QPageLayout.Orientation = ...
    Millimeter: QPageLayout.Unit = ...
    Point: QPageLayout.Unit = ...
    Inch: QPageLayout.Unit = ...
    Pica: QPageLayout.Unit = ...
    Didot: QPageLayout.Unit = ...
    Cicero: QPageLayout.Unit = ...

    class Mode(Enum):
        StandardMode: QPageLayout.Mode = ...
        FullPageMode: QPageLayout.Mode = ...

    class Orientation(Enum):
        Portrait: QPageLayout.Orientation = ...
        Landscape: QPageLayout.Orientation = ...

    class Unit(Enum):
        Millimeter: QPageLayout.Unit = ...
        Point: QPageLayout.Unit = ...
        Inch: QPageLayout.Unit = ...
        Pica: QPageLayout.Unit = ...
        Didot: QPageLayout.Unit = ...
        Cicero: QPageLayout.Unit = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#QPageLayout

        **QPageLayout::QPageLayout()**

        Creates an invalid QPageLayout.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QPageLayout) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#QPageLayout-1

        **QPageLayout::QPageLayout(const QPageSize & pageSize ,
        QPageLayout::Orientation orientation , const QMarginsF & margins ,
        QPageLayout::Unit units = Point, const QMarginsF & minMargins =
        QMarginsF(0, 0, 0, 0))**

        Creates a QPageLayout with the given **pageSize** , **orientation** and
        **margins** in the given **units**.

        Optionally define the minimum allowed margins **minMargins** , e.g. the
        minimum margins able to be printed by a physical print device.

        The constructed QPageLayout will be in **StandardMode** .

        The **margins** given will be clamped to the minimum margins and the
        maximum margins allowed by the page size.
        """
        ...

    @overload
    def __init__(
        self,
        pageSize: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
        orientation: PySide6.QtGui.QPageLayout.Orientation,
        margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins],
        units: PySide6.QtGui.QPageLayout.Unit = ...,
        minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#QPageLayout-2

        **QPageLayout::QPageLayout(const QPageLayout & other )**

        Copy constructor, copies **other** to this.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def fullRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#fullRect

        **QRectF QPageLayout::fullRect() const**

        Returns the full page rectangle in the current layout units.

        The page rectangle takes into account the page size and page
        orientation, but not the page margins.

        **See also** **paintRect** () and **units** ().
        """
        ...

    @overload
    def fullRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#fullRect-1

        **QRectF QPageLayout::fullRect(QPageLayout::Unit units ) const**

        Returns the full page rectangle in the required **units**.

        The page rectangle takes into account the page size and page
        orientation, but not the page margins.

        **See also** **paintRect** ().
        """
        ...

    def fullRectPixels(self, resolution: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#fullRectPixels

        **QRect QPageLayout::fullRectPixels(int resolution ) const**

        Returns the full page rectangle in device pixels for the given
        **resolution**.

        The page rectangle takes into account the page size and page
        orientation, but not the page margins.

        **See also** **paintRect** ().
        """
        ...

    def fullRectPoints(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#fullRectPoints

        **QRect QPageLayout::fullRectPoints() const**

        Returns the full page rectangle in Postscript Points (1/72 of an inch).

        The page rectangle takes into account the page size and page
        orientation, but not the page margins.

        **See also** **paintRect** ().
        """
        ...

    def isEquivalentTo(self, other: PySide6.QtGui.QPageLayout) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#isEquivalentTo

        **bool QPageLayout::isEquivalentTo(const QPageLayout & other ) const**

        Returns `true` if this page layout is equivalent to the **other** page
        layout, i.e. if the page has the same size, margins and orientation.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#isValid

        **bool QPageLayout::isValid() const**

        Returns `true` if this page layout is valid.
        """
        ...

    @overload
    def margins(self) -> PySide6.QtCore.QMarginsF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#margins

        **QMarginsF QPageLayout::margins() const**

        Returns the margins of the page layout using the currently set units.

        **See also** **setMargins** () and **units** ().
        """
        ...

    @overload
    def margins(
        self, units: PySide6.QtGui.QPageLayout.Unit
    ) -> PySide6.QtCore.QMarginsF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#margins-1

        **QMarginsF QPageLayout::margins(QPageLayout::Unit units ) const**

        Returns the margins of the page layout using the requested **units**.

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def marginsPixels(self, resolution: int) -> PySide6.QtCore.QMargins:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#marginsPixels

        **QMargins QPageLayout::marginsPixels(int resolution ) const**

        Returns the margins of the page layout in device pixels for the given
        **resolution**.

        **See also** **setMargins** ().
        """
        ...

    def marginsPoints(self) -> PySide6.QtCore.QMargins:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#marginsPoints

        **QMargins QPageLayout::marginsPoints() const**

        Returns the margins of the page layout in Postscript Points (1/72 of an
        inch).

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def maximumMargins(self) -> PySide6.QtCore.QMarginsF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#maximumMargins

        **QMarginsF QPageLayout::maximumMargins() const**

        Returns the maximum margins that would be applied if the page layout was
        in **StandardMode** .

        The maximum margins allowed are calculated as the full size of the page
        minus the minimum margins set. For example, if the page width is 100
        points and the minimum right margin is 10 points, then the maximum left
        margin will be 90 points.

        **See also** **setMinimumMargins** () and **minimumMargins** ().
        """
        ...

    def minimumMargins(self) -> PySide6.QtCore.QMarginsF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#minimumMargins

        **QMarginsF QPageLayout::minimumMargins() const**

        Returns the minimum margins of the page layout.

        **See also** **setMinimumMargins** () and **maximumMargins** ().
        """
        ...

    def mode(self) -> PySide6.QtGui.QPageLayout.Mode:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#mode

        **QPageLayout::Mode QPageLayout::mode() const**

        Returns the page layout mode.

        **See also** **setMode** ().
        """
        ...

    def orientation(self) -> PySide6.QtGui.QPageLayout.Orientation:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#orientation

        **QPageLayout::Orientation QPageLayout::orientation() const**

        Returns the page orientation of the page layout.

        **See also** **setOrientation** ().
        """
        ...

    def pageSize(self) -> PySide6.QtGui.QPageSize:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#pageSize

        **QPageSize QPageLayout::pageSize() const**

        Returns the page size of the page layout.

        Note that the **QPageSize**  is always defined in a Portrait
        orientation. To obtain a size that takes the set orientation into
        account you must use **fullRect** ().

        **See also** **setPageSize** ().
        """
        ...

    @overload
    def paintRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#paintRect

        **QRectF QPageLayout::paintRect() const**

        Returns the page rectangle in the current layout units.

        The paintable rectangle takes into account the page size, orientation
        and margins.

        If the **FullPageMode**  mode is set then the **fullRect** () is
        returned and the margins must be manually managed.
        """
        ...

    @overload
    def paintRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#paintRect-1

        **QRectF QPageLayout::paintRect(QPageLayout::Unit units ) const**

        Returns the page rectangle in the required **units**.

        The paintable rectangle takes into account the page size, orientation
        and margins.

        If the **FullPageMode**  mode is set then the **fullRect** () is
        returned and the margins must be manually managed.
        """
        ...

    def paintRectPixels(self, resolution: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#paintRectPixels

        **QRect QPageLayout::paintRectPixels(int resolution ) const**

        Returns the paintable rectangle in rounded device pixels for the given
        **resolution**.

        The paintable rectangle takes into account the page size, orientation
        and margins.

        If the **FullPageMode**  mode is set then the **fullRect** () is
        returned and the margins must be manually managed.
        """
        ...

    def paintRectPoints(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#paintRectPoints

        **QRect QPageLayout::paintRectPoints() const**

        Returns the paintable rectangle in rounded Postscript Points (1/72 of an
        inch).

        The paintable rectangle takes into account the page size, orientation
        and margins.

        If the **FullPageMode**  mode is set then the **fullRect** () is
        returned and the margins must be manually managed.
        """
        ...

    def setBottomMargin(self, bottomMargin: float) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setBottomMargin

        **bool QPageLayout::setBottomMargin(qreal bottomMargin )**

        Sets the bottom page margin of the page layout to **bottomMargin**.
        Returns true if the margin was successfully set.

        The units used are those currently defined for the layout. To use
        different units call **setUnits** () first.

        If in the default **StandardMode**  then the new margin must fall
        between the minimum margin set and the maximum margin allowed by the
        page size, otherwise the margin will not be set.

        If in **FullPageMode**  then any margin values will be accepted.

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def setLeftMargin(self, leftMargin: float) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setLeftMargin

        **bool QPageLayout::setLeftMargin(qreal leftMargin )**

        Sets the left page margin of the page layout to **leftMargin**. Returns
        true if the margin was successfully set.

        The units used are those currently defined for the layout. To use
        different units call **setUnits** () first.

        If in the default **StandardMode**  then the new margin must fall
        between the minimum margin set and the maximum margin allowed by the
        page size, otherwise the margin will not be set.

        If in **FullPageMode**  then any margin values will be accepted.

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def setMargins(
        self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setMargins

        **bool QPageLayout::setMargins(const QMarginsF & margins )**

        Sets the page margins of the page layout to **margins** Returns true if
        the margins were successfully set.

        The units used are those currently defined for the layout. To use
        different units then call **setUnits** () first.

        If in the default **StandardMode**  then all the new margins must fall
        between the minimum margins set and the maximum margins allowed by the
        page size, otherwise the margins will not be set.

        If in **FullPageMode**  then any margin values will be accepted.

        **See also** **margins** () and **units** ().
        """
        ...

    def setMinimumMargins(
        self, minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setMinimumMargins

        **void QPageLayout::setMinimumMargins(const QMarginsF & minMargins )**

        Sets the minimum page margins of the page layout to **minMargins**.

        It is not recommended to override the default values set for a page size
        as this may be the minimum printable area for a physical print device.

        If the **StandardMode**  mode is set then the existing margins will be
        clamped to the new **minMargins** and the maximum allowed by the page
        size. If the **FullPageMode**  is set then the existing margins will be
        unchanged.

        **See also** **minimumMargins** () and **setMargins** ().
        """
        ...

    def setMode(self, mode: PySide6.QtGui.QPageLayout.Mode) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setMode

        **void QPageLayout::setMode(QPageLayout::Mode mode )**

        Sets a page layout mode to **mode**.

        **See also** **mode** ().
        """
        ...

    def setOrientation(
        self, orientation: PySide6.QtGui.QPageLayout.Orientation
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setOrientation

        **void QPageLayout::setOrientation(QPageLayout::Orientation orientation
        )**

        Sets the page orientation of the page layout to **orientation**.

        Changing the orientation does not affect the current margins or the
        minimum margins.

        **See also** **orientation** ().
        """
        ...

    def setPageSize(
        self,
        pageSize: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
        minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setPageSize

        **void QPageLayout::setPageSize(const QPageSize & pageSize , const
        QMarginsF & minMargins = QMarginsF(0, 0, 0, 0))**

        Sets the page size of the page layout to **pageSize**.

        Optionally define the minimum allowed margins **minMargins** , e.g. the
        minimum margins able to be printed by a physical print device, otherwise
        the minimum margins will default to 0.

        If **StandardMode**  is set then the existing margins will be clamped to
        the new minimum margins and the maximum margins allowed by the page
        size. If **FullPageMode**  is set then the existing margins will be
        unchanged.

        **See also** **pageSize** ().
        """
        ...

    def setRightMargin(self, rightMargin: float) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setRightMargin

        **bool QPageLayout::setRightMargin(qreal rightMargin )**

        Sets the right page margin of the page layout to **rightMargin**.
        Returns true if the margin was successfully set.

        The units used are those currently defined for the layout. To use
        different units call **setUnits** () first.

        If in the default **StandardMode**  then the new margin must fall
        between the minimum margin set and the maximum margin allowed by the
        page size, otherwise the margin will not be set.

        If in **FullPageMode**  then any margin values will be accepted.

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def setTopMargin(self, topMargin: float) -> bool:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setTopMargin

        **bool QPageLayout::setTopMargin(qreal topMargin )**

        Sets the top page margin of the page layout to **topMargin**. Returns
        true if the margin was successfully set.

        The units used are those currently defined for the layout. To use
        different units call **setUnits** () first.

        If in the default **StandardMode**  then the new margin must fall
        between the minimum margin set and the maximum margin allowed by the
        page size, otherwise the margin will not be set.

        If in **FullPageMode**  then any margin values will be accepted.

        **See also** **setMargins** () and **margins** ().
        """
        ...

    def setUnits(self, units: PySide6.QtGui.QPageLayout.Unit) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#setUnits

        **void QPageLayout::setUnits(QPageLayout::Unit units )**

        Sets the **units** used to define the page layout.

        **See also** **units** ().
        """
        ...

    def swap(self, other: PySide6.QtGui.QPageLayout) -> None:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#swap

        **void QPageLayout::swap(QPageLayout & other )**

        Swaps this page layout with **other**. This function is very fast and
        never fails.
        """
        ...

    def units(self) -> PySide6.QtGui.QPageLayout.Unit:
        """
        https://doc.qt.io/qt-6/qpagelayout.html#units

        **QPageLayout::Unit QPageLayout::units() const**

        Returns the units the page layout is currently defined in.

        **See also** **setUnits** ().
        """
        ...
