"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QOpenGLFunctions(object):
    """
    https://doc.qt.io/qt-6/qopenglfunctions.html

    **Detailed Description**

    OpenGL ES 2.0 defines a subset of the OpenGL specification that is common
    across many desktop and embedded OpenGL implementations. However, it can be
    difficult to use the functions from that subset because they need to be
    resolved manually on desktop systems.

    QOpenGLFunctions provides a guaranteed API that is available on all OpenGL
    systems and takes care of function resolution on systems that need it. The
    recommended way to use QOpenGLFunctions is by direct inheritance:

    class MyGLWindow : public **QWindow** , protected **QOpenGLFunctions**
    {
            Q_OBJECT
        public:
            explicit MyGLWindow(**QScreen**
    *screen = nullptr);

        protected:
            void initializeGL();
    void paintGL();

            **QOpenGLContext**  *m_context;
        };
    MyGLWindow::MyGLWindow(**QScreen**  *screen)
          : **QWindow** (screen)
    {
            setSurfaceType(OpenGLSurface);
            create();

            //
    Create an OpenGL context
            m_context = new **QOpenGLContext** ;
    m_context->create();

            // Setup scene and render it
    initializeGL();
            paintGL();
        };

        void
    MyGLWindow::initializeGL()
        {
            m_context->makeCurrent(this);
    initializeOpenGLFunctions();
        }

    The `paintGL()` function can then use any of the OpenGL ES 2.0 functions
    without explicit resolution, such as **glActiveTexture** () in the following
    example:

    void MyGLWindow::paintGL()
        {
            m_context->makeCurrent(this);
    glActiveTexture(GL_TEXTURE1);
            glBindTexture(GL_TEXTURE_2D,
    textureId);
            // ...
            m_context->swapBuffers(this);
    m_context->doneCurrent();
        }

    QOpenGLFunctions can also be used directly for ad-hoc invocation of OpenGL
    ES 2.0 functions on all platforms:

    **QOpenGLFunctions**  glFuncs(**QOpenGLContext** ::currentContext());
    glFuncs.glActiveTexture(GL_TEXTURE1);

    An alternative approach is to query the context's associated
    QOpenGLFunctions instance. This is somewhat faster than the previous
    approach due to avoiding the creation of a new instance, but the difference
    is fairly small since the internal data structures are shared, and function
    resolving happens only once for a given context, regardless of the number of
    QOpenGLFunctions instances initialized for it.

    **QOpenGLFunctions**  *glFuncs = **QOpenGLContext**
    ::currentContext()->functions();
        glFuncs->glActiveTexture(GL_TEXTURE1);

    QOpenGLFunctions provides wrappers for all OpenGL ES 2.0 functions,
    including the common subset of OpenGL 1.x and ES 2.0. While such functions,
    for example **glClear** () or **glDrawArrays** (), can be called also
    directly, as long as the application links to the platform-specific OpenGL
    library, calling them via QOpenGLFunctions enables the possibility of
    dynamically loading the OpenGL implementation.

    The **hasOpenGLFeature** () and **openGLFeatures** () functions can be used
    to determine if the OpenGL implementation has a major OpenGL ES 2.0 feature.
    For example, the following checks if non power of two textures are
    available:

    **QOpenGLFunctions**  funcs(**QOpenGLContext** ::currentContext());
        bool
    npot = funcs.hasOpenGLFeature(**QOpenGLFunctions** ::NPOTTextures);

    **See also** **QOpenGLContext**  and **QSurfaceFormat** .
    """

    Multitexture: QOpenGLFunctions.OpenGLFeature = ...
    Shaders: QOpenGLFunctions.OpenGLFeature = ...
    Buffers: QOpenGLFunctions.OpenGLFeature = ...
    Framebuffers: QOpenGLFunctions.OpenGLFeature = ...
    BlendColor: QOpenGLFunctions.OpenGLFeature = ...
    BlendEquation: QOpenGLFunctions.OpenGLFeature = ...
    BlendEquationSeparate: QOpenGLFunctions.OpenGLFeature = ...
    BlendFuncSeparate: QOpenGLFunctions.OpenGLFeature = ...
    BlendSubtract: QOpenGLFunctions.OpenGLFeature = ...
    CompressedTextures: QOpenGLFunctions.OpenGLFeature = ...
    Multisample: QOpenGLFunctions.OpenGLFeature = ...
    StencilSeparate: QOpenGLFunctions.OpenGLFeature = ...
    NPOTTextures: QOpenGLFunctions.OpenGLFeature = ...
    NPOTTextureRepeat: QOpenGLFunctions.OpenGLFeature = ...
    FixedFunctionPipeline: QOpenGLFunctions.OpenGLFeature = ...
    TextureRGFormats: QOpenGLFunctions.OpenGLFeature = ...
    MultipleRenderTargets: QOpenGLFunctions.OpenGLFeature = ...
    BlendEquationAdvanced: QOpenGLFunctions.OpenGLFeature = ...

    class OpenGLFeature(Enum):
        Multitexture: QOpenGLFunctions.OpenGLFeature = ...
        Shaders: QOpenGLFunctions.OpenGLFeature = ...
        Buffers: QOpenGLFunctions.OpenGLFeature = ...
        Framebuffers: QOpenGLFunctions.OpenGLFeature = ...
        BlendColor: QOpenGLFunctions.OpenGLFeature = ...
        BlendEquation: QOpenGLFunctions.OpenGLFeature = ...
        BlendEquationSeparate: QOpenGLFunctions.OpenGLFeature = ...
        BlendFuncSeparate: QOpenGLFunctions.OpenGLFeature = ...
        BlendSubtract: QOpenGLFunctions.OpenGLFeature = ...
        CompressedTextures: QOpenGLFunctions.OpenGLFeature = ...
        Multisample: QOpenGLFunctions.OpenGLFeature = ...
        StencilSeparate: QOpenGLFunctions.OpenGLFeature = ...
        NPOTTextures: QOpenGLFunctions.OpenGLFeature = ...
        NPOTTextureRepeat: QOpenGLFunctions.OpenGLFeature = ...
        FixedFunctionPipeline: QOpenGLFunctions.OpenGLFeature = ...
        TextureRGFormats: QOpenGLFunctions.OpenGLFeature = ...
        MultipleRenderTargets: QOpenGLFunctions.OpenGLFeature = ...
        BlendEquationAdvanced: QOpenGLFunctions.OpenGLFeature = ...

    class OpenGLFeatures(object):
        ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#QOpenGLFunctions

        **QOpenGLFunctions::QOpenGLFunctions()**

        Constructs a default function resolver. The resolver cannot be used
        until **initializeOpenGLFunctions** () is called to specify the context.

        **See also** **initializeOpenGLFunctions** ().
        """
        ...

    @overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#QOpenGLFunctions-1

        **QOpenGLFunctions::QOpenGLFunctions(QOpenGLContext * context )**

        Constructs a function resolver for **context**. If **context** is
        `nullptr`, then the resolver will be created for the current
        **QOpenGLContext** .

        The context or another context in the group must be current.

        An object constructed in this way can only be used with **context** and
        other contexts that share with it. Use **initializeOpenGLFunctions** ()
        to change the object's context association.

        **See also** **initializeOpenGLFunctions** ().
        """
        ...

    def glActiveTexture(self, texture: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glActiveTexture

        **void QOpenGLFunctions::glActiveTexture(GLenum texture )**

        Convenience function that calls glActiveTexture( **texture** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glActiveTexture()** .
        """
        ...

    def glAttachShader(self, program: int, shader: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glAttachShader

        **void QOpenGLFunctions::glAttachShader(GLuint program , GLuint shader
        )**

        Convenience function that calls glAttachShader( **program** , **shader**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glAttachShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glBindAttribLocation(self, program: int, index: int, name: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBindAttribLocation

        **void QOpenGLFunctions::glBindAttribLocation(GLuint program , GLuint
        index , const char * name )**

        Convenience function that calls glBindAttribLocation( **program** ,
        **index** , **name** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBindAttribLocation()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glBindBuffer(self, target: int, buffer: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBindBuffer

        **void QOpenGLFunctions::glBindBuffer(GLenum target , GLuint buffer )**

        Convenience function that calls glBindBuffer( **target** , **buffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBindBuffer()** .
        """
        ...

    def glBindFramebuffer(self, target: int, framebuffer: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBindFramebuffer

        **void QOpenGLFunctions::glBindFramebuffer(GLenum target , GLuint
        framebuffer )**

        Convenience function that calls glBindFramebuffer( **target** ,
        **framebuffer** ).

        Note that Qt will translate a **framebuffer** argument of 0 to the
        currently bound **QOpenGLContext** 's defaultFramebufferObject().

        For more information, see the OpenGL ES 3.X documentation for
        **glBindFramebuffer()** .
        """
        ...

    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBindRenderbuffer

        **void QOpenGLFunctions::glBindRenderbuffer(GLenum target , GLuint
        renderbuffer )**

        Convenience function that calls glBindRenderbuffer( **target** ,
        **renderbuffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBindRenderbuffer()** .
        """
        ...

    def glBindTexture(self, target: int, texture: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBindTexture

        **[since 5.3] void QOpenGLFunctions::glBindTexture(GLenum target ,
        GLuint texture )**

        Convenience function that calls glBindTexture( **target** , **texture**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBindTexture()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBlendColor

        **void QOpenGLFunctions::glBlendColor(GLclampf red , GLclampf green ,
        GLclampf blue , GLclampf alpha )**

        Convenience function that calls glBlendColor( **red** , **green** ,
        **blue** , **alpha** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendColor()** .
        """
        ...

    def glBlendEquation(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBlendEquation

        **void QOpenGLFunctions::glBlendEquation(GLenum mode )**

        Convenience function that calls glBlendEquation( **mode** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendEquation()** .
        """
        ...

    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBlendEquationSeparate

        **void QOpenGLFunctions::glBlendEquationSeparate(GLenum modeRGB , GLenum
        modeAlpha )**

        Convenience function that calls glBlendEquationSeparate( **modeRGB** ,
        **modeAlpha** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendEquationSeparate()** .
        """
        ...

    def glBlendFunc(self, sfactor: int, dfactor: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBlendFunc

        **[since 5.3] void QOpenGLFunctions::glBlendFunc(GLenum sfactor , GLenum
        dfactor )**

        Convenience function that calls glBlendFunc( **sfactor** , **dfactor**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendFunc()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glBlendFuncSeparate(
        self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glBlendFuncSeparate

        **void QOpenGLFunctions::glBlendFuncSeparate(GLenum srcRGB , GLenum
        dstRGB , GLenum srcAlpha , GLenum dstAlpha )**

        Convenience function that calls glBlendFuncSeparate( **srcRGB** ,
        **dstRGB** , **srcAlpha** , **dstAlpha** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendFuncSeparate()** .
        """
        ...

    def glCheckFramebufferStatus(self, target: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCheckFramebufferStatus

        **GLenum QOpenGLFunctions::glCheckFramebufferStatus(GLenum target )**

        Convenience function that calls glCheckFramebufferStatus( **target** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCheckFramebufferStatus()** .
        """
        ...

    def glClear(self, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glClear

        **[since 5.3] void QOpenGLFunctions::glClear(GLbitfield mask )**

        Convenience function that calls glClear( **mask** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glClear()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glClearColor

        **[since 5.3] void QOpenGLFunctions::glClearColor(GLclampf red ,
        GLclampf green , GLclampf blue , GLclampf alpha )**

        Convenience function that calls glClearColor( **red** , **green** ,
        **blue** , **alpha** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glClearColor()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glClearDepthf(self, depth: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glClearDepthf

        **void QOpenGLFunctions::glClearDepthf(GLclampf depth )**

        Convenience function that calls glClearDepth( **depth** ) on desktop
        OpenGL systems and glClearDepthf( **depth** ) on embedded OpenGL ES
        systems.

        For more information, see the OpenGL ES 3.X documentation for
        **glClearDepthf()** .
        """
        ...

    def glClearStencil(self, s: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glClearStencil

        **[since 5.3] void QOpenGLFunctions::glClearStencil(GLint s )**

        Convenience function that calls glClearStencil( **s** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glClearStencil()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glColorMask

        **[since 5.3] void QOpenGLFunctions::glColorMask(GLboolean red ,
        GLboolean green , GLboolean blue , GLboolean alpha )**

        Convenience function that calls glColorMask( **red** , **green** ,
        **blue** , **alpha** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glColorMask()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glCompileShader(self, shader: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCompileShader

        **void QOpenGLFunctions::glCompileShader(GLuint shader )**

        Convenience function that calls glCompileShader( **shader** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCompileShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glCompressedTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        border: int,
        imageSize: int,
        data: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCompressedTexImage2D

        **void QOpenGLFunctions::glCompressedTexImage2D(GLenum target , GLint
        level , GLenum internalformat , GLsizei width , GLsizei height , GLint
        border , GLsizei imageSize , const void * data )**

        Convenience function that calls glCompressedTexImage2D( **target** ,
        **level** , **internalformat** , **width** , **height** , **border** ,
        **imageSize** , **data** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCompressedTexImage2D()** .
        """
        ...

    def glCompressedTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCompressedTexSubImage2D

        **void QOpenGLFunctions::glCompressedTexSubImage2D(GLenum target , GLint
        level , GLint xoffset , GLint yoffset , GLsizei width , GLsizei height ,
        GLenum format , GLsizei imageSize , const void * data )**

        Convenience function that calls glCompressedTexSubImage2D( **target** ,
        **level** , **xoffset** , **yoffset** , **width** , **height** ,
        **format** , **imageSize** , **data** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCompressedTexSubImage2D()** .
        """
        ...

    def glCopyTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        x: int,
        y: int,
        width: int,
        height: int,
        border: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCopyTexImage2D

        **[since 5.3] void QOpenGLFunctions::glCopyTexImage2D(GLenum target ,
        GLint level , GLenum internalformat , GLint x , GLint y , GLsizei width
        , GLsizei height , GLint border )**

        Convenience function that calls glCopyTexImage2D( **target** , **level**
        , **internalformat** , **x** , **y** , **width** , **height** ,
        **border** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCopyTexImage2D()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glCopyTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCopyTexSubImage2D

        **[since 5.3] void QOpenGLFunctions::glCopyTexSubImage2D(GLenum target ,
        GLint level , GLint xoffset , GLint yoffset , GLint x , GLint y ,
        GLsizei width , GLsizei height )**

        Convenience function that calls glCopyTexSubImage2D( **target** ,
        **level** , **xoffset** , **yoffset** , **x** , **y** , **width** ,
        **height** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCopyTexSubImage2D()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glCreateProgram(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCreateProgram

        **GLuint QOpenGLFunctions::glCreateProgram()**

        Convenience function that calls glCreateProgram().

        For more information, see the OpenGL ES 3.X documentation for
        **glCreateProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glCreateShader(self, type: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCreateShader

        **GLuint QOpenGLFunctions::glCreateShader(GLenum type )**

        Convenience function that calls glCreateShader( **type** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCreateShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glCullFace(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glCullFace

        **[since 5.3] void QOpenGLFunctions::glCullFace(GLenum mode )**

        Convenience function that calls glCullFace( **mode** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glCullFace()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDeleteBuffers(self, n: int, buffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteBuffers

        **void QOpenGLFunctions::glDeleteBuffers(GLsizei n , const GLuint *
        buffers )**

        Convenience function that calls glDeleteBuffers( **n** , **buffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteBuffers()** .
        """
        ...

    def glDeleteFramebuffers(self, n: int, framebuffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteFramebuffers

        **void QOpenGLFunctions::glDeleteFramebuffers(GLsizei n , const GLuint *
        framebuffers )**

        Convenience function that calls glDeleteFramebuffers( **n** ,
        **framebuffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteFramebuffers()** .
        """
        ...

    def glDeleteProgram(self, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteProgram

        **void QOpenGLFunctions::glDeleteProgram(GLuint program )**

        Convenience function that calls glDeleteProgram( **program** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glDeleteRenderbuffers(self, n: int, renderbuffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteRenderbuffers

        **void QOpenGLFunctions::glDeleteRenderbuffers(GLsizei n , const GLuint
        * renderbuffers )**

        Convenience function that calls glDeleteRenderbuffers( **n** ,
        **renderbuffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteRenderbuffers()** .
        """
        ...

    def glDeleteShader(self, shader: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteShader

        **void QOpenGLFunctions::glDeleteShader(GLuint shader )**

        Convenience function that calls glDeleteShader( **shader** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glDeleteTextures(self, n: int, textures: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDeleteTextures

        **[since 5.3] void QOpenGLFunctions::glDeleteTextures(GLsizei n , const
        GLuint * textures )**

        Convenience function that calls glDeleteTextures( **n** , **textures**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDeleteTextures()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDepthFunc(self, func: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDepthFunc

        **[since 5.3] void QOpenGLFunctions::glDepthFunc(GLenum func )**

        Convenience function that calls glDepthFunc( **func** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDepthFunc()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDepthMask(self, flag: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDepthMask

        **[since 5.3] void QOpenGLFunctions::glDepthMask(GLboolean flag )**

        Convenience function that calls glDepthMask( **flag** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDepthMask()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDepthRangef(self, zNear: float, zFar: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDepthRangef

        **void QOpenGLFunctions::glDepthRangef(GLclampf zNear , GLclampf zFar
        )**

        Convenience function that calls glDepthRange( **zNear** , **zFar** ) on
        desktop OpenGL systems and glDepthRangef( **zNear** , **zFar** ) on
        embedded OpenGL ES systems.

        For more information, see the OpenGL ES 3.X documentation for
        **glDepthRangef()** .
        """
        ...

    def glDetachShader(self, program: int, shader: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDetachShader

        **void QOpenGLFunctions::glDetachShader(GLuint program , GLuint shader
        )**

        Convenience function that calls glDetachShader( **program** , **shader**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDetachShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glDisable(self, cap: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDisable

        **[since 5.3] void QOpenGLFunctions::glDisable(GLenum cap )**

        Convenience function that calls glDisable( **cap** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDisable()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDisableVertexAttribArray(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDisableVertexAttribArray

        **void QOpenGLFunctions::glDisableVertexAttribArray(GLuint index )**

        Convenience function that calls glDisableVertexAttribArray( **index** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDisableVertexAttribArray()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glDrawArrays(self, mode: int, first: int, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDrawArrays

        **[since 5.3] void QOpenGLFunctions::glDrawArrays(GLenum mode , GLint
        first , GLsizei count )**

        Convenience function that calls glDrawArrays( **mode** , **first** ,
        **count** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDrawArrays()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glDrawElements(self, mode: int, count: int, type: int, indices: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glDrawElements

        **[since 5.3] void QOpenGLFunctions::glDrawElements(GLenum mode ,
        GLsizei count , GLenum type , const GLvoid * indices )**

        Convenience function that calls glDrawElements( **mode** , **count** ,
        **type** , **indices** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glDrawElements()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glEnable(self, cap: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glEnable

        **[since 5.3] void QOpenGLFunctions::glEnable(GLenum cap )**

        Convenience function that calls glEnable( **cap** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glEnable()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glEnableVertexAttribArray(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glEnableVertexAttribArray

        **void QOpenGLFunctions::glEnableVertexAttribArray(GLuint index )**

        Convenience function that calls glEnableVertexAttribArray( **index** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glEnableVertexAttribArray()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glFinish(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glFinish

        **[since 5.3] void QOpenGLFunctions::glFinish()**

        Convenience function that calls glFinish().

        For more information, see the OpenGL ES 3.X documentation for
        **glFinish()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glFlush(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glFlush

        **[since 5.3] void QOpenGLFunctions::glFlush()**

        Convenience function that calls glFlush().

        For more information, see the OpenGL ES 3.X documentation for
        **glFlush()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glFramebufferRenderbuffer(
        self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glFramebufferRenderbuffer

        **void QOpenGLFunctions::glFramebufferRenderbuffer(GLenum target ,
        GLenum attachment , GLenum renderbuffertarget , GLuint renderbuffer )**

        Convenience function that calls glFramebufferRenderbuffer( **target** ,
        **attachment** , **renderbuffertarget** , **renderbuffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glFramebufferRenderbuffer()** .
        """
        ...

    def glFramebufferTexture2D(
        self, target: int, attachment: int, textarget: int, texture: int, level: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glFramebufferTexture2D

        **void QOpenGLFunctions::glFramebufferTexture2D(GLenum target , GLenum
        attachment , GLenum textarget , GLuint texture , GLint level )**

        Convenience function that calls glFramebufferTexture2D( **target** ,
        **attachment** , **textarget** , **texture** , **level** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glFramebufferTexture2D()** .
        """
        ...

    def glFrontFace(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glFrontFace

        **[since 5.3] void QOpenGLFunctions::glFrontFace(GLenum mode )**

        Convenience function that calls glFrontFace( **mode** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glFrontFace()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGenBuffers(self, n: int, buffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGenBuffers

        **void QOpenGLFunctions::glGenBuffers(GLsizei n , GLuint * buffers )**

        Convenience function that calls glGenBuffers( **n** , **buffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGenBuffers()** .
        """
        ...

    def glGenFramebuffers(self, n: int, framebuffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGenFramebuffers

        **void QOpenGLFunctions::glGenFramebuffers(GLsizei n , GLuint *
        framebuffers )**

        Convenience function that calls glGenFramebuffers( **n** ,
        **framebuffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGenFramebuffers()** .
        """
        ...

    def glGenRenderbuffers(self, n: int, renderbuffers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGenRenderbuffers

        **void QOpenGLFunctions::glGenRenderbuffers(GLsizei n , GLuint *
        renderbuffers )**

        Convenience function that calls glGenRenderbuffers( **n** ,
        **renderbuffers** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGenRenderbuffers()** .
        """
        ...

    def glGenTextures(self, n: int, textures: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGenTextures

        **[since 5.3] void QOpenGLFunctions::glGenTextures(GLsizei n , GLuint *
        textures )**

        Convenience function that calls glGenTextures( **n** , **textures** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGenTextures()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGenerateMipmap(self, target: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGenerateMipmap

        **void QOpenGLFunctions::glGenerateMipmap(GLenum target )**

        Convenience function that calls glGenerateMipmap( **target** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGenerateMipmap()** .
        """
        ...

    def glGetAttachedShaders(
        self, program: int, maxcount: int, count: Sequence[int], shaders: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetAttachedShaders

        **void QOpenGLFunctions::glGetAttachedShaders(GLuint program , GLsizei
        maxcount , GLsizei * count , GLuint * shaders )**

        Convenience function that calls glGetAttachedShaders( **program** ,
        **maxcount** , **count** , **shaders** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetAttachedShaders()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetAttribLocation(self, program: int, name: bytes) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetAttribLocation

        **GLint QOpenGLFunctions::glGetAttribLocation(GLuint program , const
        char * name )**

        Convenience function that calls glGetAttribLocation( **program** ,
        **name** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetAttribLocation()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetBufferParameteriv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetBufferParameteriv

        **void QOpenGLFunctions::glGetBufferParameteriv(GLenum target , GLenum
        pname , GLint * params )**

        Convenience function that calls glGetBufferParameteriv( **target** ,
        **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetBufferParameteriv()** .
        """
        ...

    def glGetError(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetError

        **[since 5.3] GLenum QOpenGLFunctions::glGetError()**

        Convenience function that calls glGetError().

        For more information, see the OpenGL ES 3.X documentation for
        **glGetError()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetFloatv(self, pname: int, params: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetFloatv

        **[since 5.3] void QOpenGLFunctions::glGetFloatv(GLenum pname , GLfloat
        * params )**

        Convenience function that calls glGetFloatv( **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetFloatv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetFramebufferAttachmentParameteriv(
        self, target: int, attachment: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetFramebufferAttachmentP
        arameteriv

        **void QOpenGLFunctions::glGetFramebufferAttachmentParameteriv(GLenum
        target , GLenum attachment , GLenum pname , GLint * params )**

        Convenience function that calls glGetFramebufferAttachmentParameteriv(
        **target** , **attachment** , **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetFramebufferAttachmentParameteriv()** .
        """
        ...

    def glGetIntegerv(self, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetIntegerv

        **[since 5.3] void QOpenGLFunctions::glGetIntegerv(GLenum pname , GLint
        * params )**

        Convenience function that calls glGetIntegerv( **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetIntegerv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetProgramiv(self, program: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetProgramiv

        **void QOpenGLFunctions::glGetProgramiv(GLuint program , GLenum pname ,
        GLint * params )**

        Convenience function that calls glGetProgramiv( **program** , **pname**
        , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetProgramiv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetRenderbufferParameteriv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetRenderbufferParameteri
        v

        **void QOpenGLFunctions::glGetRenderbufferParameteriv(GLenum target ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetRenderbufferParameteriv( **target**
        , **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetRenderbufferParameteriv()** .
        """
        ...

    def glGetShaderPrecisionFormat(
        self,
        shadertype: int,
        precisiontype: int,
        range: Sequence[int],
        precision: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetShaderPrecisionFormat

        **void QOpenGLFunctions::glGetShaderPrecisionFormat(GLenum shadertype ,
        GLenum precisiontype , GLint * range , GLint * precision )**

        Convenience function that calls glGetShaderPrecisionFormat(
        **shadertype** , **precisiontype** , **range** , **precision** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetShaderPrecisionFormat()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetShaderSource(self, shader: int) -> bytes:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetShaderSource

        **void QOpenGLFunctions::glGetShaderSource(GLuint shader , GLsizei
        bufsize , GLsizei * length , char * source )**

        Convenience function that calls glGetShaderSource( **shader** ,
        **bufsize** , **length** , **source** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetShaderSource()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetShaderiv(self, shader: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetShaderiv

        **void QOpenGLFunctions::glGetShaderiv(GLuint shader , GLenum pname ,
        GLint * params )**

        Convenience function that calls glGetShaderiv( **shader** , **pname** ,
        **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetShaderiv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetString(self, name: int) -> str:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetString

        **[since 5.3] const GLubyte *QOpenGLFunctions::glGetString(GLenum name
        )**

        Convenience function that calls glGetString( **name** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetString()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetTexParameterfv(
        self, target: int, pname: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetTexParameterfv

        **[since 5.3] void QOpenGLFunctions::glGetTexParameterfv(GLenum target ,
        GLenum pname , GLfloat * params )**

        Convenience function that calls glGetTexParameterfv( **target** ,
        **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetTexParameterfv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetTexParameteriv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetTexParameteriv

        **[since 5.3] void QOpenGLFunctions::glGetTexParameteriv(GLenum target ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetTexParameteriv( **target** ,
        **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetTexParameteriv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glGetUniformLocation(self, program: int, name: bytes) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetUniformLocation

        **GLint QOpenGLFunctions::glGetUniformLocation(GLuint program , const
        char * name )**

        Convenience function that calls glGetUniformLocation( **program** ,
        **name** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetUniformLocation()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetUniformfv(
        self, program: int, location: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetUniformfv

        **void QOpenGLFunctions::glGetUniformfv(GLuint program , GLint location
        , GLfloat * params )**

        Convenience function that calls glGetUniformfv( **program** ,
        **location** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetUniformfv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetUniformiv(
        self, program: int, location: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetUniformiv

        **void QOpenGLFunctions::glGetUniformiv(GLuint program , GLint location
        , GLint * params )**

        Convenience function that calls glGetUniformiv( **program** ,
        **location** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetUniformiv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetVertexAttribfv(
        self, index: int, pname: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetVertexAttribfv

        **void QOpenGLFunctions::glGetVertexAttribfv(GLuint index , GLenum pname
        , GLfloat * params )**

        Convenience function that calls glGetVertexAttribfv( **index** ,
        **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetVertexAttribfv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glGetVertexAttribiv(
        self, index: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glGetVertexAttribiv

        **void QOpenGLFunctions::glGetVertexAttribiv(GLuint index , GLenum pname
        , GLint * params )**

        Convenience function that calls glGetVertexAttribiv( **index** ,
        **pname** , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glGetVertexAttribiv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glHint(self, target: int, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glHint

        **[since 5.3] void QOpenGLFunctions::glHint(GLenum target , GLenum mode
        )**

        Convenience function that calls glHint( **target** , **mode** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glHint()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glIsBuffer(self, buffer: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsBuffer

        **GLboolean QOpenGLFunctions::glIsBuffer(GLuint buffer )**

        Convenience function that calls glIsBuffer( **buffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsBuffer()** .
        """
        ...

    def glIsEnabled(self, cap: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsEnabled

        **[since 5.3] GLboolean QOpenGLFunctions::glIsEnabled(GLenum cap )**

        Convenience function that calls glIsEnabled( **cap** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsEnabled()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glIsFramebuffer(self, framebuffer: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsFramebuffer

        **GLboolean QOpenGLFunctions::glIsFramebuffer(GLuint framebuffer )**

        Convenience function that calls glIsFramebuffer( **framebuffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsFramebuffer()** .
        """
        ...

    def glIsProgram(self, program: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsProgram

        **GLboolean QOpenGLFunctions::glIsProgram(GLuint program )**

        Convenience function that calls glIsProgram( **program** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glIsRenderbuffer(self, renderbuffer: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsRenderbuffer

        **GLboolean QOpenGLFunctions::glIsRenderbuffer(GLuint renderbuffer )**

        Convenience function that calls glIsRenderbuffer( **renderbuffer** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsRenderbuffer()** .
        """
        ...

    def glIsShader(self, shader: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsShader

        **GLboolean QOpenGLFunctions::glIsShader(GLuint shader )**

        Convenience function that calls glIsShader( **shader** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsShader()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glIsTexture(self, texture: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glIsTexture

        **[since 5.3] GLboolean QOpenGLFunctions::glIsTexture(GLuint texture )**

        Convenience function that calls glIsTexture( **texture** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glIsTexture()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glLineWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glLineWidth

        **[since 5.3] void QOpenGLFunctions::glLineWidth(GLfloat width )**

        Convenience function that calls glLineWidth( **width** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glLineWidth()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glLinkProgram(self, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glLinkProgram

        **void QOpenGLFunctions::glLinkProgram(GLuint program )**

        Convenience function that calls glLinkProgram( **program** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glLinkProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glPixelStorei(self, pname: int, param: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glPixelStorei

        **[since 5.3] void QOpenGLFunctions::glPixelStorei(GLenum pname , GLint
        param )**

        Convenience function that calls glPixelStorei( **pname** , **param** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glPixelStorei()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glPolygonOffset(self, factor: float, units: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glPolygonOffset

        **[since 5.3] void QOpenGLFunctions::glPolygonOffset(GLfloat factor ,
        GLfloat units )**

        Convenience function that calls glPolygonOffset( **factor** , **units**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glPolygonOffset()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glReadPixels(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glReadPixels

        **[since 5.3] void QOpenGLFunctions::glReadPixels(GLint x , GLint y ,
        GLsizei width , GLsizei height , GLenum format , GLenum type , GLvoid *
        pixels )**

        Convenience function that calls glReadPixels( **x** , **y** , **width**
        , **height** , **format** , **type** , **pixels** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glReadPixels()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glReleaseShaderCompiler(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glReleaseShaderCompiler

        **void QOpenGLFunctions::glReleaseShaderCompiler()**

        Convenience function that calls glReleaseShaderCompiler().

        For more information, see the OpenGL ES 3.X documentation for
        **glReleaseShaderCompiler()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glRenderbufferStorage(
        self, target: int, internalformat: int, width: int, height: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glRenderbufferStorage

        **void QOpenGLFunctions::glRenderbufferStorage(GLenum target , GLenum
        internalformat , GLsizei width , GLsizei height )**

        Convenience function that calls glRenderbufferStorage( **target** ,
        **internalformat** , **width** , **height** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glRenderbufferStorage()** .
        """
        ...

    def glSampleCoverage(self, value: float, invert: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glSampleCoverage

        **void QOpenGLFunctions::glSampleCoverage(GLclampf value , GLboolean
        invert )**

        Convenience function that calls glSampleCoverage( **value** , **invert**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glSampleCoverage()** .
        """
        ...

    def glScissor(self, x: int, y: int, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glScissor

        **[since 5.3] void QOpenGLFunctions::glScissor(GLint x , GLint y ,
        GLsizei width , GLsizei height )**

        Convenience function that calls glScissor( **x** , **y** , **width** ,
        **height** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glScissor()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glShaderBinary(
        self,
        n: int,
        shaders: Sequence[int],
        binaryformat: int,
        binary: int,
        length: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glShaderBinary

        **void QOpenGLFunctions::glShaderBinary(GLint n , const GLuint * shaders
        , GLenum binaryformat , const void * binary , GLint length )**

        Convenience function that calls glShaderBinary( **n** , **shaders** ,
        **binaryformat** , **binary** , **length** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glShaderBinary()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glShaderSource(self, shader: int, source: str) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glShaderSource

        **void QOpenGLFunctions::glShaderSource(GLuint shader , GLsizei count ,
        const char ** string , const GLint * length )**

        Convenience function that calls glShaderSource( **shader** , **count** ,
        **string** , **length** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glShaderSource()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glStencilFunc(self, func: int, ref: int, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilFunc

        **[since 5.3] void QOpenGLFunctions::glStencilFunc(GLenum func , GLint
        ref , GLuint mask )**

        Convenience function that calls glStencilFunc( **func** , **ref** ,
        **mask** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilFunc()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilFuncSeparate

        **void QOpenGLFunctions::glStencilFuncSeparate(GLenum face , GLenum func
        , GLint ref , GLuint mask )**

        Convenience function that calls glStencilFuncSeparate( **face** ,
        **func** , **ref** , **mask** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilFuncSeparate()** .
        """
        ...

    def glStencilMask(self, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilMask

        **[since 5.3] void QOpenGLFunctions::glStencilMask(GLuint mask )**

        Convenience function that calls glStencilMask( **mask** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilMask()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glStencilMaskSeparate(self, face: int, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilMaskSeparate

        **void QOpenGLFunctions::glStencilMaskSeparate(GLenum face , GLuint mask
        )**

        Convenience function that calls glStencilMaskSeparate( **face** ,
        **mask** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilMaskSeparate()** .
        """
        ...

    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilOp

        **[since 5.3] void QOpenGLFunctions::glStencilOp(GLenum fail , GLenum
        zfail , GLenum zpass )**

        Convenience function that calls glStencilOp( **fail** , **zfail** ,
        **zpass** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilOp()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glStencilOpSeparate

        **void QOpenGLFunctions::glStencilOpSeparate(GLenum face , GLenum fail ,
        GLenum zfail , GLenum zpass )**

        Convenience function that calls glStencilOpSeparate( **face** , **fail**
        , **zfail** , **zpass** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glStencilOpSeparate()** .
        """
        ...

    def glTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        border: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexImage2D

        **[since 5.3] void QOpenGLFunctions::glTexImage2D(GLenum target , GLint
        level , GLint internalformat , GLsizei width , GLsizei height , GLint
        border , GLenum format , GLenum type , const GLvoid * pixels )**

        Convenience function that calls glTexImage2D( **target** , **level** ,
        **internalformat** , **width** , **height** , **border** , **format** ,
        **type** , **pixels** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexImage2D()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glTexParameterf(self, target: int, pname: int, param: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexParameterf

        **[since 5.3] void QOpenGLFunctions::glTexParameterf(GLenum target ,
        GLenum pname , GLfloat param )**

        Convenience function that calls glTexParameterf( **target** , **pname**
        , **param** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameterf()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glTexParameterfv(
        self, target: int, pname: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexParameterfv

        **[since 5.3] void QOpenGLFunctions::glTexParameterfv(GLenum target ,
        GLenum pname , const GLfloat * params )**

        Convenience function that calls glTexParameterfv( **target** , **pname**
        , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameterfv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glTexParameteri(self, target: int, pname: int, param: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexParameteri

        **[since 5.3] void QOpenGLFunctions::glTexParameteri(GLenum target ,
        GLenum pname , GLint param )**

        Convenience function that calls glTexParameteri( **target** , **pname**
        , **param** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameteri()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glTexParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexParameteriv

        **[since 5.3] void QOpenGLFunctions::glTexParameteriv(GLenum target ,
        GLenum pname , const GLint * params )**

        Convenience function that calls glTexParameteriv( **target** , **pname**
        , **params** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameteriv()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glTexSubImage2D

        **[since 5.3] void QOpenGLFunctions::glTexSubImage2D(GLenum target ,
        GLint level , GLint xoffset , GLint yoffset , GLsizei width , GLsizei
        height , GLenum format , GLenum type , const GLvoid * pixels )**

        Convenience function that calls glTexSubImage2D( **target** , **level**
        , **xoffset** , **yoffset** , **width** , **height** , **format** ,
        **type** , **pixels** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glTexSubImage2D()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def glUniform1f(self, location: int, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform1f

        **void QOpenGLFunctions::glUniform1f(GLint location , GLfloat x )**

        Convenience function that calls glUniform1f( **location** , **x** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform1f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform1fv(self, location: int, count: int, v: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform1fv

        **void QOpenGLFunctions::glUniform1fv(GLint location , GLsizei count ,
        const GLfloat * v )**

        Convenience function that calls glUniform1fv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform1fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform1i(self, location: int, x: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform1i

        **void QOpenGLFunctions::glUniform1i(GLint location , GLint x )**

        Convenience function that calls glUniform1i( **location** , **x** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform1i()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform1iv(self, location: int, count: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform1iv

        **void QOpenGLFunctions::glUniform1iv(GLint location , GLsizei count ,
        const GLint * v )**

        Convenience function that calls glUniform1iv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform1iv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform2f(self, location: int, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform2f

        **void QOpenGLFunctions::glUniform2f(GLint location , GLfloat x ,
        GLfloat y )**

        Convenience function that calls glUniform2f( **location** , **x** ,
        **y** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform2f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform2fv(self, location: int, count: int, v: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform2fv

        **void QOpenGLFunctions::glUniform2fv(GLint location , GLsizei count ,
        const GLfloat * v )**

        Convenience function that calls glUniform2fv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform2fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform2i(self, location: int, x: int, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform2i

        **void QOpenGLFunctions::glUniform2i(GLint location , GLint x , GLint y
        )**

        Convenience function that calls glUniform2i( **location** , **x** ,
        **y** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform2i()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform2iv(self, location: int, count: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform2iv

        **void QOpenGLFunctions::glUniform2iv(GLint location , GLsizei count ,
        const GLint * v )**

        Convenience function that calls glUniform2iv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform2iv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform3f(self, location: int, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform3f

        **void QOpenGLFunctions::glUniform3f(GLint location , GLfloat x ,
        GLfloat y , GLfloat z )**

        Convenience function that calls glUniform3f( **location** , **x** ,
        **y** , **z** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform3f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform3fv(self, location: int, count: int, v: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform3fv

        **void QOpenGLFunctions::glUniform3fv(GLint location , GLsizei count ,
        const GLfloat * v )**

        Convenience function that calls glUniform3fv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform3fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform3i(self, location: int, x: int, y: int, z: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform3i

        **void QOpenGLFunctions::glUniform3i(GLint location , GLint x , GLint y
        , GLint z )**

        Convenience function that calls glUniform3i( **location** , **x** ,
        **y** , **z** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform3i()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform3iv(self, location: int, count: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform3iv

        **void QOpenGLFunctions::glUniform3iv(GLint location , GLsizei count ,
        const GLint * v )**

        Convenience function that calls glUniform3iv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform3iv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform4f(
        self, location: int, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform4f

        **void QOpenGLFunctions::glUniform4f(GLint location , GLfloat x ,
        GLfloat y , GLfloat z , GLfloat w )**

        Convenience function that calls glUniform4f( **location** , **x** ,
        **y** , **z** , **w** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform4f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform4fv(self, location: int, count: int, v: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform4fv

        **void QOpenGLFunctions::glUniform4fv(GLint location , GLsizei count ,
        const GLfloat * v )**

        Convenience function that calls glUniform4fv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform4fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform4i

        **void QOpenGLFunctions::glUniform4i(GLint location , GLint x , GLint y
        , GLint z , GLint w )**

        Convenience function that calls glUniform4i( **location** , **x** ,
        **y** , **z** , **w** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform4i()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniform4iv(self, location: int, count: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniform4iv

        **void QOpenGLFunctions::glUniform4iv(GLint location , GLsizei count ,
        const GLint * v )**

        Convenience function that calls glUniform4iv( **location** , **count** ,
        **v** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniform4iv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniformMatrix2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniformMatrix2fv

        **void QOpenGLFunctions::glUniformMatrix2fv(GLint location , GLsizei
        count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix2fv( **location** ,
        **count** , **transpose** , **value** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniformMatrix2fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniformMatrix3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniformMatrix3fv

        **void QOpenGLFunctions::glUniformMatrix3fv(GLint location , GLsizei
        count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix3fv( **location** ,
        **count** , **transpose** , **value** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniformMatrix3fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUniformMatrix4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUniformMatrix4fv

        **void QOpenGLFunctions::glUniformMatrix4fv(GLint location , GLsizei
        count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix4fv( **location** ,
        **count** , **transpose** , **value** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUniformMatrix4fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glUseProgram(self, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glUseProgram

        **void QOpenGLFunctions::glUseProgram(GLuint program )**

        Convenience function that calls glUseProgram( **program** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glUseProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glValidateProgram(self, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glValidateProgram

        **void QOpenGLFunctions::glValidateProgram(GLuint program )**

        Convenience function that calls glValidateProgram( **program** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glValidateProgram()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib1f(self, indx: int, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib1f

        **void QOpenGLFunctions::glVertexAttrib1f(GLuint indx , GLfloat x )**

        Convenience function that calls glVertexAttrib1f( **indx** , **x** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib1f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib1fv(self, indx: int, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib1fv

        **void QOpenGLFunctions::glVertexAttrib1fv(GLuint indx , const GLfloat *
        values )**

        Convenience function that calls glVertexAttrib1fv( **indx** , **values**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib1fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib2f(self, indx: int, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib2f

        **void QOpenGLFunctions::glVertexAttrib2f(GLuint indx , GLfloat x ,
        GLfloat y )**

        Convenience function that calls glVertexAttrib2f( **indx** , **x** ,
        **y** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib2f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib2fv(self, indx: int, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib2fv

        **void QOpenGLFunctions::glVertexAttrib2fv(GLuint indx , const GLfloat *
        values )**

        Convenience function that calls glVertexAttrib2fv( **indx** , **values**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib2fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib3f

        **void QOpenGLFunctions::glVertexAttrib3f(GLuint indx , GLfloat x ,
        GLfloat y , GLfloat z )**

        Convenience function that calls glVertexAttrib3f( **indx** , **x** ,
        **y** , **z** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib3f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib3fv(self, indx: int, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib3fv

        **void QOpenGLFunctions::glVertexAttrib3fv(GLuint indx , const GLfloat *
        values )**

        Convenience function that calls glVertexAttrib3fv( **indx** , **values**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib3fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib4f(
        self, indx: int, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib4f

        **void QOpenGLFunctions::glVertexAttrib4f(GLuint indx , GLfloat x ,
        GLfloat y , GLfloat z , GLfloat w )**

        Convenience function that calls glVertexAttrib4f( **indx** , **x** ,
        **y** , **z** , **w** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib4f()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttrib4fv(self, indx: int, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttrib4fv

        **void QOpenGLFunctions::glVertexAttrib4fv(GLuint indx , const GLfloat *
        values )**

        Convenience function that calls glVertexAttrib4fv( **indx** , **values**
        ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttrib4fv()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glVertexAttribPointer(
        self, indx: int, size: int, type: int, normalized: int, stride: int, ptr: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glVertexAttribPointer

        **void QOpenGLFunctions::glVertexAttribPointer(GLuint indx , GLint size
        , GLenum type , GLboolean normalized , GLsizei stride , const void * ptr
        )**

        Convenience function that calls glVertexAttribPointer( **indx** ,
        **size** , **type** , **normalized** , **stride** , **ptr** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glVertexAttribPointer()** .

        This convenience function will do nothing on OpenGL ES 1.x systems.
        """
        ...

    def glViewport(self, x: int, y: int, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#glViewport

        **[since 5.3] void QOpenGLFunctions::glViewport(GLint x , GLint y ,
        GLsizei width , GLsizei height )**

        Convenience function that calls glViewport( **x** , **y** , **width** ,
        **height** ).

        For more information, see the OpenGL ES 3.X documentation for
        **glViewport()** .

        This function was introduced in Qt 5.3.
        """
        ...

    def hasOpenGLFeature(
        self, feature: PySide6.QtGui.QOpenGLFunctions.OpenGLFeature
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#hasOpenGLFeature

        **bool
        QOpenGLFunctions::hasOpenGLFeature(QOpenGLFunctions::OpenGLFeature
        feature ) const**

        Returns `true` if **feature** is present on this system's OpenGL
        implementation; false otherwise.

        It is assumed that the **QOpenGLContext**  associated with this function
        resolver is current.

        **See also** **openGLFeatures** ().
        """
        ...

    def initializeOpenGLFunctions(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#initializeOpenGLFunctions

        **void QOpenGLFunctions::initializeOpenGLFunctions()**

        Initializes OpenGL function resolution for the current context.

        After calling this function, the **QOpenGLFunctions**  object can only
        be used with the current context and other contexts that share with it.
        Call initializeOpenGLFunctions() again to change the object's context
        association.
        """
        ...

    def openGLFeatures(self) -> PySide6.QtGui.QOpenGLFunctions.OpenGLFeatures:
        """
        https://doc.qt.io/qt-6/qopenglfunctions.html#openGLFeatures

        **QOpenGLFunctions::OpenGLFeatures QOpenGLFunctions::openGLFeatures()
        const**

        Returns the set of features that are present on this system's OpenGL
        implementation.

        It is assumed that the **QOpenGLContext**  associated with this function
        resolver is current.

        **See also** **hasOpenGLFeature** ().
        """
        ...
