"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QKeyEvent(PySide6.QtGui.QInputEvent):
    """
    https://doc.qt.io/qt-6/qkeyevent.html

    **Detailed Description**

    Key events are sent to the widget with keyboard input focus when keys are
    pressed or released.

    A key event contains a special accept flag that indicates whether the
    receiver will handle the key event. This flag is set by default for
    **QEvent::KeyPress**  and **QEvent::KeyRelease** , so there is no need to
    call **accept** () when acting on a key event. For
    **QEvent::ShortcutOverride**  the receiver needs to explicitly accept the
    event to trigger the override. Calling **ignore** () on a key event will
    propagate it to the parent widget. The event is propagated up the parent
    widget chain until a widget accepts it or an event filter consumes it.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse and keyboard events for a widget.

    The event handlers **QWidget::keyPressEvent** (),
    **QWidget::keyReleaseEvent** (), **QGraphicsItem::keyPressEvent** () and
    **QGraphicsItem::keyReleaseEvent** () receive key events.

    **See also** **QFocusEvent**  and **QWidget::grabKeyboard** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#QKeyEvent-2

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , const QString & text = QString(), bool
        autorep = false, quint16 count = 1)**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.
        """
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.QEvent.Type,
        key: int,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
        nativeScanCode: int,
        nativeVirtualKey: int,
        nativeModifiers: int,
        text: str = ...,
        autorep: bool = ...,
        count: int = ...,
        device: PySide6.QtGui.QInputDevice = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#QKeyEvent-3

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , quint32 nativeScanCode , quint32
        nativeVirtualKey , quint32 nativeModifiers , const QString & text =
        QString(), bool autorep = false, quint16 count = 1, const QInputDevice *
        device = QInputDevice::primaryKeyboard())**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.

        In addition to the normal key event data, also contains
        **nativeScanCode** , **nativeVirtualKey** and **nativeModifiers**. This
        extra data is used by the shortcut system, to determine which shortcuts
        to trigger.
        """
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.QEvent.Type,
        key: int,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
        text: str = ...,
        autorep: bool = ...,
        count: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#QKeyEvent-2

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , const QString & text = QString(), bool
        autorep = false, quint16 count = 1)**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.
        """
        ...

    def clone(self) -> PySide6.QtGui.QKeyEvent:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#count

        **int QKeyEvent::count() const**

        Returns the number of keys involved in this event. If **text** () is not
        empty, this is simply the length of the string.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...

    def isAutoRepeat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#isAutoRepeat

        **bool QKeyEvent::isAutoRepeat() const**

        Returns `true` if this event comes from an auto-repeating key; returns
        `false` if it comes from an initial key press.

        Note that if the event is a multiple-key compressed event that is partly
        due to auto-repeat, this function could return either true or false
        indeterminately.
        """
        ...

    def key(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#key

        **int QKeyEvent::key() const**

        Returns the code of the key that was pressed or released.

        See **Qt::Key**  for the list of keyboard codes. These codes are
        independent of the underlying window system. Note that this function
        does not distinguish between capital and non-capital letters, use the
        **text** () function (returning the Unicode text the key generated) for
        this purpose.

        A value of either 0 or **Qt::Key_unknown**  means that the event is not
        the result of a known key; for example, it may be the result of a
        compose sequence, a keyboard macro, or due to key event compression.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...

    def keyCombination(self) -> PySide6.QtCore.QKeyCombination:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#keyCombination

        **[since 6.0] QKeyCombination QKeyEvent::keyCombination() const**

        Returns a **QKeyCombination**  object containing both the **key** () and
        the **modifiers** () carried by this event.

        This function was introduced in Qt 6.0.
        """
        ...

    def matches(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> bool:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#matches

        **bool QKeyEvent::matches(QKeySequence::StandardKey key ) const**

        Returns `true` if the key event matches the given standard **key** ;
        otherwise returns `false`.
        """
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#modifiers

        **Qt::KeyboardModifiers QKeyEvent::modifiers() const**

        Returns the keyboard modifier flags that existed immediately after the
        event occurred.

        **Warning:** This function cannot always be trusted. The user can
        confuse it by pressing both **Shift** keys simultaneously and releasing
        one of them, for example.

        **See also** **QGuiApplication::keyboardModifiers** ().
        """
        ...

    def nativeModifiers(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#nativeModifiers

        **quint32 QKeyEvent::nativeModifiers() const**

        Returns the native modifiers of a key event. If the key event does not
        contain this data 0 is returned.

        **Note:** The native modifiers may be 0, even if the key event contains
        extended information.
        """
        ...

    def nativeScanCode(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#nativeScanCode

        **quint32 QKeyEvent::nativeScanCode() const**

        Returns the native scan code of the key event. If the key event does not
        contain this data 0 is returned.

        **Note:** The native scan code may be 0, even if the key event contains
        extended information.
        """
        ...

    def nativeVirtualKey(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#nativeVirtualKey

        **quint32 QKeyEvent::nativeVirtualKey() const**

        Returns the native virtual key, or key sym of the key event. If the key
        event does not contain this data 0 is returned.

        **Note:** The native virtual key may be 0, even if the key event
        contains extended information.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qkeyevent.html#text

        **QString QKeyEvent::text() const**

        Returns the Unicode text that this key generated.

        Return values when modifier keys such as Shift, Control, Alt, and Meta
        are pressed differ among platforms and could return an empty string.

        **Note:****key** () will always return a valid value, independent of
        modifier keys.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...
