"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QIntValidator(PySide6.QtGui.QValidator):
    """
    https://doc.qt.io/qt-6/qintvalidator.html

    **Detailed Description**

    Example of use:

    **QValidator**  *validator = new **QIntValidator** (100, 999, this);
    **QLineEdit**  *edit = new **QLineEdit** (this);

        // the edit
    lineedit will only accept integers between 100 and 999
    edit->setValidator(validator);

    Below we present some examples of validators. In practice they would
    normally be associated with a widget as in the example above.

    **QString**  str;
        int pos = 0;
        **QIntValidator**  v(100, 900, this);
    str = "1";
        v.validate(str, pos);     // returns Intermediate
        str =
    "012";
        v.validate(str, pos);     // returns Intermediate

        str =
    "123";
        v.validate(str, pos);     // returns Acceptable
        str = "678";
    v.validate(str, pos);     // returns Acceptable

        str = "999";
    v.validate(str, pos);    // returns Intermediate

        str = "1234";
    v.validate(str, pos);     // returns Invalid
        str = "-123";
    v.validate(str, pos);     // returns Invalid
        str = "abc";
    v.validate(str, pos);     // returns Invalid
        str = "12cm";
    v.validate(str, pos);     // returns Invalid

    Notice that the value `999` returns Intermediate. Values consisting of a
    number of digits equal to or less than the max value are considered
    intermediate. This is intended because the digit that prevents a number from
    being in range is not necessarily the last digit typed. This also means that
    an intermediate number can have leading zeros.

    The minimum and maximum values are set in one call with **setRange** (), or
    individually with **setBottom** () and **setTop** ().

    QIntValidator uses its **locale** () to interpret the number. For example,
    in Arabic locales, QIntValidator will accept Arabic digits.

    **Note:** The **QLocale::NumberOptions**  set on the **locale** () also
    affect the way the number is interpreted. For example, since
    **QLocale::RejectGroupSeparator**  is not set by default, the validator will
    accept group separators. It is thus recommended to use **QLocale::toInt** ()
    to obtain the numeric value.

    **See also** **QDoubleValidator** , **QRegularExpressionValidator** ,
    **QLocale::toInt** (), and **Line Edits Example** .
    """

    @overload
    def __init__(
        self, bottom: int, top: int, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#QIntValidator

        **QIntValidator::QIntValidator(QObject * parent = nullptr)**

        Constructs a validator with a **parent** object that accepts all
        integers.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#QIntValidator-1

        **QIntValidator::QIntValidator(int minimum , int maximum , QObject *
        parent = nullptr)**

        Constructs a validator with a **parent** , that accepts integers from
        **minimum** to **maximum** inclusive.
        """
        ...

    def bottom(self) -> int:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#bottom-prop

        **bottom : int**

        This property holds the validator's lowest acceptable value

        By default, this property's value is derived from the lowest signed
        integer available (typically -2147483647).

        **Access functions:**

        int **bottom** () const
        void **setBottom** (int)

        **Notifier signal:**

        void **bottomChanged** (int **bottom** )

        **See also** **setRange** ().
        """
        ...

    def fixup(self, input: str) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#fixup

        **[override virtual] void QIntValidator::fixup(QString & input ) const**

        Reimplements: **QValidator::fixup(QString &input) const** .
        """
        ...

    def setBottom(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#bottom-prop

        **bottom : int**

        This property holds the validator's lowest acceptable value

        By default, this property's value is derived from the lowest signed
        integer available (typically -2147483647).

        **Access functions:**

        int **bottom** () const
        void **setBottom** (int)

        **Notifier signal:**

        void **bottomChanged** (int **bottom** )

        **See also** **setRange** ().
        """
        ...

    def setRange(self, bottom: int, top: int) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#setRange

        **void QIntValidator::setRange(int bottom , int top )**

        Sets the range of the validator to only accept integers between
        **bottom** and **top** inclusive.
        """
        ...

    def setTop(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#top-prop

        **top : int**

        This property holds the validator's highest acceptable value

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **top** () const
        void **setTop** (int)

        **Notifier signal:**

        void **topChanged** (int **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def top(self) -> int:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#top-prop

        **top : int**

        This property holds the validator's highest acceptable value

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **top** () const
        void **setTop** (int)

        **Notifier signal:**

        void **topChanged** (int **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def validate(self, arg__1: str, arg__2: int) -> object:
        """
        https://doc.qt.io/qt-6/qintvalidator.html#validate

        **[override virtual] QValidator::State QIntValidator::validate(QString &
        input , int & pos ) const**

        Reimplements: **QValidator::validate(QString &input, int &pos) const** .

        Returns **Acceptable**  if the **input** is an integer within the valid
        range. If **input** has at most as many digits as the top of the range,
        or is a prefix of an integer in the valid range, returns
        **Intermediate** . Otherwise, returns **Invalid** .

        If the valid range consists of just positive integers (e.g., 32 to 100)
        and **input** is a negative integer, then Invalid is returned. (On the
        other hand, if the range consists of negative integers (e.g., -100 to
        -32) and **input** is a positive integer, then Intermediate is returned,
        because the user might be just about to type the minus (especially for
        right-to-left languages).

        Similarly, if the valid range is between 46 and 53, then 41 and 59 will
        be evaluated as **Intermediate** , as otherwise the user wouldn't be
        able to change a value from 49 to 51.

        int pos = 0;

            s = "abc";
            v.validate(s, pos);    // returns
        Invalid

            s = "5";
            v.validate(s, pos);    // returns
        Intermediate

            s = "50";
            v.validate(s, pos);    // returns
        Acceptable

        By default, the **pos** parameter is not used by this validator.
        """
        ...

    @property
    def bottomChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def topChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
