"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QInputMethodQueryEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qinputmethodqueryevent.html

    **Detailed Description**

    It is used by the input method to query a set of properties of the object to
    be able to support complex input method operations as support for
    surrounding text and reconversions.

    **queries** () specifies which properties are queried.

    The object should call **setValue** () on the event to fill in the requested
    data before calling **accept** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodQueryEvent) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodqueryevent.html#QInputMethodQueryEven
        t-2

        **QInputMethodQueryEvent::QInputMethodQueryEvent(Qt::InputMethodQueries
        queries )**

        Constructs a query event for properties given by **queries**.
        """
        ...

    @overload
    def __init__(self, queries: PySide6.QtCore.Qt.InputMethodQueries) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodqueryevent.html#QInputMethodQueryEven
        t-2

        **QInputMethodQueryEvent::QInputMethodQueryEvent(Qt::InputMethodQueries
        queries )**

        Constructs a query event for properties given by **queries**.
        """
        ...

    def clone(self) -> PySide6.QtGui.QInputMethodQueryEvent:
        ...

    def queries(self) -> PySide6.QtCore.Qt.InputMethodQueries:
        """
        https://doc.qt.io/qt-6/qinputmethodqueryevent.html#queries

        **Qt::InputMethodQueries QInputMethodQueryEvent::queries() const**

        Returns the properties queried by the event.
        """
        ...

    def setValue(self, query: PySide6.QtCore.Qt.InputMethodQuery, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodqueryevent.html#setValue

        **void QInputMethodQueryEvent::setValue(Qt::InputMethodQuery query ,
        const QVariant & value )**

        Sets property **query** to **value**.

        **See also** **value** ().
        """
        ...

    def value(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any:
        """
        https://doc.qt.io/qt-6/qinputmethodqueryevent.html#value

        **QVariant QInputMethodQueryEvent::value(Qt::InputMethodQuery query )
        const**

        Returns value of the property **query**.

        **See also** **setValue** ().
        """
        ...
