"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Union
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QInputMethod(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qinputmethod.html

    **Detailed Description**

    QInputMethod is used by the text editors for integrating to the platform
    text input methods and more commonly by application views for querying
    various text input method-related information like virtual keyboard
    visibility and keyboard dimensions.

    Qt Quick also provides access to QInputMethod in QML through **Qt global
    object**  as `Qt.inputMethod` property.
    """

    Click: QInputMethod.Action = ...
    ContextMenu: QInputMethod.Action = ...

    class Action(Enum):
        Click: QInputMethod.Action = ...
        ContextMenu: QInputMethod.Action = ...

    def anchorRectangle(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#anchorRectangle-prop

        **[read-only] anchorRectangle : const QRectF**

        Input item's anchor rectangle in window coordinates.

        Anchor rectangle is often used by various text editing controls like
        text prediction popups for following the text selection.

        **Access functions:**

        QRectF **anchorRectangle** () const

        **Notifier signal:**

        void **anchorRectangleChanged** ()
        """
        ...

    def commit(self) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#commit

        **[slot] void QInputMethod::commit()**

        Commits the word user is currently composing to the editor. The function
        is mostly needed by the input methods with text prediction features and
        by the methods where the script used for typing characters is different
        from the script that actually gets appended to the editor. Any kind of
        action that interrupts the text composing needs to flush the composing
        state by calling the commit() function, for example when the cursor is
        moved elsewhere.
        """
        ...

    def cursorRectangle(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#cursorRectangle-prop

        **[read-only] cursorRectangle : const QRectF**

        Input item's cursor rectangle in window coordinates.

        Cursor rectangle is often used by various text editing controls like
        text prediction popups for following the text being typed.

        **Access functions:**

        QRectF **cursorRectangle** () const

        **Notifier signal:**

        void **cursorRectangleChanged** ()
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#hide

        **[slot] void QInputMethod::hide()**

        Requests virtual keyboard to close.

        Normally applications should not need to call this function, keyboard
        should automatically close when the text editor loses focus, for example
        when the parent view is closed.
        """
        ...

    def inputDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#inputDirection-prop

        **[read-only] inputDirection : const Qt::LayoutDirection**

        Current input direction.

        **Access functions:**

        Qt::LayoutDirection **inputDirection** () const

        **Notifier signal:**

        void **inputDirectionChanged** (Qt::LayoutDirection **newDirection** )
        """
        ...

    def inputItemClipRectangle(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#inputItemClipRectangle-prop

        **[read-only] inputItemClipRectangle : const QRectF**

        Input item's clipped rectangle in window coordinates.

        The clipped input rectangle is often used by various input methods to
        determine how much screen real estate is available for the input method
        (e.g. Virtual Keyboard).

        **Access functions:**

        QRectF **inputItemClipRectangle** () const

        **Notifier signal:**

        void **inputItemClipRectangleChanged** ()
        """
        ...

    def inputItemRectangle(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#inputItemRectangle

        **[since 5.1] QRectF QInputMethod::inputItemRectangle() const**

        Returns the input item's geometry in input item coordinates.

        This function was introduced in Qt 5.1.

        **See also** **setInputItemRectangle** ().
        """
        ...

    def inputItemTransform(self) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#inputItemTransform

        **QTransform QInputMethod::inputItemTransform() const**

        Returns the transformation from input item coordinates to the window
        coordinates.

        **See also** **setInputItemTransform** ().
        """
        ...

    def invokeAction(
        self, a: PySide6.QtGui.QInputMethod.Action, cursorPosition: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#invokeAction

        **[slot] void QInputMethod::invokeAction(QInputMethod::Action a , int
        cursorPosition )**

        Called by the input item when the word currently being composed is
        tapped by the user, as indicated by the action **a** and the given
        **cursorPosition**. Input methods often use this information to offer
        more word suggestions to the user.
        """
        ...

    def isAnimating(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def keyboardRectangle(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#keyboardRectangle-prop

        **[read-only] keyboardRectangle : const QRectF**

        Virtual keyboard's geometry in window coordinates.

        This might be an empty rectangle if it is not possible to know the
        geometry of the keyboard. This is the case for a floating keyboard on
        android.

        **Access functions:**

        QRectF **keyboardRectangle** () const

        **Notifier signal:**

        void **keyboardRectangleChanged** ()
        """
        ...

    def locale(self) -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#locale-prop

        **[read-only] locale : const QLocale**

        Current input locale.

        **Access functions:**

        QLocale **locale** () const

        **Notifier signal:**

        void **localeChanged** ()
        """
        ...

    @staticmethod
    def queryFocusObject(
        query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#queryFocusObject

        **[static] QVariant QInputMethod::queryFocusObject(Qt::InputMethodQuery
        query , const QVariant & argument )**

        Send **query** to the current focus object with parameters **argument**
        and return the result.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#reset

        **[slot] void QInputMethod::reset()**

        Resets the input method state. For example, a text editor normally calls
        this method before inserting a text to make widget ready to accept a
        text.

        Input method resets automatically when the focused editor changes.
        """
        ...

    def setInputItemRectangle(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#setInputItemRectangle

        **[since 5.1] void QInputMethod::setInputItemRectangle(const QRectF &
        rect )**

        Sets the input item's geometry to be **rect** , in input item
        coordinates. This needs to be updated by the focused window like
        QQuickCanvas whenever item is moved inside the scene, or focus is
        changed.

        This function was introduced in Qt 5.1.

        **See also** **inputItemRectangle** ().
        """
        ...

    def setInputItemTransform(self, transform: PySide6.QtGui.QTransform) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#setInputItemTransform

        **void QInputMethod::setInputItemTransform(const QTransform & transform
        )**

        Sets the transformation from input item coordinates to window
        coordinates to be **transform**. Item transform needs to be updated by
        the focused window like QQuickCanvas whenever item is moved inside the
        scene.

        **See also** **inputItemTransform** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#setVisible

        **void QInputMethod::setVisible(bool visible )**

        Controls the keyboard visibility. Equivalent to calling **show** () (if
        **visible** is `true`) or **hide** () (if **visible** is `false`).

        **See also** **isVisible** (), **show** (), and **hide** ().
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#show

        **[slot] void QInputMethod::show()**

        Requests virtual keyboard to open. If the platform doesn't provide
        virtual keyboard the visibility remains false.

        Normally applications should not need to call this function, keyboard
        should automatically open when the text editor gains focus.
        """
        ...

    def update(self, queries: PySide6.QtCore.Qt.InputMethodQueries) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethod.html#update

        **[slot] void QInputMethod::update(Qt::InputMethodQueries queries )**

        Called by the input item to inform the platform input methods when there
        has been state changes in editor's input method query attributes. When
        calling the function **queries** parameter has to be used to tell what
        has changes, which input method can use to make queries for attributes
        it's interested with **QInputMethodQueryEvent** .

        In particular calling update whenever the cursor position changes is
        important as that often causes other query attributes like surrounding
        text and text selection to change as well. The attributes that often
        change together with cursor position have been grouped in
        **Qt::ImQueryInput**  value for convenience.
        """
        ...

    @property
    def anchorRectangleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def animatingChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def cursorRectangleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def inputDirectionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def inputItemClipRectangleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def keyboardRectangleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def localeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
