"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QInputEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qinputevent.html

    **Detailed Description**
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputEvent) -> None:
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.QEvent.Type,
        m_dev: PySide6.QtGui.QInputDevice,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers = ...,
    ) -> None:
        ...

    def clone(self) -> PySide6.QtGui.QInputEvent:
        ...

    def device(self) -> PySide6.QtGui.QInputDevice:
        """
        https://doc.qt.io/qt-6/qinputevent.html#device

        **[since 6.0] const QInputDevice *QInputEvent::device() const**

        Returns the source device that generated the original event.

        In case of a synthesized event, for example a mouse event that was
        generated from a touch event, `device()` continues to return the
        touchscreen device, so that you can tell that it did not come from an
        actual mouse. Thus `mouseEvent.source()->type() !=
        QInputDevice::DeviceType::Mouse` is one possible replacement for the Qt
        5 expression `mouseEvent.source() == Qt::MouseEventSynthesizedByQt`.

        This function was introduced in Qt 6.0.

        **See also** **QPointerEvent::pointingDevice** ().
        """
        ...

    def deviceType(self) -> PySide6.QtGui.QInputDevice.DeviceType:
        """
        https://doc.qt.io/qt-6/qinputevent.html#deviceType

        **QInputDevice::DeviceType QInputEvent::deviceType() const**

        Returns the type of device that generated the event.
        """
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qinputevent.html#modifiers

        **Qt::KeyboardModifiers QInputEvent::modifiers() const**

        Returns the keyboard modifier flags that existed immediately before the
        event occurred.

        **See also** **QGuiApplication::keyboardModifiers** ().
        """
        ...

    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qinputevent.html#modifiers

        **Qt::KeyboardModifiers QInputEvent::modifiers() const**

        Returns the keyboard modifier flags that existed immediately before the
        event occurred.

        **See also** **QGuiApplication::keyboardModifiers** ().
        """
        ...

    def setTimestamp(self, timestamp: int) -> None:
        """
        https://doc.qt.io/qt-6/qinputevent.html#timestamp

        **quint64 QInputEvent::timestamp() const**

        Returns the window system's timestamp for this event. It will normally
        be in milliseconds since some arbitrary point in time, such as the time
        when the system was started.
        """
        ...

    def timestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qinputevent.html#timestamp

        **quint64 QInputEvent::timestamp() const**

        Returns the window system's timestamp for this event. It will normally
        be in milliseconds since some arbitrary point in time, such as the time
        when the system was started.
        """
        ...
