"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QImageWriter(object):
    """
    https://doc.qt.io/qt-6/qimagewriter.html

    **Detailed Description**

    QImageWriter supports setting format specific options, such as compression
    level and quality, prior to storing the image. If you do not need such
    options, you can use **QImage::save** () or **QPixmap::save** () instead.

    To store an image, you start by constructing a QImageWriter object. Pass
    either a file name or a device pointer, and the image format to
    QImageWriter's constructor. You can then set several options, such as
    quality (by calling **setQuality** ()). **canWrite** () returns `true` if
    QImageWriter can write the image (i.e., the image format is supported and
    the device is open for writing). Call **write** () to write the image to the
    device.

    If any error occurs when writing the image, **write** () will return false.
    You can then call **error** () to find the type of error that occurred, or
    **errorString** () to get a human readable description of what went wrong.

    Call **supportedImageFormats** () for a list of formats that QImageWriter
    can write. QImageWriter supports all built-in image formats, in addition to
    any image format plugins that support writing.

    **Note:** QImageWriter assumes exclusive control over the file or device
    that is assigned. Any attempts to modify the assigned file or device during
    the lifetime of the QImageWriter object will yield undefined results. If
    immediate access to a resource is desired, the use of a scope is the
    recommended method.

    For example:

    **QString**  imagePath(**QStringLiteral** ("path/image.jpeg"));
    **QImage**  image(64, 64, **QImage** ::Format_RGB32);
    image.fill(Qt::red);
        {
            **QImageWriter**  writer(imagePath);
    writer.write(image);
        }

        **QFile** ::rename(imagePath,
    **QStringLiteral** ("path/other_image.jpeg"));

    **See also** **QImageReader** , **QImageIOHandler** , **QImageIOPlugin** ,
    and **QColorSpace** .
    """

    UnknownError: QImageWriter.ImageWriterError = ...
    DeviceError: QImageWriter.ImageWriterError = ...
    UnsupportedFormatError: QImageWriter.ImageWriterError = ...
    InvalidImageError: QImageWriter.ImageWriterError = ...

    class ImageWriterError(Enum):
        UnknownError: QImageWriter.ImageWriterError = ...
        DeviceError: QImageWriter.ImageWriterError = ...
        UnsupportedFormatError: QImageWriter.ImageWriterError = ...
        InvalidImageError: QImageWriter.ImageWriterError = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#QImageWriter

        **QImageWriter::QImageWriter()**

        Constructs an empty QImageWriter object. Before writing, you must call
        **setFormat** () to set an image format, then **setDevice** () or
        **setFileName** ().
        """
        ...

    @overload
    def __init__(
        self,
        device: PySide6.QtCore.QIODevice,
        format: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#QImageWriter-1

        **QImageWriter::QImageWriter(QIODevice * device , const QByteArray &
        format )**

        Constructs a QImageWriter object using the device **device** and image
        format **format**.
        """
        ...

    @overload
    def __init__(
        self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#QImageWriter-2

        **QImageWriter::QImageWriter(const QString & fileName , const QByteArray
        & format = QByteArray())**

        Constructs a QImageWriter objects that will write to a file with the
        name **fileName** , using the image format **format**. If **format** is
        not provided, QImageWriter will detect the image format by inspecting
        the extension of **fileName**.
        """
        ...

    def canWrite(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#canWrite

        **bool QImageWriter::canWrite() const**

        Returns `true` if **QImageWriter**  can write the image; i.e., the image
        format is supported and the assigned device is open for reading.

        **See also** **write** (), **setDevice** (), and **setFormat** ().
        """
        ...

    def compression(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#compression

        **int QImageWriter::compression() const**

        Returns the compression of the image.

        **See also** **setCompression** ().
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#device

        **QIODevice *QImageWriter::device() const**

        Returns the device currently assigned to **QImageWriter** , or `nullptr`
        if no device has been assigned.

        **See also** **setDevice** ().
        """
        ...

    def error(self) -> PySide6.QtGui.QImageWriter.ImageWriterError:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#error

        **QImageWriter::ImageWriterError QImageWriter::error() const**

        Returns the type of error that last occurred.

        **See also** **ImageWriterError**  and **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#errorString

        **QString QImageWriter::errorString() const**

        Returns a human readable description of the last error that occurred.

        **See also** **error** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#fileName

        **QString QImageWriter::fileName() const**

        If the currently assigned device is a file, or if **setFileName** () has
        been called, this function returns the name of the file **QImageWriter**
        writes to. Otherwise (i.e., if no device has been assigned or the device
        is not a file), an empty **QString**  is returned.

        **See also** **setFileName** () and **setDevice** ().
        """
        ...

    def format(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#format

        **QByteArray QImageWriter::format() const**

        Returns the format **QImageWriter**  uses for writing images.

        **See also** **setFormat** ().
        """
        ...

    @staticmethod
    def imageFormatsForMimeType(
        mimeType: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#imageFormatsForMimeType

        **[static, since 5.12] QList<QByteArray>
        QImageWriter::imageFormatsForMimeType(const QByteArray & mimeType )**

        Returns the list of image formats corresponding to **mimeType**.

        Note that the **QGuiApplication**  instance must be created before this
        function is called.

        This function was introduced in Qt 5.12.

        **See also** **supportedImageFormats** () and **supportedMimeTypes** ().
        """
        ...

    def optimizedWrite(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#optimizedWrite

        **[since 5.5] bool QImageWriter::optimizedWrite() const**

        Returns whether optimization has been turned on for writing the image.

        This function was introduced in Qt 5.5.

        **See also** **setOptimizedWrite** ().
        """
        ...

    def progressiveScanWrite(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#progressiveScanWrite

        **[since 5.5] bool QImageWriter::progressiveScanWrite() const**

        Returns whether the image should be written as a progressive image.

        This function was introduced in Qt 5.5.

        **See also** **setProgressiveScanWrite** ().
        """
        ...

    def quality(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#quality

        **int QImageWriter::quality() const**

        Returns the quality setting of the image format.

        **See also** **setQuality** ().
        """
        ...

    def setCompression(self, compression: int) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setCompression

        **void QImageWriter::setCompression(int compression )**

        This is an image format specific function that set the compression of an
        image. For image formats that do not support setting the compression,
        this value is ignored.

        The value range of **compression** depends on the image format. For
        example, the "tiff" format supports two values, 0(no compression) and
        1(LZW-compression).

        **See also** **compression** ().
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setDevice

        **void QImageWriter::setDevice(QIODevice * device )**

        Sets **QImageWriter** 's device to **device**. If a device has already
        been set, the old device is removed from **QImageWriter**  and is
        otherwise left unchanged.

        If the device is not already open, **QImageWriter**  will attempt to
        open the device in **QIODevice::WriteOnly**  mode by calling open().
        Note that this does not work for certain devices, such as **QProcess** ,
        **QTcpSocket**  and **QUdpSocket** , where more logic is required to
        open the device.

        **See also** **device** () and **setFileName** ().
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setFileName

        **void QImageWriter::setFileName(const QString & fileName )**

        Sets the file name of **QImageWriter**  to **fileName**. Internally,
        **QImageWriter**  will create a **QFile**  and open it in
        **QIODevice::WriteOnly**  mode, and use this file when writing images.

        **See also** **fileName** () and **setDevice** ().
        """
        ...

    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setFormat

        **void QImageWriter::setFormat(const QByteArray & format )**

        Sets the format **QImageWriter**  will use when writing images, to
        **format**. **format** is a case insensitive text string. Example:

        **QImageWriter**  writer;
            writer.setFormat("png"); // same as
        writer.setFormat("PNG");

        You can call **supportedImageFormats** () for the full list of formats
        **QImageWriter**  supports.

        **See also** **format** ().
        """
        ...

    def setOptimizedWrite(self, optimize: bool) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setOptimizedWrite

        **[since 5.5] void QImageWriter::setOptimizedWrite(bool optimize )**

        This is an image format-specific function which sets the **optimize**
        flags when writing images. For image formats that do not support setting
        an **optimize** flag, this value is ignored.

        The default is false.

        This function was introduced in Qt 5.5.

        **See also** **optimizedWrite** ().
        """
        ...

    def setProgressiveScanWrite(self, progressive: bool) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setProgressiveScanWrite

        **[since 5.5] void QImageWriter::setProgressiveScanWrite(bool
        progressive )**

        This is an image format-specific function which turns on **progressive**
        scanning when writing images. For image formats that do not support
        setting a **progressive** scan flag, this value is ignored.

        The default is false.

        This function was introduced in Qt 5.5.

        **See also** **progressiveScanWrite** ().
        """
        ...

    def setQuality(self, quality: int) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setQuality

        **void QImageWriter::setQuality(int quality )**

        Sets the quality setting of the image format to **quality**.

        Some image formats, in particular lossy ones, entail a tradeoff between
        a) visual quality of the resulting image, and b) encoding execution time
        and compression level. This function sets the level of that tradeoff for
        image formats that support it. For other formats, this value is ignored.

        The value range of **quality** depends on the image format. For example,
        the "jpeg" format supports a quality range from 0 (low visual quality,
        high compression) to 100 (high visual quality, low compression).

        **See also** **quality** ().
        """
        ...

    def setSubType(self, type: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setSubType

        **[since 5.4] void QImageWriter::setSubType(const QByteArray & type )**

        This is an image format specific function that sets the subtype of the
        image to **type**. Subtype can be used by a handler to determine which
        format it should use while saving the image.

        For example, saving an image in DDS format with A8R8G8R8 subtype:

        **QImageWriter**  writer("some/image.dds");
            if
        (writer.supportsOption(**QImageIOHandler** ::SubType))
        writer.setSubType("A8R8G8B8");
            writer.write(image);

        This function was introduced in Qt 5.4.

        **See also** **subType** ().
        """
        ...

    def setText(self, key: str, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setText

        **void QImageWriter::setText(const QString & key , const QString & text
        )**

        Sets the image text associated with the key **key** to **text**. This is
        useful for storing copyright information or other information about the
        image. Example:

        **QImage**  image("some/image.jpeg");
            **QImageWriter**
        writer("images/outimage.png", "png");
            writer.setText("Author", "John
        Smith");
            writer.write(image);

        If you want to store a single block of data (e.g., a comment), you can
        pass an empty key, or use a generic key like "Description".

        The key and text will be embedded into the image data after calling
        **write** ().

        Support for this option is implemented through
        **QImageIOHandler::Description** .

        **See also** **QImage::setText** () and **QImageReader::text** ().
        """
        ...

    def setTransformation(
        self, orientation: PySide6.QtGui.QImageIOHandler.Transformations
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#setTransformation

        **[since 5.5] void
        QImageWriter::setTransformation(QImageIOHandler::Transformations
        transform )**

        Sets the image transformations metadata including orientation to
        **transform**.

        If transformation metadata is not supported by the image format, the
        transform is applied before writing.

        This function was introduced in Qt 5.5.

        **See also** **transformation** () and **write** ().
        """
        ...

    def subType(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#subType

        **[since 5.4] QByteArray QImageWriter::subType() const**

        Returns the subtype of the image.

        This function was introduced in Qt 5.4.

        **See also** **setSubType** ().
        """
        ...

    @staticmethod
    def supportedImageFormats() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#supportedImageFormats

        **[static] QList<QByteArray> QImageWriter::supportedImageFormats()**

        Returns the list of image formats supported by **QImageWriter** .

        By default, Qt can write the following formats:

        FormatMIME typeDescription
        BMPimage/bmpWindows Bitmap
        JPGimage/jpegJoint Photographic Experts Group
        PNGimage/pngPortable
        Network Graphics
        PBMimage/x-portable-bitmapPortable Bitmap
        PGMimage/x-portable-graymapPortable Graymap
        PPMimage/x-portable-
        pixmapPortable Pixmap
        XBMimage/x-xbitmapX11 Bitmap
        XPMimage/x-xpixmapX11 Pixmap

        Reading and writing SVG files is supported through the **Qt SVG**
        module. The **Qt Image Formats**  module provides support for additional
        image formats.

        Note that the **QApplication**  instance must be created before this
        function is called.

        **See also** **setFormat** (), **QImageReader::supportedImageFormats**
        (), and **QImageIOPlugin** .
        """
        ...

    @staticmethod
    def supportedMimeTypes() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#supportedMimeTypes

        **[static] QList<QByteArray> QImageWriter::supportedMimeTypes()**

        Returns the list of MIME types supported by **QImageWriter** .

        Note that the **QApplication**  instance must be created before this
        function is called.

        **See also** **supportedImageFormats** () and
        **QImageReader::supportedMimeTypes** ().
        """
        ...

    def supportedSubTypes(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#supportedSubTypes

        **[since 5.4] QList<QByteArray> QImageWriter::supportedSubTypes()
        const**

        Returns the list of subtypes supported by an image.

        This function was introduced in Qt 5.4.
        """
        ...

    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#supportsOption

        **bool QImageWriter::supportsOption(QImageIOHandler::ImageOption option
        ) const**

        Returns `true` if the writer supports **option** ; otherwise returns
        false.

        Different image formats support different options. Call this function to
        determine whether a certain option is supported by the current format.
        For example, the PNG format allows you to embed text into the image's
        metadata (see text()).

        **QImageWriter**  writer(fileName);
            if
        (writer.supportsOption(**QImageIOHandler** ::Description))
        writer.setText("Author", "John Smith");

        Options can be tested after the writer has been associated with a
        format.

        **See also** **QImageReader::supportsOption** () and **setFormat** ().
        """
        ...

    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformations:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#transformation

        **[since 5.5] QImageIOHandler::Transformations
        QImageWriter::transformation() const**

        Returns the transformation and orientation the image has been set to
        written with.

        This function was introduced in Qt 5.5.

        **See also** **setTransformation** ().
        """
        ...

    def write(self, image: Union[PySide6.QtGui.QImage, str]) -> bool:
        """
        https://doc.qt.io/qt-6/qimagewriter.html#write

        **bool QImageWriter::write(const QImage & image )**

        Writes the image **image** to the assigned device or file name. Returns
        `true` on success; otherwise returns `false`. If the operation fails,
        you can call **error** () to find the type of error that occurred, or
        **errorString** () to get a human readable description of the error.

        **See also** **canWrite** (), **error** (), and **errorString** ().
        """
        ...
