"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Union
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QImageIOHandler(object):
    """
    https://doc.qt.io/qt-6/qimageiohandler.html

    **Detailed Description**

    Qt uses QImageIOHandler for reading and writing images through
    **QImageReader**  and **QImageWriter** . You can also derive from this class
    to write your own image format handler using Qt's plugin mechanism.

    Call **setDevice** () to assign a device to the handler, and **setFormat**
    () to assign a format to it. One QImageIOHandler may support more than one
    image format. **canRead** () returns `true` if an image can be read from the
    device, and **read** () and **write** () return true if reading or writing
    an image was completed successfully.

    QImageIOHandler also has support for animations formats, through the
    functions **loopCount** (), **imageCount** (), **nextImageDelay** () and
    **currentImageNumber** ().

    In order to determine what options an image handler supports, Qt will call
    **supportsOption** () and **setOption** (). Make sure to reimplement these
    functions if you can provide support for any of the options in the
    **ImageOption**  enum.

    To write your own image handler, you must at least reimplement **canRead**
    () and **read** (). Then create a **QImageIOPlugin**  that can create the
    handler. Finally, install your plugin, and **QImageReader**  and
    **QImageWriter**  will then automatically load the plugin, and start using
    it.

    **See also** **QImageIOPlugin** , **QImageReader** , and **QImageWriter** .
    """

    Size: QImageIOHandler.ImageOption = ...
    ClipRect: QImageIOHandler.ImageOption = ...
    Description: QImageIOHandler.ImageOption = ...
    ScaledClipRect: QImageIOHandler.ImageOption = ...
    ScaledSize: QImageIOHandler.ImageOption = ...
    CompressionRatio: QImageIOHandler.ImageOption = ...
    Gamma: QImageIOHandler.ImageOption = ...
    Quality: QImageIOHandler.ImageOption = ...
    Name: QImageIOHandler.ImageOption = ...
    SubType: QImageIOHandler.ImageOption = ...
    IncrementalReading: QImageIOHandler.ImageOption = ...
    Endianness: QImageIOHandler.ImageOption = ...
    Animation: QImageIOHandler.ImageOption = ...
    BackgroundColor: QImageIOHandler.ImageOption = ...
    ImageFormat: QImageIOHandler.ImageOption = ...
    SupportedSubTypes: QImageIOHandler.ImageOption = ...
    OptimizedWrite: QImageIOHandler.ImageOption = ...
    ProgressiveScanWrite: QImageIOHandler.ImageOption = ...
    ImageTransformation: QImageIOHandler.ImageOption = ...
    TransformationNone: QImageIOHandler.Transformation = ...
    TransformationMirror: QImageIOHandler.Transformation = ...
    TransformationFlip: QImageIOHandler.Transformation = ...
    TransformationRotate180: QImageIOHandler.Transformation = ...
    TransformationRotate90: QImageIOHandler.Transformation = ...
    TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ...
    TransformationFlipAndRotate90: QImageIOHandler.Transformation = ...
    TransformationRotate270: QImageIOHandler.Transformation = ...

    class ImageOption(Enum):
        Size: QImageIOHandler.ImageOption = ...
        ClipRect: QImageIOHandler.ImageOption = ...
        Description: QImageIOHandler.ImageOption = ...
        ScaledClipRect: QImageIOHandler.ImageOption = ...
        ScaledSize: QImageIOHandler.ImageOption = ...
        CompressionRatio: QImageIOHandler.ImageOption = ...
        Gamma: QImageIOHandler.ImageOption = ...
        Quality: QImageIOHandler.ImageOption = ...
        Name: QImageIOHandler.ImageOption = ...
        SubType: QImageIOHandler.ImageOption = ...
        IncrementalReading: QImageIOHandler.ImageOption = ...
        Endianness: QImageIOHandler.ImageOption = ...
        Animation: QImageIOHandler.ImageOption = ...
        BackgroundColor: QImageIOHandler.ImageOption = ...
        ImageFormat: QImageIOHandler.ImageOption = ...
        SupportedSubTypes: QImageIOHandler.ImageOption = ...
        OptimizedWrite: QImageIOHandler.ImageOption = ...
        ProgressiveScanWrite: QImageIOHandler.ImageOption = ...
        ImageTransformation: QImageIOHandler.ImageOption = ...

    class Transformation(Enum):
        TransformationNone: QImageIOHandler.Transformation = ...
        TransformationMirror: QImageIOHandler.Transformation = ...
        TransformationFlip: QImageIOHandler.Transformation = ...
        TransformationRotate180: QImageIOHandler.Transformation = ...
        TransformationRotate90: QImageIOHandler.Transformation = ...
        TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ...
        TransformationFlipAndRotate90: QImageIOHandler.Transformation = ...
        TransformationRotate270: QImageIOHandler.Transformation = ...

    class Transformations(object):
        ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#QImageIOHandler

        **QImageIOHandler::QImageIOHandler()**

        Constructs a QImageIOHandler object.
        """
        ...

    @staticmethod
    def allocateImage(
        size: PySide6.QtCore.QSize,
        format: PySide6.QtGui.QImage.Format,
        image: Union[PySide6.QtGui.QImage, str],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#allocateImage

        **[static, since 6.0] bool QImageIOHandler::allocateImage(QSize size ,
        QImage::Format format , QImage * image )**

        This is a convenience method for the reading function in subclasses.
        Image format handlers must reject loading an image if the required
        allocation would exceeed the current allocation limit. This function
        checks the parameters and limit, and does the allocation if it is valid
        and required. Upon successful return, **image** will be a valid,
        detached **QImage**  of the given **size** and **format**.

        This function was introduced in Qt 6.0.

        **See also** **QImageReader::allocationLimit** ().
        """
        ...

    def canRead(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#canRead

        **[pure virtual] bool QImageIOHandler::canRead() const**

        Returns `true` if an image can be read from the device (i.e., the image
        format is supported, the device can be read from and the initial header
        information suggests that the image can be read); otherwise returns
        `false`.

        When reimplementing canRead(), make sure that the I/O device (**device**
        ()) is left in its original state (e.g., by using peek() rather than
        **read** ()).

        **See also** **read** () and **QIODevice::peek** ().
        """
        ...

    def currentImageNumber(self) -> int:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#currentImageNumber

        **[virtual] int QImageIOHandler::currentImageNumber() const**

        For image formats that support animation, this function returns the
        sequence number of the current image in the animation. If this function
        is called before any image is **read** (), -1 is returned. The number of
        the first image in the sequence is 0.

        If the image format does not support animation, 0 is returned.

        **See also** **read** ().
        """
        ...

    def currentImageRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#currentImageRect

        **[virtual] QRect QImageIOHandler::currentImageRect() const**

        Returns the rect of the current image. If no rect is defined for the
        image, and empty QRect() is returned.

        This function is useful for animations, where only parts of the frame
        may be updated at a time.
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#device

        **QIODevice *QImageIOHandler::device() const**

        Returns the device currently assigned to the **QImageIOHandler** . If
        not device has been assigned, `nullptr` is returned.

        **See also** **setDevice** ().
        """
        ...

    def format(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#format

        **QByteArray QImageIOHandler::format() const**

        Returns the format that is currently assigned to **QImageIOHandler** .
        If no format has been assigned, an empty string is returned.

        **See also** **setFormat** ().
        """
        ...

    def imageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#imageCount

        **[virtual] int QImageIOHandler::imageCount() const**

        For image formats that support animation, this function returns the
        number of images in the animation. If the image format does not support
        animation, or if it is unable to determine the number of images, 0 is
        returned.

        The default implementation returns 1 if **canRead** () returns `true`;
        otherwise 0 is returned.
        """
        ...

    def jumpToImage(self, imageNumber: int) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#jumpToImage

        **[virtual] bool QImageIOHandler::jumpToImage(int imageNumber )**

        For image formats that support animation, this function jumps to the
        image whose sequence number is **imageNumber**. The next call to
        **read** () will attempt to read this image.

        The default implementation does nothing, and returns `false`.
        """
        ...

    def jumpToNextImage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#jumpToNextImage

        **[virtual] bool QImageIOHandler::jumpToNextImage()**

        For image formats that support animation, this function jumps to the
        next image.

        The default implementation does nothing, and returns `false`.
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#loopCount

        **[virtual] int QImageIOHandler::loopCount() const**

        For image formats that support animation, this function returns the
        number of times the animation should loop. If the image format does not
        support animation, 0 is returned.
        """
        ...

    def nextImageDelay(self) -> int:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#nextImageDelay

        **[virtual] int QImageIOHandler::nextImageDelay() const**

        For image formats that support animation, this function returns the
        number of milliseconds to wait until reading the next image. If the
        image format does not support animation, 0 is returned.
        """
        ...

    def option(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> Any:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#option

        **[virtual] QVariant
        QImageIOHandler::option(QImageIOHandler::ImageOption option ) const**

        Returns the value assigned to **option** as a **QVariant** . The type of
        the value depends on the option. For example, option(Size) returns a
        **QSize**  variant.

        **See also** **setOption** () and **supportsOption** ().
        """
        ...

    def read(self, image: Union[PySide6.QtGui.QImage, str]) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#read

        **[pure virtual] bool QImageIOHandler::read(QImage * image )**

        Read an image from the device, and stores it in **image**. Returns
        `true` if the image is successfully read; otherwise returns false.

        For image formats that support incremental loading, and for animation
        formats, the image handler can assume that **image** points to the
        previous frame.

        **See also** **canRead** ().
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#setDevice

        **void QImageIOHandler::setDevice(QIODevice * device )**

        Sets the device of the **QImageIOHandler**  to **device**. The image
        handler will use this device when reading and writing images.

        The device can only be set once and must be set before calling
        **canRead** (), **read** (), **write** (), etc. If you need to read
        multiple files, construct multiple instances of the appropriate
        **QImageIOHandler**  subclass.

        **See also** **device** ().
        """
        ...

    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#setFormat

        **void QImageIOHandler::setFormat(const QByteArray & format )**

        Sets the format of the **QImageIOHandler**  to **format**. The format is
        most useful for handlers that support multiple image formats.

        **See also** **format** ().
        """
        ...

    def setOption(
        self, option: PySide6.QtGui.QImageIOHandler.ImageOption, value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#setOption

        **[virtual] void QImageIOHandler::setOption(QImageIOHandler::ImageOption
        option , const QVariant & value )**

        Sets the option **option** with the value **value**.

        **See also** **option** () and **ImageOption** .
        """
        ...

    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#supportsOption

        **[virtual] bool
        QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option )
        const**

        Returns `true` if the **QImageIOHandler**  supports the option
        **option** ; otherwise returns `false`. For example, if the
        **QImageIOHandler**  supports the **Size**  option, supportsOption(Size)
        must return true.

        **See also** **setOption** () and **option** ().
        """
        ...

    def write(self, image: Union[PySide6.QtGui.QImage, str]) -> bool:
        """
        https://doc.qt.io/qt-6/qimageiohandler.html#write

        **[virtual] bool QImageIOHandler::write(const QImage & image )**

        Writes the image **image** to the assigned device. Returns `true` on
        success; otherwise returns `false`.

        The default implementation does nothing, and simply returns `false`.
        """
        ...
