"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
import os
from enum import Enum
from typing import (
    Any,
    Callable,
    Iterable,
    Iterable,
    List,
    Optional,
    Sequence,
    Union,
    overload,
)
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QImage(PySide6.QtGui.QPaintDevice):
    """
    https://doc.qt.io/qt-6/qimage.html

    **Detailed Description**

    Qt provides four classes for handling image data: QImage, **QPixmap** ,
    **QBitmap**  and **QPicture** . QImage is designed and optimized for I/O,
    and for direct pixel access and manipulation, while **QPixmap**  is designed
    and optimized for showing images on screen. **QBitmap**  is only a
    convenience class that inherits **QPixmap** , ensuring a depth of 1.
    Finally, the **QPicture**  class is a paint device that records and replays
    **QPainter**  commands.

    Because QImage is a **QPaintDevice**  subclass, **QPainter**  can be used to
    draw directly onto images. When using **QPainter**  on a QImage, the
    painting can be performed in another thread than the current GUI thread.

    The QImage class supports several image formats described by the **Format**
    enum. These include monochrome, 8-bit, 32-bit and alpha-blended images which
    are available in all versions of Qt 4.x.

    QImage provides a collection of functions that can be used to obtain a
    variety of information about the image. There are also several functions
    that enables transformation of the image.

    QImage objects can be passed around by value since the QImage class uses
    **implicit data sharing** . QImage objects can also be streamed and
    compared.

    **Note:** If you would like to load QImage objects in a static build of Qt,
    refer to the **Plugin HowTo** .

    **Warning:** Painting on a QImage with the format
    **QImage::Format_Indexed8**  is not supported.

    **Reading and Writing Image Files**

    QImage provides several ways of loading an image file: The file can be
    loaded when constructing the QImage object, or by using the **load** () or
    **loadFromData** () functions later on. QImage also provides the static
    **fromData** () function, constructing a QImage from the given data. When
    loading an image, the file name can either refer to an actual file on disk
    or to one of the application's embedded resources. See **The Qt Resource
    System**  overview for details on how to embed images and other resource
    files in the application's executable.

    Simply call the **save** () function to save a QImage object.

    The complete list of supported file formats are available through the
    **QImageReader::supportedImageFormats** () and
    **QImageWriter::supportedImageFormats** () functions. New file formats can
    be added as plugins. By default, Qt supports the following formats:

    FormatDescriptionQt's support
    BMPWindows BitmapRead/write
    GIFGraphic
    Interchange Format (optional)Read
    JPGJoint Photographic Experts
    GroupRead/write
    JPEGJoint Photographic Experts GroupRead/write
    PNGPortable Network GraphicsRead/write
    PBMPortable BitmapRead
    PGMPortable GraymapRead
    PPMPortable PixmapRead/write
    XBMX11
    BitmapRead/write
    XPMX11 PixmapRead/write

    **Image Information**

    QImage provides a collection of functions that can be used to obtain a
    variety of information about the image:

    Available Functions
    GeometryThe **size** (), **width** (), **height** (),
    **dotsPerMeterX** (), and **dotsPerMeterY** () functions provide information
    about the image size and aspect ratio.

    The **rect** () function returns the
    image's enclosing rectangle. The **valid** () function tells if a given pair
    of coordinates is within this rectangle. The **offset** () function returns
    the number of pixels by which the image is intended to be offset by when
    positioned relative to other images, which also can be manipulated using the
    **setOffset** () function.

    ColorsThe color of a pixel can be retrieved
    by passing its coordinates to the **pixel** () function. The **pixel** ()
    function returns the color as a **QRgb**  value independent of the image's
    format.

    In case of monochrome and 8-bit images, the **colorCount** () and
    **colorTable** () functions provide information about the color components
    used to store the image data: The **colorTable** () function returns the
    image's entire color table. To obtain a single entry, use the **pixelIndex**
    () function to retrieve the pixel index for a given pair of coordinates,
    then use the **color** () function to retrieve the color. Note that if you
    create an 8-bit image manually, you have to set a valid color table on the
    image as well.

    The **hasAlphaChannel** () function tells if the image's
    format respects the alpha channel, or not. The **allGray** () and
    **isGrayscale** () functions tell whether an image's colors are all shades
    of gray.

    See also the **Pixel Manipulation**  and **Image Transformations**
    sections.

    TextThe **text** () function returns the image text
    associated with the given text key. An image's text keys can be retrieved
    using the **textKeys** () function. Use the **setText** () function to alter
    an image's text.
    Low-level informationThe **depth** () function returns
    the depth of the image. The supported depths are 1 (monochrome), 8, 16, 24
    and 32 bits. The **bitPlaneCount** () function tells how many of those bits
    that are used. For more information see the **Image Formats**  section.

    The
    **format** (), **bytesPerLine** (), and **sizeInBytes** () functions provide
    low-level information about the data stored in the image.

    The **cacheKey**
    () function returns a number that uniquely identifies the contents of this
    QImage object.

    **Pixel Manipulation**

    The functions used to manipulate an image's pixels depend on the image
    format. The reason is that monochrome and 8-bit images are index-based and
    use a color lookup table, while 32-bit images store ARGB values directly.
    For more information on image formats, see the **Image Formats**  section.

    In case of a 32-bit image, the **setPixel** () function can be used to alter
    the color of the pixel at the given coordinates to any other color specified
    as an ARGB quadruplet. To make a suitable **QRgb**  value, use the **qRgb**
    () (adding a default alpha component to the given RGB values, i.e. creating
    an opaque color) or **qRgba** () function. For example:

    32-bit
    ![](images/qimage-32bit_scaled.png)



        **QImage**
    image(3, 3, **QImage** ::Format_RGB32);
        **QRgb**  value;

        value
    = **qRgb** (189, 149, 39); // 0xffbd9527
        image.setPixel(1, 1, value);
    value = **qRgb** (122, 163, 39); // 0xff7aa327
        image.setPixel(0, 1,
    value);
        image.setPixel(1, 0, value);

        value = **qRgb** (237,
    187, 51); // 0xffedba31
        image.setPixel(2, 1, value);

    In case of a 8-bit and monchrome images, the pixel value is only an index
    from the image's color table. So the **setPixel** () function can only be
    used to alter the color of the pixel at the given coordinates to a
    predefined color from the image's color table, i.e. it can only change the
    pixel's index value. To alter or add a color to an image's color table, use
    the **setColor** () function.

    An entry in the color table is an ARGB quadruplet encoded as an **QRgb**
    value. Use the **qRgb** () and **qRgba** () functions to make a suitable
    **QRgb**  value for use with the **setColor** () function. For example:

    8-bit
    ![](images/qimage-8bit_scaled.png)



        **QImage**
    image(3, 3, **QImage** ::Format_Indexed8);
        **QRgb**  value;
    value = **qRgb** (122, 163, 39); // 0xff7aa327
        image.setColor(0, value);
    value = **qRgb** (237, 187, 51); // 0xffedba31
        image.setColor(1, value);
    value = **qRgb** (189, 149, 39); // 0xffbd9527
        image.setColor(2, value);
    image.setPixel(0, 1, 0);
        image.setPixel(1, 0, 0);
        image.setPixel(1,
    1, 2);
        image.setPixel(2, 1, 1);

    For images with more than 8-bit per color-channel. The methods
    **setPixelColor** () and **pixelColor** () can be used to set and get with
    **QColor**  values.

    QImage also provide the **scanLine** () function which returns a pointer to
    the pixel data at the scanline with the given index, and the **bits** ()
    function which returns a pointer to the first pixel data (this is equivalent
    to `scanLine(0)`).

    **Image Formats**

    Each pixel stored in a QImage is represented by an integer. The size of the
    integer varies depending on the format. QImage supports several image
    formats described by the **Format**  enum.

    Monochrome images are stored using 1-bit indexes into a color table with at
    most two colors. There are two different types of monochrome images: big
    endian (MSB first) or little endian (LSB first) bit order.

    8-bit images are stored using 8-bit indexes into a color table, i.e. they
    have a single byte per pixel. The color table is a **QList** <**QRgb** >,
    and the **QRgb**  typedef is equivalent to an unsigned int containing an
    ARGB quadruplet on the format 0xAARRGGBB.

    32-bit images have no color table; instead, each pixel contains an **QRgb**
    value. There are three different types of 32-bit images storing RGB (i.e.
    0xffRRGGBB), ARGB and premultiplied ARGB values respectively. In the
    premultiplied format the red, green, and blue channels are multiplied by the
    alpha component divided by 255.

    An image's format can be retrieved using the **format** () function. Use the
    **convertToFormat** () functions to convert an image into another format.
    The **allGray** () and **isGrayscale** () functions tell whether a color
    image can safely be converted to a grayscale image.

    **Image Transformations**

    QImage supports a number of functions for creating a new image that is a
    transformed version of the original: The **createAlphaMask** () function
    builds and returns a 1-bpp mask from the alpha buffer in this image, and the
    **createHeuristicMask** () function creates and returns a 1-bpp heuristic
    mask for this image. The latter function works by selecting a color from one
    of the corners, then chipping away pixels of that color starting at all the
    edges.

    The **mirrored** () function returns a mirror of the image in the desired
    direction, the **scaled** () returns a copy of the image scaled to a
    rectangle of the desired measures, and the **rgbSwapped** () function
    constructs a BGR image from a RGB image.

    The **scaledToWidth** () and **scaledToHeight** () functions return scaled
    copies of the image.

    The **transformed** () function returns a copy of the image that is
    transformed with the given transformation matrix and transformation mode:
    Internally, the transformation matrix is adjusted to compensate for unwanted
    translation, i.e. **transformed** () returns the smallest image containing
    all transformed points of the original image. The static **trueMatrix** ()
    function returns the actual matrix used for transforming the image.

    There are also functions for changing attributes of an image in-place:

    FunctionDescription
    **setDotsPerMeterX** ()Defines the aspect ratio by
    setting the number of pixels that fit horizontally in a physical meter.
    **setDotsPerMeterY** ()Defines the aspect ratio by setting the number of
    pixels that fit vertically in a physical meter.
    **fill** ()Fills the
    entire image with the given pixel value.
    **invertPixels** ()Inverts all
    pixel values in the image using the given **InvertMode**  value.
    **setColorTable** ()Sets the color table used to translate color indexes.
    Only monochrome and 8-bit formats.
    **setColorCount** ()Resizes the color
    table. Only monochrome and 8-bit formats.

    **See also** **QImageReader** , **QImageWriter** , **QPixmap** ,
    **QSvgRenderer** , **Image Composition Example** , **Image Viewer Example**
    , **Scribble Example** , and **Pixelator Example** .
    """

    Format_Invalid: QImage.Format = ...
    Format_Mono: QImage.Format = ...
    Format_MonoLSB: QImage.Format = ...
    Format_Indexed8: QImage.Format = ...
    Format_RGB32: QImage.Format = ...
    Format_ARGB32: QImage.Format = ...
    Format_ARGB32_Premultiplied: QImage.Format = ...
    Format_RGB16: QImage.Format = ...
    Format_ARGB8565_Premultiplied: QImage.Format = ...
    Format_RGB666: QImage.Format = ...
    Format_ARGB6666_Premultiplied: QImage.Format = ...
    Format_RGB555: QImage.Format = ...
    Format_ARGB8555_Premultiplied: QImage.Format = ...
    Format_RGB888: QImage.Format = ...
    Format_RGB444: QImage.Format = ...
    Format_ARGB4444_Premultiplied: QImage.Format = ...
    Format_RGBX8888: QImage.Format = ...
    Format_RGBA8888: QImage.Format = ...
    Format_RGBA8888_Premultiplied: QImage.Format = ...
    Format_BGR30: QImage.Format = ...
    Format_A2BGR30_Premultiplied: QImage.Format = ...
    Format_RGB30: QImage.Format = ...
    Format_A2RGB30_Premultiplied: QImage.Format = ...
    Format_Alpha8: QImage.Format = ...
    Format_Grayscale8: QImage.Format = ...
    Format_RGBX64: QImage.Format = ...
    Format_RGBA64: QImage.Format = ...
    Format_RGBA64_Premultiplied: QImage.Format = ...
    Format_Grayscale16: QImage.Format = ...
    Format_BGR888: QImage.Format = ...
    Format_RGBX16FPx4: QImage.Format = ...
    Format_RGBA16FPx4: QImage.Format = ...
    Format_RGBA16FPx4_Premultiplied: QImage.Format = ...
    Format_RGBX32FPx4: QImage.Format = ...
    Format_RGBA32FPx4: QImage.Format = ...
    Format_RGBA32FPx4_Premultiplied: QImage.Format = ...
    NImageFormats: QImage.Format = ...
    InvertRgb: QImage.InvertMode = ...
    InvertRgba: QImage.InvertMode = ...

    class Format(Enum):
        Format_Invalid: QImage.Format = ...
        Format_Mono: QImage.Format = ...
        Format_MonoLSB: QImage.Format = ...
        Format_Indexed8: QImage.Format = ...
        Format_RGB32: QImage.Format = ...
        Format_ARGB32: QImage.Format = ...
        Format_ARGB32_Premultiplied: QImage.Format = ...
        Format_RGB16: QImage.Format = ...
        Format_ARGB8565_Premultiplied: QImage.Format = ...
        Format_RGB666: QImage.Format = ...
        Format_ARGB6666_Premultiplied: QImage.Format = ...
        Format_RGB555: QImage.Format = ...
        Format_ARGB8555_Premultiplied: QImage.Format = ...
        Format_RGB888: QImage.Format = ...
        Format_RGB444: QImage.Format = ...
        Format_ARGB4444_Premultiplied: QImage.Format = ...
        Format_RGBX8888: QImage.Format = ...
        Format_RGBA8888: QImage.Format = ...
        Format_RGBA8888_Premultiplied: QImage.Format = ...
        Format_BGR30: QImage.Format = ...
        Format_A2BGR30_Premultiplied: QImage.Format = ...
        Format_RGB30: QImage.Format = ...
        Format_A2RGB30_Premultiplied: QImage.Format = ...
        Format_Alpha8: QImage.Format = ...
        Format_Grayscale8: QImage.Format = ...
        Format_RGBX64: QImage.Format = ...
        Format_RGBA64: QImage.Format = ...
        Format_RGBA64_Premultiplied: QImage.Format = ...
        Format_Grayscale16: QImage.Format = ...
        Format_BGR888: QImage.Format = ...
        Format_RGBX16FPx4: QImage.Format = ...
        Format_RGBA16FPx4: QImage.Format = ...
        Format_RGBA16FPx4_Premultiplied: QImage.Format = ...
        Format_RGBX32FPx4: QImage.Format = ...
        Format_RGBA32FPx4: QImage.Format = ...
        Format_RGBA32FPx4_Premultiplied: QImage.Format = ...
        NImageFormats: QImage.Format = ...

    class InvertMode(Enum):
        InvertRgb: QImage.InvertMode = ...
        InvertRgba: QImage.InvertMode = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage

        **QImage::QImage()**

        Constructs a null image.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(
        self, arg__1: str, arg__2: int, arg__3: int, arg__4: PySide6.QtGui.QImage.Format
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-1

        **QImage::QImage(const QSize & size , QImage::Format format )**

        Constructs an image with the given **size** and **format**.

        A **null**  image is returned if memory cannot be allocated.

        **Warning:** This will create a QImage with uninitialized data. Call
        **fill** () to fill the image with an appropriate pixel value before
        drawing onto it with **QPainter** .
        """
        ...

    @overload
    def __init__(
        self,
        arg__1: str,
        arg__2: int,
        arg__3: int,
        arg__4: int,
        arg__5: PySide6.QtGui.QImage.Format,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-2

        **QImage::QImage(int width , int height , QImage::Format format )**

        Constructs an image with the given **width** , **height** and
        **format**.

        A **null**  image will be returned if memory cannot be allocated.

        **Warning:** This will create a QImage with uninitialized data. Call
        **fill** () to fill the image with an appropriate pixel value before
        drawing onto it with **QPainter** .
        """
        ...

    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-3

        **QImage::QImage(uchar * data , int width , int height , QImage::Format
        format , QImageCleanupFunction cleanupFunction = nullptr, void *
        cleanupInfo = nullptr)**

        Constructs an image with the given **width** , **height** and **format**
        , that uses an existing memory buffer, **data**. The **width** and
        **height** must be specified in pixels, **data** must be 32-bit aligned,
        and each scanline of data in the image must also be 32-bit aligned.

        The buffer must remain valid throughout the life of the QImage and all
        copies that have not been modified or otherwise detached from the
        original buffer. The image does not delete the buffer at destruction.
        You can provide a function pointer **cleanupFunction** along with an
        extra pointer **cleanupInfo** that will be called when the last copy is
        destroyed.

        If **format** is an indexed color format, the image color table is
        initially empty and must be sufficiently expanded with **setColorCount**
        () or **setColorTable** () before the image is used.
        """
        ...

    @overload
    def __init__(
        self,
        data: bytes,
        width: int,
        height: int,
        bytesPerLine: int,
        format: PySide6.QtGui.QImage.Format,
        cleanupFunction: Optional[Callable] = ...,
        cleanupInfo: Optional[int] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-4

        **QImage::QImage(const uchar * data , int width , int height ,
        QImage::Format format , QImageCleanupFunction cleanupFunction = nullptr,
        void * cleanupInfo = nullptr)**

        Constructs an image with the given **width** , **height** and **format**
        , that uses an existing read-only memory buffer, **data**. The **width**
        and **height** must be specified in pixels, **data** must be 32-bit
        aligned, and each scanline of data in the image must also be 32-bit
        aligned.

        The buffer must remain valid throughout the life of the QImage and all
        copies that have not been modified or otherwise detached from the
        original buffer. The image does not delete the buffer at destruction.
        You can provide a function pointer **cleanupFunction** along with an
        extra pointer **cleanupInfo** that will be called when the last copy is
        destroyed.

        If **format** is an indexed color format, the image color table is
        initially empty and must be sufficiently expanded with **setColorCount**
        () or **setColorTable** () before the image is used.

        Unlike the similar QImage constructor that takes a non-const data
        buffer, this version will never alter the contents of the buffer. For
        example, calling **QImage::bits** () will return a deep copy of the
        image, rather than the buffer passed to the constructor. This allows for
        the efficiency of constructing a QImage from raw data, without the
        possibility of the raw data being changed.
        """
        ...

    @overload
    def __init__(
        self,
        data: bytes,
        width: int,
        height: int,
        format: PySide6.QtGui.QImage.Format,
        cleanupFunction: Optional[Callable] = ...,
        cleanupInfo: Optional[int] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-5

        **QImage::QImage(uchar * data , int width , int height , qsizetype
        bytesPerLine , QImage::Format format , QImageCleanupFunction
        cleanupFunction = nullptr, void * cleanupInfo = nullptr)**

        Constructs an image with the given **width** , **height** and **format**
        , that uses an existing memory buffer, **data**. The **width** and
        **height** must be specified in pixels. **bytesPerLine** specifies the
        number of bytes per line (stride).

        The buffer must remain valid throughout the life of the QImage and all
        copies that have not been modified or otherwise detached from the
        original buffer. The image does not delete the buffer at destruction.
        You can provide a function pointer **cleanupFunction** along with an
        extra pointer **cleanupInfo** that will be called when the last copy is
        destroyed.

        If **format** is an indexed color format, the image color table is
        initially empty and must be sufficiently expanded with **setColorCount**
        () or **setColorTable** () before the image is used.
        """
        ...

    @overload
    def __init__(
        self, fileName: Union[str, bytes, os.PathLike], format: Optional[bytes] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-6

        **QImage::QImage(const uchar * data , int width , int height , qsizetype
        bytesPerLine , QImage::Format format , QImageCleanupFunction
        cleanupFunction = nullptr, void * cleanupInfo = nullptr)**

        Constructs an image with the given **width** , **height** and **format**
        , that uses an existing memory buffer, **data**. The **width** and
        **height** must be specified in pixels. **bytesPerLine** specifies the
        number of bytes per line (stride).

        The buffer must remain valid throughout the life of the QImage and all
        copies that have not been modified or otherwise detached from the
        original buffer. The image does not delete the buffer at destruction.
        You can provide a function pointer **cleanupFunction** along with an
        extra pointer **cleanupInfo** that will be called when the last copy is
        destroyed.

        If **format** is an indexed color format, the image color table is
        initially empty and must be sufficiently expanded with **setColorCount**
        () or **setColorTable** () before the image is used.

        Unlike the similar QImage constructor that takes a non-const data
        buffer, this version will never alter the contents of the buffer. For
        example, calling **QImage::bits** () will return a deep copy of the
        image, rather than the buffer passed to the constructor. This allows for
        the efficiency of constructing a QImage from raw data, without the
        possibility of the raw data being changed.
        """
        ...

    @overload
    def __init__(
        self, size: PySide6.QtCore.QSize, format: PySide6.QtGui.QImage.Format
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-7

        **QImage::QImage(const char *const [] xpm )**

        Constructs an image from the given **xpm** image.

        Make sure that the image is a valid XPM image. Errors are silently
        ignored.

        Note that it's possible to squeeze the XPM variable a little bit by
        using an unusual declaration:

        static const char * const start_xpm[] = {
                "16 15 8 1",
        "a c #cec6bd",
                // etc.
            };

        The extra `const` makes the entire definition read-only, which is
        slightly more efficient (e.g., when the code is in a shared library) and
        able to be stored in ROM with the application.
        """
        ...

    @overload
    def __init__(
        self, width: int, height: int, format: PySide6.QtGui.QImage.Format
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-8

        **QImage::QImage(const QString & fileName , const char * format =
        nullptr)**

        Constructs an image and tries to load the image from the file with the
        given **fileName**.

        The loader attempts to read the image using the specified **format**. If
        the **format** is not specified (which is the default), it is auto-
        detected based on the file's suffix and header. For details, see
        {**QImageReader::setAutoDetectImageFormat** ()}{**QImageReader** }.

        If the loading of the image failed, this object is a null image.

        The file name can either refer to an actual file on disk or to one of
        the application's embedded resources. See the **Resource System**
        overview for details on how to embed images and other resource files in
        the application's executable.

        **See also** **isNull** () and **Reading and Writing Image Files** .
        """
        ...

    @overload
    def __init__(self, xpm: Iterable) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#QImage-9

        **QImage::QImage(const QImage & image )**

        Constructs a shallow copy of the given **image**.

        For more information about shallow copies, see the **Implicit Data
        Sharing**  documentation.

        **See also** **copy** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def allGray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#allGray

        **bool QImage::allGray() const**

        Returns `true` if all the colors in the image are shades of gray (i.e.
        their red, green and blue components are equal); otherwise false.

        Note that this function is slow for images without color table.

        **See also** **isGrayscale** ().
        """
        ...

    def applyColorTransform(self, transform: PySide6.QtGui.QColorTransform) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#applyColorTransform

        **[since 5.14] void QImage::applyColorTransform(const QColorTransform &
        transform )**

        Applies the color transformation **transform** to all pixels in the
        image.

        This function was introduced in Qt 5.14.
        """
        ...

    def bitPlaneCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#bitPlaneCount

        **int QImage::bitPlaneCount() const**

        Returns the number of bit planes in the image.

        The number of bit planes is the number of bits of color and transparency
        information for each pixel. This is different from (i.e. smaller than)
        the depth when the image format contains unused bits.

        **See also** **depth** (), **format** (), and **Image Formats** .
        """
        ...

    def bits(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qimage.html#bits

        **uchar *QImage::bits()**

        Returns a pointer to the first pixel data. This is equivalent to
        **scanLine** (0).

        Note that **QImage**  uses **implicit data sharing** . This function
        performs a deep copy of the shared pixel data, thus ensuring that this
        **QImage**  is the only one using the current return value.

        **See also** **scanLine** (), **sizeInBytes** (), and **constBits** ().
        """
        ...

    def bytesPerLine(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#bytesPerLine

        **qsizetype QImage::bytesPerLine() const**

        Returns the number of bytes per image scanline.

        This is equivalent to **sizeInBytes** () / **height** () if **height**
        () is non-zero.

        **See also** **scanLine** ().
        """
        ...

    def cacheKey(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#cacheKey

        **qint64 QImage::cacheKey() const**

        Returns a number that identifies the contents of this **QImage**
        object. Distinct **QImage**  objects can only have the same key if they
        refer to the same contents.

        The key will change when the image is altered.
        """
        ...

    def color(self, i: int) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#color

        **QRgb QImage::color(int i ) const**

        Returns the color in the color table at index **i**. The first color is
        at index 0.

        The colors in an image's color table are specified as ARGB quadruplets
        (**QRgb** ). Use the qAlpha(), qRed(), qGreen(), and qBlue() functions
        to get the color value components.

        **See also** **setColor** (), **pixelIndex** (), and **Pixel
        Manipulation** .
        """
        ...

    def colorCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#colorCount

        **int QImage::colorCount() const**

        Returns the size of the color table for the image.

        Notice that colorCount() returns 0 for 32-bpp images because these
        images do not use color tables, but instead encode pixel values as ARGB
        quadruplets.

        **See also** **setColorCount** () and **Image Information** .
        """
        ...

    def colorSpace(self) -> PySide6.QtGui.QColorSpace:
        """
        https://doc.qt.io/qt-6/qimage.html#colorSpace

        **[since 5.14] QColorSpace QImage::colorSpace() const**

        Returns the color space of the image if a color space is defined.

        This function was introduced in Qt 5.14.

        **See also** **setColorSpace** ().
        """
        ...

    def colorTable(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qimage.html#colorTable

        **QList<QRgb> QImage::colorTable() const**

        Returns a list of the colors contained in the image's color table, or an
        empty list if the image does not have a color table

        **See also** **setColorTable** (), **colorCount** (), and **color** ().
        """
        ...

    def constBits(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qimage.html#constBits

        **const uchar *QImage::constBits() const**

        Returns a pointer to the first pixel data.

        Note that **QImage**  uses **implicit data sharing** , but this function
        does **not** perform a deep copy of the shared pixel data, because the
        returned data is const.

        **See also** **bits** () and **constScanLine** ().
        """
        ...

    def constScanLine(self, arg__1: int) -> object:
        """
        https://doc.qt.io/qt-6/qimage.html#constScanLine

        **const uchar *QImage::constScanLine(int i ) const**

        Returns a pointer to the pixel data at the scanline with index **i**.
        The first scanline is at index 0.

        The scanline data is as minimum 32-bit aligned. For 64-bit formats it
        follows the native alignment of 64-bit integers (64-bit for most
        platforms, but notably 32-bit on i386).

        Note that **QImage**  uses **implicit data sharing** , but this function
        does **not** perform a deep copy of the shared pixel data, because the
        returned data is const.

        **See also** **scanLine** () and **constBits** ().
        """
        ...

    def convertTo(
        self,
        f: PySide6.QtGui.QImage.Format,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#convertTo

        **[since 5.13] void QImage::convertTo(QImage::Format format ,
        Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Converts the image to the given **format** in place, detaching if
        necessary.

        The specified image conversion **flags** control how the image data is
        handled during the conversion process.

        This function was introduced in Qt 5.13.

        **See also** **convertedTo** ().
        """
        ...

    def convertToColorSpace(
        self,
        arg__1: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#convertToColorSpace

        **[since 5.14] void QImage::convertToColorSpace(const QColorSpace &
        colorSpace )**

        Converts the image to **colorSpace**.

        If the image has no valid color space, the method does nothing.

        This function was introduced in Qt 5.14.

        **See also** **convertedToColorSpace** () and **setColorSpace** ().
        """
        ...

    @overload
    def convertToFormat(
        self,
        f: PySide6.QtGui.QImage.Format,
        colorTable: Sequence[int],
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#convertToFormat-2

        **QImage QImage::convertToFormat(QImage::Format format , const
        QList<QRgb> & colorTable , Qt::ImageConversionFlags flags =
        Qt::AutoColor) const**

        This is an overloaded function.

        Returns a copy of the image converted to the given **format** , using
        the specified **colorTable**.

        Conversion from RGB formats to indexed formats is a slow operation and
        will use a straightforward nearest color approach, with no dithering.
        """
        ...

    @overload
    def convertToFormat(
        self,
        f: PySide6.QtGui.QImage.Format,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#convertToFormat-2

        **QImage QImage::convertToFormat(QImage::Format format , const
        QList<QRgb> & colorTable , Qt::ImageConversionFlags flags =
        Qt::AutoColor) const**

        This is an overloaded function.

        Returns a copy of the image converted to the given **format** , using
        the specified **colorTable**.

        Conversion from RGB formats to indexed formats is a slow operation and
        will use a straightforward nearest color approach, with no dithering.
        """
        ...

    def convertToFormat_helper(
        self,
        format: PySide6.QtGui.QImage.Format,
        flags: PySide6.QtCore.Qt.ImageConversionFlags,
    ) -> PySide6.QtGui.QImage:
        ...

    def convertToFormat_inplace(
        self,
        format: PySide6.QtGui.QImage.Format,
        flags: PySide6.QtCore.Qt.ImageConversionFlags,
    ) -> bool:
        ...

    def convertedTo(
        self,
        f: PySide6.QtGui.QImage.Format,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QImage:
        ...

    def convertedToColorSpace(
        self,
        arg__1: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#convertedToColorSpace

        **[since 5.14] QImage QImage::convertedToColorSpace(const QColorSpace &
        colorSpace ) const**

        Returns the image converted to **colorSpace**.

        If the image has no valid color space, a null **QImage**  is returned.

        This function was introduced in Qt 5.14.

        **See also** **convertToColorSpace** ().
        """
        ...

    @overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#copy

        **QImage QImage::copy(const QRect & rectangle = QRect()) const**

        Returns a sub-area of the image as a new image.

        The returned image is copied from the position ( **rectangle**.x(),
        **rectangle**.y()) in this image, and will always have the size of the
        given **rectangle**.

        In areas beyond this image, pixels are set to 0. For 32-bit RGB images,
        this means black; for 32-bit ARGB images, this means transparent black;
        for 8-bit images, this means the color with index 0 in the color table
        which can be anything; for 1-bit images, this means **Qt::color0** .

        If the given **rectangle** is a null rectangle the entire image is
        copied.

        **See also** **QImage** ().
        """
        ...

    @overload
    def copy(self, x: int, y: int, w: int, h: int) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#copy-1

        **QImage QImage::copy(int x , int y , int width , int height ) const**

        This is an overloaded function.

        The returned image is copied from the position ( **x** , **y** ) in this
        image, and will always have the given **width** and **height**. In areas
        beyond this image, pixels are set to 0.
        """
        ...

    def createAlphaMask(
        self, flags: PySide6.QtCore.Qt.ImageConversionFlags = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#createAlphaMask

        **QImage QImage::createAlphaMask(Qt::ImageConversionFlags flags =
        Qt::AutoColor) const**

        Builds and returns a 1-bpp mask from the alpha buffer in this image.
        Returns a null image if the image's format is **QImage::Format_RGB32** .

        The **flags** argument is a bitwise-OR of the
        **Qt::ImageConversionFlags** , and controls the conversion process.
        Passing 0 for flags sets all the default options.

        The returned image has little-endian bit order (i.e. the image's format
        is **QImage::Format_MonoLSB** ), which you can convert to big-endian
        (**QImage::Format_Mono** ) using the **convertToFormat** () function.

        **See also** **createHeuristicMask** () and **Image Transformations** .
        """
        ...

    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#createHeuristicMask

        **QImage QImage::createHeuristicMask(bool clipTight = true) const**

        Creates and returns a 1-bpp heuristic mask for this image.

        The function works by selecting a color from one of the corners, then
        chipping away pixels of that color starting at all the edges. The four
        corners vote for which color is to be masked away. In case of a draw
        (this generally means that this function is not applicable to the
        image), the result is arbitrary.

        The returned image has little-endian bit order (i.e. the image's format
        is **QImage::Format_MonoLSB** ), which you can convert to big-endian
        (**QImage::Format_Mono** ) using the **convertToFormat** () function.

        If **clipTight** is true (the default) the mask is just large enough to
        cover the pixels; otherwise, the mask is larger than the data pixels.

        Note that this function disregards the alpha buffer.

        **See also** **createAlphaMask** () and **Image Transformations** .
        """
        ...

    def createMaskFromColor(
        self, color: int, mode: PySide6.QtCore.Qt.MaskMode = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#createMaskFromColor

        **QImage QImage::createMaskFromColor(QRgb color , Qt::MaskMode mode =
        Qt::MaskInColor) const**

        Creates and returns a mask for this image based on the given **color**
        value. If the **mode** is MaskInColor (the default value), all pixels
        matching **color** will be opaque pixels in the mask. If **mode** is
        MaskOutColor, all pixels matching the given color will be transparent.

        **See also** **createAlphaMask** () and **createHeuristicMask** ().
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#depth

        **int QImage::depth() const**

        Returns the depth of the image.

        The image depth is the number of bits used to store a single pixel, also
        called bits per pixel (bpp).

        The supported depths are 1, 8, 16, 24, 32 and 64.

        **See also** **bitPlaneCount** (), **convertToFormat** (), **Image
        Formats** , and **Image Information** .
        """
        ...

    def devType(self) -> int:
        ...

    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qimage.html#deviceIndependentSize

        **QSizeF QImage::deviceIndependentSize() const**

        Returns the size of the pixmap in device independent pixels.

        This value should be used when using the pixmap size in user interface
        size calculations.

        The return value is equivalent to pixmap.**size** () /
        pixmap.**devicePixelRatio** (),
        """
        ...

    def devicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qimage.html#devicePixelRatio

        **qreal QImage::devicePixelRatio() const**

        Returns the device pixel ratio for the image. This is the ratio between
        **device pixels** and **device independent pixels**.

        Use this function when calculating layout geometry based on the image
        size: **QSize**  layoutSize = image.**size** () /
        image.devicePixelRatio()

        The default value is 1.0.

        **See also** **setDevicePixelRatio** () and **QImageReader** .
        """
        ...

    def dotsPerMeterX(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#dotsPerMeterX

        **int QImage::dotsPerMeterX() const**

        Returns the number of pixels that fit horizontally in a physical meter.
        Together with **dotsPerMeterY** (), this number defines the intended
        scale and aspect ratio of the image.

        **See also** **setDotsPerMeterX** () and **Image Information** .
        """
        ...

    def dotsPerMeterY(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#dotsPerMeterY

        **int QImage::dotsPerMeterY() const**

        Returns the number of pixels that fit vertically in a physical meter.
        Together with **dotsPerMeterX** (), this number defines the intended
        scale and aspect ratio of the image.

        **See also** **setDotsPerMeterY** () and **Image Information** .
        """
        ...

    @overload
    def fill(self, color: PySide6.QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#fill

        **void QImage::fill(uint pixelValue )**

        Fills the entire image with the given **pixelValue**.

        If the depth of this image is 1, only the lowest bit is used. If you say
        fill(0), fill(2), etc., the image is filled with 0s. If you say fill(1),
        fill(3), etc., the image is filled with 1s. If the depth is 8, the
        lowest 8 bits are used and if the depth is 16 the lowest 16 bits are
        used.

        If the image depth is higher than 32bit the result is undefined.

        **Note:** There are no corresponding value getter, though
        **QImage::pixelIndex** () will return the same value for indexed
        formats, and **QImage::pixel** () for RGB32, ARGB32, and ARGB32PM
        formats.

        **See also** **depth** () and **Image Transformations** .
        """
        ...

    @overload
    def fill(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#fill-1

        **void QImage::fill(const QColor & color )**

        This is an overloaded function.

        Fills the entire image with the given **color**.

        If the depth of the image is 1, the image will be filled with 1 if
        **color** equals **Qt::color1** ; it will otherwise be filled with 0.

        If the depth of the image is 8, the image will be filled with the index
        corresponding the **color** in the color table if present; it will
        otherwise be filled with 0.
        """
        ...

    @overload
    def fill(self, pixel: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#fill-2

        **void QImage::fill(Qt::GlobalColor color )**

        This is an overloaded function.

        Fills the image with the given **color** , described as a standard
        global color.
        """
        ...

    def format(self) -> PySide6.QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qimage.html#format

        **QImage::Format QImage::format() const**

        Returns the format of the image.

        **See also** **Image Formats** .
        """
        ...

    @staticmethod
    def fromData(
        data: Union[PySide6.QtCore.QByteArray, bytes], format: Optional[bytes] = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#fromData

        **[static, since 6.2] QImage QImage::fromData(QByteArrayView data ,
        const char * format = nullptr)**

        Constructs an image from the given **QByteArrayView**  **data**. The
        loader attempts to read the image using the specified **format**. If
        **format** is not specified (which is the default), the loader probes
        the data for a header to guess the file format.

        If **format** is specified, it must be one of the values returned by
        **QImageReader::supportedImageFormats** ().

        If the loading of the image fails, the image returned will be a null
        image.

        This function was introduced in Qt 6.2.

        **See also** **load** (), **save** (), and **Reading and Writing Image
        Files** .
        """
        ...

    def hasAlphaChannel(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#hasAlphaChannel

        **bool QImage::hasAlphaChannel() const**

        Returns `true` if the image has a format that respects the alpha
        channel, otherwise returns `false`.

        **See also** **Image Information** .
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#height

        **int QImage::height() const**

        Returns the height of the image.

        **See also** **Image Information** .
        """
        ...

    def invertPixels(self, mode: PySide6.QtGui.QImage.InvertMode = ...) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#invertPixels

        **void QImage::invertPixels(QImage::InvertMode mode = InvertRgb)**

        Inverts all pixel values in the image.

        The given invert **mode** only have a meaning when the image's depth is
        32. The default **mode** is **InvertRgb** , which leaves the alpha
        channel unchanged. If the **mode** is **InvertRgba** , the alpha bits
        are also inverted.

        Inverting an 8-bit image means to replace all pixels using color index
        **i** with a pixel using color index 255 minus **i**. The same is the
        case for a 1-bit image. Note that the color table is **not** changed.

        If the image has a premultiplied alpha channel, the image is first
        converted to an unpremultiplied image format to be inverted and then
        converted back.

        **See also** **Image Transformations** .
        """
        ...

    def isGrayscale(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#isGrayscale

        **bool QImage::isGrayscale() const**

        For 32-bit images, this function is equivalent to **allGray** ().

        For color indexed images, this function returns `true` if color(i) is
        **QRgb** (i, i, i) for all indexes of the color table; otherwise returns
        `false`.

        **See also** **allGray** () and **Image Formats** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#isNull

        **bool QImage::isNull() const**

        Returns `true` if it is a null image, otherwise returns `false`.

        A null image has all parameters set to zero and no allocated data.
        """
        ...

    @overload
    def load(self, device: PySide6.QtCore.QIODevice, format: bytes) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#load

        **bool QImage::load(const QString & fileName , const char * format =
        nullptr)**

        Loads an image from the file with the given **fileName**. Returns `true`
        if the image was successfully loaded; otherwise invalidates the image
        and returns `false`.

        The loader attempts to read the image using the specified **format** ,
        e.g., PNG or JPG. If **format** is not specified (which is the default),
        it is auto-detected based on the file's suffix and header. For details,
        see **QImageReader::setAutoDetectImageFormat** ().

        The file name can either refer to an actual file on disk or to one of
        the application's embedded resources. See the **Resource System**
        overview for details on how to embed images and other resource files in
        the application's executable.

        **See also** **Reading and Writing Image Files** .
        """
        ...

    @overload
    def load(self, fileName: str, format: Optional[bytes] = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#load-1

        **bool QImage::load(QIODevice * device , const char * format )**

        This is an overloaded function.

        This function reads a **QImage**  from the given **device**. This can,
        for example, be used to load an image directly into a **QByteArray** .
        """
        ...

    def loadFromData(
        self,
        data: Union[PySide6.QtCore.QByteArray, bytes],
        format: Optional[bytes] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#loadFromData

        **[since 6.2] bool QImage::loadFromData(QByteArrayView data , const char
        * format = nullptr)**

        Loads an image from the given **QByteArrayView**  **data**. Returns
        `true` if the image was successfully loaded; otherwise invalidates the
        image and returns `false`.

        The loader attempts to read the image using the specified **format** ,
        e.g., PNG or JPG. If **format** is not specified (which is the default),
        the loader probes the file for a header to guess the file format.

        This function was introduced in Qt 6.2.

        **See also** **Reading and Writing Image Files** .
        """
        ...

    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def mirror(self, horizontally: bool = ..., vertically: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#mirror

        **[since 6.0] void QImage::mirror(bool horizontal = false, bool vertical
        = true)**

        Mirrors of the image in the horizontal and/or the vertical direction
        depending on whether **horizontal** and **vertical** are set to true or
        false.

        This function was introduced in Qt 6.0.

        **See also** **mirrored** () and **Image Transformations** .
        """
        ...

    def mirrored(
        self, horizontally: bool = ..., vertically: bool = ...
    ) -> PySide6.QtGui.QImage:
        ...

    def mirrored_helper(self, horizontal: bool, vertical: bool) -> PySide6.QtGui.QImage:
        ...

    def mirrored_inplace(self, horizontal: bool, vertical: bool) -> None:
        ...

    def offset(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qimage.html#offset

        **QPoint QImage::offset() const**

        Returns the number of pixels by which the image is intended to be offset
        by when positioning relative to other images.

        **See also** **setOffset** () and **Image Information** .
        """
        ...

    def paintEngine(self) -> PySide6.QtGui.QPaintEngine:
        ...

    @overload
    def pixel(self, pt: PySide6.QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#pixel

        **QRgb QImage::pixel(const QPoint & position ) const**

        Returns the color of the pixel at the given **position**.

        If the **position** is not valid, the results are undefined.

        **Warning:** This function is expensive when used for massive pixel
        manipulations. Use **constBits** () or **constScanLine** () when many
        pixels needs to be read.

        **See also** **setPixel** (), **valid** (), **constBits** (),
        **constScanLine** (), and **Pixel Manipulation** .
        """
        ...

    @overload
    def pixel(self, x: int, y: int) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#pixel-1

        **QRgb QImage::pixel(int x , int y ) const**

        This is an overloaded function.

        Returns the color of the pixel at coordinates ( **x** , **y** ).
        """
        ...

    @overload
    def pixelColor(self, pt: PySide6.QtCore.QPoint) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qimage.html#pixelColor

        **[since 5.6] QColor QImage::pixelColor(const QPoint & position )
        const**

        Returns the color of the pixel at the given **position** as a **QColor**
        .

        If the **position** is not valid, an invalid **QColor**  is returned.

        **Warning:** This function is expensive when used for massive pixel
        manipulations. Use **constBits** () or **constScanLine** () when many
        pixels needs to be read.

        This function was introduced in Qt 5.6.

        **See also** **setPixelColor** (), **setPixel** (), **valid** (),
        **constBits** (), **constScanLine** (), and **Pixel Manipulation** .
        """
        ...

    @overload
    def pixelColor(self, x: int, y: int) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qimage.html#pixelColor-1

        **[since 5.6] QColor QImage::pixelColor(int x , int y ) const**

        This is an overloaded function.

        Returns the color of the pixel at coordinates ( **x** , **y** ) as a
        **QColor** .

        This function was introduced in Qt 5.6.
        """
        ...

    def pixelFormat(self) -> PySide6.QtGui.QPixelFormat:
        """
        https://doc.qt.io/qt-6/qimage.html#pixelFormat

        **QPixelFormat QImage::pixelFormat() const**

        Returns the **QImage::Format**  as a **QPixelFormat**
        """
        ...

    @overload
    def pixelIndex(self, pt: PySide6.QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#pixelIndex

        **int QImage::pixelIndex(const QPoint & position ) const**

        Returns the pixel index at the given **position**.

        If **position** is not valid, or if the image is not a paletted image
        (**depth** () > 8), the results are undefined.

        **See also** **valid** (), **depth** (), and **Pixel Manipulation** .
        """
        ...

    @overload
    def pixelIndex(self, x: int, y: int) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#pixelIndex-1

        **int QImage::pixelIndex(int x , int y ) const**

        This is an overloaded function.

        Returns the pixel index at ( **x** , **y** ).
        """
        ...

    def rect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qimage.html#rect

        **QRect QImage::rect() const**

        Returns the enclosing rectangle (0, 0, **width** (), **height** ()) of
        the image.

        **See also** **Image Information** .
        """
        ...

    def reinterpretAsFormat(self, f: PySide6.QtGui.QImage.Format) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#reinterpretAsFormat

        **[since 5.9] bool QImage::reinterpretAsFormat(QImage::Format format )**

        Changes the format of the image to **format** without changing the data.
        Only works between formats of the same depth.

        Returns `true` if successful.

        This function can be used to change images with alpha-channels to their
        corresponding opaque formats if the data is known to be opaque-only, or
        to change the format of a given image buffer before overwriting it with
        new data.

        **Warning:** The function does not check if the image data is valid in
        the new format and will still return `true` if the depths are
        compatible. Operations on an image with invalid data are undefined.

        **Warning:** If the image is not detached, this will cause the data to
        be copied.

        This function was introduced in Qt 5.9.

        **See also** **hasAlphaChannel** () and **convertToFormat** ().
        """
        ...

    def rgbSwap(self) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#rgbSwap

        **[since 6.0] void QImage::rgbSwap()**

        Swaps the values of the red and blue components of all pixels,
        effectively converting an RGB image to an BGR image.

        This function was introduced in Qt 6.0.

        **See also** **rgbSwapped** () and **Image Transformations** .
        """
        ...

    def rgbSwapped(self) -> PySide6.QtGui.QImage:
        ...

    def rgbSwapped_helper(self) -> PySide6.QtGui.QImage:
        ...

    def rgbSwapped_inplace(self) -> None:
        ...

    @overload
    def save(
        self,
        device: PySide6.QtCore.QIODevice,
        format: Optional[bytes] = ...,
        quality: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#save

        **bool QImage::save(const QString & fileName , const char * format =
        nullptr, int quality = -1) const**

        Saves the image to the file with the given **fileName** , using the
        given image file **format** and **quality** factor. If **format** is
        `nullptr`, **QImage**  will attempt to guess the format by looking at
        **fileName** 's suffix.

        The **quality** factor must be in the range 0 to 100 or -1. Specify 0 to
        obtain small compressed files, 100 for large uncompressed files, and -1
        (the default) to use the default settings.

        Returns `true` if the image was successfully saved; otherwise returns
        `false`.

        **See also** **Reading and Writing Image Files** .
        """
        ...

    @overload
    def save(
        self, fileName: str, format: Optional[bytes] = ..., quality: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#save-1

        **bool QImage::save(QIODevice * device , const char * format = nullptr,
        int quality = -1) const**

        This is an overloaded function.

        This function writes a **QImage**  to the given **device**.

        This can, for example, be used to save an image directly into a
        **QByteArray** :

        **QImage**  image;
            **QByteArray**  ba;
            **QBuffer**  buffer(&ba);
        buffer.open(**QIODevice** ::WriteOnly);
            image.save(&buffer, "PNG");
        // writes image into ba in PNG format
        """
        ...

    @overload
    def scaled(
        self,
        s: PySide6.QtCore.QSize,
        aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ...,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#scaled

        **QImage QImage::scaled(const QSize & size , Qt::AspectRatioMode
        aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode
        transformMode = Qt::FastTransformation) const**

        Returns a copy of the image scaled to a rectangle defined by the given
        **size** according to the given **aspectRatioMode** and
        **transformMode**.

        ![](images/qimage-scaling.png)

        * If **aspectRatioMode** is **Qt::IgnoreAspectRatio** , the image is
        scaled to **size**.
          * If **aspectRatioMode** is
        **Qt::KeepAspectRatio** , the image is scaled to a rectangle as large as
        possible inside **size** , preserving the aspect ratio.
          * If
        **aspectRatioMode** is **Qt::KeepAspectRatioByExpanding** , the image is
        scaled to a rectangle as small as possible outside **size** , preserving
        the aspect ratio.

        If the given **size** is empty, this function returns a null image.

        **See also** **isNull** () and **Image Transformations** .
        """
        ...

    @overload
    def scaled(
        self,
        w: int,
        h: int,
        aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ...,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#scaled-1

        **QImage QImage::scaled(int width , int height , Qt::AspectRatioMode
        aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode
        transformMode = Qt::FastTransformation) const**

        This is an overloaded function.

        Returns a copy of the image scaled to a rectangle with the given
        **width** and **height** according to the given **aspectRatioMode** and
        **transformMode**.

        If either the **width** or the **height** is zero or negative, this
        function returns a null image.
        """
        ...

    def scaledToHeight(
        self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#scaledToHeight

        **QImage QImage::scaledToHeight(int height , Qt::TransformationMode mode
        = Qt::FastTransformation) const**

        Returns a scaled copy of the image. The returned image is scaled to the
        given **height** using the specified transformation **mode**.

        This function automatically calculates the width of the image so that
        the ratio of the image is preserved.

        If the given **height** is 0 or negative, a null image is returned.

        **See also** **Image Transformations** .
        """
        ...

    def scaledToWidth(
        self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#scaledToWidth

        **QImage QImage::scaledToWidth(int width , Qt::TransformationMode mode =
        Qt::FastTransformation) const**

        Returns a scaled copy of the image. The returned image is scaled to the
        given **width** using the specified transformation **mode**.

        This function automatically calculates the height of the image so that
        its aspect ratio is preserved.

        If the given **width** is 0 or negative, a null image is returned.

        **See also** **Image Transformations** .
        """
        ...

    def scanLine(self, arg__1: int) -> object:
        """
        https://doc.qt.io/qt-6/qimage.html#scanLine

        **uchar *QImage::scanLine(int i )**

        Returns a pointer to the pixel data at the scanline with index **i**.
        The first scanline is at index 0.

        The scanline data is as minimum 32-bit aligned. For 64-bit formats it
        follows the native alignment of 64-bit integers (64-bit for most
        platforms, but notably 32-bit on i386).

        For example, to remove the green component of each pixel in an image:

        for (int y = 0; y < image.height(); ++y) {
                **QRgb**  *line =
        reinterpret_cast<**QRgb** \\*>(image.scanLine(y));
                for (int x =
        0; x < image.width(); ++x) {
                    **QRgb**  &rgb = line[x];
        rgb = **qRgba** (qRed(rgb), qGreen(0), qBlue(rgb), qAlpha(rgb));
        }
            }

        **Warning:** If you are accessing 32-bpp image data, cast the returned
        pointer to `QRgb*` (**QRgb**  has a 32-bit size) and use it to
        read/write the pixel value. You cannot use the `uchar*` pointer
        directly, because the pixel format depends on the byte order on the
        underlying platform. Use qRed(), qGreen(), qBlue(), and qAlpha() to
        access the pixels.

        **See also** **bytesPerLine** (), **bits** (), **Pixel Manipulation** ,
        and **constScanLine** ().
        """
        ...

    def setAlphaChannel(self, alphaChannel: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setAlphaChannel

        **void QImage::setAlphaChannel(const QImage & alphaChannel )**

        Sets the alpha channel of this image to the given **alphaChannel**.

        If **alphaChannel** is an 8 bit alpha image, the alpha values are used
        directly. Otherwise, **alphaChannel** is converted to 8 bit grayscale
        and the intensity of the pixel values is used.

        If the image already has an alpha channel, the existing alpha channel is
        multiplied with the new one. If the image doesn't have an alpha channel
        it will be converted to a format that does.

        The operation is similar to painting **alphaChannel** as an alpha image
        over this image using `QPainter::CompositionMode_DestinationIn`.

        **See also** **hasAlphaChannel** (), **Image Transformations** , and
        **Image Formats** .
        """
        ...

    def setColor(self, i: int, c: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setColor

        **void QImage::setColor(int index , QRgb colorValue )**

        Sets the color at the given **index** in the color table, to the given
        to **colorValue**. The color value is an ARGB quadruplet.

        If **index** is outside the current size of the color table, it is
        expanded with **setColorCount** ().

        **See also** **color** (), **colorCount** (), **setColorTable** (), and
        **Pixel Manipulation** .
        """
        ...

    def setColorCount(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setColorCount

        **void QImage::setColorCount(int colorCount )**

        Resizes the color table to contain **colorCount** entries.

        If the color table is expanded, all the extra colors will be set to
        transparent (i.e **qRgba** (0, 0, 0, 0)).

        When the image is used, the color table must be large enough to have
        entries for all the pixel/index values present in the image, otherwise
        the results are undefined.

        **See also** **colorCount** (), **colorTable** (), **setColor** (), and
        **Image Transformations** .
        """
        ...

    def setColorSpace(
        self,
        arg__1: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setColorSpace

        **[since 5.14] void QImage::setColorSpace(const QColorSpace & colorSpace
        )**

        Sets the image color space to **colorSpace** without performing any
        conversions on image data.

        This function was introduced in Qt 5.14.

        **See also** **colorSpace** ().
        """
        ...

    def setColorTable(self, colors: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setColorTable

        **void QImage::setColorTable(const QList<QRgb> & colors )**

        Sets the color table used to translate color indexes to **QRgb**
        values, to the specified **colors**.

        When the image is used, the color table must be large enough to have
        entries for all the pixel/index values present in the image, otherwise
        the results are undefined.

        **See also** **colorTable** (), **setColor** (), and **Image
        Transformations** .
        """
        ...

    def setDevicePixelRatio(self, scaleFactor: float) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setDevicePixelRatio

        **void QImage::setDevicePixelRatio(qreal scaleFactor )**

        Sets the device pixel ratio for the image. This is the ratio between
        image pixels and device-independent pixels.

        The default **scaleFactor** is 1.0. Setting it to something else has two
        effects:

        QPainters that are opened on the image will be scaled. For example,
        painting on a 200x200 image if with a ratio of 2.0 will result in
        effective (device-independent) painting bounds of 100x100.

        Code paths in Qt that calculate layout geometry based on the image size
        will take the ratio into account: **QSize**  layoutSize = image.**size**
        () / image.**devicePixelRatio** () The net effect of this is that the
        image is displayed as high-DPI image rather than a large image (see
        **Drawing High Resolution Versions of Pixmaps and Images** ).

        **See also** **devicePixelRatio** () and **deviceIndependentSize** ().
        """
        ...

    def setDotsPerMeterX(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setDotsPerMeterX

        **void QImage::setDotsPerMeterX(int x )**

        Sets the number of pixels that fit horizontally in a physical meter, to
        **x**.

        Together with **dotsPerMeterY** (), this number defines the intended
        scale and aspect ratio of the image, and determines the scale at which
        **QPainter**  will draw graphics on the image. It does not change the
        scale or aspect ratio of the image when it is rendered on other paint
        devices.

        **See also** **dotsPerMeterX** () and **Image Information** .
        """
        ...

    def setDotsPerMeterY(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setDotsPerMeterY

        **void QImage::setDotsPerMeterY(int y )**

        Sets the number of pixels that fit vertically in a physical meter, to
        **y**.

        Together with **dotsPerMeterX** (), this number defines the intended
        scale and aspect ratio of the image, and determines the scale at which
        **QPainter**  will draw graphics on the image. It does not change the
        scale or aspect ratio of the image when it is rendered on other paint
        devices.

        **See also** **dotsPerMeterY** () and **Image Information** .
        """
        ...

    def setOffset(self, arg__1: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setOffset

        **void QImage::setOffset(const QPoint & offset )**

        Sets the number of pixels by which the image is intended to be offset by
        when positioning relative to other images, to **offset**.

        **See also** **offset** () and **Image Information** .
        """
        ...

    @overload
    def setPixel(self, pt: PySide6.QtCore.QPoint, index_or_rgb: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setPixel

        **void QImage::setPixel(const QPoint & position , uint index_or_rgb )**

        Sets the pixel index or color at the given **position** to
        **index_or_rgb**.

        If the image's format is either monochrome or paletted, the given
        **index_or_rgb** value must be an index in the image's color table,
        otherwise the parameter must be a **QRgb**  value.

        If **position** is not a valid coordinate pair in the image, or if
        **index_or_rgb** >= **colorCount** () in the case of monochrome and
        paletted images, the result is undefined.

        **Warning:** This function is expensive due to the call of the internal
        `detach()` function called within; if performance is a concern, we
        recommend the use of **scanLine** () or **bits** () to access pixel data
        directly.

        **See also** **pixel** () and **Pixel Manipulation** .
        """
        ...

    @overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setPixel-1

        **void QImage::setPixel(int x , int y , uint index_or_rgb )**

        This is an overloaded function.

        Sets the pixel index or color at ( **x** , **y** ) to **index_or_rgb**.
        """
        ...

    @overload
    def setPixelColor(
        self,
        pt: PySide6.QtCore.QPoint,
        c: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setPixelColor

        **[since 5.6] void QImage::setPixelColor(const QPoint & position , const
        QColor & color )**

        Sets the color at the given **position** to **color**.

        If **position** is not a valid coordinate pair in the image, or the
        image's format is either monochrome or paletted, the result is
        undefined.

        **Warning:** This function is expensive due to the call of the internal
        `detach()` function called within; if performance is a concern, we
        recommend the use of **scanLine** () or **bits** () to access pixel data
        directly.

        This function was introduced in Qt 5.6.

        **See also** **pixelColor** (), **pixel** (), **bits** (), **scanLine**
        (), and **Pixel Manipulation** .
        """
        ...

    @overload
    def setPixelColor(
        self,
        x: int,
        y: int,
        c: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setPixelColor-1

        **[since 5.6] void QImage::setPixelColor(int x , int y , const QColor &
        color )**

        This is an overloaded function.

        Sets the pixel color at ( **x** , **y** ) to **color**.

        This function was introduced in Qt 5.6.
        """
        ...

    def setText(self, key: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#setText

        **void QImage::setText(const QString & key , const QString & text )**

        Sets the image text to the given **text** and associate it with the
        given **key**.

        If you just want to store a single text block (i.e., a "comment" or just
        a description), you can either pass an empty key, or use a generic key
        like "Description".

        The image text is embedded into the image data when you call **save** ()
        or **QImageWriter::write** ().

        Not all image formats support embedded text. You can find out if a
        specific image or format supports embedding text by using
        **QImageWriter::supportsOption** (). We give an example:

        **QImageWriter**  writer;
                writer.setFormat("png");
                if
        (writer.supportsOption(**QImageIOHandler** ::Description))
        **qDebug** () << "Png supports embedded text";

        You can use **QImageWriter::supportedImageFormats** () to find out which
        image formats are available to you.

        **See also** **text** () and **textKeys** ().
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qimage.html#size

        **QSize QImage::size() const**

        Returns the size of the image, i.e. its **width** () and **height** ().

        **See also** **Image Information**  and **deviceIndependentSize** ().
        """
        ...

    def sizeInBytes(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#sizeInBytes

        **[since 5.10] qsizetype QImage::sizeInBytes() const**

        Returns the image data size in bytes.

        This function was introduced in Qt 5.10.

        **See also** **bytesPerLine** (), **bits** (), and **Image Information**
        .
        """
        ...

    def smoothScaled(self, w: int, h: int) -> PySide6.QtGui.QImage:
        ...

    def swap(self, other: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qimage.html#swap

        **void QImage::swap(QImage & other )**

        Swaps image **other** with this image. This operation is very fast and
        never fails.
        """
        ...

    def text(self, key: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qimage.html#text

        **QString QImage::text(const QString & key = QString()) const**

        Returns the image text associated with the given **key**. If the
        specified **key** is an empty string, the whole image text is returned,
        with each key-text pair separated by a newline.

        **See also** **setText** () and **textKeys** ().
        """
        ...

    def textKeys(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qimage.html#textKeys

        **QStringList QImage::textKeys() const**

        Returns the text keys for this image.

        You can use these keys with **text** () to list the image text for a
        certain key.

        **See also** **text** ().
        """
        ...

    @staticmethod
    def toImageFormat(
        format: PySide6.QtGui.QPixelFormat,
    ) -> PySide6.QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qimage.html#toImageFormat

        **[static] QImage::Format QImage::toImageFormat(QPixelFormat format )**

        Converts **format** into a **QImage::Format**
        """
        ...

    @staticmethod
    def toPixelFormat(
        format: PySide6.QtGui.QImage.Format,
    ) -> PySide6.QtGui.QPixelFormat:
        """
        https://doc.qt.io/qt-6/qimage.html#toPixelFormat

        **[static] QPixelFormat QImage::toPixelFormat(QImage::Format format )**

        Converts **format** into a **QPixelFormat**
        """
        ...

    def transformed(
        self,
        matrix: PySide6.QtGui.QTransform,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimage.html#transformed

        **QImage QImage::transformed(const QTransform & matrix ,
        Qt::TransformationMode mode = Qt::FastTransformation) const**

        Returns a copy of the image that is transformed using the given
        transformation **matrix** and transformation **mode**.

        The returned image will normally have the same {Image Formats}{format}
        as the original image. However, a complex transformation may result in
        an image where not all pixels are covered by the transformed pixels of
        the original image. In such cases, those background pixels will be
        assigned a transparent color value, and the transformed image will be
        given a format with an alpha channel, even if the original image did not
        have that.

        The transformation **matrix** is internally adjusted to compensate for
        unwanted translation; i.e. the image produced is the smallest image that
        contains all the transformed points of the original image. Use the
        **trueMatrix** () function to retrieve the actual matrix used for
        transforming an image.

        Unlike the other overload, this function can be used to perform
        perspective transformations on images.

        **See also** **trueMatrix** () and **Image Transformations** .
        """
        ...

    @staticmethod
    def trueMatrix(
        arg__1: PySide6.QtGui.QTransform, w: int, h: int
    ) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qimage.html#trueMatrix

        **[static] QTransform QImage::trueMatrix(const QTransform & matrix , int
        width , int height )**

        Returns the actual matrix used for transforming an image with the given
        **width** , **height** and **matrix**.

        When transforming an image using the **transformed** () function, the
        transformation matrix is internally adjusted to compensate for unwanted
        translation, i.e. **transformed** () returns the smallest image
        containing all transformed points of the original image. This function
        returns the modified matrix, which maps points correctly from the
        original image into the new image.

        Unlike the other overload, this function creates transformation matrices
        that can be used to perform perspective transformations on images.

        **See also** **transformed** () and **Image Transformations** .
        """
        ...

    @overload
    def valid(self, pt: PySide6.QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#valid

        **bool QImage::valid(const QPoint & pos ) const**

        Returns `true` if **pos** is a valid coordinate pair within the image;
        otherwise returns `false`.

        **See also** **rect** () and **QRect::contains** ().
        """
        ...

    @overload
    def valid(self, x: int, y: int) -> bool:
        """
        https://doc.qt.io/qt-6/qimage.html#valid-1

        **bool QImage::valid(int x , int y ) const**

        This is an overloaded function.

        Returns `true` if **QPoint** ( **x** , **y** ) is a valid coordinate
        pair within the image; otherwise returns `false`.
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qimage.html#width

        **int QImage::width() const**

        Returns the width of the image.

        **See also** **Image Information** .
        """
        ...
