"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QIconEngine(object):
    """
    https://doc.qt.io/qt-6/qiconengine.html

    **Detailed Description**

    An icon engine provides the rendering functions for a **QIcon** . Each icon
    has a corresponding icon engine that is responsible for drawing the icon
    with a requested size, mode and state.

    The icon is rendered by the **paint** () function, and the icon can
    additionally be obtained as a pixmap with the **pixmap** () function (the
    default implementation simply uses **paint** () to achieve this). The
    **addPixmap** () function can be used to add new pixmaps to the icon engine,
    and is used by **QIcon**  to add specialized custom pixmaps.

    The **paint** (), **pixmap** (), and **addPixmap** () functions are all
    virtual, and can therefore be reimplemented in subclasses of QIconEngine.

    **See also** **QIconEnginePlugin** .
    """

    IsNullHook: QIconEngine.IconEngineHook = ...
    ScaledPixmapHook: QIconEngine.IconEngineHook = ...

    class IconEngineHook(Enum):
        IsNullHook: QIconEngine.IconEngineHook = ...
        ScaledPixmapHook: QIconEngine.IconEngineHook = ...

    class ScaledPixmapArgument(object):
        def __init__(self) -> None:
            ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qiconengine.html#QIconEngine

        **[since 5.6] QIconEngine::QIconEngine()**

        Constructs the icon engine.

        This function was introduced in Qt 5.6.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QIconEngine) -> None:
        """
        https://doc.qt.io/qt-6/qiconengine.html#QIconEngine

        **[since 5.6] QIconEngine::QIconEngine()**

        Constructs the icon engine.

        This function was introduced in Qt 5.6.
        """
        ...

    def actualSize(
        self,
        size: PySide6.QtCore.QSize,
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qiconengine.html#actualSize

        **[virtual] QSize QIconEngine::actualSize(const QSize & size ,
        QIcon::Mode mode , QIcon::State state )**

        Returns the actual size of the icon the engine provides for the
        requested **size** , **mode** and **state**. The default implementation
        returns the given **size**.
        """
        ...

    def addFile(
        self,
        fileName: str,
        size: PySide6.QtCore.QSize,
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qiconengine.html#addFile

        **[virtual] void QIconEngine::addFile(const QString & fileName , const
        QSize & size , QIcon::Mode mode , QIcon::State state )**

        Called by **QIcon::addFile** (). Adds a specialized pixmap from the file
        with the given **fileName** , **size** , **mode** and **state**. The
        default pixmap-based engine stores any supplied file names, and it loads
        the pixmaps on demand instead of using scaled pixmaps if the size of a
        pixmap matches the size of icon requested. Custom icon engines that
        implement scalable vector formats are free to ignores any extra files.
        """
        ...

    def addPixmap(
        self,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qiconengine.html#addPixmap

        **[virtual] void QIconEngine::addPixmap(const QPixmap & pixmap ,
        QIcon::Mode mode , QIcon::State state )**

        Called by **QIcon::addPixmap** (). Adds a specialized **pixmap** for the
        given **mode** and **state**. The default pixmap-based engine stores any
        supplied pixmaps, and it uses them instead of scaled pixmaps if the size
        of a pixmap matches the size of icon requested. Custom icon engines that
        implement scalable vector formats are free to ignores any extra pixmaps.
        """
        ...

    def availableSizes(
        self,
        mode: PySide6.QtGui.QIcon.Mode = ...,
        state: PySide6.QtGui.QIcon.State = ...,
    ) -> List[PySide6.QtCore.QSize]:
        """
        https://doc.qt.io/qt-6/qiconengine.html#availableSizes

        **[virtual] QList<QSize> QIconEngine::availableSizes(QIcon::Mode mode =
        QIcon::Normal, QIcon::State state = QIcon::Off)**

        Returns sizes of all images that are contained in the engine for the
        specific **mode** and **state**.
        """
        ...

    def clone(self) -> PySide6.QtGui.QIconEngine:
        """
        https://doc.qt.io/qt-6/qiconengine.html#clone

        **[pure virtual] QIconEngine *QIconEngine::clone() const**

        Reimplement this method to return a clone of this icon engine.
        """
        ...

    def iconName(self) -> str:
        """
        https://doc.qt.io/qt-6/qiconengine.html#iconName

        **[virtual] QString QIconEngine::iconName()**

        Returns the name used to create the engine, if available.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiconengine.html#isNull

        **[virtual, since 5.7] bool QIconEngine::isNull()**

        Returns true if this icon engine represent a null **QIcon** .

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        This function was introduced in Qt 5.7.
        """
        ...

    def key(self) -> str:
        """
        https://doc.qt.io/qt-6/qiconengine.html#key

        **[virtual] QString QIconEngine::key() const**

        Returns a key that identifies this icon engine.
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qiconengine.html#paint

        **[pure virtual] void QIconEngine::paint(QPainter * painter , const
        QRect & rect , QIcon::Mode mode , QIcon::State state )**

        Uses the given **painter** to paint the icon with the required **mode**
        and **state** into the rectangle **rect**.
        """
        ...

    def pixmap(
        self,
        size: PySide6.QtCore.QSize,
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qiconengine.html#pixmap

        **[virtual] QPixmap QIconEngine::pixmap(const QSize & size , QIcon::Mode
        mode , QIcon::State state )**

        Returns the icon as a pixmap with the required **size** , **mode** , and
        **state**. The default implementation creates a new pixmap and calls
        **paint** () to fill it.
        """
        ...

    def read(self, in_: PySide6.QtCore.QDataStream) -> bool:
        """
        https://doc.qt.io/qt-6/qiconengine.html#read

        **[virtual] bool QIconEngine::read(QDataStream & in )**

        Reads icon engine contents from the **QDataStream**  **in**. Returns
        true if the contents were read; otherwise returns `false`.

        **QIconEngine** 's default implementation always return false.
        """
        ...

    def scaledPixmap(
        self,
        size: PySide6.QtCore.QSize,
        mode: PySide6.QtGui.QIcon.Mode,
        state: PySide6.QtGui.QIcon.State,
        scale: float,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qiconengine.html#scaledPixmap

        **[virtual, since 5.9] QPixmap QIconEngine::scaledPixmap(const QSize &
        size , QIcon::Mode mode , QIcon::State state , qreal scale )**

        Returns a pixmap for the given **size** , **mode** , **state** and
        **scale**.

        The **scale** argument is typically equal to the **device pixel ratio**
        of the display.

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        **Note:** Some engines may cast **scale** to an integer.

        This function was introduced in Qt 5.9.

        **See also** **ScaledPixmapArgument** .
        """
        ...

    def write(self, out: PySide6.QtCore.QDataStream) -> bool:
        """
        https://doc.qt.io/qt-6/qiconengine.html#write

        **[virtual] bool QIconEngine::write(QDataStream & out ) const**

        Writes the contents of this engine to the **QDataStream**  **out**.
        Returns `true` if the contents were written; otherwise returns `false`.

        **QIconEngine** 's default implementation always return false.
        """
        ...
