"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QGradient(object):
    """
    https://doc.qt.io/qt-6/qgradient.html

    **Detailed Description**

    Qt currently supports three types of gradient fills:

    * **Linear** gradients interpolate colors between start and end points.
      *
    **Simple** radial gradients interpolate colors between a focal point and end
    points on a circle surrounding it.
      * **Extended** radial gradients
    interpolate colors between a center and a focal circle.
      * **Conical**
    gradients interpolate colors around a center point.

    A gradient's type can be retrieved using the **type** () function. Each of
    the types is represented by a subclass of QGradient:

    **QLinearGradient** **QRadialGradient** **QConicalGradient**
    ![](images/qgradient-linear.png)![](images/qgradient-
    radial.png)![](images/qgradient-conical.png)

    The colors in a gradient are defined using stop points of the
    **QGradientStop**  type; i.e., a position and a color. Use the
    **setColorAt** () function to define a single stop point. Alternatively, use
    the **setStops** () function to define several stop points in one go. Note
    that the latter function **replaces** the current set of stop points.

    It is the gradient's complete set of stop points (accessible through the
    **stops** () function) that describes how the gradient area should be
    filled. If no stop points have been specified, a gradient of black at 0 to
    white at 1 is used.

    A diagonal linear gradient from black at (100, 100) to white at (200, 200)
    could be specified like this:

    **QLinearGradient**  linearGrad(**QPointF** (100, 100), **QPointF** (200,
    200));
        linearGrad.setColorAt(0, Qt::black);
        linearGrad.setColorAt(1,
    Qt::white);

    A gradient can have an arbitrary number of stop points. The following would
    create a radial gradient starting with red in the center, blue and then
    green on the edges:

    **QRadialGradient**  radialGrad(**QPointF** (100, 100), 100);
    radialGrad.setColorAt(0, Qt::red);
        radialGrad.setColorAt(0.5, Qt::blue);
    radialGrad.setColorAt(1, Qt::green);

    It is possible to repeat or reflect the gradient outside its area by
    specifying the **spread method**  using the **setSpread** () function. The
    default is to pad the outside area with the color at the closest stop point.
    The currently set **spread method**  can be retrieved using the **spread**
    () function. The **QGradient::Spread**  enum defines three different
    methods:

    ![](images/qradialgradient-pad.png)![](images/qradialgradient-
    repeat.png)![](images/qradialgradient-reflect.png)
    **PadSpread**
    **RepeatSpread** **ReflectSpread**

    Note that the **setSpread** () function only has effect for linear and
    radial gradients. The reason is that the conical gradient is closed by
    definition, i.e. the **conical** gradient fills the entire circle from 0 -
    360 degrees, while the boundary of a radial or a linear gradient can be
    specified through its radius or final stop points, respectively.

    The gradient coordinates can be specified in logical coordinates, relative
    to device coordinates, or relative to object bounding box coordinates. The
    **coordinate mode**  can be set using the **setCoordinateMode** () function.
    The default is **LogicalMode** , where the gradient coordinates are
    specified in the same way as the object coordinates. To retrieve the
    currently set **coordinate mode**  use **coordinateMode** ().

    **See also** **The Gradients Example**  and **QBrush** .
    """

    LogicalMode: QGradient.CoordinateMode = ...
    StretchToDeviceMode: QGradient.CoordinateMode = ...
    ObjectBoundingMode: QGradient.CoordinateMode = ...
    ObjectMode: QGradient.CoordinateMode = ...
    ColorInterpolation: QGradient.InterpolationMode = ...
    ComponentInterpolation: QGradient.InterpolationMode = ...
    WarmFlame: QGradient.Preset = ...
    NightFade: QGradient.Preset = ...
    SpringWarmth: QGradient.Preset = ...
    JuicyPeach: QGradient.Preset = ...
    YoungPassion: QGradient.Preset = ...
    LadyLips: QGradient.Preset = ...
    SunnyMorning: QGradient.Preset = ...
    RainyAshville: QGradient.Preset = ...
    FrozenDreams: QGradient.Preset = ...
    WinterNeva: QGradient.Preset = ...
    DustyGrass: QGradient.Preset = ...
    TemptingAzure: QGradient.Preset = ...
    HeavyRain: QGradient.Preset = ...
    AmyCrisp: QGradient.Preset = ...
    MeanFruit: QGradient.Preset = ...
    DeepBlue: QGradient.Preset = ...
    RipeMalinka: QGradient.Preset = ...
    CloudyKnoxville: QGradient.Preset = ...
    MalibuBeach: QGradient.Preset = ...
    NewLife: QGradient.Preset = ...
    TrueSunset: QGradient.Preset = ...
    MorpheusDen: QGradient.Preset = ...
    RareWind: QGradient.Preset = ...
    NearMoon: QGradient.Preset = ...
    WildApple: QGradient.Preset = ...
    SaintPetersburg: QGradient.Preset = ...
    PlumPlate: QGradient.Preset = ...
    EverlastingSky: QGradient.Preset = ...
    HappyFisher: QGradient.Preset = ...
    Blessing: QGradient.Preset = ...
    SharpeyeEagle: QGradient.Preset = ...
    LadogaBottom: QGradient.Preset = ...
    LemonGate: QGradient.Preset = ...
    ItmeoBranding: QGradient.Preset = ...
    ZeusMiracle: QGradient.Preset = ...
    OldHat: QGradient.Preset = ...
    StarWine: QGradient.Preset = ...
    HappyAcid: QGradient.Preset = ...
    AwesomePine: QGradient.Preset = ...
    NewYork: QGradient.Preset = ...
    ShyRainbow: QGradient.Preset = ...
    MixedHopes: QGradient.Preset = ...
    FlyHigh: QGradient.Preset = ...
    StrongBliss: QGradient.Preset = ...
    FreshMilk: QGradient.Preset = ...
    SnowAgain: QGradient.Preset = ...
    FebruaryInk: QGradient.Preset = ...
    KindSteel: QGradient.Preset = ...
    SoftGrass: QGradient.Preset = ...
    GrownEarly: QGradient.Preset = ...
    SharpBlues: QGradient.Preset = ...
    ShadyWater: QGradient.Preset = ...
    DirtyBeauty: QGradient.Preset = ...
    GreatWhale: QGradient.Preset = ...
    TeenNotebook: QGradient.Preset = ...
    PoliteRumors: QGradient.Preset = ...
    SweetPeriod: QGradient.Preset = ...
    WideMatrix: QGradient.Preset = ...
    SoftCherish: QGradient.Preset = ...
    RedSalvation: QGradient.Preset = ...
    BurningSpring: QGradient.Preset = ...
    NightParty: QGradient.Preset = ...
    SkyGlider: QGradient.Preset = ...
    HeavenPeach: QGradient.Preset = ...
    PurpleDivision: QGradient.Preset = ...
    AquaSplash: QGradient.Preset = ...
    SpikyNaga: QGradient.Preset = ...
    LoveKiss: QGradient.Preset = ...
    CleanMirror: QGradient.Preset = ...
    PremiumDark: QGradient.Preset = ...
    ColdEvening: QGradient.Preset = ...
    CochitiLake: QGradient.Preset = ...
    SummerGames: QGradient.Preset = ...
    PassionateBed: QGradient.Preset = ...
    MountainRock: QGradient.Preset = ...
    DesertHump: QGradient.Preset = ...
    JungleDay: QGradient.Preset = ...
    PhoenixStart: QGradient.Preset = ...
    OctoberSilence: QGradient.Preset = ...
    FarawayRiver: QGradient.Preset = ...
    AlchemistLab: QGradient.Preset = ...
    OverSun: QGradient.Preset = ...
    PremiumWhite: QGradient.Preset = ...
    MarsParty: QGradient.Preset = ...
    EternalConstance: QGradient.Preset = ...
    JapanBlush: QGradient.Preset = ...
    SmilingRain: QGradient.Preset = ...
    CloudyApple: QGradient.Preset = ...
    BigMango: QGradient.Preset = ...
    HealthyWater: QGradient.Preset = ...
    AmourAmour: QGradient.Preset = ...
    RiskyConcrete: QGradient.Preset = ...
    StrongStick: QGradient.Preset = ...
    ViciousStance: QGradient.Preset = ...
    PaloAlto: QGradient.Preset = ...
    HappyMemories: QGradient.Preset = ...
    MidnightBloom: QGradient.Preset = ...
    Crystalline: QGradient.Preset = ...
    PartyBliss: QGradient.Preset = ...
    ConfidentCloud: QGradient.Preset = ...
    LeCocktail: QGradient.Preset = ...
    RiverCity: QGradient.Preset = ...
    FrozenBerry: QGradient.Preset = ...
    ChildCare: QGradient.Preset = ...
    FlyingLemon: QGradient.Preset = ...
    NewRetrowave: QGradient.Preset = ...
    HiddenJaguar: QGradient.Preset = ...
    AboveTheSky: QGradient.Preset = ...
    Nega: QGradient.Preset = ...
    DenseWater: QGradient.Preset = ...
    Seashore: QGradient.Preset = ...
    MarbleWall: QGradient.Preset = ...
    CheerfulCaramel: QGradient.Preset = ...
    NightSky: QGradient.Preset = ...
    MagicLake: QGradient.Preset = ...
    YoungGrass: QGradient.Preset = ...
    ColorfulPeach: QGradient.Preset = ...
    GentleCare: QGradient.Preset = ...
    PlumBath: QGradient.Preset = ...
    HappyUnicorn: QGradient.Preset = ...
    AfricanField: QGradient.Preset = ...
    SolidStone: QGradient.Preset = ...
    OrangeJuice: QGradient.Preset = ...
    GlassWater: QGradient.Preset = ...
    NorthMiracle: QGradient.Preset = ...
    FruitBlend: QGradient.Preset = ...
    MillenniumPine: QGradient.Preset = ...
    HighFlight: QGradient.Preset = ...
    MoleHall: QGradient.Preset = ...
    SpaceShift: QGradient.Preset = ...
    ForestInei: QGradient.Preset = ...
    RoyalGarden: QGradient.Preset = ...
    RichMetal: QGradient.Preset = ...
    JuicyCake: QGradient.Preset = ...
    SmartIndigo: QGradient.Preset = ...
    SandStrike: QGradient.Preset = ...
    NorseBeauty: QGradient.Preset = ...
    AquaGuidance: QGradient.Preset = ...
    SunVeggie: QGradient.Preset = ...
    SeaLord: QGradient.Preset = ...
    BlackSea: QGradient.Preset = ...
    GrassShampoo: QGradient.Preset = ...
    LandingAircraft: QGradient.Preset = ...
    WitchDance: QGradient.Preset = ...
    SleeplessNight: QGradient.Preset = ...
    AngelCare: QGradient.Preset = ...
    CrystalRiver: QGradient.Preset = ...
    SoftLipstick: QGradient.Preset = ...
    SaltMountain: QGradient.Preset = ...
    PerfectWhite: QGradient.Preset = ...
    FreshOasis: QGradient.Preset = ...
    StrictNovember: QGradient.Preset = ...
    MorningSalad: QGradient.Preset = ...
    DeepRelief: QGradient.Preset = ...
    SeaStrike: QGradient.Preset = ...
    NightCall: QGradient.Preset = ...
    SupremeSky: QGradient.Preset = ...
    LightBlue: QGradient.Preset = ...
    MindCrawl: QGradient.Preset = ...
    LilyMeadow: QGradient.Preset = ...
    SugarLollipop: QGradient.Preset = ...
    SweetDessert: QGradient.Preset = ...
    MagicRay: QGradient.Preset = ...
    TeenParty: QGradient.Preset = ...
    FrozenHeat: QGradient.Preset = ...
    GagarinView: QGradient.Preset = ...
    FabledSunset: QGradient.Preset = ...
    PerfectBlue: QGradient.Preset = ...
    NumPresets: QGradient.Preset = ...
    PadSpread: QGradient.Spread = ...
    ReflectSpread: QGradient.Spread = ...
    RepeatSpread: QGradient.Spread = ...
    LinearGradient: QGradient.Type = ...
    RadialGradient: QGradient.Type = ...
    ConicalGradient: QGradient.Type = ...
    NoGradient: QGradient.Type = ...

    class CoordinateMode(Enum):
        LogicalMode: QGradient.CoordinateMode = ...
        StretchToDeviceMode: QGradient.CoordinateMode = ...
        ObjectBoundingMode: QGradient.CoordinateMode = ...
        ObjectMode: QGradient.CoordinateMode = ...

    class InterpolationMode(Enum):
        ColorInterpolation: QGradient.InterpolationMode = ...
        ComponentInterpolation: QGradient.InterpolationMode = ...

    class Preset(Enum):
        WarmFlame: QGradient.Preset = ...
        NightFade: QGradient.Preset = ...
        SpringWarmth: QGradient.Preset = ...
        JuicyPeach: QGradient.Preset = ...
        YoungPassion: QGradient.Preset = ...
        LadyLips: QGradient.Preset = ...
        SunnyMorning: QGradient.Preset = ...
        RainyAshville: QGradient.Preset = ...
        FrozenDreams: QGradient.Preset = ...
        WinterNeva: QGradient.Preset = ...
        DustyGrass: QGradient.Preset = ...
        TemptingAzure: QGradient.Preset = ...
        HeavyRain: QGradient.Preset = ...
        AmyCrisp: QGradient.Preset = ...
        MeanFruit: QGradient.Preset = ...
        DeepBlue: QGradient.Preset = ...
        RipeMalinka: QGradient.Preset = ...
        CloudyKnoxville: QGradient.Preset = ...
        MalibuBeach: QGradient.Preset = ...
        NewLife: QGradient.Preset = ...
        TrueSunset: QGradient.Preset = ...
        MorpheusDen: QGradient.Preset = ...
        RareWind: QGradient.Preset = ...
        NearMoon: QGradient.Preset = ...
        WildApple: QGradient.Preset = ...
        SaintPetersburg: QGradient.Preset = ...
        PlumPlate: QGradient.Preset = ...
        EverlastingSky: QGradient.Preset = ...
        HappyFisher: QGradient.Preset = ...
        Blessing: QGradient.Preset = ...
        SharpeyeEagle: QGradient.Preset = ...
        LadogaBottom: QGradient.Preset = ...
        LemonGate: QGradient.Preset = ...
        ItmeoBranding: QGradient.Preset = ...
        ZeusMiracle: QGradient.Preset = ...
        OldHat: QGradient.Preset = ...
        StarWine: QGradient.Preset = ...
        HappyAcid: QGradient.Preset = ...
        AwesomePine: QGradient.Preset = ...
        NewYork: QGradient.Preset = ...
        ShyRainbow: QGradient.Preset = ...
        MixedHopes: QGradient.Preset = ...
        FlyHigh: QGradient.Preset = ...
        StrongBliss: QGradient.Preset = ...
        FreshMilk: QGradient.Preset = ...
        SnowAgain: QGradient.Preset = ...
        FebruaryInk: QGradient.Preset = ...
        KindSteel: QGradient.Preset = ...
        SoftGrass: QGradient.Preset = ...
        GrownEarly: QGradient.Preset = ...
        SharpBlues: QGradient.Preset = ...
        ShadyWater: QGradient.Preset = ...
        DirtyBeauty: QGradient.Preset = ...
        GreatWhale: QGradient.Preset = ...
        TeenNotebook: QGradient.Preset = ...
        PoliteRumors: QGradient.Preset = ...
        SweetPeriod: QGradient.Preset = ...
        WideMatrix: QGradient.Preset = ...
        SoftCherish: QGradient.Preset = ...
        RedSalvation: QGradient.Preset = ...
        BurningSpring: QGradient.Preset = ...
        NightParty: QGradient.Preset = ...
        SkyGlider: QGradient.Preset = ...
        HeavenPeach: QGradient.Preset = ...
        PurpleDivision: QGradient.Preset = ...
        AquaSplash: QGradient.Preset = ...
        SpikyNaga: QGradient.Preset = ...
        LoveKiss: QGradient.Preset = ...
        CleanMirror: QGradient.Preset = ...
        PremiumDark: QGradient.Preset = ...
        ColdEvening: QGradient.Preset = ...
        CochitiLake: QGradient.Preset = ...
        SummerGames: QGradient.Preset = ...
        PassionateBed: QGradient.Preset = ...
        MountainRock: QGradient.Preset = ...
        DesertHump: QGradient.Preset = ...
        JungleDay: QGradient.Preset = ...
        PhoenixStart: QGradient.Preset = ...
        OctoberSilence: QGradient.Preset = ...
        FarawayRiver: QGradient.Preset = ...
        AlchemistLab: QGradient.Preset = ...
        OverSun: QGradient.Preset = ...
        PremiumWhite: QGradient.Preset = ...
        MarsParty: QGradient.Preset = ...
        EternalConstance: QGradient.Preset = ...
        JapanBlush: QGradient.Preset = ...
        SmilingRain: QGradient.Preset = ...
        CloudyApple: QGradient.Preset = ...
        BigMango: QGradient.Preset = ...
        HealthyWater: QGradient.Preset = ...
        AmourAmour: QGradient.Preset = ...
        RiskyConcrete: QGradient.Preset = ...
        StrongStick: QGradient.Preset = ...
        ViciousStance: QGradient.Preset = ...
        PaloAlto: QGradient.Preset = ...
        HappyMemories: QGradient.Preset = ...
        MidnightBloom: QGradient.Preset = ...
        Crystalline: QGradient.Preset = ...
        PartyBliss: QGradient.Preset = ...
        ConfidentCloud: QGradient.Preset = ...
        LeCocktail: QGradient.Preset = ...
        RiverCity: QGradient.Preset = ...
        FrozenBerry: QGradient.Preset = ...
        ChildCare: QGradient.Preset = ...
        FlyingLemon: QGradient.Preset = ...
        NewRetrowave: QGradient.Preset = ...
        HiddenJaguar: QGradient.Preset = ...
        AboveTheSky: QGradient.Preset = ...
        Nega: QGradient.Preset = ...
        DenseWater: QGradient.Preset = ...
        Seashore: QGradient.Preset = ...
        MarbleWall: QGradient.Preset = ...
        CheerfulCaramel: QGradient.Preset = ...
        NightSky: QGradient.Preset = ...
        MagicLake: QGradient.Preset = ...
        YoungGrass: QGradient.Preset = ...
        ColorfulPeach: QGradient.Preset = ...
        GentleCare: QGradient.Preset = ...
        PlumBath: QGradient.Preset = ...
        HappyUnicorn: QGradient.Preset = ...
        AfricanField: QGradient.Preset = ...
        SolidStone: QGradient.Preset = ...
        OrangeJuice: QGradient.Preset = ...
        GlassWater: QGradient.Preset = ...
        NorthMiracle: QGradient.Preset = ...
        FruitBlend: QGradient.Preset = ...
        MillenniumPine: QGradient.Preset = ...
        HighFlight: QGradient.Preset = ...
        MoleHall: QGradient.Preset = ...
        SpaceShift: QGradient.Preset = ...
        ForestInei: QGradient.Preset = ...
        RoyalGarden: QGradient.Preset = ...
        RichMetal: QGradient.Preset = ...
        JuicyCake: QGradient.Preset = ...
        SmartIndigo: QGradient.Preset = ...
        SandStrike: QGradient.Preset = ...
        NorseBeauty: QGradient.Preset = ...
        AquaGuidance: QGradient.Preset = ...
        SunVeggie: QGradient.Preset = ...
        SeaLord: QGradient.Preset = ...
        BlackSea: QGradient.Preset = ...
        GrassShampoo: QGradient.Preset = ...
        LandingAircraft: QGradient.Preset = ...
        WitchDance: QGradient.Preset = ...
        SleeplessNight: QGradient.Preset = ...
        AngelCare: QGradient.Preset = ...
        CrystalRiver: QGradient.Preset = ...
        SoftLipstick: QGradient.Preset = ...
        SaltMountain: QGradient.Preset = ...
        PerfectWhite: QGradient.Preset = ...
        FreshOasis: QGradient.Preset = ...
        StrictNovember: QGradient.Preset = ...
        MorningSalad: QGradient.Preset = ...
        DeepRelief: QGradient.Preset = ...
        SeaStrike: QGradient.Preset = ...
        NightCall: QGradient.Preset = ...
        SupremeSky: QGradient.Preset = ...
        LightBlue: QGradient.Preset = ...
        MindCrawl: QGradient.Preset = ...
        LilyMeadow: QGradient.Preset = ...
        SugarLollipop: QGradient.Preset = ...
        SweetDessert: QGradient.Preset = ...
        MagicRay: QGradient.Preset = ...
        TeenParty: QGradient.Preset = ...
        FrozenHeat: QGradient.Preset = ...
        GagarinView: QGradient.Preset = ...
        FabledSunset: QGradient.Preset = ...
        PerfectBlue: QGradient.Preset = ...
        NumPresets: QGradient.Preset = ...

    class Spread(Enum):
        PadSpread: QGradient.Spread = ...
        ReflectSpread: QGradient.Spread = ...
        RepeatSpread: QGradient.Spread = ...

    class Type(Enum):
        LinearGradient: QGradient.Type = ...
        RadialGradient: QGradient.Type = ...
        ConicalGradient: QGradient.Type = ...
        NoGradient: QGradient.Type = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#QGradient-1

        **[since 5.12] QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    @overload
    def __init__(
        self, QGradient: Union[PySide6.QtGui.QGradient, PySide6.QtGui.QGradient.Preset]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#QGradient-1

        **[since 5.12] QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QGradient.Preset) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#QGradient-1

        **[since 5.12] QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def coordinateMode(self) -> PySide6.QtGui.QGradient.CoordinateMode:
        """
        https://doc.qt.io/qt-6/qgradient.html#coordinateMode

        **QGradient::CoordinateMode QGradient::coordinateMode() const**

        Returns the coordinate mode of this gradient. The default mode is
        **LogicalMode** .

        **See also** **setCoordinateMode** ().
        """
        ...

    def interpolationMode(self) -> PySide6.QtGui.QGradient.InterpolationMode:
        ...

    def setColorAt(
        self,
        pos: float,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#setColorAt

        **void QGradient::setColorAt(qreal position , const QColor & color )**

        Creates a stop point at the given **position** with the given **color**.
        The given **position** must be in the range 0 to 1.

        **See also** **setStops** () and **stops** ().
        """
        ...

    def setCoordinateMode(self, mode: PySide6.QtGui.QGradient.CoordinateMode) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#setCoordinateMode

        **void QGradient::setCoordinateMode(QGradient::CoordinateMode mode )**

        Sets the coordinate mode of this gradient to **mode**. The default mode
        is **LogicalMode** .

        **See also** **coordinateMode** ().
        """
        ...

    def setInterpolationMode(
        self, mode: PySide6.QtGui.QGradient.InterpolationMode
    ) -> None:
        ...

    def setSpread(self, spread: PySide6.QtGui.QGradient.Spread) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#setSpread

        **void QGradient::setSpread(QGradient::Spread method )**

        Specifies the spread **method** that should be used for this gradient.

        Note that this function only has effect for linear and radial gradients.

        **See also** **spread** ().
        """
        ...

    def setStops(self, stops: Sequence[Tuple[float, PySide6.QtGui.QColor]]) -> None:
        """
        https://doc.qt.io/qt-6/qgradient.html#setStops

        **void QGradient::setStops(const QGradientStops & stopPoints )**

        Replaces the current set of stop points with the given **stopPoints**.
        The positions of the points must be in the range 0 to 1, and must be
        sorted with the lowest point first.

        **See also** **setColorAt** () and **stops** ().
        """
        ...

    def spread(self) -> PySide6.QtGui.QGradient.Spread:
        """
        https://doc.qt.io/qt-6/qgradient.html#spread

        **QGradient::Spread QGradient::spread() const**

        Returns the spread method use by this gradient. The default is
        **PadSpread** .

        **See also** **setSpread** ().
        """
        ...

    def stops(self) -> List[Tuple[float, PySide6.QtGui.QColor]]:
        """
        https://doc.qt.io/qt-6/qgradient.html#stops

        **QGradientStops QGradient::stops() const**

        Returns the stop points for this gradient.

        If no stop points have been specified, a gradient of black at 0 to white
        at 1 is used.

        **See also** **setStops** () and **setColorAt** ().
        """
        ...

    def type(self) -> PySide6.QtGui.QGradient.Type:
        """
        https://doc.qt.io/qt-6/qgradient.html#type

        **QGradient::Type QGradient::type() const**

        Returns the type of gradient.
        """
        ...
