"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QGlyphRun(object):
    """
    https://doc.qt.io/qt-6/qglyphrun.html

    **Detailed Description**

    When Qt displays a string of text encoded in Unicode, it will first convert
    the Unicode points into a list of glyph indexes and a list of positions
    based on one or more fonts. The Unicode representation of the text and the
    **QFont**  object will in this case serve as a convenient abstraction that
    hides the details of what actually takes place when displaying the text on-
    screen. For instance, by the time the text actually reaches the screen, it
    may be represented by a set of fonts in addition to the one specified by the
    user, e.g. in case the originally selected font did not support all the
    writing systems contained in the text.

    Under certain circumstances, it can be useful as an application developer to
    have more low-level control over which glyphs in a specific font are drawn
    to the screen. This could for instance be the case in applications that use
    an external font engine and text shaper together with Qt. QGlyphRun provides
    an interface to the raw data needed to get text on the screen. It contains a
    list of glyph indexes, a position for each glyph and a font.

    It is the user's responsibility to ensure that the selected font actually
    contains the provided glyph indexes.

    **QTextLayout::glyphRuns** () or **QTextFragment::glyphRuns** () can be used
    to convert unicode encoded text into a list of QGlyphRun objects, and
    **QPainter::drawGlyphRun** () can be used to draw the glyphs.

    **Note:** Please note that **QRawFont**  is considered local to the thread
    in which it is constructed. This in turn means that a new **QRawFont**  will
    have to be created and set on the QGlyphRun if it is moved to a different
    thread. If the QGlyphRun contains a reference to a **QRawFont**  from a
    different thread than the current, it will not be possible to draw the
    glyphs using a **QPainter** , as the **QRawFont**  is considered invalid and
    inaccessible in this case.
    """

    Overline: QGlyphRun.GlyphRunFlag = ...
    Underline: QGlyphRun.GlyphRunFlag = ...
    StrikeOut: QGlyphRun.GlyphRunFlag = ...
    RightToLeft: QGlyphRun.GlyphRunFlag = ...
    SplitLigature: QGlyphRun.GlyphRunFlag = ...

    class GlyphRunFlag(Enum):
        Overline: QGlyphRun.GlyphRunFlag = ...
        Underline: QGlyphRun.GlyphRunFlag = ...
        StrikeOut: QGlyphRun.GlyphRunFlag = ...
        RightToLeft: QGlyphRun.GlyphRunFlag = ...
        SplitLigature: QGlyphRun.GlyphRunFlag = ...

    class GlyphRunFlags(object):
        ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#QGlyphRun

        **QGlyphRun::QGlyphRun()**

        Constructs an empty QGlyphRun object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QGlyphRun) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#QGlyphRun-1

        **QGlyphRun::QGlyphRun(const QGlyphRun & other )**

        Constructs a QGlyphRun object which is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#boundingRect

        **[since 5.0] QRectF QGlyphRun::boundingRect() const**

        Returns the smallest rectangle that contains all glyphs in this
        **QGlyphRun** . If a bounding rect has been set using
        **setBoundingRect** (), then this will be returned. Otherwise the
        bounding rect will be calculated based on the font metrics of the glyphs
        in the glyph run.

        This function was introduced in Qt 5.0.

        **See also** **setBoundingRect** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#clear

        **void QGlyphRun::clear()**

        Clears all data in the **QGlyphRun**  object.
        """
        ...

    def flags(self) -> PySide6.QtGui.QGlyphRun.GlyphRunFlags:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#flags

        **[since 5.0] QGlyphRun::GlyphRunFlags QGlyphRun::flags() const**

        Returns the flags set for this **QGlyphRun** .

        This function was introduced in Qt 5.0.

        **See also** **setFlags** (), **setFlag** (), and **setFlag** ().
        """
        ...

    def glyphIndexes(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#glyphIndexes

        **QList<quint32> QGlyphRun::glyphIndexes() const**

        Returns the glyph indexes for this **QGlyphRun**  object.

        **See also** **setGlyphIndexes** () and **setPositions** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#isEmpty

        **[since 5.0] bool QGlyphRun::isEmpty() const**

        Returns `true` if the **QGlyphRun**  does not contain any glyphs.

        This function was introduced in Qt 5.0.
        """
        ...

    def isRightToLeft(self) -> bool:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#isRightToLeft

        **[since 5.0] bool QGlyphRun::isRightToLeft() const**

        Returns `true` if this **QGlyphRun**  contains glyphs that are painted
        from the right to the left.

        This function was introduced in Qt 5.0.

        **See also** **setRightToLeft** () and **flags** ().
        """
        ...

    def overline(self) -> bool:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#overline

        **bool QGlyphRun::overline() const**

        Returns `true` if this **QGlyphRun**  should be painted with an overline
        decoration.

        **See also** **setOverline** () and **flags** ().
        """
        ...

    def positions(self) -> List[PySide6.QtCore.QPointF]:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#positions

        **QList<QPointF> QGlyphRun::positions() const**

        Returns the position of the edge of the baseline for each glyph in this
        set of glyph indexes.

        **See also** **setPositions** ().
        """
        ...

    def rawFont(self) -> PySide6.QtGui.QRawFont:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#rawFont

        **QRawFont QGlyphRun::rawFont() const**

        Returns the font selected for this **QGlyphRun**  object.

        **See also** **setRawFont** ().
        """
        ...

    def setBoundingRect(
        self, boundingRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setBoundingRect

        **[since 5.0] void QGlyphRun::setBoundingRect(const QRectF &
        boundingRect )**

        Sets the bounding rect of the glyphs in this **QGlyphRun**  to be
        **boundingRect**. This rectangle will be returned by **boundingRect** ()
        unless it is empty, in which case the bounding rectangle of the glyphs
        in the glyph run will be returned instead.

        **Note:** Unless you are implementing text shaping, you should not have
        to use this function. It is used specifically when the **QGlyphRun**
        should represent an area which is smaller than the area of the glyphs it
        contains. This could happen e.g. if the glyph run is retrieved by
        calling **QTextLayout::glyphRuns** () and the specified range only
        includes part of a ligature (where two or more characters are combined
        to a single glyph.) When this is the case, the bounding rect should only
        include the appropriate part of the ligature glyph, based on a
        calculation of the average width of the characters in the ligature.

        In order to support such a case (an example is selections which should
        be drawn with a different color than the main text color), it is
        necessary to clip the painting mechanism to the rectangle returned from
        **boundingRect** () to avoid drawing the entire ligature glyph.

        This function was introduced in Qt 5.0.

        **See also** **boundingRect** ().
        """
        ...

    def setFlag(
        self, flag: PySide6.QtGui.QGlyphRun.GlyphRunFlag, enabled: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setFlag

        **[since 5.0] void QGlyphRun::setFlag(QGlyphRun::GlyphRunFlag flag ,
        bool enabled = true)**

        If **enabled** is true, then **flag** is enabled; otherwise, it is
        disabled.

        This function was introduced in Qt 5.0.

        **See also** **flags** () and **setFlags** ().
        """
        ...

    def setFlags(self, flags: PySide6.QtGui.QGlyphRun.GlyphRunFlags) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setFlags

        **[since 5.0] void QGlyphRun::setFlags(QGlyphRun::GlyphRunFlags flags
        )**

        Sets the flags of this **QGlyphRun**  to **flags**.

        This function was introduced in Qt 5.0.

        **See also** **setFlag** () and **flags** ().
        """
        ...

    def setGlyphIndexes(self, glyphIndexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setGlyphIndexes

        **void QGlyphRun::setGlyphIndexes(const QList<quint32> & glyphIndexes
        )**

        Set the glyph indexes for this **QGlyphRun**  object to
        **glyphIndexes**. The glyph indexes must be valid for the selected font.

        **See also** **glyphIndexes** ().
        """
        ...

    def setOverline(self, overline: bool) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setOverline

        **void QGlyphRun::setOverline(bool overline )**

        Indicates that this **QGlyphRun**  should be painted with an overline
        decoration if **overline** is true. Otherwise the **QGlyphRun**  should
        be painted with no overline decoration.

        **See also** **overline** (), **setFlag** (), and **setFlags** ().
        """
        ...

    def setPositions(self, positions: Sequence[PySide6.QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setPositions

        **void QGlyphRun::setPositions(const QList<QPointF> & positions )**

        Sets the positions of the edge of the baseline for each glyph in this
        set of glyph indexes to **positions**.

        **See also** **positions** ().
        """
        ...

    def setRawData(
        self,
        glyphIndexArray: int,
        glyphPositionArray: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        size: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setRawData

        **void QGlyphRun::setRawData(const quint32 * glyphIndexArray , const
        QPointF * glyphPositionArray , int size )**

        Sets the glyph indexes and positions of this **QGlyphRun**  to use the
        first **size** elements in the arrays **glyphIndexArray** and
        **glyphPositionArray**. The data is **not** copied. The caller must
        guarantee that the arrays are not deleted as long as this **QGlyphRun**
        and any copies of it exists.

        **See also** **setGlyphIndexes** () and **setPositions** ().
        """
        ...

    def setRawFont(self, rawFont: PySide6.QtGui.QRawFont) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setRawFont

        **void QGlyphRun::setRawFont(const QRawFont & rawFont )**

        Sets the font in which to look up the glyph indexes to the **rawFont**
        specified.

        **See also** **rawFont** () and **setGlyphIndexes** ().
        """
        ...

    def setRightToLeft(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setRightToLeft

        **[since 5.0] void QGlyphRun::setRightToLeft(bool rightToLeft )**

        Indicates that this **QGlyphRun**  contains glyphs that should be
        ordered from the right to left if **rightToLeft** is true. Otherwise the
        order of the glyphs is assumed to be left to right.

        This function was introduced in Qt 5.0.

        **See also** **isRightToLeft** (), **setFlag** (), and **setFlags** ().
        """
        ...

    def setStrikeOut(self, strikeOut: bool) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setStrikeOut

        **void QGlyphRun::setStrikeOut(bool strikeOut )**

        Indicates that this **QGlyphRun**  should be painted with an strike out
        decoration if **strikeOut** is true. Otherwise the **QGlyphRun**  should
        be painted with no strike out decoration.

        **See also** **strikeOut** (), **setFlag** (), and **setFlags** ().
        """
        ...

    def setUnderline(self, underline: bool) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#setUnderline

        **void QGlyphRun::setUnderline(bool underline )**

        Indicates that this **QGlyphRun**  should be painted with an underline
        decoration if **underline** is true. Otherwise the **QGlyphRun**  should
        be painted with no underline decoration.

        **See also** **underline** (), **setFlag** (), and **setFlags** ().
        """
        ...

    def strikeOut(self) -> bool:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#strikeOut

        **bool QGlyphRun::strikeOut() const**

        Returns `true` if this **QGlyphRun**  should be painted with a strike
        out decoration.

        **See also** **setStrikeOut** () and **flags** ().
        """
        ...

    def swap(self, other: PySide6.QtGui.QGlyphRun) -> None:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#swap

        **[since 5.0] void QGlyphRun::swap(QGlyphRun & other )**

        Swaps this glyph run instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def underline(self) -> bool:
        """
        https://doc.qt.io/qt-6/qglyphrun.html#underline

        **bool QGlyphRun::underline() const**

        Returns `true` if this **QGlyphRun**  should be painted with an
        underline decoration.

        **See also** **setUnderline** () and **flags** ().
        """
        ...
