"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QFontInfo(object):
    """
    https://doc.qt.io/qt-6/qfontinfo.html

    **Detailed Description**

    The QFontInfo class provides the same access functions as **QFont** , e.g.
    **family** (), **pointSize** (), **italic** (), **weight** (),
    **fixedPitch** (), **styleHint** () etc. But whilst the **QFont**  access
    functions return the values that were set, a QFontInfo object returns the
    values that apply to the font that will actually be used to draw the text.

    For example, when the program asks for a 25pt Courier font on a machine that
    has a non-scalable 24pt Courier font, **QFont**  will (normally) use the
    24pt Courier for rendering. In this case, **QFont::pointSize** () returns 25
    and **QFontInfo::pointSize** () returns 24.

    There are three ways to create a QFontInfo object.

    1. Calling the QFontInfo constructor with a **QFont**  creates a font info
    object for a screen-compatible font, i.e. the font cannot be a printer font.
    If the font is changed later, the font info object is **not** updated.
    (Note: If you use a printer font the values returned may be inaccurate.
    Printer fonts are not always accessible so the nearest screen font is used
    if a printer font is supplied.)

      2. **QWidget::fontInfo** () returns the
    font info for a widget's font. This is equivalent to calling
    QFontInfo(widget->font()). If the widget's font is changed later, the font
    info object is **not** updated.
      3. **QPainter::fontInfo** () returns the
    font info for a painter's current font. If the painter's font is changed
    later, the font info object is **not** updated.

    **See also** **QFont** , **QFontMetrics** , and **QFontDatabase** .
    """

    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#QFontInfo

        **QFontInfo::QFontInfo(const QFont & font )**

        Constructs a font info object for **font**.

        The font must be screen-compatible, i.e. a font you use when drawing
        text in **widgets**  or **pixmaps** , not **QPicture**  or **QPrinter**
        .

        The font info object holds the information for the font that is passed
        in the constructor at the time it is created, and is not updated if the
        font's attributes are changed later.

        Use **QPainter::fontInfo** () to get the font info when painting. This
        will give correct results also when painting on paint device that is not
        screen-compatible.
        """
        ...

    @overload
    def __init__(
        self, arg__1: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#QFontInfo-1

        **QFontInfo::QFontInfo(const QFontInfo & fi )**

        Constructs a copy of **fi**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def bold(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#bold

        **bool QFontInfo::bold() const**

        Returns `true` if **weight** () would return a value greater than
        **QFont::Normal** ; otherwise returns `false`.

        **See also** **weight** () and **QFont::bold** ().
        """
        ...

    def exactMatch(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#exactMatch

        **bool QFontInfo::exactMatch() const**

        Returns `true` if the matched window system font is exactly the same as
        the one specified by the font; otherwise returns `false`.

        **See also** **QFont::exactMatch** ().
        """
        ...

    def family(self) -> str:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#family

        **QString QFontInfo::family() const**

        Returns the family name of the matched window system font.

        **See also** **QFont::family** ().
        """
        ...

    def fixedPitch(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#fixedPitch

        **bool QFontInfo::fixedPitch() const**

        Returns the fixed pitch value of the matched window system font.

        **See also** **QFont::fixedPitch** ().
        """
        ...

    def italic(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#italic

        **bool QFontInfo::italic() const**

        Returns the italic value of the matched window system font.

        **See also** **QFont::italic** ().
        """
        ...

    def legacyWeight(self) -> int:
        ...

    def overline(self) -> bool:
        ...

    def pixelSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#pixelSize

        **int QFontInfo::pixelSize() const**

        Returns the pixel size of the matched window system font.

        **See also** **QFont::pointSize** ().
        """
        ...

    def pointSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#pointSize

        **int QFontInfo::pointSize() const**

        Returns the point size of the matched window system font.

        **See also** **pointSizeF** () and **QFont::pointSize** ().
        """
        ...

    def pointSizeF(self) -> float:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#pointSizeF

        **qreal QFontInfo::pointSizeF() const**

        Returns the point size of the matched window system font.

        **See also** **QFont::pointSizeF** ().
        """
        ...

    def strikeOut(self) -> bool:
        ...

    def style(self) -> PySide6.QtGui.QFont.Style:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#style

        **QFont::Style QFontInfo::style() const**

        Returns the style value of the matched window system font.

        **See also** **QFont::style** ().
        """
        ...

    def styleHint(self) -> PySide6.QtGui.QFont.StyleHint:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#styleHint

        **QFont::StyleHint QFontInfo::styleHint() const**

        Returns the style of the matched window system font.

        Currently only returns the style hint set in **QFont** .

        **See also** **QFont::styleHint** () and **QFont::StyleHint** .
        """
        ...

    def styleName(self) -> str:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#styleName

        **QString QFontInfo::styleName() const**

        Returns the style name of the matched window system font on systems that
        support it.

        **See also** **QFont::styleName** ().
        """
        ...

    def swap(self, other: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]) -> None:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#swap

        **[since 5.0] void QFontInfo::swap(QFontInfo & other )**

        Swaps this font info instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def underline(self) -> bool:
        ...

    def weight(self) -> int:
        """
        https://doc.qt.io/qt-6/qfontinfo.html#weight

        **int QFontInfo::weight() const**

        Returns the weight of the matched window system font.

        **See also** **QFont::weight** () and **bold** ().
        """
        ...
