"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QDoubleValidator(PySide6.QtGui.QValidator):
    """
    https://doc.qt.io/qt-6/qdoublevalidator.html

    **Detailed Description**

    QDoubleValidator provides an upper bound, a lower bound, and a limit on the
    number of digits after the decimal point. It does not provide a **fixup** ()
    function.

    You can set the acceptable range in one call with **setRange** (), or with
    **setBottom** () and **setTop** (). Set the number of decimal places with
    **setDecimals** (). The **validate** () function returns the validation
    state.

    QDoubleValidator uses its **locale** () to interpret the number. For
    example, in the German locale, "1,234" will be accepted as the fractional
    number 1.234. In Arabic locales, QDoubleValidator will accept Arabic digits.

    **Note:** The **QLocale::NumberOptions**  set on the **locale** () also
    affect the way the number is interpreted. For example, since
    **QLocale::RejectGroupSeparator**  is not set by default, the validator will
    accept group separators. It is thus recommended to use **QLocale::toDouble**
    () to obtain the numeric value.

    **See also** **QIntValidator** , **QRegularExpressionValidator** ,
    **QLocale::toDouble** (), and **Line Edits Example** .
    """

    StandardNotation: QDoubleValidator.Notation = ...
    ScientificNotation: QDoubleValidator.Notation = ...

    class Notation(Enum):
        StandardNotation: QDoubleValidator.Notation = ...
        ScientificNotation: QDoubleValidator.Notation = ...

    @overload
    def __init__(
        self,
        bottom: float,
        top: float,
        decimals: int,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#QDoubleValidator

        **QDoubleValidator::QDoubleValidator(QObject * parent = nullptr)**

        Constructs a validator object with a **parent** object that accepts any
        double.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#QDoubleValidator-1

        **QDoubleValidator::QDoubleValidator(double bottom , double top , int
        decimals , QObject * parent = nullptr)**

        Constructs a validator object with a **parent** object. This validator
        will accept doubles from **bottom** to **top** inclusive, with up to
        **decimals** digits after the decimal point.
        """
        ...

    def bottom(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#bottom-prop

        **bottom : double**

        This property holds the validator's minimum acceptable value

        By default, this property contains a value of -infinity.

        **Access functions:**

        double **bottom** () const
        void **setBottom** (double)

        **Notifier signal:**

        void **bottomChanged** (double **bottom** )

        **See also** **setRange** ().
        """
        ...

    def decimals(self) -> int:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#decimals-prop

        **decimals : int**

        This property holds the validator's maximum number of digits after the
        decimal point

        By default, this property contains a value of 1000.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** (int)

        **Notifier signal:**

        void **decimalsChanged** (int **decimals** )

        **See also** **setRange** ().
        """
        ...

    def notation(self) -> PySide6.QtGui.QDoubleValidator.Notation:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#notation-prop

        **notation : Notation**

        This property holds the notation of how a string can describe a number

        By default, this property is set to **ScientificNotation** .

        **Access functions:**

        QDoubleValidator::Notation **notation** () const
        void **setNotation**
        (QDoubleValidator::Notation)

        **Notifier signal:**

        void **notationChanged** (QDoubleValidator::Notation **notation** )

        **See also** **Notation** .
        """
        ...

    def setBottom(self, arg__1: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#bottom-prop

        **bottom : double**

        This property holds the validator's minimum acceptable value

        By default, this property contains a value of -infinity.

        **Access functions:**

        double **bottom** () const
        void **setBottom** (double)

        **Notifier signal:**

        void **bottomChanged** (double **bottom** )

        **See also** **setRange** ().
        """
        ...

    def setDecimals(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#decimals-prop

        **decimals : int**

        This property holds the validator's maximum number of digits after the
        decimal point

        By default, this property contains a value of 1000.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** (int)

        **Notifier signal:**

        void **decimalsChanged** (int **decimals** )

        **See also** **setRange** ().
        """
        ...

    def setNotation(self, arg__1: PySide6.QtGui.QDoubleValidator.Notation) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#notation-prop

        **notation : Notation**

        This property holds the notation of how a string can describe a number

        By default, this property is set to **ScientificNotation** .

        **Access functions:**

        QDoubleValidator::Notation **notation** () const
        void **setNotation**
        (QDoubleValidator::Notation)

        **Notifier signal:**

        void **notationChanged** (QDoubleValidator::Notation **notation** )

        **See also** **Notation** .
        """
        ...

    def setRange(self, bottom: float, top: float, decimals: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#setRange

        **void QDoubleValidator::setRange(double minimum , double maximum , int
        decimals = 0)**

        Sets the validator to accept doubles from **minimum** to **maximum**
        inclusive, with at most **decimals** digits after the decimal point.
        """
        ...

    def setTop(self, arg__1: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#top-prop

        **top : double**

        This property holds the validator's maximum acceptable value

        By default, this property contains a value of infinity.

        **Access functions:**

        double **top** () const
        void **setTop** (double)

        **Notifier signal:**

        void **topChanged** (double **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def top(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#top-prop

        **top : double**

        This property holds the validator's maximum acceptable value

        By default, this property contains a value of infinity.

        **Access functions:**

        double **top** () const
        void **setTop** (double)

        **Notifier signal:**

        void **topChanged** (double **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def validate(self, arg__1: str, arg__2: int) -> object:
        """
        https://doc.qt.io/qt-6/qdoublevalidator.html#validate

        **[override virtual] QValidator::State
        QDoubleValidator::validate(QString & input , int & pos ) const**

        Reimplements: **QValidator::validate(QString &input, int &pos) const** .

        Returns **Acceptable**  if the string **input** contains a double that
        is within the valid range and is in the correct format.

        Returns **Intermediate**  if **input** contains a double that is outside
        the range or is in the wrong format; e.g. is empty.

        Returns **Invalid**  if the **input** is not a double or with too many
        digits after the decimal point.

        Note: If the valid range consists of just positive doubles (e.g. 0.0 to
        100.0) and **input** is a negative double then **Invalid**  is returned.
        If **notation** () is set to **StandardNotation** , and the input
        contains more digits before the decimal point than a double in the valid
        range may have, **Invalid**  is returned. If **notation** () is
        **ScientificNotation** , and the input is not in the valid range,
        **Intermediate**  is returned. The value may yet become valid by
        changing the exponent.

        By default, the **pos** parameter is not used by this validator.
        """
        ...

    @property
    def bottomChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def decimalsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def notationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def topChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
