"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QContextMenuEvent(PySide6.QtGui.QInputEvent):
    """
    https://doc.qt.io/qt-6/qcontextmenuevent.html

    **Detailed Description**

    Context menu events are sent to widgets when a user performs an action
    associated with opening a context menu. The actions required to open context
    menus vary between platforms; for example, on Windows, pressing the menu
    button or clicking the right mouse button will cause this event to be sent.

    When this event occurs it is customary to show a **QMenu**  with a context
    menu, if this is relevant to the context.
    """

    Mouse: QContextMenuEvent.Reason = ...
    Keyboard: QContextMenuEvent.Reason = ...
    Other: QContextMenuEvent.Reason = ...

    class Reason(Enum):
        Mouse: QContextMenuEvent.Reason = ...
        Keyboard: QContextMenuEvent.Reason = ...
        Other: QContextMenuEvent.Reason = ...

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#QContextMenuEvent-2

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos , const QPoint & globalPos , Qt::KeyboardModifiers
        modifiers = Qt::NoModifier)**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget. **globalPos** is the mouse position in absolute
        coordinates. The **modifiers** holds the keyboard modifiers.
        """
        ...

    @overload
    def __init__(
        self, reason: PySide6.QtGui.QContextMenuEvent.Reason, pos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#QContextMenuEvent-3

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos )**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget.

        The **globalPos** () is initialized to **QCursor::pos** (), which may
        not be appropriate. Use the other constructor to specify the global
        position explicitly.
        """
        ...

    @overload
    def __init__(
        self,
        reason: PySide6.QtGui.QContextMenuEvent.Reason,
        pos: PySide6.QtCore.QPoint,
        globalPos: PySide6.QtCore.QPoint,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#QContextMenuEvent-2

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos , const QPoint & globalPos , Qt::KeyboardModifiers
        modifiers = Qt::NoModifier)**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget. **globalPos** is the mouse position in absolute
        coordinates. The **modifiers** holds the keyboard modifiers.
        """
        ...

    def clone(self) -> PySide6.QtGui.QContextMenuEvent:
        ...

    def globalPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#globalPos

        **const QPoint &QContextMenuEvent::globalPos() const**

        Returns the global position of the mouse pointer at the time of the
        event.

        **See also** **x** (), **y** (), and **pos** ().
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#globalX

        **int QContextMenuEvent::globalX() const**

        Returns the global x position of the mouse pointer at the time of the
        event.

        **See also** **globalY** () and **globalPos** ().
        """
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#globalY

        **int QContextMenuEvent::globalY() const**

        Returns the global y position of the mouse pointer at the time of the
        event.

        **See also** **globalX** () and **globalPos** ().
        """
        ...

    def pos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#pos

        **const QPoint &QContextMenuEvent::pos() const**

        Returns the position of the mouse pointer relative to the widget that
        received the event.

        **See also** **x** (), **y** (), and **globalPos** ().
        """
        ...

    def reason(self) -> PySide6.QtGui.QContextMenuEvent.Reason:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#reason

        **QContextMenuEvent::Reason QContextMenuEvent::reason() const**

        Returns the reason for this context event.
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#x

        **int QContextMenuEvent::x() const**

        Returns the x position of the mouse pointer, relative to the widget that
        received the event.

        **See also** **y** () and **pos** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-6/qcontextmenuevent.html#y

        **int QContextMenuEvent::y() const**

        Returns the y position of the mouse pointer, relative to the widget that
        received the event.

        **See also** **x** () and **pos** ().
        """
        ...
