"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QColorSpace(object):
    """
    https://doc.qt.io/qt-6/qcolorspace.html

    **Detailed Description**

    Color values can be interpreted in different ways, and based on the
    interpretation can live in different spaces. We call this **color spaces**.

    QColorSpace provides access to creating several predefined color spaces and
    can generate QColorTransforms for converting colors from one color space to
    another.

    QColorSpace can also represent color spaces defined by ICC profiles or
    embedded in images, that do not otherwise fit the predefined color spaces.

    A color space can generally speaking be conceived as a combination of set of
    primary colors and a transfer function. The primaries defines the axes of
    the color space, and the transfer function how values are mapped on the
    axes. The primaries are defined by three primary colors that represent
    exactly how red, green, and blue look in this particular color space, and a
    white color that represents where and how bright pure white is. The range of
    colors expressible by the primary colors is called the gamut, and a color
    space that can represent a wider range of colors is also known as a wide-
    gamut color space.

    The transfer function or gamma curve determines how each component in the
    color space is encoded. These are used because human perception does not
    operate linearly, and the transfer functions try to ensure that colors will
    seem evenly spaced to human eyes.
    """

    SRgb: QColorSpace.NamedColorSpace = ...
    SRgbLinear: QColorSpace.NamedColorSpace = ...
    AdobeRgb: QColorSpace.NamedColorSpace = ...
    DisplayP3: QColorSpace.NamedColorSpace = ...
    ProPhotoRgb: QColorSpace.NamedColorSpace = ...

    class NamedColorSpace(Enum):
        SRgb: QColorSpace.NamedColorSpace = ...
        SRgbLinear: QColorSpace.NamedColorSpace = ...
        AdobeRgb: QColorSpace.NamedColorSpace = ...
        DisplayP3: QColorSpace.NamedColorSpace = ...
        ProPhotoRgb: QColorSpace.NamedColorSpace = ...

    class Primaries(Enum):
        Custom: QColorSpace.Primaries = ...
        SRgb: QColorSpace.Primaries = ...
        AdobeRgb: QColorSpace.Primaries = ...
        DciP3D65: QColorSpace.Primaries = ...
        ProPhotoRgb: QColorSpace.Primaries = ...

    class TransferFunction(Enum):
        Custom: QColorSpace.TransferFunction = ...
        Linear: QColorSpace.TransferFunction = ...
        Gamma: QColorSpace.TransferFunction = ...
        SRgb: QColorSpace.TransferFunction = ...
        ProPhotoRgb: QColorSpace.TransferFunction = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace

        **QColorSpace::QColorSpace()**

        Creates a new colorspace object that represents an undefined and invalid
        colorspace.
        """
        ...

    @overload
    def __init__(
        self,
        colorSpace: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-1

        **QColorSpace::QColorSpace(QColorSpace::NamedColorSpace namedColorSpace
        )**

        Creates a new colorspace object that represents a **namedColorSpace**.
        """
        ...

    @overload
    def __init__(
        self, namedColorSpace: PySide6.QtGui.QColorSpace.NamedColorSpace
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-2

        **QColorSpace::QColorSpace(QColorSpace::Primaries primaries ,
        QColorSpace::TransferFunction transferFunction , float gamma = 0.0f)**

        Creates a custom color space with the primaries **primaries** , using
        the transfer function **transferFunction** and optionally **gamma**.
        """
        ...

    @overload
    def __init__(
        self, primaries: PySide6.QtGui.QColorSpace.Primaries, gamma: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-3

        **QColorSpace::QColorSpace(QColorSpace::Primaries primaries , float
        gamma )**

        Creates a custom color space with the primaries **primaries** , using a
        gamma transfer function of **gamma**.
        """
        ...

    @overload
    def __init__(
        self,
        primaries: PySide6.QtGui.QColorSpace.Primaries,
        transferFunction: PySide6.QtGui.QColorSpace.TransferFunction,
        gamma: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-4

        **[since 6.1] QColorSpace::QColorSpace(QColorSpace::Primaries gamut ,
        const QList<uint16_t> & transferFunctionTable )**

        Creates a custom color space with the primaries **gamut** , using a
        custom transfer function described by **transferFunctionTable**.

        The table should contain at least 2 values, and contain an monotonically
        increasing list of values from 0 to 65535.

        This function was introduced in Qt 6.1.
        """
        ...

    @overload
    def __init__(
        self,
        primaries: PySide6.QtGui.QColorSpace.Primaries,
        transferFunctionTable: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-5

        **QColorSpace::QColorSpace(const QPointF & whitePoint , const QPointF &
        redPoint , const QPointF & greenPoint , const QPointF & bluePoint ,
        QColorSpace::TransferFunction transferFunction , float gamma = 0.0f)**

        Creates a custom colorspace with a primaries based on the chromaticities
        of the primary colors **whitePoint** , **redPoint** , **greenPoint** and
        **bluePoint** , and using the transfer function **transferFunction** and
        optionally **gamma**.
        """
        ...

    @overload
    def __init__(
        self,
        whitePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        redPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        greenPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        bluePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        redTransferFunctionTable: Sequence[int],
        greenTransferFunctionTable: Sequence[int],
        blueTransferFunctionTable: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-6

        **[since 6.1] QColorSpace::QColorSpace(const QPointF & whitePoint ,
        const QPointF & redPoint , const QPointF & greenPoint , const QPointF &
        bluePoint , const QList<uint16_t> & transferFunctionTable )**

        Creates a custom color space with primaries based on the chromaticities
        of the primary colors **whitePoint** , **redPoint** , **greenPoint** and
        **bluePoint** , and using the custom transfer function described by
        **transferFunctionTable**.

        This function was introduced in Qt 6.1.
        """
        ...

    @overload
    def __init__(
        self,
        whitePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        redPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        greenPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        bluePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        transferFunction: PySide6.QtGui.QColorSpace.TransferFunction,
        gamma: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace-7

        **[since 6.1] QColorSpace::QColorSpace(const QPointF & whitePoint ,
        const QPointF & redPoint , const QPointF & greenPoint , const QPointF &
        bluePoint , const QList<uint16_t> & redTransferFunctionTable , const
        QList<uint16_t> & greenTransferFunctionTable , const QList<uint16_t> &
        blueTransferFunctionTable )**

        Creates a custom color space with primaries based on the chromaticities
        of the primary colors **whitePoint** , **redPoint** , **greenPoint** and
        **bluePoint** , and using the custom transfer functions described by
        **redTransferFunctionTable** , **greenTransferFunctionTable** , and
        **blueTransferFunctionTable**.

        This function was introduced in Qt 6.1.
        """
        ...

    @overload
    def __init__(
        self,
        whitePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        redPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        greenPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        bluePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        transferFunctionTable: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#QColorSpace

        **QColorSpace::QColorSpace()**

        Creates a new colorspace object that represents an undefined and invalid
        colorspace.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#description

        **[since 6.2] QString QColorSpace::description() const**

        Returns the name or short description. If a description hasn't been
        given in **setDescription** (), the original name of the profile is
        returned if the profile is unmodified, a guessed name is returned if the
        profile has been recognized as a known color space, otherwise an empty
        string is returned.

        This function was introduced in Qt 6.2.

        **See also** **setDescription** ().
        """
        ...

    @staticmethod
    def fromIccProfile(
        iccProfile: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtGui.QColorSpace:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#fromIccProfile

        **[static] QColorSpace QColorSpace::fromIccProfile(const QByteArray &
        iccProfile )**

        Creates a **QColorSpace**  from ICC profile **iccProfile**.

        **Note:** Not all ICC profiles are supported. **QColorSpace**  only
        supports RGB-XYZ ICC profiles that are three-component matrix-based.

        If the ICC profile is not supported an invalid **QColorSpace**  is
        returned where you can still read the original ICC profile using
        **iccProfile** ().

        **See also** **iccProfile** ().
        """
        ...

    def gamma(self) -> float:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#gamma

        **float QColorSpace::gamma() const**

        Returns the gamma value of color spaces with `TransferFunction::Gamma`,
        an approximate gamma value for other predefined color spaces, or 0.0 if
        no approximate gamma is known.

        **See also** **transferFunction** ().
        """
        ...

    def iccProfile(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#iccProfile

        **QByteArray QColorSpace::iccProfile() const**

        Returns an ICC profile representing the color space.

        If the color space was generated from an ICC profile, that profile is
        returned, otherwise one is generated.

        **Note:** Even invalid color spaces may return the ICC profile if they
        were generated from one, to allow applications to implement wider
        support themselves.

        **See also** **fromIccProfile** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#isValid

        **bool QColorSpace::isValid() const**

        Returns `true` if the color space is valid.
        """
        ...

    def primaries(self) -> PySide6.QtGui.QColorSpace.Primaries:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#primaries

        **QColorSpace::Primaries QColorSpace::primaries() const**

        Returns the predefined primaries of the color space or
        `primaries::Custom` if it doesn't match any of them.

        **See also** **setPrimaries** ().
        """
        ...

    def setDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setDescription

        **[since 6.2] void QColorSpace::setDescription(const QString &
        description )**

        Sets the name or short description of the color space to
        **description**.

        If set to empty **description** () will return original or guessed
        descriptions instead.

        This function was introduced in Qt 6.2.

        **See also** **description** ().
        """
        ...

    @overload
    def setPrimaries(self, primariesId: PySide6.QtGui.QColorSpace.Primaries) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setPrimaries

        **void QColorSpace::setPrimaries(QColorSpace::Primaries primariesId )**

        Sets the primaries to those of the **primariesId** set.

        **See also** **primaries** ().
        """
        ...

    @overload
    def setPrimaries(
        self,
        whitePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        redPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        greenPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        bluePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setPrimaries-1

        **void QColorSpace::setPrimaries(const QPointF & whitePoint , const
        QPointF & redPoint , const QPointF & greenPoint , const QPointF &
        bluePoint )**

        Set primaries to the chromaticities of **whitePoint** , **redPoint** ,
        **greenPoint** and **bluePoint**.

        **See also** **primaries** ().
        """
        ...

    @overload
    def setTransferFunction(
        self,
        transferFunction: PySide6.QtGui.QColorSpace.TransferFunction,
        gamma: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setTransferFunction

        **void QColorSpace::setTransferFunction(QColorSpace::TransferFunction
        transferFunction , float gamma = 0.0f)**

        Sets the transfer function to **transferFunction** and **gamma**.

        **See also** **transferFunction** (), **gamma** (), and
        **withTransferFunction** ().
        """
        ...

    @overload
    def setTransferFunction(self, transferFunctionTable: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setTransferFunction-1

        **[since 6.1] void QColorSpace::setTransferFunction(const
        QList<uint16_t> & transferFunctionTable )**

        Sets the transfer function to **transferFunctionTable**.

        This function was introduced in Qt 6.1.

        **See also** **withTransferFunction** ().
        """
        ...

    def setTransferFunctions(
        self,
        redTransferFunctionTable: Sequence[int],
        greenTransferFunctionTable: Sequence[int],
        blueTransferFunctionTable: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#setTransferFunctions

        **[since 6.1] void QColorSpace::setTransferFunctions(const
        QList<uint16_t> & redTransferFunctionTable , const QList<uint16_t> &
        greenTransferFunctionTable , const QList<uint16_t> &
        blueTransferFunctionTable )**

        Sets the transfer functions to **redTransferFunctionTable** ,
        **greenTransferFunctionTable** and **blueTransferFunctionTable**.

        This function was introduced in Qt 6.1.

        **See also** **withTransferFunctions** ().
        """
        ...

    def swap(
        self,
        colorSpace: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#swap

        **void QColorSpace::swap(QColorSpace & other )**

        Swaps color space **other** with this color space. This operation is
        very fast and never fails.
        """
        ...

    def transferFunction(self) -> PySide6.QtGui.QColorSpace.TransferFunction:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#transferFunction

        **QColorSpace::TransferFunction QColorSpace::transferFunction() const**

        Returns the predefined transfer function of the color space or
        `TransferFunction::Custom` if it doesn't match any of them.

        **See also** **gamma** (), **setTransferFunction** (), and
        **withTransferFunction** ().
        """
        ...

    def transformationToColorSpace(
        self,
        colorspace: Union[
            PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace
        ],
    ) -> PySide6.QtGui.QColorTransform:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#transformationToColorSpace

        **QColorTransform QColorSpace::transformationToColorSpace(const
        QColorSpace & colorspace ) const**

        Generates and returns a color space transformation from this color space
        to **colorspace**.
        """
        ...

    @overload
    def withTransferFunction(
        self,
        transferFunction: PySide6.QtGui.QColorSpace.TransferFunction,
        gamma: float = ...,
    ) -> PySide6.QtGui.QColorSpace:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#withTransferFunction

        **QColorSpace
        QColorSpace::withTransferFunction(QColorSpace::TransferFunction
        transferFunction , float gamma = 0.0f) const**

        Returns a copy of this color space, except using the transfer function
        **transferFunction** and **gamma**.

        **See also** **transferFunction** (), **gamma** (), and
        **setTransferFunction** ().
        """
        ...

    @overload
    def withTransferFunction(
        self, transferFunctionTable: Sequence[int]
    ) -> PySide6.QtGui.QColorSpace:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#withTransferFunction-1

        **[since 6.1] QColorSpace QColorSpace::withTransferFunction(const
        QList<uint16_t> & transferFunctionTable ) const**

        Returns a copy of this color space, except using the transfer function
        described by **transferFunctionTable**.

        This function was introduced in Qt 6.1.

        **See also** **transferFunction** () and **setTransferFunction** ().
        """
        ...

    def withTransferFunctions(
        self,
        redTransferFunctionTable: Sequence[int],
        greenTransferFunctionTable: Sequence[int],
        blueTransferFunctionTable: Sequence[int],
    ) -> PySide6.QtGui.QColorSpace:
        """
        https://doc.qt.io/qt-6/qcolorspace.html#withTransferFunctions

        **[since 6.1] QColorSpace QColorSpace::withTransferFunctions(const
        QList<uint16_t> & redTransferFunctionTable , const QList<uint16_t> &
        greenTransferFunctionTable , const QList<uint16_t> &
        blueTransferFunctionTable ) const**

        Returns a copy of this color space, except using the transfer functions
        described by **redTransferFunctionTable** ,
        **greenTransferFunctionTable** and **blueTransferFunctionTable**.

        This function was introduced in Qt 6.1.

        **See also** **setTransferFunctions** ().
        """
        ...
