"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QActionEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qactionevent.html

    **Detailed Description**

    Actions can be added to controls, for example by using
    **QWidget::addAction** (). This generates an **ActionAdded**  event, which
    you can handle to provide custom behavior. For example, **QToolBar**
    reimplements **QWidget::actionEvent** () to create **QToolButton** s for the
    actions.

    **See also** **QAction** , **QWidget::addAction** (),
    **QWidget::removeAction** (), and **QWidget::actions** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qactionevent.html#QActionEvent-2

        **QActionEvent::QActionEvent(int type , QAction * action , QAction *
        before = nullptr)**

        Constructs an action event. The **type** can be **ActionChanged** ,
        **ActionAdded** , or **ActionRemoved** .

        **action** is the action that is changed, added, or removed. If **type**
        is ActionAdded, the action is to be inserted before the action
        **before**. If **before** is `nullptr`, the action is appended.
        """
        ...

    @overload
    def __init__(
        self,
        type: int,
        action: PySide6.QtGui.QAction,
        before: Optional[PySide6.QtGui.QAction] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qactionevent.html#QActionEvent-2

        **QActionEvent::QActionEvent(int type , QAction * action , QAction *
        before = nullptr)**

        Constructs an action event. The **type** can be **ActionChanged** ,
        **ActionAdded** , or **ActionRemoved** .

        **action** is the action that is changed, added, or removed. If **type**
        is ActionAdded, the action is to be inserted before the action
        **before**. If **before** is `nullptr`, the action is appended.
        """
        ...

    def action(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactionevent.html#action

        **QAction *QActionEvent::action() const**

        Returns the action that is changed, added, or removed.

        **See also** **before** ().
        """
        ...

    def before(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactionevent.html#before

        **QAction *QActionEvent::before() const**

        If **type** () is **ActionAdded** , returns the action that should
        appear before **action** (). If this function returns `nullptr`, the
        action should be appended to already existing actions on the same
        widget.

        **See also** **action** () and **QWidget::actions** ().
        """
        ...

    def clone(self) -> PySide6.QtGui.QActionEvent:
        ...
