"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Any

bytes = str


class QAccessibleValueInterface(object):
    """
    https://doc.qt.io/qt-6/qaccessiblevalueinterface.html

    **Detailed Description**

    This interface should be implemented by accessible objects that represent a
    value. Examples are spinner, slider, dial and scroll bar.

    Instead of forcing the user to deal with the individual parts of the
    widgets, this interface gives an easier approach to the kind of widget it
    represents.

    Usually this interface is implemented by classes that also implement
    **QAccessibleInterface** .

    **IAccessible2 Specification**
    """

    def __init__(self) -> None:
        ...

    def currentValue(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaccessiblevalueinterface.html#currentValue

        **[pure virtual] QVariant QAccessibleValueInterface::currentValue()
        const**

        Returns the current value of the widget. This is usually a double or
        int.

        **See also** **setCurrentValue** ().
        """
        ...

    def maximumValue(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaccessiblevalueinterface.html#maximumValue

        **[pure virtual] QVariant QAccessibleValueInterface::maximumValue()
        const**

        Returns the maximum value this object accepts.

        **See also** **minimumValue** () and **currentValue** ().
        """
        ...

    def minimumStepSize(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaccessiblevalueinterface.html#minimumStepSize

        **[pure virtual] QVariant QAccessibleValueInterface::minimumStepSize()
        const**

        Returns the minimum step size for the accessible. This is the smallest
        increment that makes sense when changing the value. When
        programmatically changing the value it should always be a multiple of
        the minimum step size.

        Some tools use this value even when the **setCurrentValue**  does not
        perform any action. Progress bars for example are read-only but should
        return their range divided by 100.
        """
        ...

    def minimumValue(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaccessiblevalueinterface.html#minimumValue

        **[pure virtual] QVariant QAccessibleValueInterface::minimumValue()
        const**

        Returns the minimum value this object accepts.

        **See also** **maximumValue** () and **currentValue** ().
        """
        ...

    def setCurrentValue(self, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblevalueinterface.html#setCurrentValue

        **[pure virtual] void QAccessibleValueInterface::setCurrentValue(const
        QVariant & value )**

        Sets the **value**. If the desired **value** is out of the range of
        permissible values, this call will be ignored.

        **See also** **currentValue** (), **minimumValue** (), and
        **maximumValue** ().
        """
        ...
