"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAccessibleValueChangeEvent(PySide6.QtGui.QAccessibleEvent):
    """
    https://doc.qt.io/qt-6/qaccessiblevaluechangeevent.html

    **Detailed Description**

    It contains the new value.

    This class is used with **QAccessible::updateAccessibility** ().
    """

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, val: Any) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblevaluechangeevent.html#QAccessibleValue
        ChangeEvent

        **QAccessibleValueChangeEvent::QAccessibleValueChangeEvent(QObject *
        object , const QVariant & value )**

        Constructs a new QAccessibleValueChangeEvent for **object**. The event
        contains the new **value**.
        """
        ...

    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, val: Any) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblevaluechangeevent.html#QAccessibleValue
        ChangeEvent-1

        **QAccessibleValueChangeEvent::QAccessibleValueChangeEvent(QAccessibleIn
        terface * iface , const QVariant & val )**

        Constructs a new QAccessibleValueChangeEvent for **iface**. The event
        contains the new value **val**.
        """
        ...

    def setValue(self, val: Any) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblevaluechangeevent.html#setValue

        **void QAccessibleValueChangeEvent::setValue(const QVariant & value )**

        Sets the new **value** for this event.

        **See also** **value** ().
        """
        ...

    def value(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaccessiblevaluechangeevent.html#value

        **QVariant QAccessibleValueChangeEvent::value() const**

        Returns the new value of the accessible object of this event.

        **See also** **setValue** ().
        """
        ...
